/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DataImportDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JFileChooser;
import org.apache.commons.lang.StringUtils;

public class ImportFromAldeloAction
extends PosAction {
    public ImportFromAldeloAction() {
        super(Messages.getString("ImportFromAldeloAction.0"));
    }

    @Override
    public void execute() throws Exception {
        this.a();
    }

    private void a() {
        JFileChooser jFileChooser = DataExportAction.getFileChooser("Backup.mdb", "Microsoft Access (*.accdb;*.mdb)", ".mdb", ".accdb");
        int n = jFileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            this.a(file, "", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            POSMessageDialog.showError(file.getName() + " " + Messages.getString("ImportFromAldeloAction.1"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void a(File file, String string, String string2) throws Exception {
        Database database = DatabaseBuilder.open((File)file);
        Elements elements = new Elements();
        this.a(database, elements);
        this.b(database, elements);
        this.c(database, elements);
        this.d(database, elements);
        this.f(database, elements);
        this.e(database, elements);
        this.g(database, elements);
        this.a(elements);
    }

    private void a(Database database, Elements elements) throws IOException {
        ArrayList<ReportGroup> arrayList = new ArrayList<ReportGroup>();
        Table table = database.getTable("MenuCategories");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "MenuCategoryID");
                String string2 = this.a(row, "MenuCategoryText");
                ReportGroup reportGroup = new ReportGroup(string);
                reportGroup.setName(string2);
                arrayList.add(reportGroup);
            }
        }
        elements.setReportGroups(arrayList);
    }

    private void b(Database database, Elements elements) throws IOException {
        ArrayList<MenuGroup> arrayList = new ArrayList<MenuGroup>();
        ArrayList<MenuCategory> arrayList2 = new ArrayList<MenuCategory>();
        Table table = database.getTable("MenuGroups");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "MenuGroupID");
                String string2 = this.a(row, "MenuGroupText");
                Boolean bl = !POSUtil.getBoolean(this.a(row, "MenuGroupInActive"));
                Integer n = POSUtil.parseInteger(this.a(row, "ButtonColor"));
                Integer n2 = POSUtil.parseInteger(this.a(row, "DisplayIndex"));
                MenuCategory menuCategory = new MenuCategory(string);
                menuCategory.setName(string2);
                menuCategory.setButtonColorCode(n);
                menuCategory.setSortOrder(n2);
                menuCategory.setVisible(bl);
                arrayList2.add(menuCategory);
                MenuGroup menuGroup = new MenuGroup(string);
                menuGroup.setName(string2);
                menuGroup.setButtonColorCode(n);
                menuGroup.setSortOrder(n2);
                menuGroup.setMenuCategory(menuCategory);
                menuGroup.setVisible(bl);
                arrayList.add(menuGroup);
            }
        }
        elements.setMenuGroups(arrayList);
        elements.setMenuCategories(arrayList2);
    }

    private void c(Database database, Elements elements) throws IOException {
        HashMap<String, MenuGroup> hashMap = new HashMap<String, MenuGroup>();
        if (elements.getMenuGroups() != null) {
            for (MenuGroup object2 : elements.getMenuGroups()) {
                hashMap.put(object2.getId(), object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        Table table = database.getTable("MenuItems");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "MenuItemID");
                String string2 = this.a(row, "MenuItemText");
                String string3 = this.a(row, "Barcode");
                String string4 = this.a(row, "MenuItemDescription");
                String string5 = this.a(row, "MenuGroupID");
                String string6 = this.a(row, "MenuCategoryID");
                Double d = POSUtil.parseDouble(this.a(row, "DefaultUnitPrice"));
                Double d2 = POSUtil.parseDouble(this.a(row, "MenuItemCost"));
                Integer n = POSUtil.parseInteger(this.a(row, "ButtonColor"));
                Boolean bl = POSUtil.getBoolean(this.a(row, "Pizza"));
                Boolean bl2 = POSUtil.getBoolean(this.a(row, "DoNotPrintOnReceipt"));
                Integer n2 = POSUtil.parseInteger(this.a(row, "DisplayIndex"));
                Boolean bl3 = !POSUtil.getBoolean(this.a(row, "MenuItemInActive"));
                MenuGroup menuGroup = null;
                if (StringUtils.isNotBlank((String)string5)) {
                    menuGroup = (MenuGroup)hashMap.get(string5);
                }
                MenuItem menuItem = new MenuItem(string);
                menuItem.setName(string2);
                menuItem.setBarcode(string3);
                menuItem.setDescription(string4);
                menuItem.setMenuGroup(menuGroup);
                if (menuGroup != null) {
                    menuItem.setMenuCategoryId(menuGroup.getId());
                    menuItem.setMenuCategoryName(menuGroup.getName());
                }
                menuItem.setReportGroupId(string6);
                menuItem.setPrice(d);
                menuItem.setCost(d2);
                menuItem.setShouldPrintToKitchen(bl2 == false);
                menuItem.setButtonColorCode(n);
                menuItem.setPizzaType(bl);
                menuItem.setSortOrder(n2);
                menuItem.setVisible(bl3);
                arrayList.add(menuItem);
            }
        }
        elements.setMenuItems(arrayList);
    }

    private void d(Database database, Elements elements) throws IOException {
        ArrayList<MenuModifier> arrayList = new ArrayList<MenuModifier>();
        Table table = database.getTable("MenuModifiers");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "MenuModifierID");
                String string2 = this.a(row, "MenuModifierText");
                Double d = POSUtil.parseDouble(this.a(row, "AdditionalCost"));
                Boolean bl = !POSUtil.getBoolean(this.a(row, "MenuModifierInActive"));
                MenuModifier menuModifier = new MenuModifier(string);
                menuModifier.setName(string2);
                menuModifier.setPrice(d);
                menuModifier.setEnable(bl);
                arrayList.add(menuModifier);
            }
        }
        elements.setMenuModifiers(arrayList);
    }

    private void e(Database database, Elements elements) throws IOException {
        HashMap<String, UserType> hashMap = new HashMap<String, UserType>();
        if (elements.getUserTypes() != null) {
            for (UserType object2 : elements.getUserTypes()) {
                hashMap.put(object2.getId(), object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        Table table = database.getTable("EmployeeFiles");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                UserType userType;
                Row row = table.getNextRow();
                String string = this.a(row, "EmployeeID");
                String string2 = this.a(row, "FirstName");
                String string3 = this.a(row, "LastName");
                String string4 = this.a(row, "SocialSecurityNumber");
                String string5 = this.a(row, "AccessCode");
                String string6 = this.a(row, "JobTitleID");
                String string7 = this.a(row, "EmailAddress");
                Double d = POSUtil.parseDouble(this.a(row, "PayRate"));
                Boolean bl = POSUtil.getBoolean(this.a(row, "UseStaffBank"));
                Boolean bl2 = POSUtil.getBoolean(this.a(row, "EmployeeIsDriver"));
                Boolean bl3 = !POSUtil.getBoolean(this.a(row, "EmployeeInActive"));
                User user = new User(string);
                user.setFirstName(string2);
                user.setLastName(string3);
                user.setSsn(string4);
                user.setRoot(true);
                user.setEmail(string7);
                if (string6 != null && (userType = (UserType)hashMap.get(string6)) != null) {
                    user.setTypeName(userType.getName());
                }
                user.setStaffBank(bl);
                user.setDriver(bl2);
                user.setUserTypeId(string6);
                if (StringUtils.isNotBlank((String)string5)) {
                    user.setEncryptedPassword(string5);
                }
                user.setCostPerHour(d);
                user.setActive(bl3);
                arrayList.add(user);
            }
        }
        elements.setUsers(arrayList);
    }

    private void f(Database database, Elements elements) throws IOException {
        ArrayList<UserType> arrayList = new ArrayList<UserType>();
        Table table = database.getTable("JobTitles");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "JobTitleID");
                String string2 = this.a(row, "JobTitleText");
                Integer n = POSUtil.parseInteger(this.a(row, "DefaultSecurityLevel"));
                UserType userType = new UserType(string);
                userType.setPermissions(this.a(n));
                userType.setName(string2);
                arrayList.add(userType);
            }
        }
        elements.setUserTypes(arrayList);
    }

    private HashSet<UserPermission> a(Integer n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                return new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions));
            }
            case 0: 
            case 1: 
            case 2: {
                return new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET, UserPermission.EDIT_OTHER_USERS_TICKETS));
            }
        }
        return null;
    }

    private void g(Database database, Elements elements) throws IOException {
        ArrayList<Customer> arrayList = new ArrayList<Customer>();
        Table table = database.getTable("CustomerFiles");
        if (table != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Row row = table.getNextRow();
                String string = this.a(row, "CustomerID");
                String string2 = this.a(row, "CustomerName");
                String string3 = this.a(row, "DeliveryAddress");
                String string4 = this.a(row, "ZipCode");
                String string5 = this.a(row, "EmailAddress");
                String string6 = this.a(row, "PhoneNumber");
                Customer customer = new Customer(string);
                customer.setFirstName(string2);
                customer.setAddress(string3);
                customer.setZipCode(string4);
                customer.setEmail(string5);
                customer.setMobileNo(string6);
                customer.setActive(true);
                arrayList.add(customer);
            }
        }
        elements.setCustomers(arrayList);
    }

    private String a(Row row, String string) {
        String string2 = String.valueOf(row.getOrDefault((Object)string, (Object)""));
        if (string2.equals("null")) {
            return null;
        }
        return string2;
    }

    private void a(Elements elements) {
        try {
            DataImportDialog dataImportDialog = new DataImportDialog(elements);
            dataImportDialog.setSize(PosUIManager.getSize((int)800, (int)550));
            dataImportDialog.open();
            if (dataImportDialog.isCanceled()) {
                return;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }
}

