/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.AboutAction;
import com.floreantpos.actions.CacheDataUpdateAction;
import com.floreantpos.actions.DefaultPriceAction;
import com.floreantpos.actions.ImageGalleryAction;
import com.floreantpos.actions.PayoutReasonAction;
import com.floreantpos.actions.PluginsAction;
import com.floreantpos.actions.RecalculateTicketsAction;
import com.floreantpos.actions.SetupWizardAction;
import com.floreantpos.actions.VoidReasonAction;
import com.floreantpos.bo.actions.AttendanceHistoryAction;
import com.floreantpos.bo.actions.BackofficeWindowCloseListener;
import com.floreantpos.bo.actions.BalanceUpdateTransactionHistoryAction;
import com.floreantpos.bo.actions.BrandExplorerAction;
import com.floreantpos.bo.actions.CategorywiseSalesReport;
import com.floreantpos.bo.actions.CookingInstructionExplorerAction;
import com.floreantpos.bo.actions.CouponExplorerAction;
import com.floreantpos.bo.actions.CourseExplorerAction;
import com.floreantpos.bo.actions.CreditCardReportAction;
import com.floreantpos.bo.actions.CronJobScheduleExplorerAction;
import com.floreantpos.bo.actions.CurrencyExplorerAction;
import com.floreantpos.bo.actions.CustomerAccountReportAction;
import com.floreantpos.bo.actions.CustomerMonitorConfigurationAction;
import com.floreantpos.bo.actions.CustomerPaymentReportAction;
import com.floreantpos.bo.actions.DashboardAction;
import com.floreantpos.bo.actions.DataResetAction;
import com.floreantpos.bo.actions.DataServiceConfigurationAction;
import com.floreantpos.bo.actions.DatabaseBackupAction;
import com.floreantpos.bo.actions.DatabaseRestoreAction;
import com.floreantpos.bo.actions.DeliverySummaryReportAction;
import com.floreantpos.bo.actions.DepartmentAction;
import com.floreantpos.bo.actions.DiscountReportAction;
import com.floreantpos.bo.actions.DrawerPullReportExplorerAction;
import com.floreantpos.bo.actions.EmployeeAttendanceAction;
import com.floreantpos.bo.actions.EndOfDaySummaryReporAction;
import com.floreantpos.bo.actions.GiftCardBrowserAction;
import com.floreantpos.bo.actions.GiftCardGenerateAction;
import com.floreantpos.bo.actions.GiftCardSummaryReportAction;
import com.floreantpos.bo.actions.GiftCardTransactionReportAction;
import com.floreantpos.bo.actions.HourlySalesReportAction;
import com.floreantpos.bo.actions.ImportFromExcelAction;
import com.floreantpos.bo.actions.ImportFromOtherPosAction;
import com.floreantpos.bo.actions.ItemExplorerAction;
import com.floreantpos.bo.actions.ItemwiseSalesReportAction;
import com.floreantpos.bo.actions.JournalReportAction;
import com.floreantpos.bo.actions.KeyStatisticsSalesReportAction;
import com.floreantpos.bo.actions.KitchenDisplayAction;
import com.floreantpos.bo.actions.LanguageSelectionAction;
import com.floreantpos.bo.actions.MailTemplateConfigurationExplorerAction;
import com.floreantpos.bo.actions.MenuPageExplorerAction;
import com.floreantpos.bo.actions.MigrateDatabaseAction;
import com.floreantpos.bo.actions.MigrateFloreantposAction;
import com.floreantpos.bo.actions.MultiplierExplorerAction;
import com.floreantpos.bo.actions.OpenTicketSummaryReportAction;
import com.floreantpos.bo.actions.OrdersTypeExplorerAction;
import com.floreantpos.bo.actions.PaymentReceivedReportAction;
import com.floreantpos.bo.actions.PaymentToBeConfirmAction;
import com.floreantpos.bo.actions.PayoutReportAction;
import com.floreantpos.bo.actions.PayrollReportAction;
import com.floreantpos.bo.actions.PizzaItemExplorerAction;
import com.floreantpos.bo.actions.PriceExplorerAction;
import com.floreantpos.bo.actions.ReceiptConfigurationExplorerAction;
import com.floreantpos.bo.actions.SalesAreaExplorerAction;
import com.floreantpos.bo.actions.SalesBalanceReportAction;
import com.floreantpos.bo.actions.SalesByEmployeeReportAction;
import com.floreantpos.bo.actions.SalesDetailReportAction;
import com.floreantpos.bo.actions.SalesExceptionReportAction;
import com.floreantpos.bo.actions.SalesReportAction;
import com.floreantpos.bo.actions.SalesTaxReportAction;
import com.floreantpos.bo.actions.ServerProductivityReportAction;
import com.floreantpos.bo.actions.ServiceExplorerAction;
import com.floreantpos.bo.actions.SessionSummaryReportAction;
import com.floreantpos.bo.actions.ShiftExplorerAction;
import com.floreantpos.bo.actions.ShiftwiseSalesSummaryReportAction;
import com.floreantpos.bo.actions.ShowReleaseNoteAction;
import com.floreantpos.bo.actions.StaffBankReportAction;
import com.floreantpos.bo.actions.StoreConfigurationAction;
import com.floreantpos.bo.actions.StoreSessionExplorerAction;
import com.floreantpos.bo.actions.TaxExemptReportAction;
import com.floreantpos.bo.actions.TaxExplorerAction;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.actions.TerminalExplorerAction;
import com.floreantpos.bo.actions.TicketExplorerAction;
import com.floreantpos.bo.actions.TracTipsReportAction;
import com.floreantpos.bo.actions.UserAndRoleExplorerAction;
import com.floreantpos.bo.actions.VoidItemReportAction;
import com.floreantpos.bo.actions.VoidPaymentReportAction;
import com.floreantpos.bo.actions.WeeklyPayrollReportAction;
import com.floreantpos.bo.actions.WorkHourCalculationAction;
import com.floreantpos.bo.ui.MenuScroller;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customPayment.CustomPaymentBrowserAction;
import com.floreantpos.extension.CloudSyncPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ToolbarBlinkButton;
import com.floreantpos.teminaltype.TerminalTypeAction;
import com.floreantpos.ui.FooterPanel;
import com.floreantpos.ui.floorplan.ShowTableBrowserAction;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudSyncAction;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class BackOfficeWindow
extends JFrame
implements ComponentListener {
    private static final String a = "bwy";
    private static final String b = "bwx";
    private static final String c = "bwheight";
    private static final String d = "bwwidth";
    private JMenu e;
    private static BackOfficeWindow f;
    private JMenuBar g;
    private JPanel h;
    private JTabbedPane i;
    private JComboBox j;
    private ToolbarBlinkButton k;
    private ToolbarBlinkButton l;
    private FooterPanel m;
    private final User n;
    private boolean o;
    private JButton p;
    private JButton q;
    private JButton r;
    private JButton s;
    private JButton t;
    private JButton u;

    public BackOfficeWindow(User user) {
        this(user, false);
    }

    public BackOfficeWindow(User user, boolean bl) {
        this.n = user;
        this.o = bl;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/icon.png")).getImage());
        this.i();
        this.createMenus();
        this.b();
        this.g();
        this.setDefaultCloseOperation(0);
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = VersionInfo.getAppName() + " " + VersionInfo.getVersion() + "- " + POSConstants.BACK_OFFICE;
        if (terminal.isMasterTerminal().booleanValue()) {
            string = string + Messages.getString("BackOfficeWindow.3");
        }
        this.setTitle(string);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        f = this;
        this.h();
        JMenu jMenu = new JMenu(Messages.getString("BackOfficeWindow.0"));
        jMenu.add(new AboutAction());
        jMenu.add(new PluginsAction());
        jMenu.add(new ShowReleaseNoteAction());
        this.g.add(jMenu);
        this.a();
        new DashboardAction().execute();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BackOfficeWindow.this.close();
            }
        });
        this.addComponentListener(this);
    }

    private void a() {
        this.m = new FooterPanel();
        this.m.initTimers();
        this.add((Component)this.m, "South");
        this.f();
    }

    public FooterPanel getStatusBar() {
        return this.m;
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill, hidemode 3"));
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.k = new ToolbarBlinkButton(Messages.getString("CacheDataUpdateAction.0"));
        this.k.setBackground(UIManager.getColor("Control.background"));
        this.k.setOriginalBackColor(UIManager.getColor("Control.background"));
        this.k.setIcon(IconFactory.getIcon("refresh_24.png"));
        this.k.addActionListener(actionEvent -> this.e());
        this.k.setHideActionText(false);
        this.k.setBorderPainted(false);
        this.l = new ToolbarBlinkButton(Messages.getString("BackOfficeWindow.4"));
        this.l.setBackground(UIManager.getColor("Control.background"));
        this.l.setOriginalBackColor(UIManager.getColor("Control.background"));
        this.l.setAction(new CloudSyncAction(Boolean.TRUE, Messages.getString("BackOfficeWindow.5")));
        this.l.setHideActionText(false);
        this.l.setBorderPainted(false);
        this.l.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLOUD_QUEUE, (float)PosUIManager.getSize((int)25)));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0, hidemode 3"));
        this.p = new JButton(new DashboardAction());
        this.p.setBackground(UIManager.getColor("Control.background"));
        this.p.setBorderPainted(false);
        this.p.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.DASHBOARD, (float)PosUIManager.getSize((int)25)));
        jPanel2.add(this.p);
        jPanel2.add((Component)this.c(), "growy");
        this.q = new JButton(new UserAndRoleExplorerAction());
        this.r = new JButton(new StoreConfigurationAction());
        this.s = new JButton(new TerminalConfigurationAction(DataProvider.get().getCurrentTerminal()));
        if (this.n.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            this.q.setBackground(UIManager.getColor("Control.background"));
            this.q.setBorderPainted(false);
            this.q.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.USERS, (float)PosUIManager.getSize((int)25)));
            this.r.setBackground(UIManager.getColor("Control.background"));
            this.r.setBorderPainted(false);
            this.r.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.STORE, (float)PosUIManager.getSize((int)25)));
            this.s.setBackground(UIManager.getColor("Control.background"));
            this.s.setBorderPainted(false);
            this.s.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.DEVICES, (float)PosUIManager.getSize((int)25)));
            jPanel2.add(this.q);
            jPanel2.add((Component)this.c(), "growy");
            jPanel2.add(this.r);
            jPanel2.add((Component)this.c(), "growy");
            jPanel2.add(this.s);
            jPanel2.add((Component)this.c(), "growy");
        }
        this.t = new JButton(new ItemExplorerAction());
        this.t.setBackground(UIManager.getColor("Control.background"));
        this.t.setBorderPainted(false);
        this.t.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.DATABASE, (float)PosUIManager.getSize((int)20)));
        jPanel2.add(this.t);
        this.u = new JButton(new MenuPageExplorerAction());
        this.u.setBackground(UIManager.getColor("Control.background"));
        this.u.setBorderPainted(false);
        this.u.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.BORDER_CLEAR, (float)PosUIManager.getSize((int)25)));
        jPanel2.add((Component)this.c(), "growy");
        jPanel2.add(this.u);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PrintConfigurationView.10"));
        jPanel3.add(jLabel);
        this.j = new JComboBox<PaperSize>(PaperSize.values());
        jPanel3.add(this.j);
        this.d();
        CloudSyncPlugin cloudSyncPlugin = (CloudSyncPlugin)ExtensionManager.getPlugin(CloudSyncPlugin.class);
        if (cloudSyncPlugin != null && cloudSyncPlugin.hasValidLicense()) {
            jPanel2.add((Component)this.c(), "growy");
            jPanel2.add(this.l);
            jPanel2.add((Component)this.c(), "growy");
        }
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "left");
        jPanel.add((Component)this.k, "right");
        this.add((Component)jPanel, "North");
        this.j.addActionListener(actionEvent -> this.a(this.j.getSelectedItem()));
        jPanel3.setVisible(Application.getInstance().isDevelopmentMode());
        this.l.setToolTipText(this.l.getText());
        this.p.setToolTipText(this.p.getText());
        this.q.setToolTipText(this.q.getText());
        this.r.setToolTipText(this.r.getText());
        this.s.setToolTipText(this.s.getText());
        this.t.setToolTipText(this.t.getText());
        this.u.setToolTipText(this.u.getText());
        this.k.setToolTipText(this.k.getText());
    }

    private JSeparator c() {
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setBackground(Color.BLACK);
        return jSeparator;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m != null) {
            this.m.startOrStopTimer(bl);
        }
    }

    private void d() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = terminal.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)string)) {
            PaperSize paperSize = PaperSize.valueOf(string);
            this.j.setSelectedItem((Object)paperSize);
        }
    }

    private void e() {
        new CacheDataUpdateAction(true, true).execute();
        this.d();
        this.f();
    }

    private void f() {
        try {
            this.m.updateView(this.n);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Object object) {
        try {
            DataProvider.get().refreshCurrentTerminal();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            PaperSize paperSize = (PaperSize)((Object)object);
            terminal.addProperty("report.paper_size", paperSize.name());
            TerminalDAO.getInstance().update(terminal);
        }
        catch (Exception exception) {
            PosLog.debug(this.getClass(), exception.getMessage());
        }
    }

    private void g() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = AppConfig.getInt(d, (int)dimension.getWidth());
        int n2 = AppConfig.getInt(c, (int)dimension.getHeight());
        this.setSize(n, n2);
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        n3 = AppConfig.getInt(b, n3);
        n4 = AppConfig.getInt(a, n4);
        this.setLocation(n3, n4);
    }

    protected void createMenus() {
        UserType userType = this.n.getType();
        this.g = new JMenuBar();
        if (userType == null) {
            this.createAdminMenu(this.g);
            this.a(this.g);
            this.createReportMenu(this.g);
            this.createFloorMenu(this.g);
        } else {
            if (this.n.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
                this.createAdminMenu(this.g);
            }
            if (this.n.hasPermissionInAnyRole(UserPermission.VIEW_EXPLORERS)) {
                this.a(this.g);
            }
            if (this.n.hasPermissionInAnyRole(UserPermission.VIEW_REPORTS)) {
                this.createReportMenu(this.g);
            }
        }
        this.createFloorMenu(this.g);
        this.setJMenuBar(this.g);
    }

    private void h() {
        for (FloreantPlugin object : ExtensionManager.getPlugins()) {
            object.initBackoffice(this);
        }
        OroLicense oroLicense = Application.getInstance().getLicense();
        for (FloreantPlugin floreantPlugin : ExtensionManager.getInactivePlugins()) {
            String string = "";
            if (oroLicense == null) continue;
            string = oroLicense.getHolderEmail() == null ? "" : oroLicense.getHolderEmail();
            floreantPlugin.initAboutMenu(this, string);
        }
    }

    protected void createReportMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.REPORTS);
        jMenu.add(new SalesReportAction());
        jMenu.add(new ItemwiseSalesReportAction());
        jMenu.add(new CategorywiseSalesReport());
        jMenu.add(new ShiftwiseSalesSummaryReportAction());
        jMenu.add(new SalesByEmployeeReportAction());
        jMenu.add(new HourlySalesReportAction());
        jMenu.add(new SalesBalanceReportAction());
        jMenu.add(new SalesDetailReportAction());
        jMenu.add(new KeyStatisticsSalesReportAction());
        jMenu.add(new SalesExceptionReportAction());
        jMenu.add(new SalesTaxReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new EndOfDaySummaryReporAction());
        jMenu.add(new DeliverySummaryReportAction());
        jMenu.add(new OpenTicketSummaryReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new PaymentReceivedReportAction());
        jMenu.add(new CreditCardReportAction());
        jMenu.add(new CustomerPaymentReportAction());
        jMenu.add(new CustomerAccountReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new VoidItemReportAction());
        jMenu.add(new VoidPaymentReportAction());
        jMenu.add(new DiscountReportAction());
        jMenu.add(new PayoutReportAction());
        jMenu.add(new TaxExemptReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new PayrollReportAction());
        jMenu.add(new WeeklyPayrollReportAction());
        jMenu.add(new TracTipsReportAction());
        jMenu.add(new ServerProductivityReportAction());
        jMenu.add(new EmployeeAttendanceAction());
        jMenu.add(new StaffBankReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new GiftCardSummaryReportAction());
        jMenu.add(new GiftCardTransactionReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new JournalReportAction());
        jMenu.add(new SessionSummaryReportAction());
        this.a(jMenu);
        jMenuBar.add(jMenu);
    }

    private void a(JMenu jMenu) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jMenu.getPopupMenu().getPreferredSize();
        if (dimension2.height > dimension.height - 60) {
            MenuScroller.setScrollerFor(jMenu, 22);
        }
    }

    private void a(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.EXPLORERS);
        jMenuBar.add(jMenu);
        jMenu.add(new MenuPageExplorerAction());
        jMenu.add(new ItemExplorerAction());
        jMenu.add(new PizzaItemExplorerAction());
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension != null) {
            jMenu.add(new ServiceExplorerAction());
        }
        jMenu.add(new JSeparator());
        jMenu.add(new ShiftExplorerAction());
        jMenu.add(new MultiplierExplorerAction());
        jMenu.add(new VoidReasonAction());
        jMenu.add(new PayoutReasonAction());
        jMenu.add(new CookingInstructionExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new CourseExplorerAction());
        jMenu.add(new BrandExplorerAction());
        jMenu.add(new CouponExplorerAction());
        jMenu.add(new DefaultPriceAction());
        jMenu.add(new PriceExplorerAction());
        jMenu.add(new JSeparator());
        if (this.n.hasPermissionInAnyRole(UserPermission.VIEW_GIFT_CARD)) {
            jMenu.add(new GiftCardBrowserAction());
        }
        jMenu.add(new StoreSessionExplorerAction());
        jMenu.add(new TicketExplorerAction());
        jMenu.add(new PaymentToBeConfirmAction());
        jMenu.add(new DrawerPullReportExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new ImageGalleryAction());
        jMenu.add(new JSeparator());
        jMenu.add(new AttendanceHistoryAction());
        jMenu.add(new WorkHourCalculationAction());
        if (Application.getInstance().isDevelopmentMode()) {
            jMenu.add(new BalanceUpdateTransactionHistoryAction());
        }
        if (orderServiceExtension == null) {
            return;
        }
        this.a(jMenu);
        orderServiceExtension.createCustomerMenu(jMenu);
    }

    protected void createAdminMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.ADMIN);
        jMenu.add(new DashboardAction());
        jMenu.add(new JSeparator());
        jMenu.add(new StoreConfigurationAction());
        jMenu.add(new TerminalConfigurationAction(DataProvider.get().getCurrentTerminal()));
        if (this.n.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK) || this.n.hasPermissionInAnyRole(UserPermission.PERFORM_MANAGER_TASK)) {
            jMenu.add(new ReceiptConfigurationExplorerAction());
        }
        jMenu.add(new MailTemplateConfigurationExplorerAction());
        jMenu.add(new KitchenDisplayAction());
        jMenu.add(new CustomerMonitorConfigurationAction());
        jMenu.add(new DataServiceConfigurationAction());
        jMenu.add(new JSeparator());
        jMenu.add(new UserAndRoleExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new DepartmentAction());
        jMenu.add(new SalesAreaExplorerAction());
        jMenu.add(new TerminalExplorerAction());
        jMenu.add(new TerminalTypeAction());
        if (TerminalConfig.isMultipleOrderSupported()) {
            jMenu.add(new OrdersTypeExplorerAction());
        }
        jMenu.add(new JSeparator());
        jMenu.add(new CurrencyExplorerAction());
        jMenu.add(new TaxExplorerAction());
        jMenu.add(new CustomPaymentBrowserAction());
        jMenu.add(new JSeparator());
        jMenu.add(new CronJobScheduleExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new LanguageSelectionAction());
        jMenu.add(new SetupWizardAction());
        jMenu.add(new JSeparator());
        if (Application.getInstance().isDevelopmentMode()) {
            jMenu.add(new RecalculateTicketsAction());
        }
        jMenu.add(new DataResetAction());
        jMenu.add(new MigrateDatabaseAction());
        jMenu.add(new MigrateFloreantposAction());
        jMenu.add(new JSeparator());
        jMenu.add(new DatabaseBackupAction());
        jMenu.add(new DatabaseRestoreAction());
        jMenu.add(new JSeparator());
        jMenu.add(new ImportFromExcelAction());
        jMenu.add(new ImportFromOtherPosAction());
        jMenu.add(new JSeparator());
        AbstractAction abstractAction = new AbstractAction("Restart"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.restart();
            }
        };
        jMenu.add(abstractAction);
        JMenuItem jMenuItem = jMenu.add(new AbstractAction(POSConstants.CLOSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BackOfficeWindow.this.close();
                if (BackOfficeWindow.this.o) {
                    new BackofficeWindowCloseListener(BackOfficeWindow.this).windowClosing(null);
                }
            }
        });
        jMenu.add(jMenuItem);
        this.a(jMenu);
        jMenuBar.add(jMenu);
    }

    protected void createFloorMenu(JMenuBar jMenuBar) {
        this.e = new JMenu(Messages.getString("BackOfficeWindow.2"));
        this.e.add(new ShowTableBrowserAction());
        jMenuBar.add(this.e);
    }

    protected void createGiftCardMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(Messages.getString("GiftCard"));
        jMenu.add(new GiftCardGenerateAction());
        jMenu.add(new GiftCardBrowserAction());
        jMenuBar.add(jMenu);
    }

    private void i() {
        this.h = new JPanel();
        this.i = new JTabbedPane();
        this.i.putClientProperty("JTabbedPane.tabType", "card");
        this.i.putClientProperty("JTabbedPane.tabClosable", true);
        this.i.putClientProperty("JTabbedPane.tabCloseToolTipText", "Close");
        this.i.putClientProperty("JTabbedPane.tabCloseCallback", (jTabbedPane, n) -> jTabbedPane.remove((int)n));
        this.getContentPane().setLayout(new BorderLayout(5, 0));
        this.setDefaultCloseOperation(3);
        this.h.setLayout(new BorderLayout(5, 0));
        this.h.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.h.add((Component)this.i, "Center");
        this.getContentPane().add((Component)this.h, "Center");
        this.i.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                Component component = jTabbedPane.getSelectedComponent();
                if (component instanceof ExplorerView) {
                    ((ExplorerView)((Object)component)).initData();
                }
            }
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.i;
    }

    private void j() {
        AppConfig.putInt(d, this.getWidth());
        AppConfig.putInt(c, this.getHeight());
        AppConfig.putInt(b, this.getX());
        AppConfig.putInt(a, this.getY());
    }

    public void close() {
        this.j();
        this.dispose();
    }

    public static BackOfficeWindow getInstance() {
        return f;
    }

    public JMenuBar getBackOfficeMenuBar() {
        return this.g;
    }

    public JMenu getFloorPlanMenu() {
        return this.e;
    }

    public void setFloorPlanMenu(JMenu jMenu) {
        this.e = jMenu;
    }

    @Override
    public void dispose() {
        f = null;
        super.dispose();
    }

    public User getCurrentUser() {
        return this.n;
    }

    public void blinkCacheRefreshButton() {
        this.k.setBlinking(true);
    }

    public void blinkSyncButton() {
        this.l.setBlinking(true);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getSize().width < 1280) {
            this.l.setText("");
            this.p.setText("");
            this.q.setText("");
            this.r.setText("");
            this.s.setText("");
            this.t.setText("");
            this.u.setText("");
        } else {
            this.l.setText(this.l.getToolTipText());
            this.p.setText(this.p.getToolTipText());
            this.q.setText(this.q.getToolTipText());
            this.r.setText(this.r.getToolTipText());
            this.s.setText(this.s.getToolTipText());
            this.t.setText(this.t.getToolTipText());
            this.u.setText(this.u.getToolTipText());
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

