/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.DateChoserDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class AttendanceHistoryExplorer
extends TransparentPanel {
    private SimpleDateFormat a = new SimpleDateFormat("MMM dd, YYYY hh:mm a");
    private JButton b = new JButton(POSConstants.GO);
    private JButton c = new JButton(Messages.getString("AttendanceHistoryExplorer.0"));
    private JButton d = new JButton(Messages.getString("AttendanceHistoryExplorer.1"));
    private JXTable e;
    private JComboBox f;
    private JPanel g;
    private JXDatePicker h;
    private JXDatePicker i;
    private AttendenceHistoryTableModel j = new AttendenceHistoryTableModel();

    public AttendanceHistoryExplorer() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.f = new JComboBox();
        List<User> list = UserDAO.getInstance().findAllActive();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.h = UiUtil.getCurrentMonthStart();
        this.h.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)new JLabel(POSConstants.START_DATE), "grow");
        jPanel.add((Component)this.h);
        this.i = UiUtil.getCurrentMonthEnd();
        jPanel.add((Component)new JLabel(POSConstants.END_DATE), "grow");
        this.i.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)this.i);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.f);
        jPanel.add((Component)this.b, "skip 1, al right");
        JButton jButton = new JButton(Messages.getString("RESET"));
        jButton.addActionListener(actionEvent -> this.a());
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.g = new JPanel(new BorderLayout());
        this.add(this.g);
        this.b();
    }

    private void a() {
        JXDatePicker jXDatePicker = UiUtil.getCurrentMonthStart();
        this.h.setDate(jXDatePicker.getDate());
        JXDatePicker jXDatePicker2 = UiUtil.getCurrentMonthEnd();
        this.i.setDate(jXDatePicker2.getDate());
        this.f.setSelectedIndex(0);
        this.c();
    }

    private void b() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.c);
        jPanel.add(this.d);
        this.add((Component)jPanel, "South");
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AttendanceHistoryExplorer.this.c();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(AttendanceHistoryExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AttendanceHistoryExplorer.this.e != null) {
                    int n = AttendanceHistoryExplorer.this.e.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(AttendanceHistoryExplorer.this, Messages.getString("AttendanceHistoryExplorer.4"));
                        return;
                    }
                    int n2 = AttendanceHistoryExplorer.this.e.convertRowIndexToModel(n);
                    AttendenceHistoryTableModel attendenceHistoryTableModel = (AttendenceHistoryTableModel)AttendanceHistoryExplorer.this.e.getModel();
                    AttendenceHistory attendenceHistory = (AttendenceHistory)attendenceHistoryTableModel.getRowData(n2);
                    Date date = attendenceHistory.getClockInTime();
                    Date date2 = attendenceHistory.getClockOutTime();
                    DateChoserDialog dateChoserDialog = new DateChoserDialog(attendenceHistory, Messages.getString("AttendanceHistoryExplorer.5"));
                    dateChoserDialog.pack();
                    dateChoserDialog.open();
                    if (dateChoserDialog.isCanceled()) {
                        return;
                    }
                    if (dateChoserDialog.getAttendenceHistory() != null) {
                        attendenceHistory = dateChoserDialog.getAttendenceHistory();
                    }
                    AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
                    attendenceHistoryDAO.saveOrUpdate(attendenceHistory);
                    String string = String.format("User %s's attendance history changed by user %s, ", Application.getCurrentUser().getId(), attendenceHistory.getUserId());
                    string = string + String.format("Previous clock in time: %s\n", DateUtil.formatDateWithTime(date));
                    string = string + String.format("Changed clock in time: %s\n", DateUtil.formatDateWithTime(attendenceHistory.getClockInTime()));
                    string = string + String.format("Previous clock out time: %s\n", date2 != null ? DateUtil.formatDateWithTime(date2) : POSConstants.NONE);
                    string = string + String.format("Changed clock out time: %s\n", attendenceHistory.getClockOutTime() != null ? DateUtil.formatDateWithTime(attendenceHistory.getClockOutTime()) : POSConstants.NONE);
                    ActionHistoryDAO.saveHistory(Application.getCurrentUser(), "ATTENDANCE HISTORY CHANGE", string);
                    attendenceHistoryTableModel.updateItem(n);
                }
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChoserDialog dateChoserDialog = new DateChoserDialog(Messages.getString("AttendanceHistoryExplorer.6"));
                dateChoserDialog.pack();
                dateChoserDialog.open();
                if (dateChoserDialog.isCanceled()) {
                    return;
                }
                AttendenceHistory attendenceHistory = null;
                if (dateChoserDialog.getAttendenceHistory() != null) {
                    attendenceHistory = dateChoserDialog.getAttendenceHistory();
                }
                AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
                attendenceHistoryDAO.saveOrUpdate(attendenceHistory);
                String string = String.format("User %s's attendance history added by user %s, ", Application.getCurrentUser().getId(), attendenceHistory.getUserId());
                string = string + String.format("Clock in time: %s\n", DateUtil.formatDateWithTime(attendenceHistory.getClockInTime()));
                string = string + String.format("Clock out time: %s\n", attendenceHistory.getClockOutTime() != null ? DateUtil.formatDateWithTime(attendenceHistory.getClockOutTime()) : POSConstants.NONE);
                ActionHistoryDAO.saveHistory(Application.getCurrentUser(), "ATTENDANCE HISTORY ADD", string);
                AttendanceHistoryExplorer.this.j.addItem(attendenceHistory);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        try {
            AttendenceHistoryDAO attendenceHistoryDAO;
            List<AttendenceHistory> list;
            this.g.removeAll();
            Date date = this.h.getDate();
            Date date2 = this.i.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(this.h.getDate());
            date2 = DateUtil.endOfDay(this.i.getDate());
            User user = null;
            if (!this.f.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.f.getSelectedItem();
            }
            if ((list = (attendenceHistoryDAO = new AttendenceHistoryDAO()).findHistory(date, date2, user)) == null || list.isEmpty()) {
                this.d.setVisible(false);
                this.c.setVisible(false);
                return;
            }
            this.e = new JXTable();
            this.j.setRows(list);
            this.e.setModel((TableModel)this.j);
            this.e.setRowHeight(PosUIManager.getSize((int)30));
            this.e.getSelectionModel().setSelectionMode(0);
            this.e.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
            JScrollPane jScrollPane = new JScrollPane((Component)this.e);
            this.g.add((Component)jScrollPane, "Center");
            this.resizeColumnWidth((JTable)this.e);
            this.d.setVisible(true);
            this.c.setVisible(true);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            this.g.revalidate();
            this.g.repaint();
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(5);
        arrayList.add(20);
        arrayList.add(400);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(40);
        arrayList.add(40);
        arrayList.add(40);
        return arrayList;
    }

    class AttendenceHistoryTableModel
    extends ListTableModel {
        String[] a = new String[]{Messages.getString("AttendanceHistoryExplorer.14"), Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("colRole"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("AttendanceHistoryExplorer.11"), Messages.getString("AttendanceHistoryExplorer.12"), Messages.getString("AttendanceHistoryExplorer.13")};

        public AttendenceHistoryTableModel() {
            this.setColumnNames(this.a);
        }

        AttendenceHistoryTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.a);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttendenceHistory attendenceHistory = (AttendenceHistory)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    return attendenceHistory.getUser().getId();
                }
                case 2: {
                    return attendenceHistory.getUser().getFirstName() + " " + attendenceHistory.getUser().getLastName();
                }
                case 3: {
                    return attendenceHistory.getUser().getTypeName();
                }
                case 4: {
                    Date date = attendenceHistory.getClockInTime();
                    if (date != null) {
                        return AttendanceHistoryExplorer.this.a.format(date);
                    }
                    return "";
                }
                case 5: {
                    Date date = attendenceHistory.getClockOutTime();
                    if (date != null) {
                        return AttendanceHistoryExplorer.this.a.format(date);
                    }
                    return "";
                }
                case 6: {
                    return attendenceHistory.isClockedOut() == false;
                }
                case 7: {
                    if (attendenceHistory.getShift() == null) {
                        return "";
                    }
                    return attendenceHistory.getShift().getId();
                }
                case 8: {
                    return attendenceHistory.getTerminal().getId();
                }
            }
            return null;
        }
    }
}

