/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Brand;
import com.floreantpos.model.dao.BrandDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.model.BrandForm;

public class BrandExplorer
extends BeanTableExplorerView<Brand> {
    public BrandExplorer() {
        super(Brand.class);
    }

    @Override
    public void initTableModel(BeanTableModel<Brand> beanTableModel) {
        beanTableModel.addColumn(Messages.getString("BrandExplorer.0"), Brand.PROP_ID);
        beanTableModel.addColumn(Messages.getString("BrandExplorer.1"), Brand.PROP_NAME);
    }

    @Override
    public void initData() {
        this.setRows(BrandDAO.getInstance().findAll());
    }

    @Override
    public Brand createNew() {
        BrandForm brandForm = new BrandForm();
        return super.openNewForm(brandForm);
    }

    @Override
    public Brand editSelectedRow(Brand brand) {
        BrandDAO.getInstance().refresh(brand);
        this.checkDataValidation(brand.isDeleted(), brand.getName());
        BrandForm brandForm = new BrandForm(brand);
        return this.openEditForm(brandForm);
    }

    @Override
    public boolean delete(Brand brand) {
        BrandDAO.getInstance().refresh(brand);
        this.checkDataValidation(brand.isDeleted(), brand.getName());
        BrandDAO.getInstance().delete(brand);
        return true;
    }
}

