/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ComboGroupTreeExplorer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.ui.model.ComboItemExplorerTableModel;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private DoubleTextField a = new DoubleTextField(10);
    private JCheckBox b;
    private JTable c;
    private final ComboItemExplorerTableModel d;
    private MenuItem e;
    private ComboGroupTreeExplorer f;
    private JRadioButton g;
    private JRadioButton h;
    private JRadioButton i;
    private JRadioButton j;
    private JCheckBox k;

    public ComboItemExplorer() {
        this.a();
        this.d = new ComboItemExplorerTableModel();
        this.c.setModel(this.d);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fill"));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(11);
        jLabel.setText(Messages.getString("ComboItemExplorer.6") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        this.a.setHorizontalAlignment(4);
        this.b = new JCheckBox(Messages.getString("MenuItemForm.91"));
        this.b.addActionListener(actionEvent -> this.e.setEditablePrice(this.b.isSelected()));
        jPanel.add((Component)jLabel, "gapleft 5, split 3");
        jPanel.add(this.a);
        jPanel.add((Component)this.b, "wrap");
        this.c = new JTable();
        this.c.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.c.setRowHeight(PosUIManager.getSize((int)30));
        JButton jButton = new JButton(Messages.getString("MenuItemForm.9"));
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton();
        jButton4.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        JButton jButton5 = new JButton();
        jButton5.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.k = new JCheckBox(Messages.getString("ComboItemExplorer.1"));
        this.k.addActionListener(actionEvent -> this.a(actionEvent));
        this.g = new JRadioButton(Messages.getString("BasePriceOnly"));
        this.g.setSelected(true);
        this.h = new JRadioButton(Messages.getString("BaseAndGroupPrice"));
        this.i = new JRadioButton(Messages.getString("SumOfAddedItemsPrice"));
        this.j = new JRadioButton(Messages.getString("HighestPrice"));
        this.g.addItemListener(itemEvent -> this.e());
        this.h.addItemListener(itemEvent -> this.f());
        this.i.addItemListener(itemEvent -> this.g());
        this.j.addItemListener(itemEvent -> this.h());
        jButton5.addActionListener(actionEvent -> this.d());
        jButton4.addActionListener(actionEvent -> this.c());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        JPanel jPanel2 = new JPanel(new WrapLayout(3));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("PricingRule")));
        jPanel2.add((Component)this.g, "wrap");
        jPanel2.add((Component)this.h, "wrap");
        jPanel2.add((Component)this.i, "wrap");
        jPanel2.add((Component)this.j, "wrap");
        jPanel.add((Component)jPanel2, "gaptop 5!,wrap,growx");
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 0 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add((Component)jButton3, "push");
        transparentPanel.add(jButton5);
        transparentPanel.add(jButton4);
        JScrollPane jScrollPane = new JScrollPane(this.c);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(PosUIManager.getSize((int)10));
        jScrollPane.setPreferredSize(PosUIManager.getSize((int)0, (int)172));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.5")));
        jPanel3.add((Component)jScrollPane, "grow,wrap");
        jPanel3.add((Component)transparentPanel, "grow");
        jPanel.add((Component)jPanel3, "grow,newline");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
        this.f = new ComboGroupTreeExplorer();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.12"));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(titledBorder, new EmptyBorder(7, 7, 0, 7)));
        jPanel4.add((Component)this.k, "growy, wrap");
        jPanel4.add((Component)this.f, "grow");
        jPanel.add((Component)jPanel4, "grow, newline");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(jScrollPane2);
    }

    private void b() {
        this.e.setBasePriceForComboItem(false);
        this.e.setBaseAndGroupPriceForComboItem(false);
        this.e.setModifiablePriceForComboItem(false);
        this.e.setHighestPricedComboItem(false);
        this.b.setEnabled(this.g.isSelected() || this.h.isSelected());
    }

    private void c() {
        int n = this.c.getSelectedRow();
        if (n == -1) {
            return;
        }
        n = this.c.convertRowIndexToModel(n);
        int n2 = this.d.getRowCount() - 1 == n ? n : n + 1;
        this.d.moveRow(n, n2);
        this.c.setRowSelectionInterval(n2, n2);
    }

    private void d() {
        int n = this.c.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = (n = this.c.convertRowIndexToModel(n)) == 0 ? 0 : n - 1;
        this.d.moveRow(n, n2);
        this.c.setRowSelectionInterval(n2, n2);
    }

    private void e() {
        this.b();
        this.b.setSelected(this.e.isEditablePrice());
        this.e.setBasePriceForComboItem(true);
        this.k();
    }

    private void f() {
        this.b();
        this.b.setSelected(this.e.isEditablePrice());
        this.e.setBaseAndGroupPriceForComboItem(true);
        this.k();
    }

    private void g() {
        this.b();
        this.b.setSelected(false);
        this.e.setModifiablePriceForComboItem(true);
        this.k();
    }

    private void h() {
        this.b();
        this.b.setSelected(false);
        this.e.setHighestPricedComboItem(true);
        this.k();
    }

    private void a(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.e.setEnableComboQuantitySelection(jCheckBox.isSelected());
    }

    public void setMenuItem(MenuItem menuItem) {
        this.e = menuItem;
        this.i();
    }

    private void i() {
        if (this.e.getComboItems() != null) {
            this.d.setItems(new ArrayList<ComboItem>(this.e.getComboItems()));
        } else {
            this.d.setItems(new ArrayList<ComboItem>());
        }
        this.f.setMenuItem(this.e);
        this.k.setSelected(this.e.isEnableComboQuantitySelection());
        this.g.setSelected(this.e.isBasePriceForComboItem());
        this.h.setSelected(this.e.isBaseAndGroupPriceForComboItem());
        this.i.setSelected(this.e.isModifiablePriceForComboItem());
        this.j.setSelected(this.e.isHighestPricedComboItem());
        if (StringUtils.isEmpty((String)this.e.getId()) && this.g.isSelected()) {
            this.e.setBasePriceForComboItem(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.j();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(Messages.getString("ComboItemExplorer.8"));
                return;
            }
            ComboItem comboItem = this.d.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.d.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void j() {
        try {
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setShowComboItem(false);
            menuItemSelectionDialog.setIncludePizzaItem(false);
            menuItemSelectionDialog.setSize(PosUIManager.getSize((int)600, (int)515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            for (MenuItem object : list) {
                if (!this.e.equals(object)) continue;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CannotAddParentItem"));
                return;
            }
            List<ComboItem> list2 = this.d.getItems();
            for (MenuItem menuItem : list) {
                boolean bl = list2.stream().anyMatch(comboItem -> comboItem.getItemId().equals(menuItem.getId()));
                if (!bl) {
                    ComboItem comboItem2 = new ComboItem();
                    comboItem2.setMenuItem(menuItem);
                    comboItem2.setQuantity(1.0);
                    comboItem2.setCost(menuItem.getCost());
                    Double d = menuItem.getPrice();
                    if (menuItem.isVariant().booleanValue()) {
                        d = d + menuItem.getParentMenuItem().getPrice();
                    }
                    comboItem2.setPrice(d);
                    this.d.addComboItem(comboItem2);
                    continue;
                }
                POSMessageDialog.showMessage(Messages.getString("ComboItemExplorer.3"));
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog();
            comboItemEntryDialog.setComboItemTitle(comboItem.getName());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            Double d = comboItemEntryDialog.getQuantity();
            boolean bl = MenuItemDAO.getInstance().isFractionalUnit(comboItem.getItemId());
            if (NumberUtil.isFractional(d).booleanValue() && !bl) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FractionalQuantityNotAllowed"));
                return;
            }
            comboItem.setQuantity(d);
            this.d.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.d.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        List<ComboItem> list = this.d.getItems();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).putSortOrder(i);
        }
        return list;
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.f.getGroups();
    }

    public DoubleTextField getTfPrice() {
        return this.a;
    }

    public JCheckBox getChkEditablePrice() {
        return this.b;
    }

    private void k() {
        if (this.f != null) {
            this.f.doRearrangeComboGroupTableComlums();
        }
    }
}

