/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.CopyToClipboardAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomPaymentTransactionDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumn;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdesktop.swingx.JXDatePicker;

public class CustomTransactionExplorer
extends TransparentPanel
implements PosTable.PosTableClickListener {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private PosTable d;
    private BeanTableModel<CustomPaymentTransaction> e;
    private JButton f;
    private JButton g;
    private FixedLengthTextField h;
    private FixedLengthTextField i;
    private JButton j;
    private JButton k;
    private JLabel l;

    public CustomTransactionExplorer() {
        this.a();
        this.g();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.e = new BeanTableModel(CustomPaymentTransaction.class);
        this.e.addColumn(Messages.getString("CustomTransactionExplorer.0"), CustomPaymentTransaction.PROP_ID);
        this.e.addColumn(Messages.getString("CustomTransactionExplorer.6"), "transactionEntityNo");
        this.e.addColumn(Messages.getString("CustomTransactionExplorer.1"), "TransactionTimeWithoutSec");
        this.e.addColumn(POSConstants.CUSTOMER, "customerName");
        this.e.addColumn(POSConstants.NOTES, "customPaymentRefDisplay");
        this.e.addColumn(POSConstants.TOTAL, CustomPaymentTransaction.PROP_AMOUNT, 4, BeanTableModel.DataType.MONEY);
        this.e.addColumn(POSConstants.CONFIRM, "ConfirmPayment");
        this.d = new PosTable(this.e);
        this.d.setPosTableClickListener(this);
        this.d.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.d.setDefaultRenderer(Date.class, new CustomCellRenderer());
        this.d.setRowHeight(PosUIManager.getSize((int)30));
        this.e.initTableRenderer((JTable)((Object)this.d));
        this.b();
        this.d.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (CustomTransactionExplorer.this.j() != null) {
                    CustomTransactionExplorer.this.d.setComponentPopupMenu(CustomTransactionExplorer.this.a((JTable)((Object)CustomTransactionExplorer.this.d)));
                } else {
                    CustomTransactionExplorer.this.d.setComponentPopupMenu(null);
                }
            }
        });
        int n = PosUIManager.getSize((int)16);
        this.l = new JLabel();
        this.j = new JButton();
        this.j.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.k = new JButton();
        this.k.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.j.addActionListener(actionEvent -> this.a(this.e.getPreviousRowIndex()));
        this.k.addActionListener(actionEvent -> this.a(this.e.getNextRowIndex()));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new WrapLayout(3));
        transparentPanel.add(this.c());
        this.add((Component)transparentPanel, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.d)), "Center");
        this.f();
    }

    private void b() {
        this.d.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize((int)150));
        this.a(1, PosUIManager.getSize((int)150));
        this.a(2, PosUIManager.getSize((int)180));
        this.a(3, PosUIManager.getSize((int)250));
        this.a(4, PosUIManager.getSize((int)450));
        this.a(5, PosUIManager.getSize((int)110));
        this.a(6, PosUIManager.getSize((int)100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.d.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    private JPanel c() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        try {
            jPanel2.setLayout((LayoutManager)new MigLayout());
            JLabel jLabel = new JLabel(Messages.getString("CustomTransactionExplorer.3"));
            this.h = new FixedLengthTextField(15, 20);
            jPanel2.add(jLabel);
            jPanel2.add(this.h);
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (CustomTransactionExplorer.this.h.getText().length() > 3) {
                        CustomTransactionExplorer.this.g();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        CustomTransactionExplorer.this.g();
                    }
                }
            };
            this.h.addKeyListener(keyAdapter);
            JLabel jLabel2 = new JLabel(Messages.getString("CustomTransactionExplorer.4"));
            this.i = new FixedLengthTextField(15);
            jPanel2.add((Component)jLabel2, "gapleft 10!");
            jPanel2.add(this.i);
            KeyAdapter keyAdapter2 = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (StringUtils.isNotBlank((String)CustomTransactionExplorer.this.i.getText())) {
                        // empty if block
                    }
                    CustomTransactionExplorer.this.g();
                }
            };
            this.i.addKeyListener(keyAdapter2);
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.d(), "Center");
        return jPanel;
    }

    private JPanel d() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CustomTransactionExplorer.this.g();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.a.setDate(null);
        this.b.setDate(null);
        JButton jButton = new JButton(POSConstants.CLEAR);
        jButton.addActionListener(actionEvent -> this.e());
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.a, "gapright 10");
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow");
        jPanel.add((Component)this.b);
        jPanel.add(this.c);
        jPanel.add(jButton);
        return jPanel;
    }

    private void e() {
        this.h.setText("");
        this.i.setText("");
        this.i.setText("");
        this.a.setDate(null);
        this.b.setDate(null);
        this.g();
    }

    private void f() {
        this.f = new JButton(POSConstants.CONFIRM);
        this.f.addActionListener(actionEvent -> this.h());
        this.g = new JButton(POSConstants.VOID);
        this.a(false);
        this.g.addActionListener(actionEvent -> this.i());
        JPanel jPanel = new JPanel(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.f);
        transparentPanel.add(this.g);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.l);
        jPanel2.add(this.j);
        jPanel2.add(this.k);
        jPanel.add((Component)transparentPanel, "Center");
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)jPanel, "South");
    }

    private void a(boolean bl) {
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
    }

    private void g() {
        this.a(0);
    }

    private void a(int n) {
        try {
            this.e.setCurrentRowIndex(n);
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            if (date != null && date2 != null && date.after(date2)) {
                throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            }
            String string = this.h.getText().trim();
            String string2 = this.i.getText().trim();
            CustomPaymentTransactionDAO.getInstance().loadCustomTransactions(this.e, string, date, date2, string2);
            int n2 = this.e.getCurrentRowIndex();
            int n3 = this.e.getNextRowIndex();
            int n4 = this.e.getNumRows();
            int n5 = n2 = n4 == 0 ? n2 : n2 + 1;
            if (n3 > n4) {
                n3 = n4;
            }
            this.l.setText(String.format(Messages.getString("TicketExplorer.2"), n2, n3, n4));
            this.j.setEnabled(this.e.hasPrevious());
            this.k.setEnabled(this.e.hasNext());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
    }

    private void h() {
        try {
            int n = this.d.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomTransactionExplorer.9"));
                return;
            }
            n = this.d.convertRowIndexToModel(n);
            CustomPaymentTransaction customPaymentTransaction = this.e.getRows().get(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("CustomTransactionExplorer.10"), POSConstants.CONFIRM) != 0) {
                return;
            }
            customPaymentTransaction.putConfirmPayment(true);
            CustomPaymentTransactionDAO.getInstance().saveOrUpdate(customPaymentTransaction);
            this.e.setRow(n, customPaymentTransaction);
            this.e.fireTableRowsUpdated(n, n);
            this.d.revalidate();
            this.d.repaint();
            this.a(false);
            this.a(0);
            String string = "Ticket id: " + customPaymentTransaction.getTicketId() + ", transaction id: " + customPaymentTransaction.getId() + ", user id: " + Application.getCurrentUser().getId() + ", transaction amount: " + customPaymentTransaction.getAmount();
            ActionHistory actionHistory = ActionHistory.create(null, "Confirmed payment", string);
            ActionHistoryDAO.getInstance().saveOrUpdate(actionHistory);
            POSMessageDialog.showMessage(this, Messages.getString("CustomTransactionExplorer.2"));
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void i() {
        Transaction transaction = null;
        try (Session session = GenericDAO.getInstance().createNewSession();){
            int n = this.d.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomTransactionExplorer.5"));
                return;
            }
            n = this.d.convertRowIndexToModel(n);
            CustomPaymentTransaction customPaymentTransaction = this.e.getRows().get(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("CustomTransactionExplorer.17"), POSConstants.CONFIRM) != 0) {
                return;
            }
            NotesDialog notesDialog = new NotesDialog();
            notesDialog.setTitle(Messages.getString("VoidTicketItemDialog.7"));
            notesDialog.open();
            if (notesDialog.isCanceled()) {
                POSMessageDialog.showError(this, Messages.getString("CustomTransactionExplorer.19"));
                return;
            }
            String string = notesDialog.getNote().trim();
            if (StringUtils.isNotBlank((String)string) && string.length() > 120) {
                POSMessageDialog.showError(this, Messages.getString("VoidReasonDialog.2"));
                return;
            }
            customPaymentTransaction.putVoidReason(string);
            customPaymentTransaction.setVoided(true);
            customPaymentTransaction.setVoidDate(StoreDAO.getServerTimestamp());
            Ticket ticket = TicketDAO.getInstance().load(customPaymentTransaction.getTicketId(), session);
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() - customPaymentTransaction.getAmount()));
            ticket.setDueAmount(NumberUtil.round(ticket.getDueAmount() + customPaymentTransaction.getAmount()));
            ticket.setClosed(false);
            ticket.setPaid(false);
            String string2 = "Ticket id: " + ticket.getId() + ", transaction id: " + customPaymentTransaction.getId() + ", user id: " + Application.getCurrentUser().getId() + ", transaction amount: " + customPaymentTransaction.getAmount() + ", void reason: " + string;
            ticket.addEvent("Void payment", string2);
            transaction = session.beginTransaction();
            TicketDAO.getInstance().update(ticket, session);
            CustomPaymentTransactionDAO.getInstance().update(customPaymentTransaction, session);
            transaction.commit();
            this.e.removeRow(n);
            this.a(false);
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void doubleClick(int n) {
    }

    @Override
    public void singleClick(int n) {
        if (n < 0) {
            return;
        }
        n = this.d.convertRowIndexToModel(n);
        CustomPaymentTransaction customPaymentTransaction = this.e.getRows().get(n);
        this.f.setEnabled(!customPaymentTransaction.isConfirmPayment());
        this.g.setEnabled(!customPaymentTransaction.isConfirmPayment());
    }

    private JPopupMenu a(final JTable jTable) {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new CopyToClipboardAction<String>(Messages.getString("TicketListView.0"), IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CONTENT_COPY, (float)20.0f), () -> this.j().getTicketId()));
        JMenuItem jMenuItem2 = new JMenuItem(new CopyToClipboardAction<String>(Messages.getString("CustomTransactionExplorer.25"), IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CONTENT_COPY, (float)20.0f), () -> this.j().getId()));
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(() -> {
                    int n = jTable.rowAtPoint(SwingUtilities.convertPoint(jPopupMenu, new Point(0, 0), jTable));
                    if (n > -1) {
                        jTable.setRowSelectionInterval(n, n);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        return jPopupMenu;
    }

    private CustomPaymentTransaction j() {
        int n = this.d.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.e.getRows().get(this.d.convertRowIndexToModel(n));
    }
}

