/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.chart.ChartDuration;
import com.floreantpos.report.chart.DummyRecordService;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DashboardUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.RingPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class DashboardExplorer
extends JPanel
implements ComponentListener {
    private JFreeChart a;
    private JFreeChart b;
    private JFreeChart c;
    private JFreeChart d;
    private TransparentPanel e;
    private TransparentPanel f;
    private TransparentPanel g;
    private TransparentPanel h;
    private JButton i;
    private DashboardUtil j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private JComboBox<ChartDuration> p;
    private JComboBox<ChartDuration> q;
    private JComboBox<ChartDuration> r;
    private JComboBox<ChartDuration> s;
    private boolean t;
    private JLabel u;

    public DashboardExplorer() {
        AsyncAction.execute(() -> {
            this.t = !TicketDAO.getInstance().hasAnyTicket();
            this.a();
            this.addComponentListener(this);
        });
    }

    private void a() {
        this.setLayout(new BorderLayout(15, 15));
        this.j = new DashboardUtil();
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill,center"));
        TitledBorder titledBorder = new TitledBorder(Messages.getString("DashboardExplorer.0"));
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(2);
        transparentPanel.setBorder(titledBorder);
        TransparentPanel transparentPanel2 = this.createTotalSalesLayout();
        TransparentPanel transparentPanel3 = this.createTotalCashSalesLayout();
        TransparentPanel transparentPanel4 = this.createTotalCreditCardSalesLayout();
        TransparentPanel transparentPanel5 = this.createTotalOtherSalesLayout();
        TransparentPanel transparentPanel6 = this.createTotalItemsLayout();
        int n = PosUIManager.getSize((int)45);
        transparentPanel.add((Component)transparentPanel2, "grow,h " + n + "!");
        transparentPanel.add((Component)transparentPanel3, "grow, h " + n + "!");
        transparentPanel.add((Component)transparentPanel4, "grow, h " + n + "!");
        transparentPanel.add((Component)transparentPanel5, "grow, h " + n + "!");
        transparentPanel.add((Component)transparentPanel6, "grow, h " + n + "!");
        this.i = new JButton(POSConstants.REFRESH);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center", "", "[][]"));
        jPanel.add((Component)transparentPanel, "split 2,growx");
        jPanel.add((Component)this.i, "growy,align center,gaptop " + PosUIManager.getSize((int)13) + "!, h " + n + "!,wrap");
        this.a(this.j);
        this.b(this.j);
        this.c(this.j);
        this.d(this.j);
        jPanel.add((Component)this.e, "split 3, align center,grow");
        jPanel.add((Component)this.g, "grow");
        jPanel.add((Component)this.f, "wrap,grow");
        jPanel.add((Component)this.h, "grow");
        String string = "<html>" + Messages.getString("DashboardExplorer.1") + "</html>";
        this.u = new JLabel(string, 0);
        this.u.setFont(this.u.getFont().deriveFont(1, PosUIManager.getFontSize((int)22)));
        this.u.setForeground(Color.red);
        this.u.setVisible(this.t);
        this.add((Component)this.u, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)jScrollPane, "Center");
        this.d();
        this.i.addActionListener(actionEvent -> this.b());
        this.b();
    }

    private void b() {
        this.t = !TicketDAO.getInstance().hasAnyTicket();
        this.u.setVisible(this.t);
        this.c();
        this.p.setSelectedItem((Object)ChartDuration.WEEK);
        this.q.setSelectedItem((Object)ChartDuration.WEEK);
        this.r.setSelectedItem((Object)ChartDuration.WEEK);
        this.s.setSelectedItem((Object)ChartDuration.MONTH);
    }

    private void c() {
        if (this.t) {
            String string = CurrencyUtil.getCurrencySymbol();
            this.k.setText(string + DummyRecordService.createRandomNumber());
            this.l.setText(string + DummyRecordService.createRandomNumber());
            this.m.setText(string + DummyRecordService.createRandomNumber());
            this.n.setText(string + DummyRecordService.createRandomNumber());
            this.o.setText("" + DummyRecordService.createRandomInt());
            return;
        }
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        Date date2 = DateUtil.startOfDay(date);
        SalesReportUtil salesReportUtil = new SalesReportUtil(date2, date);
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            String string = CurrencyUtil.getCurrencySymbol();
            this.k.setText(string + NumberUtil.formatNumber(salesReportUtil.calculateTotalSales(session)));
            this.l.setText(string + NumberUtil.formatNumber(salesReportUtil.calculateCashReceipt(session)));
            this.m.setText(string + NumberUtil.formatNumber(salesReportUtil.calculateCreditReceipt(session)));
            this.n.setText(string + NumberUtil.formatNumber(salesReportUtil.calculateOthersSalesAmount(session)));
            double d = salesReportUtil.calculateItemCountWithoutRetunItem(session);
            Boolean bl = NumberUtil.isFractional(d);
            String string2 = bl != false ? NumberUtil.formatNumber(d) : String.valueOf((int)d);
            this.o.setText(string2);
        }
    }

    private void d() {
        int n = POSUtil.getBackOfficeWindow().getWidth() - 450;
        int n2 = PosUIManager.getFontSize((int)330);
        int n3 = n / 3;
        this.e.setPreferredSize(PosUIManager.getSize((int)n3, (int)n2));
        this.e.repaint();
        this.e.revalidate();
        this.f.setPreferredSize(PosUIManager.getSize((int)n3, (int)n2));
        this.f.repaint();
        this.f.revalidate();
        this.g.setPreferredSize(PosUIManager.getSize((int)n3, (int)n2));
        this.f.repaint();
        this.f.revalidate();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.d();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private void a(TransparentPanel transparentPanel) {
        MigLayout migLayout = new MigLayout("hidemode 3, fill, insets 0", "[grow]", "");
        transparentPanel.setLayout((LayoutManager)migLayout);
        transparentPanel.setBorder(BorderFactory.createEtchedBorder());
        transparentPanel.setOpaque(true);
        transparentPanel.setBackground(Color.WHITE);
    }

    public TransparentPanel createTotalSalesLayout() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a(transparentPanel);
        JLabel jLabel = new JLabel(Messages.getString("DashboardExplorer.2"));
        this.k = new JLabel();
        transparentPanel.add((Component)jLabel, "wrap,center");
        transparentPanel.add((Component)this.k, "center");
        return transparentPanel;
    }

    public TransparentPanel createTotalCashSalesLayout() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a(transparentPanel);
        JLabel jLabel = new JLabel(Messages.getString("DashboardExplorer.3"));
        this.l = new JLabel();
        transparentPanel.add((Component)jLabel, "wrap,center");
        transparentPanel.add((Component)this.l, "center");
        return transparentPanel;
    }

    public TransparentPanel createTotalCreditCardSalesLayout() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a(transparentPanel);
        JLabel jLabel = new JLabel(Messages.getString("DashboardExplorer.4"));
        this.m = new JLabel();
        transparentPanel.add((Component)jLabel, "wrap,center");
        transparentPanel.add((Component)this.m, "center");
        return transparentPanel;
    }

    public TransparentPanel createTotalOtherSalesLayout() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a(transparentPanel);
        JLabel jLabel = new JLabel(Messages.getString("DashboardExplorer.5"));
        this.n = new JLabel();
        transparentPanel.add((Component)jLabel, "wrap,center");
        transparentPanel.add((Component)this.n, "center");
        return transparentPanel;
    }

    public TransparentPanel createTotalItemsLayout() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a(transparentPanel);
        JLabel jLabel = new JLabel(Messages.getString("DashboardExplorer.6"));
        this.o = new JLabel();
        transparentPanel.add((Component)jLabel, "wrap,center");
        transparentPanel.add((Component)this.o, "center");
        return transparentPanel;
    }

    private void a(DashboardUtil dashboardUtil) {
        this.e = this.e();
        this.a = dashboardUtil.getTopItemBarChart();
        ChartPanel chartPanel = new ChartPanel(this.a);
        this.p = new JComboBox();
        this.p.putClientProperty("ID", "TOP_ITEMS");
        TransparentPanel transparentPanel = this.a(this.p, Messages.getString("DashboardExplorer.7"), dashboardUtil);
        this.e.add((Component)transparentPanel, "North");
        this.e.add((Component)chartPanel, "Center");
    }

    private void b(DashboardUtil dashboardUtil) {
        this.g = this.e();
        this.b = dashboardUtil.getTopPaymentTypePieChart();
        ChartPanel chartPanel = new ChartPanel(this.b);
        this.q = new JComboBox();
        this.q.putClientProperty("ID", "TOP_PAYMENT_TYPE");
        TransparentPanel transparentPanel = this.a(this.q, Messages.getString("DashboardExplorer.8"), dashboardUtil);
        this.g.add((Component)transparentPanel, "North");
        this.g.add((Component)chartPanel, "Center");
    }

    private void c(DashboardUtil dashboardUtil) {
        this.f = this.e();
        this.c = dashboardUtil.getTopEmployeesBarChart();
        ChartPanel chartPanel = new ChartPanel(this.c);
        this.r = new JComboBox();
        this.r.putClientProperty("ID", "TOP_EMPLOYEES");
        TransparentPanel transparentPanel = this.a(this.r, Messages.getString("DashboardExplorer.9"), dashboardUtil);
        this.f.add((Component)transparentPanel, "North");
        this.f.add((Component)chartPanel, "Center");
    }

    private void d(DashboardUtil dashboardUtil) {
        this.h = this.e();
        this.d = dashboardUtil.getSalesReportLineChart();
        ChartPanel chartPanel = new ChartPanel(this.d);
        chartPanel.setMaximumDrawWidth(Toolkit.getDefaultToolkit().getScreenSize().width);
        this.s = new JComboBox();
        this.s.putClientProperty("ID", "SALES_REPORT");
        TransparentPanel transparentPanel = this.a(this.s, Messages.getString("DashboardExplorer.10"), dashboardUtil, true);
        this.h.add((Component)transparentPanel, "North");
        this.h.add((Component)chartPanel, "Center");
    }

    private TransparentPanel e() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        transparentPanel.setLayout(new BorderLayout(5, 5));
        return transparentPanel;
    }

    private TransparentPanel a(JComboBox<ChartDuration> jComboBox, String string, DashboardUtil dashboardUtil) {
        return this.a(jComboBox, string, dashboardUtil, false);
    }

    private TransparentPanel a(JComboBox<ChartDuration> jComboBox, String string, DashboardUtil dashboardUtil, boolean bl) {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new BorderLayout());
        transparentPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        transparentPanel.setOpaque(true);
        transparentPanel.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel(string);
        JLabel jLabel2 = new JLabel(Messages.getString("DashboardExplorer.11") + ": ");
        ArrayList<ChartDuration> arrayList = new ArrayList<ChartDuration>(Arrays.asList(ChartDuration.values()));
        if (bl) {
            arrayList.remove((Object)ChartDuration.TODAY);
        }
        jComboBox.setModel(new ComboBoxModel(arrayList));
        jComboBox.setSelectedItem((Object)ChartDuration.WEEK);
        jComboBox.addActionListener(actionEvent -> this.a(jComboBox, dashboardUtil));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.add(jLabel2);
        transparentPanel2.add(jComboBox);
        transparentPanel.add((Component)jLabel, "West");
        transparentPanel.add((Component)transparentPanel2, "East");
        return transparentPanel;
    }

    private void a(JComboBox jComboBox, DashboardUtil dashboardUtil) {
        ChartDuration chartDuration = (ChartDuration)((Object)jComboBox.getSelectedItem());
        String string = (String)jComboBox.getClientProperty("ID");
        this.a(string, chartDuration, dashboardUtil);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String string, ChartDuration chartDuration, DashboardUtil dashboardUtil) {
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            switch (string) {
                case "TOP_ITEMS": {
                    DefaultCategoryDataset defaultCategoryDataset = this.t ? DummyRecordService.createtopItemBarChartDataSet() : dashboardUtil.createtopItemBarChartDataSet(session, ChartDuration.getFromDateBehind(chartDuration));
                    this.a.getCategoryPlot().setDataset((CategoryDataset)defaultCategoryDataset);
                    this.a.fireChartChanged();
                    return;
                }
                case "TOP_PAYMENT_TYPE": {
                    DefaultPieDataset defaultPieDataset = this.t ? DummyRecordService.createtopPaymentTypePieChartDataSet() : dashboardUtil.createtopPaymentTypePieChartDataSet(session, ChartDuration.getFromDateBehind(chartDuration));
                    RingPlot ringPlot = (RingPlot)this.b.getPlot();
                    ringPlot.setDataset((PieDataset)defaultPieDataset);
                    this.b.fireChartChanged();
                    return;
                }
                case "TOP_EMPLOYEES": {
                    DefaultCategoryDataset defaultCategoryDataset = this.t ? DummyRecordService.createtopEmployeesBarChartDataSet() : dashboardUtil.createtopEmployeesBarChartDataSet(session, ChartDuration.getFromDateBehind(chartDuration));
                    this.c.getCategoryPlot().setDataset((CategoryDataset)defaultCategoryDataset);
                    this.c.fireChartChanged();
                    return;
                }
                case "SALES_REPORT": {
                    TimeSeriesCollection timeSeriesCollection = this.t ? DummyRecordService.createSalesReportLineChartDataSet(ChartDuration.getFromDateBehind(chartDuration)) : dashboardUtil.createSalesReportLineChartDataSet(session, ChartDuration.getFromDateBehind(chartDuration));
                    this.d.getXYPlot().setDataset((XYDataset)timeSeriesCollection);
                    this.d.fireChartChanged();
                    return;
                }
            }
            return;
        }
    }
}

