/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.jdesktop.swingx.JXTable;

public class MenuCategoryExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable a;
    private BeanTableModel<MenuCategory> b;
    private FixedLengthTextField c;
    private JButton d;
    private JButton e;
    private JLabel f;
    private boolean g;

    public MenuCategoryExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(MenuCategory.class);
        this.b.addColumn(POSConstants.NAME, "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.b.addColumn(POSConstants.BEVERAGE, "beverage");
        this.b.addColumn(POSConstants.VISIBLE, "visible");
        this.a = new JXTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize((int)30));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuCategoryExplorer.this.editSelectedRow();
                }
            }
        });
        this.b.initTableRenderer((JTable)this.a);
        this.add((Component)this.a(), "North");
        this.add(new JScrollPane((Component)this.a));
        this.f();
    }

    private JPanel a() {
        JPanel jPanel = new JPanel(new WrapLayout(3));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Search")));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        this.c = new FixedLengthTextField(20);
        this.c.addKeyListener(this.c());
        JButton jButton = new JButton(Messages.getString("Search"));
        jButton.addActionListener(this.d());
        JButton jButton2 = new JButton(Messages.getString("RESET"));
        jButton2.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)jLabel, "align label");
        jPanel.add(this.c);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void b() {
        this.c.setText("");
        this.e();
    }

    private KeyListener c() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (MenuCategoryExplorer.this.c.getText().length() > 2) {
                    MenuCategoryExplorer.this.e();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    MenuCategoryExplorer.this.e();
                }
            }
        };
    }

    private ActionListener d() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategoryExplorer.this.e();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        };
    }

    private void e() {
        this.a(0);
    }

    private void a(Integer n) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String string = this.c.getText();
            if (n != null) {
                this.b.setCurrentRowIndex(n);
            }
            MenuCategoryDAO.getInstance().findCategories(this.b, string);
            this.f.setText(this.b.getPaginationDisplayInfo());
            this.d.setEnabled(this.b.hasPrevious());
            this.e.setEnabled(this.b.hasNext());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void f() {
        int n = PosUIManager.getSize((int)16);
        this.d = new JButton();
        this.d.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategoryExplorer.this.a(MenuCategoryExplorer.this.b.getPreviousRowIndex());
            }
        });
        this.e = new JButton();
        this.e.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategoryExplorer.this.a(MenuCategoryExplorer.this.b.getNextRowIndex());
            }
        });
        this.f = new JLabel();
        JButton jButton = new JButton(POSConstants.ADD);
        UiUtil.setButtonColorGreen(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
                    beanEditorDialog.setPreferredSize(PosUIManager.getSize((int)600, (int)600));
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
                    MenuCategoryExplorer.this.b.addRow(menuCategory);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategoryExplorer.this.editSelectedRow();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategoryExplorer.this.g();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel3.add(this.f);
        jPanel3.add(this.d);
        jPanel3.add(this.e);
        jPanel.add(jPanel2);
        jPanel.add((Component)jPanel3, "East");
        this.add((Component)jPanel, "South");
    }

    public void editSelectedRow() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuCategory menuCategory = this.b.getRow(n);
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize((int)600, (int)600));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void initData() {
        if (!this.g) {
            this.e();
            this.g = true;
        }
    }

    private void g() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuCategory menuCategory = this.b.getRow(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            boolean bl = MenuGroupDAO.getInstance().existsMenuGroups(menuCategory);
            boolean bl2 = MenuItemDAO.getInstance().existsMenuItem(menuCategory);
            MenuCategoryDAO menuCategoryDAO = new MenuCategoryDAO();
            if (bl || bl2) {
                menuCategoryDAO.delete(menuCategory);
                return;
            }
            menuCategoryDAO.delete(menuCategory);
            this.b.removeRow(menuCategory);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
            return;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

