/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.jdesktop.swingx.JXTable;

public class MenuGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable a;
    private BeanTableModel<MenuGroup> b;
    private FixedLengthTextField c;
    private JButton d;
    private JButton e;
    private JLabel f;
    private JComboBox g;
    private boolean h;

    public MenuGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(MenuGroup.class);
        this.b.addColumn(POSConstants.NAME, "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.b.addColumn(POSConstants.CATEGORY, MenuGroup.PROP_MENU_CATEGORY_NAME);
        this.b.addColumn(POSConstants.VISIBLE, "visible");
        this.a = new JXTable(this.b);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuGroupExplorer.this.g();
                }
            }
        });
        this.b.initTableRenderer((JTable)this.a);
        this.a.setRowHeight(PosUIManager.getSize((int)30));
        this.add((Component)this.a(), "North");
        this.add(new JScrollPane((Component)this.a));
        this.f();
    }

    private JPanel a() {
        JPanel jPanel = new JPanel(new WrapLayout(3));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Search")));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        this.c = new FixedLengthTextField(20);
        this.c.addKeyListener(this.c());
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.4"));
        this.g = new JComboBox();
        this.g.setPreferredSize(PosUIManager.getSize((int)150, (int)22));
        this.h();
        JButton jButton = new JButton(Messages.getString("Search"));
        jButton.addActionListener(this.d());
        JButton jButton2 = new JButton(Messages.getString("RESET"));
        jButton2.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)jLabel, "align label");
        jPanel.add(this.c);
        jPanel.add(jLabel2);
        jPanel.add(this.g);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void b() {
        this.c.setText("");
        this.g.setSelectedIndex(0);
        this.e();
    }

    private KeyListener c() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (MenuGroupExplorer.this.c.getText().length() > 2) {
                    MenuGroupExplorer.this.e();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    MenuGroupExplorer.this.e();
                }
            }
        };
    }

    private ActionListener d() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuGroupExplorer.this.e();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        };
    }

    private void e() {
        this.a(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Integer n) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (n != null) {
                this.b.setCurrentRowIndex(n);
            }
            String string = this.c.getText();
            Object object = this.g.getSelectedItem();
            MenuCategory menuCategory = null;
            if (object instanceof MenuCategory) {
                menuCategory = (MenuCategory)object;
            }
            MenuGroupDAO.getInstance().findGroups(this.b, string, menuCategory);
            this.f.setText(this.b.getPaginationDisplayInfo());
            this.d.setEnabled(this.b.hasPrevious());
            this.e.setEnabled(this.b.hasNext());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void f() {
        int n = PosUIManager.getSize((int)16);
        this.d = new JButton();
        this.d.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.a(MenuGroupExplorer.this.b.getPreviousRowIndex());
            }
        });
        this.e = new JButton();
        this.e.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.a(MenuGroupExplorer.this.b.getNextRowIndex());
            }
        });
        this.f = new JLabel();
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        UiUtil.setButtonColorGreen(jButton2);
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.g();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuGroupForm menuGroupForm = new MenuGroupForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
                    beanEditorDialog.openWithScale(450, 350);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
                    MenuGroupExplorer.this.b.addRow(menuGroup);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.i();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel2.add(jButton3);
        jPanel3.add(this.f);
        jPanel3.add(this.d);
        jPanel3.add(this.e);
        jPanel.add(jPanel2);
        jPanel.add((Component)jPanel3, "East");
        this.add((Component)jPanel, "South");
    }

    private void g() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuGroup menuGroup = this.b.getRow(n);
            MenuGroupForm menuGroupForm = new MenuGroupForm(menuGroup);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.openWithScale(450, 350);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void initData() {
        this.h();
        if (!this.h) {
            this.e();
            this.h = true;
        }
    }

    private void h() {
        this.g.removeAllItems();
        this.g.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory menuCategory : list) {
            this.g.addItem(menuCategory);
        }
        this.g.setSelectedIndex(0);
    }

    private void i() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuGroup menuGroup = this.b.getRow(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
            menuGroupDAO.delete(menuGroup);
            this.b.removeRow(menuGroup);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

