/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.bo.ui.explorer.MenuItemTreeTableModel;
import com.floreantpos.model.ActiveStatus;
import com.floreantpos.model.Brand;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.BrandDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.QuickMenuItemEntryDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.ui.model.combo.ComboItemWizard;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView,
PaginationBar.PagingListener {
    private MenuItemTreeTableModel a;
    private JXTreeTable b;
    private OverflowCombobox c;
    private OverflowCombobox d;
    private FixedLengthTextField e;
    private JCheckBox f;
    private OverflowCombobox g;
    private OverflowCombobox h;
    private OverflowCombobox<ActiveStatus> i;
    private JPanel j;
    private JPanel k;
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnDuplicate;
    protected JButton btnQuickMenuItemEntry;
    private JButton l;
    private JButton m;
    private JButton n;
    private OverflowCombobox<MenuItemSortType> o;
    private boolean p;
    private PaginationBar q;

    public MenuItemExplorer() {
        this.a();
        this.b.setAutoCreateColumnsFromModel(false);
        this.resizeColumnWidth(this.b);
    }

    private void a(int n) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId("0");
        menuItem.setName("Root");
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)menuItem);
        defaultMutableTreeTableNode.setUserObject((Object)menuItem);
        this.a.setRoot((TreeTableNode)defaultMutableTreeTableNode);
        Object object = this.c.getSelectedItem();
        Object object2 = this.g.getSelectedItem();
        ActiveStatus activeStatus = (ActiveStatus)((Object)this.i.getSelectedItem());
        Object object3 = this.d.getSelectedItem();
        MenuItemSortType menuItemSortType = (MenuItemSortType)((Object)this.o.getSelectedItem());
        String string = this.e.getText();
        Boolean bl = this.f.isSelected();
        MenuGroup menuGroup = null;
        MenuCategory menuCategory = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = false;
        Brand brand = null;
        Object object4 = this.h.getSelectedItem();
        if (object2 instanceof MenuGroup) {
            menuGroup = (MenuGroup)object2;
        }
        if (object instanceof MenuCategory) {
            menuCategory = (MenuCategory)object;
        }
        if (activeStatus == ActiveStatus.Active) {
            bl2 = true;
        } else if (activeStatus == ActiveStatus.Inactive) {
            bl2 = false;
        }
        if (object3 == MenuItemType.Combo) {
            bl3 = true;
        }
        if (object3 == MenuItemType.Variant) {
            bl4 = true;
        }
        if (object4 instanceof Brand) {
            brand = (Brand)object4;
        }
        MenuItemDAO.getInstance().loadMenuItemsTree(this.a, bl, menuGroup, string, menuCategory, bl4, false, bl2, bl3, menuItemSortType == null ? "" : menuItemSortType.getKey(), false, brand);
        List list = this.a.getRows();
        for (MenuItem menuItem2 : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)menuItem2);
            MenuItemDAO.getInstance().initialize(menuItem2);
            List<MenuItem> list2 = menuItem2.getVariants();
            for (MenuItem menuItem3 : list2) {
                if (menuItem3.isDeleted().booleanValue()) continue;
                DefaultMutableTreeTableNode defaultMutableTreeTableNode3 = new DefaultMutableTreeTableNode((Object)menuItem3);
                defaultMutableTreeTableNode2.add((MutableTreeTableNode)defaultMutableTreeTableNode3);
            }
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
    }

    private void a() {
        this.b = new JXTreeTable(){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                boolean bl3 = this.isCellEditable(n, n2);
                if (bl3) {
                    this.editCellAt(n, n2);
                    DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.getCellEditor(n, n2);
                    JTextField jTextField = (JTextField)defaultCellEditor.getComponent();
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }
        };
        this.b.setRootVisible(false);
        this.b.setShowGrid(true, true);
        this.b.setRowHeight(PosUIManager.getSize((int)45));
        this.b.setLeafIcon(null);
        this.b.setOpenIcon(null);
        this.b.setClosedIcon(null);
        this.b.setSelectionMode(0);
        this.b.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.b());
        this.b.setColumnSelectionAllowed(false);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        MenuItem menuItem = new MenuItem();
        menuItem.setId("0");
        menuItem.setName("Root");
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)menuItem);
        defaultMutableTreeTableNode.setUserObject((Object)menuItem);
        if (this.a == null) {
            this.a = new MenuItemTreeTableModel(defaultMutableTreeTableNode, this.b);
            this.b.setTreeTableModel((TreeTableModel)this.a);
            this.b.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
            this.b.getSelectionModel().setSelectionMode(1);
            DoubleTextField doubleTextField = new DoubleTextField();
            doubleTextField.setHorizontalAlignment(4);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
            defaultCellEditor.setClickCountToStart(1);
            this.b.setDefaultEditor(this.b.getColumnClass(7), (TableCellEditor)defaultCellEditor);
        }
        int n = PosUIManager.getSize((int)16);
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemExplorer.this.i();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        this.j = this.g();
        this.add((Component)this.j, "South");
        this.k = this.c();
        this.add((Component)this.k, "North");
    }

    private void b() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return;
        }
        TreePath treePath = this.b.getPathForRow(n);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        this.l.setEnabled(menuItem.isInventoryItem() != false && menuItem.isHasVariant() == false);
        this.m.setEnabled(menuItem.isInventoryItem() != false && menuItem.isHasVariant() == false);
        this.n.setEnabled(menuItem.isInventoryItem() != false && menuItem.isHasVariant() == false);
        this.btnDelete.setEnabled(menuItem.isVariant() == false);
        this.btnDuplicate.setEnabled(menuItem.isVariant() == false);
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        try {
            WrapLayout wrapLayout = new WrapLayout(0, 5, 0);
            jPanel.setLayout(wrapLayout);
            JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.c = new OverflowCombobox();
            this.c.setPreferredSize(PosUIManager.getSize((int)150, (int)22));
            this.c.addActionListener(actionEvent -> this.l());
            JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.16"));
            this.d = new OverflowCombobox((Object[])MenuItemType.values());
            this.d.addActionListener(actionEvent -> this.f());
            JLabel jLabel3 = new JLabel(Messages.getString("MenuItemExplorer.0"));
            JLabel jLabel4 = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.g = new OverflowCombobox();
            this.g.setPreferredSize(PosUIManager.getSize((int)150, (int)22));
            this.g.addActionListener(actionEvent -> this.f());
            JLabel jLabel5 = new JLabel(Messages.getString(Messages.getString("MenuItemExplorer.38")));
            this.h = new OverflowCombobox();
            this.h.setPreferredSize(PosUIManager.getSize((int)100, (int)22));
            this.h.addActionListener(actionEvent -> this.f());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel5);
            jPanel2.add(this.h);
            String[] stringArray = new String[]{Messages.getString("MenuItemExplorer.32"), Messages.getString("ACTIVE"), Messages.getString("MenuItemExplorer.34")};
            JLabel jLabel6 = new JLabel(Messages.getString("MenuItemExplorer.35"));
            this.i = new OverflowCombobox((Object[])ActiveStatus.values());
            this.i.addActionListener(actionEvent -> this.f());
            this.e = new FixedLengthTextField(15, 255);
            this.e.addKeyListener(this.e());
            this.f = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton jButton = new JButton(Messages.getString("Search"));
            JButton jButton2 = new JButton(Messages.getString("RESET"));
            jButton2.addActionListener(actionEvent -> this.d());
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jLabel3);
            jPanel3.add(this.e);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jLabel);
            jPanel4.add(this.c);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jLabel2);
            jPanel5.add(this.d);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(jLabel4);
            jPanel6.add(this.g);
            JPanel jPanel7 = new JPanel();
            jPanel7.add(jLabel6);
            jPanel7.add(this.i);
            JPanel jPanel8 = new JPanel();
            JLabel jLabel7 = new JLabel(Messages.getString("MenuItemExplorer.33"));
            this.o = new OverflowCombobox((Object[])MenuItemSortType.values());
            this.o.setSelectedItem(null);
            this.o.addActionListener(actionEvent -> this.f());
            jPanel8.add(jLabel7);
            jPanel8.add(this.o);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel6);
            jPanel.add(jPanel2);
            jPanel.add(jPanel5);
            jPanel.add(jPanel7);
            jPanel.add(jPanel8);
            jPanel.add(this.f);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(actionEvent -> this.f());
            this.e.addActionListener(actionEvent -> this.f());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void d() {
        this.e.setText("");
        this.c.setSelectedIndex(0);
        this.g.setSelectedIndex(0);
        this.d.setSelectedIndex(0);
        this.i.setSelectedIndex(0);
        this.o.setSelectedIndex(0);
        this.f.setSelected(false);
        this.h.setSelectedIndex(0);
        this.f();
    }

    private KeyListener e() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (MenuItemExplorer.this.e.getText().length() > 2) {
                    MenuItemExplorer.this.f();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    MenuItemExplorer.this.f();
                }
            }
        };
    }

    private void f() {
        this.b(0);
    }

    private void b(int n) {
        this.a.setCurrentRowIndex(n);
        this.a(n);
        this.b.expandAll();
        this.b.collapseAll();
        this.q.updateView();
    }

    private JPanel g() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        this.btnAdd = explorerButtonPanel.getAddButton();
        this.btnDelete = explorerButtonPanel.getDeleteButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        this.btnAdd.setText(Messages.getString("MenuItemExplorer.17"));
        UiUtil.setButtonColorGreen(this.btnAdd);
        jButton2.setText(Messages.getString("MenuItemExplorer.3"));
        jButton3.setText(Messages.getString("MenuItemExplorer.9"));
        jButton.setText(Messages.getString("MenuItemExplorer.18"));
        this.btnDelete.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(actionEvent -> this.i());
        this.btnAdd.addActionListener(actionEvent -> this.a(Boolean.FALSE, (boolean)Boolean.FALSE));
        jButton2.addActionListener(actionEvent -> this.a(Boolean.TRUE, (boolean)Boolean.FALSE));
        jButton3.addActionListener(actionEvent -> this.a(Boolean.FALSE, (boolean)Boolean.TRUE));
        this.btnDelete.addActionListener(actionEvent -> this.j());
        this.btnDuplicate = new JButton(Messages.getString("MenuItemExplorer.41"));
        this.btnDuplicate.addActionListener(actionEvent -> {
            try {
                this.o();
            }
            catch (Throwable throwable) {
                BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
            }
        });
        this.btnQuickMenuItemEntry = new JButton(Messages.getString("MenuItemExplorer.37"));
        this.btnQuickMenuItemEntry.addActionListener(actionEvent -> this.h());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3"));
        transparentPanel.add(this.btnAdd);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(this.btnQuickMenuItemEntry);
        transparentPanel.add(jButton);
        transparentPanel.add(this.btnDelete);
        transparentPanel.add(this.btnDuplicate);
        this.a(transparentPanel);
        jPanel.add((Component)transparentPanel, "");
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        this.q = new PaginationBar(this, this.a);
        jPanel2.add(this.q);
        jPanel.add((Component)jPanel2, "grow");
        return jPanel;
    }

    private void h() {
        try {
            QuickMenuItemEntryDialog quickMenuItemEntryDialog = new QuickMenuItemEntryDialog();
            quickMenuItemEntryDialog.setTitle(Messages.getString("MenuItemExplorer.44"));
            quickMenuItemEntryDialog.openFullScreen();
            if (quickMenuItemEntryDialog.isCanceled()) {
                return;
            }
            this.f();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(JPanel jPanel) {
        this.l = new JButton(Messages.getString("MenuItemExplorer.46"));
        this.m = new JButton(Messages.getString("MenuItemExplorer.47"));
        this.n = new JButton(Messages.getString("MenuItemExplorer.48"));
        this.l.addActionListener(actionEvent -> this.a(InventoryTransactionType.IN));
        this.m.addActionListener(actionEvent -> this.a(InventoryTransactionType.OUT, false));
        this.n.addActionListener(actionEvent -> this.a(InventoryTransactionType.UNCHANGED, true));
        jPanel.add(this.l);
        jPanel.add(this.m);
        jPanel.add(this.n);
    }

    private boolean a(InventoryTransactionType inventoryTransactionType, boolean bl) {
        if (this.b.getRowCount() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.49"));
            return false;
        }
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.20"));
            return false;
        }
        TreePath treePath = this.b.getPathForRow(n = this.b.convertRowIndexToModel(n));
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        if (menuItem == null) {
            return false;
        }
        if (menuItem.getUnit() == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
            return false;
        }
        MenuItemDAO.getInstance().initialize(menuItem);
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        if (bl) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        Double d = menuItem.getVariantCost();
        inventoryTransaction.setUnitCost(d);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        beanEditorDialog.setPreferredSize(PosUIManager.getSize((int)500, (int)500));
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return false;
        }
        this.f();
        return true;
    }

    private boolean a(InventoryTransactionType inventoryTransactionType) {
        Serializable serializable;
        InventoryTransaction inventoryTransaction;
        int n = this.b.getSelectedRow();
        MenuItem menuItem = null;
        TreePath treePath = null;
        if (n >= 0) {
            n = this.b.convertRowIndexToModel(n);
            treePath = this.b.getPathForRow(n);
            inventoryTransaction = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            menuItem = (MenuItem)inventoryTransaction.getUserObject();
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        InventoryStockInForm inventoryStockInForm = null;
        if (menuItem == null) {
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            serializable = menuItem.getUnit();
            if (serializable == null) {
                POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
                return false;
            }
            inventoryTransaction.setUnitId(((BaseInventoryUnit)serializable).getId());
            inventoryTransaction.setUnitType(((InventoryUnit)serializable).getUnitType());
            Double d = Math.floor(menuItem.getReplenishLevel());
            inventoryTransaction.setQuantity(d);
            Double d2 = menuItem.getVariantCost();
            inventoryTransaction.setUnitCost(d2);
            inventoryTransaction.setTotal(d * d2);
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        }
        serializable = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)inventoryStockInForm);
        ((BeanEditorDialog)serializable).openWithScale(830, 630);
        if (((BeanEditorDialog)serializable).isCanceled()) {
            return false;
        }
        this.f();
        return true;
    }

    public void resizeColumnWidth(JXTreeTable jXTreeTable) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(250);
        arrayList.add(200);
        arrayList.add(150);
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(120);
        for (int i = 0; i < arrayList.size(); ++i) {
            jXTreeTable.getColumnExt(i).setPreferredWidth(((Integer)arrayList.get(i)).intValue());
        }
    }

    private void i() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem.isVariant().booleanValue()) {
                VariantForm variantForm = new VariantForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)variantForm, true);
                beanEditorDialog.setTitle(Messages.getString("MenuItemExplorer.31"));
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else if (menuItem.isPizzaType().booleanValue()) {
                PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else {
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm, true);
                beanEditorDialog.openWithScale(1015, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            }
            this.a.doRefresh();
        }
        catch (PosException posException) {
            BOMessageDialog.showError(this, posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void a(boolean bl, boolean bl2) {
        try {
            Serializable serializable;
            MenuItem menuItem = new MenuItem();
            menuItem.setComboItem(bl);
            menuItem.setHasVariant(bl2);
            menuItem.setMenuCategoryId("default_category");
            menuItem.setMenuGroupId("default_group");
            Object object = this.c.getSelectedItem();
            if (object instanceof OrderType) {
                serializable = new ArrayList<Object>();
                serializable.add(object);
                menuItem.setOrderTypeList((List)((Object)serializable));
            }
            if (!bl) {
                serializable = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else {
                serializable = new ComboItemWizard(menuItem);
                ((POSDialog)serializable).open();
            }
            this.f();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void j() {
        try {
            List<MenuItem> list;
            if (this.b.getRowCount() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.22"));
                return;
            }
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
            MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
            menuItem = menuItemDAO.getInitialized(menuItem.getId());
            if (menuItem.isHasVariant().booleanValue() && (list = menuItem.getVariants()) != null) {
                for (MenuItem menuItem2 : list) {
                    menuItemDAO.checkIfItemCanbeDeleted(menuItem2);
                }
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            menuItemDAO.delete(menuItem);
            this.f();
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.57"));
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void initData() {
        this.k();
        this.n();
        if (!this.p) {
            this.f();
            this.p = true;
        }
    }

    private void k() {
        this.c.removeAllItems();
        this.c.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory menuCategory : list) {
            this.c.addItem(menuCategory);
        }
        this.c.setSelectedIndex(0);
        this.m();
    }

    private void l() {
        try {
            this.m();
            this.f();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void m() {
        Object object = this.c.getSelectedItem();
        this.g.removeAllItems();
        this.g.addItem(Messages.getString("MenuItemExplorer.5"));
        if (object instanceof MenuCategory) {
            MenuCategory menuCategory = (MenuCategory)object;
            List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
            for (MenuGroup menuGroup : list) {
                this.g.addItem(menuGroup);
            }
        } else {
            List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
            for (MenuGroup menuGroup : list) {
                this.g.addItem(menuGroup);
            }
        }
    }

    private void n() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(POSConstants.ALL);
        List<Brand> list = BrandDAO.getInstance().findAll();
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        this.h.setModel(new ComboBoxModel(arrayList));
    }

    private void o() throws Exception {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.59"));
            return;
        }
        TreePath treePath = this.b.getPathForRow(n);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
        MenuItem menuItem2 = menuItem.clone();
        if (menuItem2.isPizzaType().booleanValue()) {
            PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm, true);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
        } else {
            MenuItemForm menuItemForm = new MenuItemForm(menuItem2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
        }
        this.f();
    }

    public void setInventoryButtonsVisible(boolean bl) {
        this.l.setVisible(bl);
        this.m.setVisible(bl);
        this.n.setVisible(bl);
    }

    @Override
    public void pageRequested(int n) {
        this.b(n);
    }

    static enum MenuItemSortType {
        EMPTY("", ""),
        NAME(MenuItem.PROP_NAME, POSConstants.NAME),
        TRANSLATED_NAME(MenuItem.PROP_TRANSLATED_NAME, POSConstants.TRANSLATED_NAME),
        BARCODE(MenuItem.PROP_BARCODE, POSConstants.BARCODE),
        VISIBLE(MenuItem.PROP_VISIBLE, Messages.getString("MenuItemExplorer.39")),
        COMBO_ITEM(MenuItem.PROP_COMBO_ITEM, Messages.getString("MenuItemExplorer.42")),
        HAS_MODIFIERS(MenuItem.PROP_HAS_MODIFIERS, Messages.getString("MenuItemExplorer.43")),
        PRICE(MenuItem.PROP_PRICE, POSConstants.PRICE);

        String a;
        String b;

        private MenuItemSortType(String string2, String string3) {
            this.a = string2;
            this.b = string3;
        }

        public String getKey() {
            return this.a;
        }

        public String getDisplayString() {
            return this.b;
        }

        public static MenuItemSortType fromKey(String string) {
            MenuItemSortType[] menuItemSortTypeArray;
            for (MenuItemSortType menuItemSortType : menuItemSortTypeArray = MenuItemSortType.values()) {
                if (!menuItemSortType.getKey().equals(string)) continue;
                return menuItemSortType;
            }
            return null;
        }

        public String toString() {
            return this.b;
        }
    }

    static enum MenuItemType {
        All(Messages.getString("MenuItemExplorer.24")),
        Combo(Messages.getString("MenuItemExplorer.28")),
        Variant(Messages.getString("MenuItemExplorer.30"));

        String a;

        private MenuItemType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }
}

