/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.base.BaseModifierMultiplierPrice;
import com.floreantpos.model.base.BasePizzaModifierPrice;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class ModifierExplorer
extends TransparentPanel
implements ExplorerView,
PaginationBar.PagingListener {
    private String a;
    private JXTable b;
    private ModifierExplorerModel c;
    private FixedLengthTextField d;
    private boolean e;
    private PaginationBar f;

    public ModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = CurrencyUtil.getCurrencySymbol();
        this.c = new ModifierExplorerModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setRowHeight(PosUIManager.getSize((int)30));
        this.add(new JScrollPane((Component)this.b));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ModifierExplorer.this.e();
                }
            }
        });
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setSelectionMode(0);
        this.a();
        this.add((Component)this.b(), "North");
    }

    private void a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getAddButton();
        UiUtil.setButtonColorGreen(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuModifierForm menuModifierForm = new MenuModifierForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuModifierForm);
                    beanEditorDialog.openWithScale(800, 600);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier = (MenuModifier)menuModifierForm.getBean();
                    ModifierExplorer.this.c.addModifier(menuModifier);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton2 = explorerButtonPanel.getEditButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierExplorer.this.e();
            }
        });
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = ModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = ModifierExplorer.this.b.convertRowIndexToModel(n);
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        MenuModifier menuModifier = (MenuModifier)ModifierExplorer.this.c.getRowData(n);
                        MenuModifierDAO menuModifierDAO = new MenuModifierDAO();
                        menuModifierDAO.delete(menuModifier);
                        ModifierExplorer.this.c.deleteModifier(menuModifier, n);
                        OroMqttClient.getInstance().sendUpdateNotification();
                    }
                }
                catch (PosException posException) {
                    DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
                    detailsInfoDialog.open();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton4 = new JButton(Messages.getString("ModifierExplorer.9"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Serializable serializable;
                    Object object;
                    Object object2;
                    int n = ModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierExplorer.10"));
                        return;
                    }
                    n = ModifierExplorer.this.b.convertRowIndexToModel(n);
                    MenuModifier menuModifier = (MenuModifier)ModifierExplorer.this.c.getRowData(n);
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                    MenuModifier menuModifier2 = new MenuModifier();
                    PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                    List<ModifierMultiplierPrice> list = menuModifier2.getMultiplierPriceList();
                    if (list != null && list.size() > 0) {
                        object2 = list.iterator();
                        while (object2.hasNext()) {
                            object = (ModifierMultiplierPrice)object2.next();
                            ((BaseModifierMultiplierPrice)object).setId(null);
                            ((BaseModifierMultiplierPrice)object).setVersion(0L);
                        }
                    }
                    if ((object2 = menuModifier2.getPizzaModifierPriceList()) != null && object2.size() > 0) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            serializable = (PizzaModifierPrice)object.next();
                            ((BasePizzaModifierPrice)serializable).setId(null);
                            ((BasePizzaModifierPrice)serializable).setVersion(0L);
                        }
                    }
                    menuModifier2.setId(null);
                    object = ModifierExplorer.this.a(menuModifier);
                    menuModifier2.setName((String)object);
                    serializable = new MenuModifierForm(menuModifier2);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier3 = (MenuModifier)((BeanEditor)serializable).getBean();
                    ModifierExplorer.this.c.addModifier(menuModifier3);
                    ModifierExplorer.this.b.getSelectionModel().addSelectionInterval(ModifierExplorer.this.c.getRowCount() - 1, ModifierExplorer.this.c.getRowCount() - 1);
                    ModifierExplorer.this.b.scrollRowToVisible(ModifierExplorer.this.c.getRowCount() - 1);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        explorerButtonPanel.add(jButton4);
        JPanel jPanel = new JPanel(new FlowLayout(4));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        this.f = new PaginationBar(this, this.c);
        jPanel2.add((Component)this.f, "growy");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        jPanel3.add((Component)transparentPanel, "Center");
        jPanel3.add((Component)jPanel, "East");
        this.add((Component)jPanel3, "South");
    }

    private String a(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        String string2 = new String();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string2 = string + " 1";
        } else {
            String string3 = string.substring(n + 1, string.length());
            if (StringUtils.isNumeric((CharSequence)string3)) {
                Integer n2 = Integer.valueOf(string3);
                n2 = n2 + 1;
                string2 = string.replace(string3, String.valueOf(n2));
            } else {
                string2 = string + " 1";
            }
        }
        return string2;
    }

    private int b(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        Pattern pattern = Pattern.compile(" .* ([0-9]+)");
        Matcher matcher = pattern.matcher(string);
        int n = 1;
        if (matcher.find()) {
            try {
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 + 1 > n) {
                    n = n2 + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new WrapLayout(3));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        JLabel jLabel2 = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.d = new FixedLengthTextField(15);
        this.d.addKeyListener(this.d());
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Messages.getString("ModifierExplorer.5"));
        JButton jButton = new JButton(Messages.getString("RESET"));
        jButton.addActionListener(actionEvent -> this.c());
        JButton jButton2 = new JButton(Messages.getString("Search"));
        jPanel.add((Component)jLabel, "align label");
        jPanel.add(this.d);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierExplorer.this.f();
            }
        });
        return jPanel;
    }

    private void c() {
        this.d.setText("");
        this.f();
    }

    private KeyListener d() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (ModifierExplorer.this.d.getText().length() > 2) {
                    ModifierExplorer.this.f();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    ModifierExplorer.this.f();
                }
            }
        };
    }

    private void e() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            MenuModifierDAO.getInstance().initialize(menuModifier);
            MenuModifierForm menuModifierForm = new MenuModifierForm(menuModifier);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuModifierForm);
            beanEditorDialog.openWithScale(810, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void f() {
        this.c.setCurrentRowIndex(0);
        this.a(0);
    }

    private void a(int n) {
        String string = this.d.getText();
        if (this.c.getRowCount() > 0) {
            this.c.removeAll();
        }
        this.c.setCurrentRowIndex(n);
        MenuModifierDAO.getInstance().loadModifierItems(this.c, string);
        this.f.updateView();
    }

    @Override
    public void initData() {
        if (!this.e) {
            this.f();
            this.e = true;
        }
    }

    @Override
    public void pageRequested(int n) {
        this.a(n);
    }

    private class ModifierExplorerModel
    extends ListTableModel
    implements PaginationSupport {
        private int b;
        private int c;
        private int d;

        public ModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.PRICE + " (" + ModifierExplorer.this.a + ")", Messages.getString("TAX_GROUP") + Messages.getString("ModifierExplorer.0")});
            this.d = 50;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List list = this.getRows();
            MenuModifier menuModifier = (MenuModifier)list.get(n);
            switch (n2) {
                case 0: {
                    return menuModifier.getName();
                }
                case 1: {
                    return menuModifier.getTranslatedName();
                }
                case 2: {
                    return NumberUtil.formatAmount(menuModifier.getPrice());
                }
                case 3: {
                    if (menuModifier.getTaxGroup() == null) {
                        return "";
                    }
                    return menuModifier.getTaxGroup();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier menuModifier) {
            int n = this.getRows().size();
            this.getRows().add(menuModifier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifier(MenuModifier menuModifier, int n) {
            this.getRows().remove(menuModifier);
            this.fireTableRowsDeleted(n, n);
        }

        public void removeAll() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        public void addRows(List<MenuModifier> list) {
            if (list == null) {
                return;
            }
            for (MenuModifier menuModifier : list) {
                this.addModifier(menuModifier);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getNumRows() {
            return this.b;
        }

        @Override
        public void setNumRows(int n) {
            this.b = n;
        }

        @Override
        public int getCurrentRowIndex() {
            return this.c;
        }

        @Override
        public void setCurrentRowIndex(int n) {
            this.c = n;
        }

        @Override
        public int getPageSize() {
            return this.d;
        }

        @Override
        public void setPageSize(int n) {
            this.d = n;
        }

        @Override
        public boolean hasNext() {
            return this.c + this.d < this.b;
        }

        @Override
        public boolean hasPrevious() {
            return this.c > 0;
        }

        @Override
        public int getNextRowIndex() {
            if (this.b == 0) {
                return 0;
            }
            return this.getCurrentRowIndex() + this.getPageSize();
        }

        @Override
        public int getPreviousRowIndex() {
            int n = this.getCurrentRowIndex() - this.getPageSize();
            if (n < 0) {
                n = 0;
            }
            return n;
        }
    }
}

