/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class PizzaItemExplorer
extends TransparentPanel
implements PaginationBar.PagingListener {
    private JXTable a;
    private BeanTableModel<MenuItem> b = new BeanTableModel(MenuItem.class);
    private JComboBox c;
    private FixedLengthTextField d;
    private PaginationBar e;

    public PizzaItemExplorer() {
        this.b.addColumn(POSConstants.NAME, MenuItem.PROP_NAME);
        this.b.addColumn(POSConstants.TRANSLATED_NAME, MenuItem.PROP_TRANSLATED_NAME);
        this.b.addColumn(POSConstants.PRICE + CurrencyUtil.getCurrencySymbolWithBracket(), MenuItem.PROP_PRICE, 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(POSConstants.VISIBLE, MenuItem.PROP_VISIBLE);
        this.b.addColumn(Messages.getString("PizzaItemExplorer.1"), "taxGroup");
        this.b.addColumn(POSConstants.IMAGE, "image");
        this.a = new JXTable(this.b);
        this.a.getColumn(0).setMinWidth(100);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize((int)30));
        this.b.initTableRenderer((JTable)this.a);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)this.g(), "South");
        this.add((Component)this.c(), "North");
        this.resizeColumnWidth((JTable)this.a);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaItemExplorer.this.a();
                }
            }
        });
        this.f();
    }

    private void a() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            int n2 = this.a.convertRowIndexToModel(n);
            MenuItem menuItem = this.b.getRow(n2);
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem == null) {
                throw new PosException(Messages.getString("MenuItemExplorer.52"));
            }
            PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm);
            beanEditorDialog.openWithScale(1000, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.setRow(n2, menuItem);
            this.b.fireTableRowsUpdated(n, n);
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void b() {
        this.c.removeAllItems();
        this.c.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory menuCategory : list) {
            this.c.addItem(menuCategory);
        }
        this.c.setSelectedIndex(0);
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new WrapLayout(3));
        JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
        this.c = new OverflowCombobox();
        this.c.setPreferredSize(PosUIManager.getSize((int)150, (int)22));
        this.b();
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.0"));
        this.d = new FixedLengthTextField(15);
        this.d.addKeyListener(this.e());
        JButton jButton = new JButton(Messages.getString("RESET"));
        jButton.addActionListener(actionEvent -> this.d());
        try {
            JButton jButton2 = new JButton(Messages.getString("Search"));
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.d);
            jPanel.add(jLabel);
            jPanel.add(this.c);
            jPanel.add(jButton2);
            jPanel.add(jButton);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PizzaItemExplorer.this.f();
                }
            });
            this.d.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PizzaItemExplorer.this.f();
                }
            });
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void d() {
        this.d.setText("");
        this.c.setSelectedIndex(0);
        this.f();
    }

    private KeyListener e() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (PizzaItemExplorer.this.d.getText().length() > 2) {
                    PizzaItemExplorer.this.f();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    PizzaItemExplorer.this.f();
                }
            }
        };
    }

    private void f() {
        this.b.setCurrentRowIndex(0);
        this.a(0);
    }

    private void a(int n) {
        Object object = this.c.getSelectedItem();
        String string = this.d.getText();
        this.b.removeAll();
        this.b.setCurrentRowIndex(n);
        if (object instanceof MenuCategory) {
            MenuItemDAO.getInstance().getPizzaItems(this.b, string, (MenuCategory)object);
        } else {
            MenuItemDAO.getInstance().getPizzaItems(this.b, string, null);
        }
        this.e.updateView();
    }

    private JPanel g() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        JButton jButton4 = new JButton(Messages.getString("PizzaItemExplorer.3"));
        jButton.addActionListener(actionEvent -> this.a());
        jButton2.addActionListener(actionEvent -> this.i());
        jButton3.addActionListener(actionEvent -> this.j());
        jButton4.addActionListener(actionEvent -> this.k());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.e = new PaginationBar(this, this.b);
        jPanel.add((Component)this.e, "growy");
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        transparentPanel.add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)transparentPanel, "Center");
        jPanel2.add((Component)jPanel, "East");
        return jPanel2;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.h().get(i));
        }
    }

    private List h() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(50);
        arrayList.add(200);
        arrayList.add(200);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(140);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(200);
        return arrayList;
    }

    private void i() {
        try {
            Serializable serializable;
            MenuItem menuItem = new MenuItem();
            Object object = this.c.getSelectedItem();
            if (object instanceof OrderType) {
                serializable = new ArrayList<Object>();
                serializable.add(object);
                menuItem.setOrderTypeList((List)((Object)serializable));
            }
            serializable = new PizzaItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable);
            beanEditorDialog.openWithScale(1000, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            menuItem = (MenuItem)((BeanEditor)serializable).getBean();
            this.b.addRow(menuItem);
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void j() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem menuItem = this.b.getRow(n);
            MenuItemDAO.getInstance().delete(menuItem.getId());
            this.b.removeRow(n);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemExplorer.4"));
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void k() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("Duplicate"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuItem menuItem = this.b.getRow(n);
            MenuItemDAO.getInstance().initialize(menuItem);
            MenuItem menuItem2 = menuItem.clone();
            PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm);
            beanEditorDialog.openWithScale(900, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem3 = (MenuItem)pizzaItemForm.getBean();
            this.b.addRow(menuItem3);
            this.a.getSelectionModel().addSelectionInterval(this.b.getRowCount() - 1, this.b.getRowCount() - 1);
            this.a.scrollRowToVisible(this.b.getRowCount() - 1);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void pageRequested(int n) {
        this.a(n);
    }
}

