/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierExplorer
extends TransparentPanel
implements PaginationBar.PagingListener {
    private String a;
    private JXTable b;
    private PizzaModifierExplorerModel c;
    private FixedLengthTextField d;
    private PaginationBar e;

    public PizzaModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = CurrencyUtil.getCurrencySymbol();
        this.c = new PizzaModifierExplorerModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setRowHeight(PosUIManager.getSize((int)30));
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.b));
        this.a();
        this.add((Component)this.e(), "North");
        this.updateModifierList();
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaModifierExplorer.this.c();
                }
            }
        });
        this.a((JTable)this.b);
    }

    private void a(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(250);
        tableColumnModel.getColumn(0).setMaxWidth(300);
        tableColumnModel.getColumn(1).setMinWidth(250);
        tableColumnModel.getColumn(1).setMaxWidth(300);
        tableColumnModel.getColumn(2).setMinWidth(150);
        tableColumnModel.getColumn(2).setMaxWidth(200);
    }

    private void a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        explorerButtonPanel.getAddButton().addActionListener(actionEvent -> this.b());
        explorerButtonPanel.getEditButton().addActionListener(actionEvent -> this.c());
        explorerButtonPanel.getDeleteButton().addActionListener(actionEvent -> this.d());
        JButton jButton = new JButton(Messages.getString("PizzaModifierExplorer.2"));
        jButton.addActionListener(actionEvent -> this.h());
        explorerButtonPanel.add(jButton);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.e = new PaginationBar(this, this.c);
        jPanel.add((Component)this.e, "growy");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)explorerButtonPanel, "Center");
        jPanel2.add((Component)jPanel, "East");
        this.add((Component)jPanel2, "South");
    }

    private void b() {
        try {
            PizzaModifierForm pizzaModifierForm = new PizzaModifierForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaModifierForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuModifier menuModifier = (MenuModifier)pizzaModifierForm.getBean();
            this.c.addModifier(menuModifier);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            MenuModifier menuModifier2 = MenuModifierDAO.getInstance().get(menuModifier.getId());
            PizzaModifierForm pizzaModifierForm = new PizzaModifierForm(menuModifier2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaModifierForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.c.setRowData(n, menuModifier2);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            MenuModifierDAO.getInstance().delete(menuModifier);
            this.c.deleteModifier(menuModifier, n);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private String a(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        String string2 = new String();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string2 = string + " 1";
        } else {
            String string3 = string.substring(n + 1, string.length());
            if (StringUtils.isNumeric((CharSequence)string3)) {
                Integer n2 = Integer.valueOf(string3);
                n2 = n2 + 1;
                string2 = string.replace(string3, String.valueOf(n2));
            } else {
                string2 = string + " 1";
            }
        }
        return string2;
    }

    private JPanel e() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new WrapLayout(3));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        JLabel jLabel2 = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.d = new FixedLengthTextField(15);
        this.d.addKeyListener(this.g());
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        List<MenuItemModifierSpec> list = MenuItemModifierSpecDAO.getInstance().findAll();
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.addItem(Messages.getString("ModifierExplorer.5"));
        for (MenuItemModifierSpec serializable2 : list) {
            jComboBox.addItem(serializable2);
        }
        JButton jButton = new JButton(Messages.getString("Search"));
        JButton jButton2 = new JButton(Messages.getString("RESET"));
        jButton2.addActionListener(actionEvent -> this.f());
        jPanel.add((Component)jLabel, "align label,split 2");
        jPanel.add(this.d);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        return jPanel;
    }

    private void f() {
        this.d.setText("");
        this.updateModifierList();
    }

    private KeyListener g() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (PizzaModifierExplorer.this.d.getText().length() > 2) {
                    PizzaModifierExplorer.this.updateModifierList();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    PizzaModifierExplorer.this.updateModifierList();
                }
            }
        };
    }

    public synchronized void updateModifierList() {
        this.c.setCurrentRowIndex(0);
        this.updateModifierList(0);
    }

    public synchronized void updateModifierList(int n) {
        this.c.setCurrentRowIndex(n);
        MenuModifierDAO.getInstance().loadPizzaModifiers(this.c, this.d.getText());
        this.e.updateView();
    }

    public void setModifierList(List<MenuModifier> list) {
        this.c.setRows(list);
    }

    private void h() {
        try {
            Comparable comparable2;
            ArrayList<PizzaModifierPrice> arrayList;
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("Duplicate"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            MenuModifierDAO.getInstance().initialize(menuModifier);
            MenuModifier menuModifier2 = new MenuModifier();
            PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
            menuModifier2.setId(null);
            String string = this.a(menuModifier);
            menuModifier2.setName(string);
            menuModifier2.setPizzaModifier(true);
            menuModifier2.setMultiplierPriceList(null);
            List<PizzaModifierPrice> list = menuModifier.getPizzaModifierPriceList();
            if (list != null) {
                arrayList = new ArrayList();
                for (Comparable comparable2 : list) {
                    PizzaModifierPrice pizzaModifierPrice = new PizzaModifierPrice();
                    PropertyUtils.copyProperties((Object)pizzaModifierPrice, (Object)comparable2);
                    pizzaModifierPrice.setId(null);
                    arrayList.add(pizzaModifierPrice);
                    List<ModifierMultiplierPrice> list2 = pizzaModifierPrice.getMultiplierPriceList();
                    if (list2 == null) continue;
                    ArrayList<ModifierMultiplierPrice> arrayList2 = new ArrayList<ModifierMultiplierPrice>();
                    for (ModifierMultiplierPrice modifierMultiplierPrice : list2) {
                        ModifierMultiplierPrice modifierMultiplierPrice2 = new ModifierMultiplierPrice();
                        PropertyUtils.copyProperties((Object)modifierMultiplierPrice2, (Object)modifierMultiplierPrice);
                        modifierMultiplierPrice2.setId(null);
                        modifierMultiplierPrice2.setModifierId(menuModifier2.getId());
                        arrayList2.add(modifierMultiplierPrice2);
                    }
                    pizzaModifierPrice.setMultiplierPriceList(arrayList2);
                }
                menuModifier2.setPizzaModifierPriceList(arrayList);
            }
            arrayList = new PizzaModifierForm(menuModifier2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)((Object)arrayList));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            comparable2 = (MenuModifier)((BeanEditor)((Object)arrayList)).getBean();
            this.c.addModifier((MenuModifier)comparable2);
            this.b.getSelectionModel().addSelectionInterval(this.c.getRowCount() - 1, this.c.getRowCount() - 1);
            this.b.scrollRowToVisible(this.c.getRowCount() - 1);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void pageRequested(int n) {
        this.updateModifierList(n);
    }

    private class PizzaModifierExplorerModel
    extends ListTableModel
    implements PaginationSupport {
        private int b;
        private int c;
        private int d;

        public PizzaModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, Messages.getString("TAX_GROUP"), POSConstants.MODIFIER_GROUP});
            this.d = 50;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List list = this.getRows();
            MenuModifier menuModifier = (MenuModifier)list.get(n);
            switch (n2) {
                case 0: {
                    return menuModifier.getName();
                }
                case 1: {
                    return menuModifier.getTranslatedName();
                }
                case 2: {
                    if (menuModifier.getTaxGroup() == null) {
                        return "";
                    }
                    return menuModifier.getTaxGroup();
                }
                case 3: {
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                    List<ModifierGroup> list2 = menuModifier.getModifierGroups();
                    if (list2 != null) {
                        Iterator<ModifierGroup> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            ModifierGroup modifierGroup = iterator.next();
                            if (!modifierGroup.isDeleted().booleanValue()) continue;
                            iterator.remove();
                        }
                    }
                    return list2 == null ? "" : list2.toString();
                }
                case 4: {
                    if (menuModifier.getButtonColor() != null) {
                        return new Color(menuModifier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    return menuModifier.getSortOrder();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier menuModifier) {
            int n = this.getRows().size();
            this.getRows().add(menuModifier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifier(MenuModifier menuModifier, int n) {
            this.getRows().remove(menuModifier);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public int getNumRows() {
            return this.b;
        }

        @Override
        public void setNumRows(int n) {
            this.b = n;
        }

        @Override
        public int getCurrentRowIndex() {
            return this.c;
        }

        @Override
        public void setCurrentRowIndex(int n) {
            this.c = n;
        }

        @Override
        public int getPageSize() {
            return this.d;
        }

        @Override
        public void setPageSize(int n) {
            this.d = n;
        }

        @Override
        public boolean hasNext() {
            return this.c + this.d < this.b;
        }

        @Override
        public boolean hasPrevious() {
            return this.c > 0;
        }

        @Override
        public int getNextRowIndex() {
            if (this.b == 0) {
                return 0;
            }
            return this.getCurrentRowIndex() + this.getPageSize();
        }

        @Override
        public int getPreviousRowIndex() {
            int n = this.getCurrentRowIndex() - this.getPageSize();
            if (n < 0) {
                n = 0;
            }
            return n;
        }
    }
}

