/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.main.Application;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.OroLicenseInfoDialog;
import com.floreantpos.ui.dialog.OroMobileLicenceActivation;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class TerminalExplorer
extends TransparentPanel {
    private static final long a = 1L;
    private JXTable b;
    private BeanTableModel<Terminal> c;
    private JButton d;
    private JButton e;

    public TerminalExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new BeanTableModel(Terminal.class);
        this.c.addColumn(Messages.getString("TerminalExplorer.0"), "id");
        this.c.addColumn(Messages.getString("TerminalExplorer.2"), "name");
        this.c.addColumn(Messages.getString("TerminalExplorer.4"), "department");
        this.c.addColumn(Messages.getString("TerminalExplorer.12"), "location");
        this.c.addColumn(Messages.getString("TerminalExplorer.10"), "hasCashDrawer");
        this.c.addColumn(Messages.getString("TerminalExplorer.1"), Terminal.PROP_IS_AUTO_LOG_OFF_ENABLED);
        this.c.addColumn(Messages.getString("TerminalExplorer.18"), "defaultPassLength");
        this.c.addColumn(Messages.getString("TerminalExplorer.5"), "active");
        this.f();
        this.b = new JXTable(this.c);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.b.setRowHeight(PosUIManager.getSize((int)30));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TerminalExplorer.this.g();
                }
            }
        });
        this.b.getColumn(0).setCellRenderer(new IconRenderer());
        this.add(new JScrollPane((Component)this.b));
        this.add((Component)this.b(), "South");
        this.add((Component)this.e(), "North");
        this.b.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.a());
    }

    private void a() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.b.convertRowIndexToModel(n);
        this.d.setVisible(true);
        Terminal terminal = this.c.getRow(n);
        String string = terminal.isActive() != false ? Messages.getString("TerminalExplorer.8") : Messages.getString("TerminalExplorer.11");
        this.d.setText(string);
        this.e.setVisible(terminal.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType());
    }

    private TransparentPanel b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getDeleteButton();
        JButton jButton3 = new JButton(Messages.getString("TerminalExplorer.3"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalExplorer.this.i();
            }
        });
        this.d = new JButton("");
        this.d.setVisible(false);
        this.d.addActionListener(actionEvent -> this.d());
        this.e = new JButton(Messages.getString("TerminalExplorer.15"));
        this.e.setVisible(false);
        this.e.addActionListener(actionEvent -> this.c());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalExplorer.this.g();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalExplorer.this.h();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(this.d);
        transparentPanel.add(this.e);
        return transparentPanel;
    }

    private void c() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.b.convertRowIndexToModel(n);
        Terminal terminal = this.c.getRow(n);
        OroMobileLicenceActivation oroMobileLicenceActivation = new OroMobileLicenceActivation();
        File file = OroMobileLicenceActivation.getLicenseFile(terminal.getTerminalKey());
        try {
            OroLicense oroLicense = LicenseUtil.loadAndValidate((File)file, (String)"ORO POS Mobile", null, (String)terminal.getTerminalKey());
            this.a(oroMobileLicenceActivation, oroLicense, terminal);
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            POSMessageDialog.showError(Messages.getString("TerminalExplorer.16"));
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.a(oroMobileLicenceActivation, invalidLicenseException.getLicense(), terminal);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("TerminalExplorer.16"));
        }
    }

    private void a(OroMobileLicenceActivation oroMobileLicenceActivation, OroLicense oroLicense, Terminal terminal) {
        OroLicenseInfoDialog oroLicenseInfoDialog = new OroLicenseInfoDialog();
        oroLicenseInfoDialog.setLicense(oroLicense);
        oroLicenseInfoDialog.setSize(PosUIManager.getSize((int)500, (int)500));
        oroLicenseInfoDialog.setLocationRelativeTo(null);
        oroLicenseInfoDialog.setTerminal(terminal);
        oroLicenseInfoDialog.setShowCommonActivationDialog(true);
        oroLicenseInfoDialog.setVisible(true);
    }

    private void d() {
        Object object;
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TerminalExplorer.14"));
            return;
        }
        n = this.b.convertRowIndexToModel(n);
        Terminal terminal = this.c.getRow(n);
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        terminalDAO.refresh(terminal);
        if (terminal.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType() && !terminal.isActive().booleanValue()) {
            object = new OroMobileLicenceActivation();
            ((OroMobileLicenceActivation)object).doCheckLicense(terminal);
            if (!((OroMobileLicenceActivation)object).isLicensefound()) {
                return;
            }
        }
        Object object2 = object = terminal.isActive() != false ? Messages.getString("TerminalExplorer.8") : Messages.getString("TerminalExplorer.11");
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalExplorer.17") + ((String)object).toLowerCase() + "?", (String)object) != 0) {
            return;
        }
        terminal.setActive(terminal.isActive() == false);
        terminalDAO.saveOrUpdate(terminal);
        OroMqttClient.getInstance().notifyDataUpdated(Terminal.class);
        this.c.setRow(n, terminal);
        this.b.repaint();
        this.a();
    }

    private JPanel e() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("ins 5 5 0 0"));
        JButton jButton = new JButton(POSConstants.REFRESH);
        jButton.addActionListener(actionEvent -> this.f());
        jPanel.add(jButton);
        return jPanel;
    }

    private void f() {
        this.c.setRows(TerminalDAO.getInstance().findAll());
    }

    private void g() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            Terminal terminal = this.c.getRow(n);
            terminal = TerminalDAO.getInstance().initialize(terminal);
            this.c.setRow(n, terminal);
            TerminalConfigurationAction terminalConfigurationAction = new TerminalConfigurationAction(terminal);
            terminalConfigurationAction.actionPerformed(null);
            this.b.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void h() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            Terminal terminal = this.c.getRow(n);
            if (DataProvider.get().getCurrentTerminal().equals(terminal)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TerminalExplorer.6"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TerminalDAO terminalDAO = new TerminalDAO();
            terminalDAO.delete(terminal);
            OroMqttClient.getInstance().notifyDataUpdated(Terminal.class);
            this.c.removeRow(n);
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalExplorer.7"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void i() {
        try {
            Outlet outlet = DataProvider.get().getOutlet();
            String string = outlet.getAdminEmail();
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showError(this, Messages.getString("MailService.4"));
                return;
            }
            PosResponse posResponse = new PosResponse();
            posResponse.setResponseCode(1);
            posResponse.setRequest("Log File Request");
            String string2 = Messages.getString("TerminalExplorer.9");
            posResponse.setMsg(string2);
            posResponse.setDeviceId(TerminalUtil.getSystemUID());
            posResponse.setData(string);
            posResponse.setOutletId(Application.getInstance().getCurrentTerminalOutletId());
            String string3 = ServiceUtils.getAsJsonString(posResponse);
            OroMqttClient.getInstance().publishData("public", string3, true);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalExplorer.13"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Terminal terminal = Application.getInstance().getTerminal();
            Terminal terminal2 = (Terminal)TerminalExplorer.this.c.getRow(n);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if (terminal.equals(terminal2)) {
                jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                return jLabel;
            }
            if (terminal2.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType()) {
                GoogleMaterialDesignIcons googleMaterialDesignIcons = terminal2.isActive() != false ? GoogleMaterialDesignIcons.PHONE_ANDROID : GoogleMaterialDesignIcons.PHONELINK_ERASE;
                jLabel.setIcon(IconFontSwing.buildIcon((IconCode)googleMaterialDesignIcons, (float)PosUIManager.getFontSize((int)18)));
                return jLabel;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

