/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseAttendenceHistory;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.ibm.icu.util.Calendar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class WorkHourCalculationExplorer
extends TransparentPanel {
    private SimpleDateFormat a = new SimpleDateFormat("MMM dd, YYYY hh:mm a");
    private JButton b = new JButton(POSConstants.GO);
    private JXTable c;
    private JComboBox d;
    private JPanel e;
    private JXDatePicker f;
    private JXDatePicker g;
    private JLabel h;
    private JComboBox<Date> i;
    private JLabel j;
    private JComboBox<Date> k;
    private JCheckBox l;
    private HourlyPayrollReportTableModel m;

    public WorkHourCalculationExplorer() {
        super(new BorderLayout());
        this.a();
    }

    private void a() {
        this.m = new HourlyPayrollReportTableModel();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.d = new JComboBox();
        List<User> list = UserDAO.getInstance().findAllActive();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.d.setModel(new DefaultComboBoxModel(vector));
        this.f = UiUtil.getPreviousMonthStart();
        this.f.setFormats(new String[]{"MMM dd, yyyy"});
        this.g = UiUtil.getPreviousMonthEnd();
        this.g.setFormats(new String[]{"MMM dd, yyyy"});
        TimeComboBox timeComboBox = new TimeComboBox();
        this.h = new JLabel(POSConstants.START_TIME + ":");
        this.i = timeComboBox.getDefaultTimeComboBox();
        this.j = new JLabel(POSConstants.END_TIME + ":");
        this.k = timeComboBox.getDefaultTimeComboBox();
        this.c();
        this.l = new JCheckBox(Messages.getString("ReportViewer.15"));
        jPanel.add((Component)new JLabel(POSConstants.START_DATE), "grow");
        jPanel.add((Component)this.f);
        jPanel.add((Component)new JLabel(POSConstants.TO_DATE), "grow");
        jPanel.add((Component)this.g);
        jPanel.add(this.h);
        jPanel.add(this.i);
        jPanel.add(this.j);
        jPanel.add(this.k);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.d);
        jPanel.add(this.l);
        jPanel.add((Component)this.b, "skip 1, al right");
        JButton jButton = new JButton(Messages.getString("RESET"));
        jButton.addActionListener(actionEvent -> this.b());
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.e = new JPanel(new BorderLayout());
        this.add(this.e);
        this.b.addActionListener(actionEvent -> this.d());
    }

    private void b() {
        JXDatePicker jXDatePicker = UiUtil.getPreviousMonthStart();
        this.f.setDate(jXDatePicker.getDate());
        JXDatePicker jXDatePicker2 = UiUtil.getPreviousMonthEnd();
        this.g.setDate(jXDatePicker2.getDate());
        this.c();
        this.d.setSelectedIndex(0);
        this.d();
        this.revalidate();
        this.repaint();
    }

    private void c() {
        this.i.setSelectedIndex(16);
        this.k.setSelectedIndex(44);
    }

    private void d() {
        try {
            Comparator<AttendenceHistory> comparator;
            Serializable serializable2;
            boolean bl;
            this.e.removeAll();
            HashMap<String, AttendenceHistory> hashMap = new HashMap<String, AttendenceHistory>();
            ArrayList<AttendenceHistory> arrayList = new ArrayList<AttendenceHistory>();
            Date date = this.f.getDate();
            Date date2 = this.g.getDate();
            DateUtil.validateDate(date, date2);
            User user = null;
            if (!this.d.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.d.getSelectedItem();
            }
            List<Date> list = POSUtil.getDaysBetweenDates(date, date2);
            boolean bl2 = bl = !this.l.isSelected();
            if (list != null) {
                for (Serializable serializable2 : list) {
                    Date date3 = (Date)this.i.getSelectedItem();
                    Date date4 = (Date)this.k.getSelectedItem();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(serializable2);
                    if (date3.after(date4) || date3.equals(date4)) {
                        calendar.add(5, 1);
                    }
                    serializable2 = DateUtil.copyTime(serializable2, date3);
                    Date date5 = DateUtil.copyTime(calendar.getTime(), date4);
                    List<AttendenceHistory> list2 = AttendenceHistoryDAO.getInstance().findAttendenceReport((Date)serializable2, date5, user, true);
                    if (list2 == null) continue;
                    for (AttendenceHistory attendenceHistory : list2) {
                        attendenceHistory.setFilterClockInDate((Date)serializable2);
                        attendenceHistory.setFilterClockOutDate(date5);
                        attendenceHistory.setFilterDate((Date)serializable2);
                        if (bl) {
                            Date date6 = attendenceHistory.getClockInTime();
                            Date date7 = attendenceHistory.getClockOutTime();
                            long l = date7.getTime() - date6.getTime();
                            if (date6.before(attendenceHistory.getFilterClockInDate())) {
                                date6 = attendenceHistory.getFilterClockInDate();
                            }
                            if (date7.after(attendenceHistory.getFilterClockOutDate())) {
                                date7 = attendenceHistory.getFilterClockOutDate();
                            }
                            long l2 = date7.getTime() - date6.getTime();
                            String string = attendenceHistory.getUserId();
                            AttendenceHistory attendenceHistory2 = (AttendenceHistory)hashMap.get(string);
                            if (attendenceHistory2 == null) {
                                attendenceHistory.setActualTotalWorkHourMs(l);
                                attendenceHistory.setFilterTotalWorkHourMs(l2);
                                hashMap.put(string, attendenceHistory);
                                continue;
                            }
                            if (!attendenceHistory2.getId().equals(attendenceHistory.getId())) {
                                attendenceHistory2.setActualTotalWorkHourMs(attendenceHistory2.getActualTotalWorkHourMs() + l);
                            }
                            attendenceHistory2.setFilterTotalWorkHourMs(attendenceHistory2.getFilterTotalWorkHourMs() + l2);
                            continue;
                        }
                        arrayList.add(attendenceHistory);
                    }
                }
            }
            if (bl) {
                comparator = hashMap.values();
                arrayList.addAll(new ArrayList(comparator));
            }
            if (arrayList == null || arrayList.isEmpty()) {
                return;
            }
            comparator = Comparator.comparing(BaseAttendenceHistory::getUserId, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)).thenComparing(BaseAttendenceHistory::getClockInTime, Comparator.naturalOrder());
            arrayList.sort(comparator);
            this.c = new JXTable();
            this.m.setRows(arrayList);
            this.m.setShowBreakdown(!bl);
            this.c.setModel((TableModel)this.m);
            this.c.setRowHeight(PosUIManager.getSize((int)30));
            this.c.getSelectionModel().setSelectionMode(0);
            this.c.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
            serializable2 = new JScrollPane((Component)this.c);
            this.e.add((Component)serializable2, "Center");
            this.resizeColumnWidth((JTable)this.c);
            this.e.revalidate();
            this.e.repaint();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.e().get(i));
        }
    }

    private List e() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(20);
        arrayList.add(400);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(40);
        arrayList.add(40);
        arrayList.add(40);
        return arrayList;
    }

    class HourlyPayrollReportTableModel
    extends ListTableModel {
        String[] a = new String[]{Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("colRole"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("WorkHourCalculationExplorer.0"), "Filter date", Messages.getString("WorkHourCalculationExplorer.1")};
        private boolean c;

        public HourlyPayrollReportTableModel() {
            this.setColumnNames(this.a);
        }

        public void setShowBreakdown(boolean bl) {
            this.c = bl;
        }

        HourlyPayrollReportTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.a);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttendenceHistory attendenceHistory = (AttendenceHistory)this.rows.get(n);
            Date date = attendenceHistory.getClockInTime();
            Date date2 = attendenceHistory.getClockOutTime();
            switch (n2) {
                case 0: {
                    return attendenceHistory.getUser().getId();
                }
                case 1: {
                    return attendenceHistory.getUser().getFirstName() + " " + attendenceHistory.getUser().getLastName();
                }
                case 2: {
                    return attendenceHistory.getUser().getTypeName();
                }
                case 3: {
                    if (!this.c) {
                        return "";
                    }
                    if (date != null) {
                        return WorkHourCalculationExplorer.this.a.format(date);
                    }
                    return "";
                }
                case 4: {
                    if (!this.c) {
                        return "";
                    }
                    if (date2 != null) {
                        return WorkHourCalculationExplorer.this.a.format(date2);
                    }
                    return "";
                }
                case 5: {
                    if (!this.c) {
                        return DurationFormatUtils.formatDuration((long)attendenceHistory.getActualTotalWorkHourMs(), (String)"HH'h 'mm'm 'ss's'");
                    }
                    long l = attendenceHistory.getClockOutTime().getTime() - attendenceHistory.getClockInTime().getTime();
                    return DurationFormatUtils.formatDuration((long)l, (String)"HH'h 'mm'm 'ss's'");
                }
                case 6: {
                    if (!this.c) {
                        return "";
                    }
                    return DateUtil.formatSmall(attendenceHistory.getFilterDate());
                }
                case 7: {
                    if (!this.c) {
                        return DurationFormatUtils.formatDuration((long)attendenceHistory.getFilterTotalWorkHourMs(), (String)"HH'h 'mm'm 'ss's'");
                    }
                    if (date.before(attendenceHistory.getFilterClockInDate())) {
                        date = attendenceHistory.getFilterClockInDate();
                    }
                    if (date2.after(attendenceHistory.getFilterClockOutDate())) {
                        date2 = attendenceHistory.getFilterClockOutDate();
                    }
                    long l = date2.getTime() - date.getTime();
                    return DurationFormatUtils.formatDuration((long)l, (String)"HH'h 'mm'm 'ss's'");
                }
            }
            return null;
        }
    }
}

