/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer.attribute;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.attribute.QuickGroupLayout;
import com.floreantpos.bo.ui.explorer.attribute.VariantComboCheckUtil;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import validation.TextFieldValidationComponant;

public class QuickAttributeLayout
extends TransparentPanel {
    private TextFieldValidationComponant a;
    private FixedLengthTextField b;
    private JButton c;
    private Attribute d;
    private QuickGroupLayout e;
    private QuickAttributeLayout f;
    private FocusListener g;

    public QuickAttributeLayout(Attribute attribute, QuickGroupLayout quickGroupLayout) {
        this.e = quickGroupLayout;
        this.d = attribute;
        this.a();
        this.renderAttribute();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,ins 0", "[][grow]", ""));
        this.b = new FixedLengthTextField(30);
        this.b.addActionListener(actionEvent -> this.createNewAttributeLayout(this));
        this.a = new TextFieldValidationComponant(this.b);
        this.c = new JButton(Messages.getString("QuickAttributeLayout.0"));
        this.c.setFont(this.c.getFont().deriveFont(1));
        this.c.setToolTipText(Messages.getString("QuickAttributeLayout.1"));
        this.c.addActionListener(actionEvent -> this.a(this));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,ins 0", "[][grow]", ""));
        transparentPanel.add(this.a);
        transparentPanel.add(this.c);
        this.add(transparentPanel);
    }

    private void a(QuickAttributeLayout quickAttributeLayout) {
        try {
            Attribute attribute;
            MenuItem menuItem = this.e.getParentMenuItem();
            if (menuItem != null) {
                VariantComboCheckUtil.checkVariantIsUsedByCombo(menuItem, this.d);
            }
            if (StringUtils.isNotBlank((CharSequence)(attribute = quickAttributeLayout.d).getId())) {
                this.e.b.add(attribute);
            }
            if (this.e.a.size() == 1) {
                this.b.requestFocus();
                AttributeGroup attributeGroup = this.e.getAttributeGroup(false);
                this.a(attributeGroup);
            } else {
                this.e.c.remove(quickAttributeLayout);
                this.e.getQuickAttributeLayoutList().remove(quickAttributeLayout);
            }
            this.e.revalidateUi();
        }
        catch (DuplicateDataException duplicateDataException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(duplicateDataException.getMessage(), duplicateDataException.getDetails());
            detailsInfoDialog.open();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void a(AttributeGroup attributeGroup) {
        this.d = new Attribute();
        this.b.setText("");
    }

    public void renderAttribute() {
        if (this.d == null && StringUtils.isBlank((CharSequence)this.d.getId())) {
            return;
        }
        String string = this.d.getName();
        this.b.setText(StringUtils.isBlank((CharSequence)string) ? "" : string);
    }

    public Attribute getAttribute() {
        this.d.setName(this.b.getText().trim());
        return this.d;
    }

    public void createNewAttributeLayout(QuickAttributeLayout quickAttributeLayout) {
        try {
            if (this.g != null) {
                this.g.focusLost(null);
            }
            List<QuickAttributeLayout> list = this.e.getQuickAttributeLayoutList();
            for (QuickAttributeLayout quickAttributeLayout2 : list) {
                JTextField jTextField = quickAttributeLayout2.getTfAttributeName();
                if (!StringUtils.isBlank((CharSequence)jTextField.getText())) continue;
                Container container = quickAttributeLayout2.getParent();
                if (container.getComponentCount() > 2) {
                    quickAttributeLayout2.updateValidation(Messages.getString("please_enter_variant_value"));
                } else {
                    quickAttributeLayout2.updateValidation(Messages.getString("AttributesGroupSelectionDialog.3"));
                }
                quickAttributeLayout2.requestFocus();
                return;
            }
            this.b(quickAttributeLayout);
            this.f.requestFocus();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void b(QuickAttributeLayout quickAttributeLayout) {
        QuickGroupLayout quickGroupLayout = quickAttributeLayout.e;
        this.f = new QuickAttributeLayout(new Attribute(), quickGroupLayout);
        this.f.setFocusListener(this.g);
        TransparentPanel transparentPanel = quickGroupLayout.c;
        Component component = transparentPanel.getComponent(transparentPanel.getComponentCount() - 1);
        if (component instanceof JButton) {
            transparentPanel.remove(component);
            transparentPanel.add(this.f);
            transparentPanel.add(component);
        } else {
            transparentPanel.add(this.f);
        }
        quickGroupLayout.getQuickAttributeLayoutList().add(this.f);
        this.e.revalidateUi();
    }

    @Override
    public void requestFocus() {
        this.b.requestFocus();
    }

    public JTextField getTfAttributeName() {
        return this.b;
    }

    public void updateValidation(String string) {
        ValidationResult validationResult = new ValidationResult();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            validationResult.addError(string, (Object)GlobalIdGenerator.generateGlobalId());
        }
        this.a(validationResult);
    }

    private void a(ValidationResult validationResult) {
        ValidationResultModel validationResultModel = this.a.getValidationResultModel();
        validationResultModel.setResult(validationResult);
        this.a.updateValidationResult(validationResult, this.a.getValidationResultModel());
        this.e.revalidateUi();
    }

    public void setFocusListener(FocusListener focusListener) {
        this.g = focusListener;
        this.b.addFocusListener(focusListener);
    }
}

