/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.modifierdesigner.ModifierActionSelectorDialog;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.base.BaseMenuItemModifierPageItem;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierPageDesignView
extends TransparentPanel {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int a = 5;
    private static final int b = 5;
    private List<MenuItemModifierPageItem> c;
    private List<MenuItemModifierPage> d;
    private final Dimension e;
    private MenuItemModifierPage f;
    private final JPanel g = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private PageSelectionListener h;
    private Integer i;
    private Integer j;
    private boolean k;
    private MenuItemModifierPageItem l = null;

    public ModifierPageDesignView() {
        this.e = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.g);
    }

    public void setPageListener(PageSelectionListener pageSelectionListener) {
        this.h = pageSelectionListener;
    }

    public void setPizzaItem(boolean bl) {
        this.k = bl;
    }

    public MenuItemModifierPage getMenuPage() {
        return this.f;
    }

    public void setMenuItemModifierPage(MenuItemModifierPage menuItemModifierPage) {
        this.f = menuItemModifierPage;
        this.reset();
        try {
            if (this.f == null) {
                return;
            }
            this.i = this.f.getCols();
            if (this.i <= 0) {
                this.i = 4;
            }
            this.j = this.f.getRows();
            if (this.j <= 0) {
                this.j = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.i);
            if (this.f.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.g.setLayout((LayoutManager)migLayout);
            this.c = this.f.getPageItems();
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void setMenuItems(List<MenuItemModifierPageItem> list) {
        this.c = list;
        try {
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    protected void renderItems() {
        this.reset();
        if (this.c == null) {
            this.c = new ArrayList<MenuItemModifierPageItem>();
        }
        try {
            Serializable serializable;
            String string;
            HashMap<String, ModifierButton> hashMap = new HashMap<String, ModifierButton>();
            for (int i = 0; i < this.j; ++i) {
                for (int j = 0; j < this.i; ++j) {
                    string = String.valueOf(j) + String.valueOf(i);
                    serializable = this.a(i, j, this.c);
                    ModifierButton modifierButton = (ModifierButton)this.createItemButton(serializable);
                    if (this.f.getModifierSpec() != null) {
                        modifierButton.setEnabled(!this.f.getModifierSpec().isUseModifierGroupSettings());
                    }
                    hashMap.put(string, modifierButton);
                    String string2 = String.format("cell %s %s", j, i);
                    if (!this.f.isFlixibleButtonSize().booleanValue()) {
                        string2 = string2 + String.format(", w %s!, h %s!", this.f.getButtonWidth(), this.f.getButtonHeight());
                    }
                    this.g.add((Component)modifierButton, string2);
                }
            }
            for (MenuItemModifierPageItem menuItemModifierPageItem : this.c) {
                string = String.valueOf(menuItemModifierPageItem.getCol()) + String.valueOf(menuItemModifierPageItem.getRow());
                serializable = (ModifierButton)hashMap.get(string);
                if (serializable == null) continue;
                ((ModifierButton)serializable).setMenuModifier(menuItemModifierPageItem.getMenuModifier());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidate();
        this.repaint();
    }

    private MenuItemModifierPageItem a(int n, int n2, List<MenuItemModifierPageItem> list) {
        for (MenuItemModifierPageItem menuItemModifierPageItem : list) {
            if (menuItemModifierPageItem.getCol() != n2 || menuItemModifierPageItem.getRow() != n) continue;
            return menuItemModifierPageItem;
        }
        MenuItemModifierPageItem menuItemModifierPageItem = new MenuItemModifierPageItem(n2, n);
        menuItemModifierPageItem.setParentPage(this.f);
        return menuItemModifierPageItem;
    }

    public void reset() {
        this.g.removeAll();
    }

    public void fillSelectedPageItems(List<MenuItemModifierPageItem> list) {
        int n = 0;
        for (int i = 0; i < this.g.getComponents().length; ++i) {
            ModifierButton modifierButton = (ModifierButton)this.g.getComponent(i);
            if (modifierButton.isEmptyItem()) {
                MenuItemModifierPageItem menuItemModifierPageItem = list.get(n);
                modifierButton.setMenuModifier(menuItemModifierPageItem.getMenuModifier());
                this.f.addTopageItems(modifierButton.getMenuItemModifierPageItem());
                ++n;
            }
            if (n == list.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object object) {
        MenuItemModifierPageItem menuItemModifierPageItem = (MenuItemModifierPageItem)object;
        ModifierButton modifierButton = new ModifierButton(menuItemModifierPageItem);
        return modifierButton;
    }

    public List<MenuItemModifierPageItem> getItems() {
        return this.c;
    }

    public List<MenuItemModifierPage> getPages() {
        return this.d;
    }

    public void setPages(List<MenuItemModifierPage> list) {
        this.d = list;
    }

    public class ModifierButton
    extends PosButton
    implements Transferable,
    MouseListener,
    MouseMotionListener {
        MenuItemModifierPageItem a;
        private DataFlavor d = new DataFlavor(MenuItemModifierPageItem.class, "menuItemModifierPageItem");
        private final DataFlavor[] e = new DataFlavor[]{this.d};
        private DragAndDropTransferHandler f;

        ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            this.a = menuItemModifierPageItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText(Messages.getString("ModifierPageDesignView.10"));
            this.setPreferredSize(ModifierPageDesignView.this.e);
            this.c();
            this.f = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.f);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int a() {
            return this.a.getRow();
        }

        int b() {
            return this.a.getCol();
        }

        public void setMenuItemModifierPageItem(MenuItemModifierPageItem menuItemModifierPageItem) {
            this.a = menuItemModifierPageItem;
        }

        public MenuItemModifierPageItem getMenuItemModifierPageItem() {
            return this.a;
        }

        public void setMenuModifier(MenuModifier menuModifier) {
            this.a.setMenuModifier(menuModifier);
            this.a.setParentPage(ModifierPageDesignView.this.f);
            this.c();
        }

        public boolean isEmptyItem() {
            return this.a.getMenuModifier() == null;
        }

        private void c() {
            if (StringUtils.isEmpty((String)this.a.getMenuModifierId())) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                this.setText(Messages.getString("ModifierPageDesignView.11"));
                return;
            }
            ImageIcon imageIcon = this.a.getImage();
            if (imageIcon != null) {
                if (this.a.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText("<html><body><center>" + this.a.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + this.a.getMenuModifierName() + "</center></body></html>");
            }
            this.setBackground(this.a.getButtonColor());
            this.setForeground(this.a.getTextColor());
        }

        private void d() {
            try {
                MenuModifier menuModifier = this.a.getMenuModifier();
                ArrayList<MenuModifier> arrayList = new ArrayList<MenuModifier>();
                if (menuModifier != null) {
                    arrayList.add(menuModifier);
                }
                if (menuModifier == null) {
                    menuModifier = this.e();
                    if (menuModifier == null) {
                        return;
                    }
                    if (this.a(menuModifier)) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierAlreadyExist"));
                        return;
                    }
                } else {
                    ModifierActionSelectorDialog modifierActionSelectorDialog = new ModifierActionSelectorDialog(this.a);
                    modifierActionSelectorDialog.setSize(PosUIManager.getSize((int)500, (int)350));
                    modifierActionSelectorDialog.open();
                    if (modifierActionSelectorDialog.isCanceled()) {
                        return;
                    }
                    String string = modifierActionSelectorDialog.getActionCommand();
                    if (string.equals("Replace")) {
                        menuModifier = this.e();
                        if (menuModifier == null) {
                            return;
                        }
                        if (this.a(menuModifier)) {
                            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierAlreadyExist"));
                            return;
                        }
                    } else if (string.equals("Edit")) {
                        Serializable serializable;
                        if (menuModifier.isPizzaModifier().booleanValue()) {
                            serializable = new PizzaModifierForm(menuModifier);
                            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable);
                            beanEditorDialog.open();
                            if (beanEditorDialog.isCanceled()) {
                                return;
                            }
                        } else {
                            MenuModifierDAO.getInstance().initialize(menuModifier);
                            serializable = new MenuModifierForm(menuModifier);
                            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable);
                            beanEditorDialog.setSize(PosUIManager.getSize((int)800, (int)600));
                            beanEditorDialog.open();
                            if (beanEditorDialog.isCanceled()) {
                                return;
                            }
                        }
                        if (StringUtils.isNotEmpty((String)this.a.getId()) && (serializable = MenuItemModifierPageItemDAO.getInstance().get(this.a.getId())) != null) {
                            this.a.setVersion(((BaseMenuItemModifierPageItem)serializable).getVersion());
                            this.a.setButtonColor(((MenuItemModifierPageItem)serializable).getButtonColor());
                            this.a.setTextColor(((MenuItemModifierPageItem)serializable).getTextColor());
                        }
                    } else if (string.equals("Detach")) {
                        MenuItemModifierPage menuItemModifierPage = ModifierPageDesignView.this.getMenuPage();
                        List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
                        Iterator<MenuItemModifierPageItem> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            MenuItemModifierPageItem menuItemModifierPageItem = iterator.next();
                            if (menuItemModifierPageItem.getRow() != this.a.getRow() || menuItemModifierPageItem.getCol() != this.a.getCol() || menuItemModifierPageItem.getId() != this.a.getId()) continue;
                            iterator.remove();
                            break;
                        }
                        ModifierPageDesignView.this.renderItems();
                        if (ModifierPageDesignView.this.h == null) {
                            return;
                        }
                        ModifierPageDesignView.this.h.itemSelected(null);
                        return;
                    }
                }
                this.a.setMenuModifier(menuModifier);
                this.a.setParentPage(ModifierPageDesignView.this.f);
                this.c();
                if (ModifierPageDesignView.this.h == null) {
                    return;
                }
                if (ModifierPageDesignView.this.f.getPageItems() != null && ModifierPageDesignView.this.f.getPageItems().contains(this.a)) {
                    ModifierPageDesignView.this.f.getPageItems().remove(this.a);
                }
                ModifierPageDesignView.this.f.addTopageItems(this.a);
                ModifierPageDesignView.this.h.itemSelected(this.a);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private boolean a(MenuModifier menuModifier) {
            List<MenuItemModifierPage> list = ModifierPageDesignView.this.getPages();
            if (list != null) {
                for (MenuItemModifierPage menuItemModifierPage : list) {
                    List<MenuItemModifierPageItem> list2 = menuItemModifierPage.getPageItems();
                    if (list2 == null || list2.size() == 0) continue;
                    for (MenuItemModifierPageItem menuItemModifierPageItem : list2) {
                        String string = menuItemModifierPageItem.getMenuModifierId();
                        if (string == null || !string.equals(menuModifier.getId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private MenuModifier e() {
            ArrayList<MenuModifier> arrayList;
            MenuItemModifierSpec menuItemModifierSpec = ModifierPageDesignView.this.f.getModifierSpec();
            if (menuItemModifierSpec == null) {
                arrayList = new ArrayList();
            } else {
                arrayList = new ArrayList<MenuModifier>(menuItemModifierSpec.getModifiers());
                ModifierPageDesignView.this.setPages(new ArrayList<MenuItemModifierPage>(menuItemModifierSpec.getModifierPages()));
            }
            ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(arrayList, ModifierPageDesignView.this.k);
            modifierSelectionDialog.setSingleSelectionEnable(Boolean.TRUE);
            modifierSelectionDialog.setSize(PosUIManager.getSize((int)600, (int)500));
            modifierSelectionDialog.open();
            if (modifierSelectionDialog.isCanceled()) {
                return null;
            }
            return modifierSelectionDialog.getSelectedRowData();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            try {
                ModifierButton modifierButton = (ModifierButton)mouseEvent.getSource();
                TransferHandler transferHandler = modifierButton.getTransferHandler();
                transferHandler.exportAsDrag(modifierButton, mouseEvent, 2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.d();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.e;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.e.length; ++i) {
                if (!dataFlavor.equals(this.e[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.d)) {
                return this.a;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ModifierButton b = null;

        public DragAndDropTransferHandler(ModifierButton modifierButton) {
            this.b = modifierButton;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return this.b;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(this.b.d);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            try {
                super.exportDone(jComponent, transferable, n);
                if (jComponent != null && jComponent instanceof ModifierButton && ModifierPageDesignView.this.l != null) {
                    List<MenuItemModifierPageItem> list;
                    this.b.setMenuItemModifierPageItem(ModifierPageDesignView.this.l);
                    MenuItemModifierPage menuItemModifierPage = ModifierPageDesignView.this.getMenuPage();
                    List<MenuItemModifierPageItem> list2 = list = menuItemModifierPage == null ? null : menuItemModifierPage.getPageItems();
                    if (list != null) {
                        for (MenuItemModifierPageItem menuItemModifierPageItem : list) {
                            if (menuItemModifierPageItem == null || !menuItemModifierPageItem.getRandomId().equals(ModifierPageDesignView.this.l.getRandomId())) continue;
                            menuItemModifierPageItem.setRow(this.b.a());
                            menuItemModifierPageItem.setCol(this.b.b());
                            break;
                        }
                    }
                    ModifierPageDesignView.this.l = null;
                    this.b.c();
                    ModifierPageDesignView.this.h.uiUpdate();
                    this.b.getModel().setPressed(false);
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), exception);
                return;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            boolean bl = false;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                Transferable transferable = transferSupport.getTransferable();
                MenuItemModifierPageItem menuItemModifierPageItem = (MenuItemModifierPageItem)transferable.getTransferData(this.b.d);
                ModifierPageDesignView.this.l = this.b.a;
                if (menuItemModifierPageItem != null) {
                    int n = menuItemModifierPageItem.getRow();
                    int n2 = menuItemModifierPageItem.getCol();
                    menuItemModifierPageItem.setRow(this.b.a());
                    menuItemModifierPageItem.setCol(this.b.b());
                    this.b.setMenuItemModifierPageItem(menuItemModifierPageItem);
                    MenuItemModifierPage menuItemModifierPage = ModifierPageDesignView.this.getMenuPage();
                    List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
                    if (list == null) {
                        return false;
                    }
                    for (MenuItemModifierPageItem menuItemModifierPageItem2 : list) {
                        if (menuItemModifierPageItem2 == null || !menuItemModifierPageItem2.getRandomId().equals(menuItemModifierPageItem.getRandomId())) continue;
                        menuItemModifierPageItem2.setRow(this.b.a());
                        menuItemModifierPageItem2.setCol(this.b.b());
                        break;
                    }
                    ModifierPageDesignView.this.l.setRow(n);
                    ModifierPageDesignView.this.l.setCol(n2);
                }
                this.b.c();
                ModifierPageDesignView.this.h.uiUpdate();
                bl = true;
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), exception);
            }
            return bl;
        }
    }
}

