/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.config.ui.VirtualPrinterConfigDialog;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PrinterType;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AddPrinterView
extends JPanel {
    private static final String a = " ";
    private static final String b = Messages.getString("AddPrinterDialog.1");
    private Printer c;
    private VirtualPrinter d;
    private FixedLengthTextField e;
    private JComboBox f;
    private JComboBox g;
    private JCheckBox h;
    private JRadioButton i;
    private JRadioButton j;
    private JRadioButton k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private FixedLengthTextField p;
    private FixedLengthTextField q;
    private FixedLengthTextField r;
    private TerminalPrinters s;
    private IntegerTextField t;
    private JComboBox u;
    private JButton v;
    private JLabel w;
    private JButton x;
    private JCheckBox y;
    private int z;

    public AddPrinterView() {
        this.initUI();
        this.setMinimumSize(new Dimension(500, 200));
    }

    public AddPrinterView(int n) {
        this.z = n;
        this.initUI();
        this.setMinimumSize(new Dimension(500, 200));
    }

    public void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[][grow]", ""));
        this.t = new IntegerTextField(5);
        this.v = new JButton(Messages.getString("MultiPrinterPane.5"));
        this.v.addActionListener(actionEvent -> this.a(false));
        JLabel jLabel = new JLabel(Messages.getString("AddPrinterDialog.4"));
        jPanel.add((Component)jLabel, "");
        this.m = new JLabel(Messages.getString("AddPrinterDialog.5"));
        this.n = new JLabel(Messages.getString("AddPrinterDialog.6"));
        this.p = new FixedLengthTextField();
        this.q = new FixedLengthTextField();
        this.o = new JLabel(Messages.getString("AddPrinterDialog.7"));
        this.r = new FixedLengthTextField();
        this.e = new FixedLengthTextField(20);
        this.i = new JRadioButton(PrinterType.LOCAL.getName());
        this.j = new JRadioButton(PrinterType.NETWORK.getName());
        this.k = new JRadioButton(PrinterType.SERIAL.getName());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterView.this.c();
            }
        };
        this.i.addActionListener(actionListener);
        this.j.addActionListener(actionListener);
        this.k.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        buttonGroup.add(this.k);
        this.f = new JComboBox();
        this.f.setEnabled(false);
        List<VirtualPrinter> list = VirtualPrinterDAO.getInstance().findAll();
        this.f.setModel(new DefaultComboBoxModel<VirtualPrinter>(list.toArray(new VirtualPrinter[0])));
        jPanel.add((Component)this.e, "growx");
        JButton jButton = new JButton(Messages.getString("NEW"));
        jButton.addActionListener(actionEvent -> this.doAddNewVirtualPrinter());
        this.u = new JComboBox();
        this.u.addItem("Standard");
        this.u.addItem("EscPOS");
        this.u.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                if (AddPrinterView.this.s == null) {
                    AddPrinterView.this.q.setText("9100");
                    AddPrinterView.this.p.setText("127.0.0.1");
                    AddPrinterView.this.t.setText("40");
                }
                AddPrinterView.this.a();
            }
        });
        jPanel.add((Component)new JLabel(Messages.getString("AddPrinterDialog.8")), "");
        jPanel.add((Component)this.u, "growx,split 4");
        jPanel.add((Component)this.i, "right");
        jPanel.add(this.j);
        jPanel.add(this.k);
        this.l = new JLabel(Messages.getString("AddPrinterDialog.9") + ":");
        this.g = new JComboBox();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(b);
        arrayList.add(ReceiptPrintService.OROPOS_PDF_PRINTER);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        this.g.addItem(null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i]);
        }
        this.g.setModel(new ComboBoxModel(arrayList));
        this.g.setRenderer(new PrintServiceComboRenderer());
        jPanel.add((Component)this.l, "newline");
        jPanel.add((Component)this.g, "growx,split 2");
        jPanel.add((Component)this.m, "newline");
        jPanel.add((Component)this.p, "growx,split 4");
        jPanel.add(this.n);
        jPanel.add((Component)this.q, "w 70!,split 2");
        jPanel.add((Component)this.o, "newline");
        jPanel.add((Component)this.r, "growx,split 2");
        jPanel.add((Component)this.v, "right");
        this.w = new JLabel(Messages.getString("AddPrinterDialog.13"));
        jPanel.add((Component)this.w, "newline");
        jPanel.add((Component)this.t, "growx,split 2");
        this.x = new JButton(Messages.getString("MultiPrinterPane.5"));
        this.x.addActionListener(actionEvent -> this.a(true));
        jPanel.add((Component)this.x, "right");
        this.y = new JCheckBox(Messages.getString("StoreMiscellaneousConfigurationView.3"));
        jPanel.add((Component)this.y, "skip 1, wrap");
        this.h = new JCheckBox(Messages.getString("AddPrinterDialog.12"));
        JSeparator jSeparator = new JSeparator();
        this.add((Component)jPanel, "Center");
        this.i.setSelected(true);
        this.a();
    }

    private void a() {
        boolean bl;
        String string = (String)this.u.getSelectedItem();
        boolean bl2 = bl = string == null || string.equals("Standard");
        if (bl) {
            this.i.setSelected(bl);
        }
        this.i.setVisible(!bl);
        this.j.setVisible(!bl);
        this.k.setVisible(!bl);
        this.w.setVisible(!bl);
        this.t.setVisible(!bl);
        this.x.setVisible(!bl);
        if (!bl && this.z == 2) {
            this.y.setVisible(true);
        } else {
            this.y.setVisible(false);
        }
        this.c();
    }

    private void a(boolean bl) {
        try {
            if (!this.updateModel(true)) {
                return;
            }
            String string = this.s.getPrinterName();
            if (string == null) {
                return;
            }
            String string2 = bl ? this.b() : ReceiptPrintService.getSystemInfo(this.s.getPrinterName(), this.d.getName());
            ReceiptPrintService.testPrinter(PosPrinters.createPrinter(this.s), bl ? "" : "System Information", string2);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("AddPrinterDialog.16"));
        }
    }

    private String b() {
        if (this.t.getInteger() <= 0) {
            throw new PosException(Messages.getString("AddPrinterDialog.17"));
        }
        String string = "";
        for (int i = 0; i < this.t.getInteger(); ++i) {
            string = string + "W";
        }
        return string;
    }

    private void c() {
        this.m.setVisible(this.j.isSelected());
        this.p.setVisible(this.j.isSelected());
        this.n.setVisible(this.j.isSelected());
        this.q.setVisible(this.j.isSelected());
        this.o.setVisible(this.k.isSelected());
        this.r.setVisible(this.k.isSelected());
        this.l.setVisible(this.i.isSelected());
        this.g.setVisible(this.i.isSelected());
    }

    protected void doAddNewVirtualPrinter() {
        try {
            VirtualPrinterConfigDialog virtualPrinterConfigDialog = new VirtualPrinterConfigDialog();
            virtualPrinterConfigDialog.open();
            if (virtualPrinterConfigDialog.isCanceled()) {
                return;
            }
            VirtualPrinter virtualPrinter = virtualPrinterConfigDialog.getPrinter();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.f.getModel();
            defaultComboBoxModel.addElement(virtualPrinter);
            this.f.setSelectedItem(virtualPrinter);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public boolean updateModel(boolean bl) {
        String string = this.e.getText().trim();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.11"));
            return false;
        }
        VirtualPrinter virtualPrinter = VirtualPrinterDAO.getInstance().findPrinterByName(string);
        if (this.d == null && virtualPrinter != null && !virtualPrinter.isDeleted().booleanValue()) {
            String string2 = string + a + Messages.getString("AddPrinterDialog.11");
            throw new PosException(string2);
        }
        if (this.d == null && virtualPrinter != null && virtualPrinter.isDeleted().booleanValue()) {
            this.d = virtualPrinter;
        }
        if (this.d == null) {
            this.d = new VirtualPrinter();
        } else {
            this.d.setDeleted(Boolean.FALSE);
        }
        this.d.setName(string);
        PrintService printService = null;
        Object object = this.g.getSelectedItem();
        if (object instanceof PrintService) {
            printService = (PrintService)object;
        }
        boolean bl2 = this.h.isSelected();
        if (this.c == null) {
            this.c = new Printer();
        }
        String string3 = this.c.getDeviceName();
        this.c.setVirtualPrinter(this.d);
        string3 = printService != null && printService.getName() != null ? printService.getName() : (object != null && object.equals(ReceiptPrintService.OROPOS_PDF_PRINTER) ? ReceiptPrintService.OROPOS_PDF_PRINTER : null);
        this.c.setDefaultPrinter(bl2);
        if (this.s == null) {
            this.s = new TerminalPrinters();
        }
        PrinterType printerType = this.getPrinterType();
        this.s.addProperty("receipt.printer_type", String.valueOf(this.u.getSelectedItem()));
        this.s.addProperty("printerType", printerType.getName());
        if (printerType == PrinterType.NETWORK) {
            String string4 = this.getIPAddress();
            if (StringUtils.isBlank((String)string4)) {
                POSMessageDialog.showError(Messages.getString("AddPrinterView.0"));
                return false;
            }
            String string5 = this.getIPPort();
            if (StringUtils.isBlank((String)string5)) {
                POSMessageDialog.showError(Messages.getString("AddPrinterView.1"));
                return false;
            }
            String string6 = this.t.getText();
            if (StringUtils.isBlank((String)string6)) {
                POSMessageDialog.showError(Messages.getString("AddPrinterView.2"));
                return false;
            }
            this.s.addProperty("ipAddress", string4);
            this.s.addProperty("ipPort", string5);
            string3 = string4 + (StringUtils.isNotBlank((String)string5) ? ":" + string5 : "");
        } else if (printerType == PrinterType.SERIAL) {
            this.s.addProperty("serialPort", this.getSerialPort());
            string3 = this.getSerialPort();
        } else {
            this.s.removeProperty("ipAddress");
            this.s.removeProperty("ipPort");
            this.s.removeProperty("serialPort");
        }
        this.s.addProperty("textLength", String.valueOf(this.t.getInteger()));
        if (!bl) {
            this.c.setDeviceName(string3);
        }
        this.s.setPrinterName(string3);
        if (this.y.isVisible()) {
            this.d.setBeepAfterPrintToKitchenIsDone(this.y.isSelected());
        } else {
            this.d.setBeepAfterPrintToKitchenIsDone(false);
        }
        boolean bl3 = DataProvider.get().getCurrentTerminal().isEnableRtl();
        boolean bl4 = DataProvider.get().getCurrentTerminal().isShowBothNameAndTranslatedName();
        if (this.u.getSelectedItem().equals("EscPOS") && (bl3 || bl4)) {
            POSMessageDialog.showMessage(Messages.getString("AddPrinterView.3"));
        }
        return true;
    }

    public TerminalPrinters getTerminalPrinter() {
        return this.s;
    }

    public PrinterType getPrinterType() {
        if (this.j.isSelected()) {
            return PrinterType.NETWORK;
        }
        if (this.k.isSelected()) {
            return PrinterType.SERIAL;
        }
        return PrinterType.LOCAL;
    }

    public String getIPAddress() {
        return this.p.getText();
    }

    public String getIPPort() {
        return this.q.getText();
    }

    public String getSerialPort() {
        return this.r.getText();
    }

    public Printer getPrinter() {
        return this.c;
    }

    public void setPrinter(Printer printer, TerminalPrinters terminalPrinters) {
        Object object;
        VirtualPrinter virtualPrinter;
        this.c = printer;
        this.s = terminalPrinters;
        this.d = virtualPrinter = printer.getVirtualPrinter();
        this.e.setText(virtualPrinter.getName());
        this.h.setSelected(printer.isDefaultPrinter());
        this.y.setSelected(virtualPrinter.isBeepAfterPrintToKitchenIsDone());
        if (printer != null && StringUtils.isNotEmpty((String)printer.getDeviceName())) {
            this.f.setSelectedItem(virtualPrinter);
            if (printer.getDeviceName().equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                this.g.setSelectedItem(ReceiptPrintService.OROPOS_PDF_PRINTER);
                return;
            }
            if (printer.getDeviceName().equals(Messages.getString("AddPrinterDialog.2"))) {
                this.g.setSelectedItem(b);
                return;
            }
            object = (ComboBoxModel)this.g.getModel();
            for (int i = 0; i < ((ComboBoxModel)object).getSize(); ++i) {
                PrintService printService;
                Object object2 = ((ComboBoxModel)object).getElementAt(i);
                if (!(object2 instanceof PrintService) || (printService = (PrintService)object2) == null || !printService.getName().equals(printer.getDeviceName())) continue;
                this.g.setSelectedIndex(i);
                break;
            }
        }
        if (terminalPrinters != null) {
            object = PrinterType.fromString(terminalPrinters.getProperty("printerType", PrinterType.LOCAL.getName()));
            if (object == PrinterType.NETWORK) {
                this.j.setSelected(true);
            } else if (object == PrinterType.SERIAL) {
                this.k.setSelected(true);
            } else {
                this.i.setSelected(true);
            }
            this.u.setSelectedItem(terminalPrinters.getProperty("receipt.printer_type", "Standard"));
            this.p.setText(terminalPrinters.getProperty("ipAddress", "127.0.0.1"));
            this.q.setText(terminalPrinters.getProperty("ipPort", ""));
            this.r.setText(terminalPrinters.getProperty("serialPort", ""));
            this.t.setText(terminalPrinters.getProperty("textLength", "40"));
        } else {
            this.t.setText("40");
            this.i.setSelected(true);
        }
        this.c();
    }

    public void setDefaultPrinterName(String string) {
        this.e.setText(string);
    }

    public void selectOroposPDFPrinter() {
        this.g.setSelectedItem(ReceiptPrintService.OROPOS_PDF_PRINTER);
    }
}

