/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ImagePanel;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class CustMonitorConfigurationDialog
extends POSDialog
implements PaginationBar.PagingListener,
ActionListener,
WindowListener {
    private JRadioButton a;
    private JRadioButton b;
    private JRadioButton c;
    private IntegerTextField d;
    private Store e;
    private ButtonGroup f;
    private JPanel g;
    private PaginatedTableModel h;
    private PaginationBar i;
    private ImageResource j;
    private JPanel k;

    public CustMonitorConfigurationDialog() {
        this.setTitle(VersionInfo.getAppName());
        this.h = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return null;
            }
        };
        this.h.setRows(new ArrayList());
        this.a();
        this.e();
        this.addWindowListener(this);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CustMonitorConfigurationDialog.0"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.add((Component)jPanel, "South");
        PosButton posButton = new PosButton(Messages.getString("CustMonitorConfigurationDialog.2"));
        PosButton posButton2 = new PosButton(Messages.getString("Close"));
        posButton.addActionListener(actionEvent -> this.d());
        posButton2.addActionListener(actionEvent -> {
            this.setCanceled(true);
            this.dispose();
        });
        jPanel.add(posButton);
        jPanel.add(posButton2);
        this.add(this.c());
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.g = new JPanel(new WrapLayout());
        this.g.setBorder(BorderFactory.createLineBorder(Color.gray));
        JScrollPane jScrollPane = new JScrollPane(this.g, 20, 30);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.k = new JPanel((LayoutManager)new MigLayout("fillx"));
        PosButton posButton = new PosButton(Messages.getString("CustMonitorConfigurationDialog.7"));
        posButton.addActionListener(actionEvent -> this.f());
        PosButton posButton2 = new PosButton(Messages.getString("CustMonitorConfigurationDialog.8"));
        posButton2.addActionListener(actionEvent -> this.doRemoveSlideImage());
        this.k.add((Component)posButton, "split 2");
        this.k.add(posButton2);
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.k, "South");
        return jPanel;
    }

    protected void doRemoveSlideImage() {
        int n;
        HashSet<ImageResource> hashSet = new HashSet<ImageResource>();
        for (n = 0; n < this.g.getComponentCount(); ++n) {
            ImagePanel imagePanel = (ImagePanel)this.g.getComponent(n);
            if (!imagePanel.getBtnImage().isSelected()) continue;
            ImageResource imageResource = (ImageResource)imagePanel.getBtnImage().getClientProperty("selected");
            hashSet.add(imageResource);
        }
        if (hashSet.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustMonitorConfigurationDialog.3"));
            return;
        }
        n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), String.format(Messages.getString("CustMonitorConfigurationDialog.13"), hashSet.size()), Messages.getString("CustMonitorConfigurationDialog.14"));
        if (n != 0) {
            return;
        }
        try {
            for (ImageResource imageResource : hashSet) {
                SlideShowImageDAO slideShowImageDAO;
                SlideShowImage slideShowImage;
                if (imageResource.getId() != null && (slideShowImage = (slideShowImageDAO = SlideShowImageDAO.getInstance()).findByImageId(imageResource.getId())) != null) {
                    slideShowImageDAO.delete(slideShowImage);
                }
                this.h.deleteItem(imageResource);
            }
            this.a(true, true);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustMonitorConfigurationDialog.15"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("left", "[][]", ""));
        this.f = new ButtonGroup();
        this.a = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.19"));
        this.b = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.20"));
        this.c = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.21"));
        this.f.add(this.a);
        this.f.add(this.b);
        this.f.add(this.c);
        JLabel jLabel = new JLabel(Messages.getString("CustMonitorConfigurationDialog.22"));
        this.d = new IntegerTextField(5, 4);
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)jLabel, "split 3");
        jPanel.add((Component)this.d, "grow");
        jPanel.add(new JLabel(Messages.getString("CustMonitorConfigurationDialog.28")));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel2.add((Component)jPanel, "wrap, top");
        JPanel jPanel3 = this.b();
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustMonitorConfigurationDialog.6")));
        jPanel2.add((Component)jPanel3, "grow,push");
        return jPanel2;
    }

    private void d() {
        try {
            int n = 0;
            if (this.a.isSelected()) {
                n = 0;
            } else if (this.b.isSelected()) {
                n = 1;
            } else if (this.c.isSelected()) {
                n = 2;
            }
            int n2 = this.d.getInteger();
            if (n2 > 1000) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustMonitorConfigurationDialog.1"));
                return;
            }
            this.e.addProperty("customer.monitor.display.option", String.valueOf(n));
            this.e.addProperty("customer.monitor.slide.duration", String.valueOf(n2));
            StoreDAO.getInstance().saveOrUpdate(this.e);
            OroMqttClient.getInstance().notifyDataUpdated(Store.class);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() {
        this.e = DataProvider.get().getStore();
        int n = this.e.getCustomerMonitorDisplayOption();
        switch (n) {
            case 0: {
                this.a.setSelected(true);
                break;
            }
            case 1: {
                this.b.setSelected(true);
                break;
            }
            case 2: {
                this.c.setSelected(true);
                break;
            }
        }
        int n2 = this.e.getCustomerMonitorDisplaySlideDuration();
        this.d.setText("" + n2);
    }

    private void f() {
        try {
            ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance(ImageGalleryDialog.SelectionMode.MULTIPLE);
            imageGalleryDialog.setTitle(VersionInfo.getAppName());
            imageGalleryDialog.setAutoCloseOnUpload();
            imageGalleryDialog.setSelectBtnVisible(true);
            imageGalleryDialog.setResizable(false);
            imageGalleryDialog.openFullScreen();
            if (imageGalleryDialog.isCanceled()) {
                return;
            }
            Set<ImageResource> set = imageGalleryDialog.getImageResources();
            Iterator<ImageResource> iterator = set.iterator();
            while (iterator.hasNext()) {
                ImageResource imageResource = iterator.next();
                SlideShowImage slideShowImage = SlideShowImageDAO.getInstance().findByImageId(imageResource.getId());
                if (slideShowImage != null) {
                    iterator.remove();
                }
                this.h.addItem(imageResource);
            }
            SlideShowImageDAO.getInstance().saveAll(new ArrayList<ImageResource>(set));
            this.h.setCurrentRowIndex(0);
            this.a(true);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(boolean bl) {
        this.a(bl, false);
    }

    private void a(boolean bl, boolean bl2) {
        this.g.removeAll();
        this.g.revalidate();
        this.g.repaint();
        if (bl) {
            this.h.setNumRows(SlideShowImageDAO.getInstance().rowCount());
            SlideShowImageDAO.getInstance().getImages(this.h);
        }
        List list = this.h.getRows();
        this.i.updateView();
        if (list != null) {
            AsyncAction.execute(() -> {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (ImageResource imageResource : list) {
                        ImagePanel imagePanel = new ImagePanel(this, imageResource, null, this.g);
                        imagePanel.setTitleEditableMode(false);
                        this.g.add(imagePanel);
                        this.g.revalidate();
                        this.g.repaint();
                    }
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        this.g.revalidate();
        this.g.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        if (jToggleButton.isSelected()) {
            this.j = (ImageResource)jToggleButton.getClientProperty("selected");
        }
    }

    @Override
    public void pageRequested(int n) {
        this.a(true);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Dimension dimension = this.g.getSize();
        int n = dimension.width / PosUIManager.getSize((int)180);
        int n2 = dimension.height / PosUIManager.getSize((int)180);
        if (n2 == 1) {
            n2 = 2;
        }
        int n3 = n * n2;
        this.h.setPageSize(n3);
        this.i = new PaginationBar(this, this.h);
        this.k.add((Component)this.i, "right, split 2");
        this.a(true);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

