/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.DatabaseSetupWizard;
import com.floreantpos.ui.setup.SetupWizard;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationDialog
extends POSDialog
implements ActionListener,
WindowListener {
    private static final String a = "CD";
    private static final String b = "UD";
    private static final String c = "SAVE";
    private static final String d = "cancel";
    private static final String e = "test";
    private static final String f = "open_path";
    private POSTextField g;
    private POSTextField h;
    private POSTextField i;
    private POSTextField j;
    private POSPasswordField k;
    private PosButton l;
    private PosButton m;
    private PosButton n;
    private PosButton o;
    private PosButton p;
    private JComboBox q;
    private TitlePanel r;
    private JLabel s;
    private JLabel t;
    private JLabel u;
    private JLabel v;
    private JLabel w;
    private PosButton x;
    private static boolean y = true;
    private JButton z;
    private boolean A;

    public DatabaseConfigurationDialog() throws HeadlessException {
        this.b();
        this.a();
    }

    @Override
    protected void initUI() {
        Object object;
        this.getContentPane().setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.r = new TitlePanel();
        this.g = new POSTextField();
        this.h = new POSTextField();
        this.i = new POSTextField(20);
        this.j = new POSTextField();
        this.k = new POSPasswordField();
        this.q = new JComboBox<Database>(Database.values());
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string) && (object = Database.getByProviderName(string)) != null) {
            this.q.setSelectedItem(object);
        }
        this.getContentPane().add((Component)this.r, "span, grow, wrap");
        this.getContentPane().add(new JLabel(Messages.getString("DatabaseConfigurationDialog.8")));
        this.getContentPane().add((Component)this.q, "grow, wrap");
        this.u = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        this.getContentPane().add(this.u);
        this.A = AppConfig.getDatabaseProviderName().equals(Database.DERBY_SINGLE.getProviderName());
        this.getContentPane().add((Component)this.i, "grow" + (this.A ? ", split 2" : ", wrap"));
        this.z = new JButton(Messages.getString("DatabaseConfigurationDialog.14"));
        this.z.setActionCommand(f);
        if (this.A) {
            this.getContentPane().add((Component)this.z, "wrap");
        }
        this.s = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        this.getContentPane().add(this.s);
        this.getContentPane().add((Component)this.g, "grow, wrap");
        this.t = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        this.getContentPane().add(this.t);
        this.getContentPane().add((Component)this.h, "grow, wrap");
        this.v = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        this.getContentPane().add(this.v);
        this.getContentPane().add((Component)this.j, "grow, wrap");
        this.w = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        this.getContentPane().add(this.w);
        this.getContentPane().add((Component)this.k, "grow, wrap");
        this.getContentPane().add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.l = new PosButton(Messages.getString("TestConnection"));
        this.l.setActionCommand(e);
        this.p = new PosButton(Messages.getString("DatabaseConfigurationDialog.27"));
        this.p.setActionCommand(c);
        this.o = new PosButton(Messages.getString("Cancel"));
        this.o.setActionCommand(d);
        object = new JPanel((LayoutManager)new MigLayout("inset 0, fill", "grow", ""));
        this.m = new PosButton(Messages.getString("DatabaseConfigurationDialog.29"));
        this.m.setActionCommand(a);
        this.n = new PosButton(Messages.getString("UPDATE_DATABASE"));
        this.n.setActionCommand(b);
        this.q.setEnabled(false);
        this.g.setEnabled(false);
        this.h.setEnabled(false);
        this.i.setEnabled(false);
        this.j.setEnabled(false);
        this.k.setEnabled(false);
        this.x = new PosButton(Messages.getString("DatabaseConfigurationDialog.1"));
        this.x.setActionCommand(a);
        ((Container)object).add((Component)this.x, "grow");
        ((Container)object).add((Component)this.l, "split 2, grow");
        ((Container)object).add((Component)this.o, "right");
        this.getContentPane().add((Component)object, "span, grow");
    }

    private void a() {
        this.l.addActionListener(this);
        this.m.addActionListener(this);
        this.p.addActionListener(this);
        this.o.addActionListener(this);
        this.n.addActionListener(this);
        this.x.addActionListener(this);
        this.z.addActionListener(this);
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Database database = (Database)((Object)DatabaseConfigurationDialog.this.q.getSelectedItem());
                if (database == Database.DERBY_SINGLE) {
                    DatabaseConfigurationDialog.this.a(false);
                    return;
                }
                DatabaseConfigurationDialog.this.a(true);
                String string = AppConfig.getDatabasePort();
                if (StringUtils.isEmpty((String)string)) {
                    string = database.getDefaultPort();
                }
                DatabaseConfigurationDialog.this.h.setText(string);
            }
        });
    }

    private void b() {
        Database database = (Database)((Object)this.q.getSelectedItem());
        if (database == null) {
            database = Database.DERBY_SINGLE;
        }
        String string = AppConfig.getDatabaseHost();
        this.g.setText(string);
        String string2 = AppConfig.getDatabasePort();
        if (StringUtils.isEmpty((String)string2)) {
            string2 = database.getDefaultPort();
        }
        this.h.setText(string2);
        this.i.setText(AppConfig.getDatabaseName());
        this.j.setText(AppConfig.getDatabaseUser());
        this.k.setText(AppConfig.getDatabasePassword());
        if (database == Database.DERBY_SINGLE) {
            try {
                this.i.setText(this.c().getCanonicalPath());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
            this.a(false);
        } else {
            this.a(true);
        }
    }

    private File c() {
        File file = new File(AppConfig.getDatabaseName());
        if (!file.isAbsolute()) {
            file = new File("database/derby-single/" + AppConfig.getDatabaseName());
        }
        return file;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block18: {
            try {
                String string = actionEvent.getActionCommand();
                if (d.equalsIgnoreCase(string)) {
                    this.dispose();
                    this.setCanceled(true);
                    return;
                }
                DbInfo dbInfo = this.d();
                if (e.equalsIgnoreCase(string)) {
                    try {
                        DatabaseUtil.checkConnection(dbInfo.connectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass);
                    }
                    catch (DatabaseConnectionException databaseConnectionException) {
                        POSMessageDialog.showError(this, Messages.getString("DatabaseConfigurationDialog.32"));
                        return;
                    }
                    if (y) {
                        POSMessageDialog.showMessage(this, Messages.getString("DatabaseConfigurationDialog.31"));
                    } else {
                        POSMessageDialog.showMessage(this, Messages.getString("DatabaseConfigurationDialog.12"));
                        ProcessUtil.restart();
                    }
                    break block18;
                }
                if (b.equals(string)) {
                    int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.0"), POSConstants.CONFIRM);
                    if (n != 0) {
                        return;
                    }
                    Application.getInstance().setSystemInitialized(false);
                    DatabaseConfigurationDialog.saveConfig(dbInfo);
                    this.a(dbInfo);
                } else if (a.equals(string)) {
                    if (y) {
                        this.dispose();
                    }
                    DatabaseSetupWizard databaseSetupWizard = new DatabaseSetupWizard();
                    databaseSetupWizard.setTitle(String.format(Messages.getString("OroposDbSetupWizardTitle"), VersionInfo.getAppName()));
                    databaseSetupWizard.setDefaultCloseOperation(0);
                    databaseSetupWizard.setCloseSetupWizerdAndPosShutdown(false);
                    databaseSetupWizard.open();
                } else if (c.equalsIgnoreCase(string)) {
                    int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationView.0"));
                    if (n != 0) {
                        return;
                    }
                    DatabaseConfigurationDialog.saveConfig(dbInfo);
                    ProcessUtil.restart();
                } else if (f.equalsIgnoreCase(string)) {
                    Desktop.getDesktop().open(this.c().getParentFile());
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, exception.getMessage(), exception);
            }
        }
    }

    public static void doCreateDb(final DbInfo dbInfo, final boolean bl) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setTitle(Messages.getString("DatabaseConfigurationDialog.5"));
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl2 = DatabaseUtil.createDatabase(dbInfo.createDbConnectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass, bl);
                if (bl2 && !bl) {
                    DatabaseUtil.initialize();
                    DataProvider.get().initialize();
                }
                return bl2;
            }

            @Override
            protected void done() {
                try {
                    Boolean bl2 = (Boolean)this.get();
                    busyDialog.dispose();
                    if (bl2.booleanValue()) {
                        Object object;
                        if (!bl) {
                            object = new SetupWizard();
                            ((SetupWizard)object).setRestartOnFinish(false);
                            ((POSDialog)object).openFullScreen();
                        }
                        object = String.format(Messages.getString("DatabaseConfigurationDialog.6"), "1111");
                        POSMessageDialog.showMessage((String)object);
                        ProcessUtil.restart();
                    } else {
                        POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.36"));
                    }
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    POSMessageDialog.showMessage(throwable.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showMessage(exception.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void a(final DbInfo dbInfo) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setTitle(Messages.getString("DatabaseConfigurationDialog.7"));
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl = DatabaseUtil.updateDatabase(dbInfo.connectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass);
                return bl;
            }

            @Override
            protected void done() {
                try {
                    Boolean bl = (Boolean)this.get();
                    busyDialog.dispose();
                    if (bl.booleanValue()) {
                        POSMessageDialog.showMessage(DatabaseConfigurationDialog.this, Messages.getString("DatabaseConfigurationDialog.2"));
                    } else {
                        POSMessageDialog.showError(DatabaseConfigurationDialog.this, Messages.getString("DatabaseConfigurationDialog.3"));
                    }
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    POSMessageDialog.showMessage(throwable.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showMessage(exception.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public static void saveConfig(DbInfo dbInfo) {
        AppConfig.setDatabaseProviderName(dbInfo.providerName);
        AppConfig.setConnectString(dbInfo.connectionString);
        AppConfig.setDatabaseHost(dbInfo.databaseURL);
        AppConfig.setDatabasePort(dbInfo.databasePort);
        AppConfig.setDatabaseName(dbInfo.databaseName);
        AppConfig.setDatabaseUser(dbInfo.user);
        AppConfig.setDatabasePassword(dbInfo.pass);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(VersionInfo.getAppName());
        this.r.setTitle(string);
    }

    private void a(boolean bl) {
        this.s.setVisible(bl);
        this.g.setVisible(bl);
        this.t.setVisible(bl);
        this.h.setVisible(bl);
        this.v.setVisible(bl);
        this.j.setVisible(bl);
        this.w.setVisible(bl);
        this.k.setVisible(bl);
    }

    public static DatabaseConfigurationDialog show(Frame frame, boolean bl) {
        y = bl;
        return DatabaseConfigurationDialog.show(frame);
    }

    public static DatabaseConfigurationDialog show(Frame frame) {
        DatabaseConfigurationDialog databaseConfigurationDialog = new DatabaseConfigurationDialog();
        databaseConfigurationDialog.setModal(true);
        databaseConfigurationDialog.setTitle(Messages.getString("DatabaseConfigurationDialog.38"));
        if (frame != null) {
            databaseConfigurationDialog.setIconImage(frame.getIconImage());
        }
        databaseConfigurationDialog.pack();
        databaseConfigurationDialog.open();
        return databaseConfigurationDialog;
    }

    private DbInfo d() {
        Database database = (Database)((Object)this.q.getSelectedItem());
        DbInfo dbInfo = new DbInfo();
        dbInfo.providerName = database.getProviderName();
        dbInfo.databaseURL = this.g.getText();
        dbInfo.databasePort = this.h.getText();
        dbInfo.databaseName = this.i.getText();
        dbInfo.user = this.j.getText();
        dbInfo.pass = new String(this.k.getPassword());
        dbInfo.connectionString = database.getConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.createDbConnectionString = database.getCreateDbConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.hibernateDialect = database.getHibernateDialect();
        dbInfo.driverClass = database.getHibernateConnectionDriverClass();
        return dbInfo;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.dispose();
        this.setCanceled(true);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static class DbInfo {
        public String providerName;
        public String databaseURL;
        public String databasePort;
        public String databaseName;
        public String user;
        public String pass;
        public String connectionString;
        public String createDbConnectionString;
        public String hibernateDialect;
        public String driverClass;
    }
}

