/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DatabaseBackupAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.DatabaseSetupWizard;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationView
extends ConfigurationView
implements ActionListener {
    private static final String a = "CD";
    private static final String b = "SAVE";
    private static final String c = "cancel";
    private static final String d = "test";
    private POSTextField e;
    private POSTextField f;
    private POSTextField g;
    private POSTextField h;
    private POSPasswordField i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JComboBox m;
    private JLabel n;
    private JLabel o;
    private JLabel p;
    private JLabel q;
    private JLabel r;
    private String s;
    private String t;
    private String u;
    private String v;
    private String w;
    private JComboBox x;
    private JLabel y;
    private JCheckBox z;
    private Terminal A;
    private FixedLengthTextField B;
    private JButton C;
    private JLabel D;
    private JLabel E;

    public DatabaseConfigurationView() throws HeadlessException {
        DataProvider.get().refreshCurrentTerminal();
        this.A = DataProvider.get().getCurrentTerminal();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fill", "[][grow,fill]", "[][][][][][][][][][grow,fill]"));
        this.e = new POSTextField();
        this.f = new POSTextField();
        this.g = new POSTextField();
        this.h = new POSTextField();
        this.i = new POSPasswordField();
        this.m = new JComboBox<Database>(Database.values());
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string)) {
            this.m.setSelectedItem((Object)Database.getByProviderName(string));
        }
        jPanel.add(new JLabel(Messages.getString("DatabaseConfigurationDialog.8")));
        jPanel.add((Component)this.m, "grow, wrap");
        this.n = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        jPanel.add(this.n);
        jPanel.add((Component)this.e, "grow, wrap");
        this.o = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        jPanel.add(this.o);
        jPanel.add((Component)this.f, "grow, wrap");
        this.p = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        jPanel.add(this.p);
        jPanel.add((Component)this.g, "grow, wrap");
        this.q = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        jPanel.add(this.q);
        jPanel.add((Component)this.h, "grow, wrap");
        this.r = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        jPanel.add(this.r);
        jPanel.add((Component)this.i, "grow, wrap");
        jPanel.add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.j = new JButton(Messages.getString("TestConnection"));
        this.j.setActionCommand(d);
        this.l = new JButton(Messages.getString("DatabaseConfigurationDialog.27"));
        this.l.setActionCommand(b);
        this.m.setEnabled(false);
        this.e.setEnabled(false);
        this.f.setEnabled(false);
        this.g.setEnabled(false);
        this.h.setEnabled(false);
        this.i.setEnabled(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.k = new JButton(Messages.getString("DatabaseConfigurationDialog.29"));
        this.k.setActionCommand(a);
        jPanel2.add(this.k);
        jPanel2.add(this.j);
        jPanel.add((Component)jPanel2, "span, grow");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("", "[]", "[]"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("DatabaseConfigurationView.4")));
        this.z = new JCheckBox(POSConstants.ENABLE_OPTION_LABEL);
        this.z.addActionListener(actionEvent -> this.c());
        this.C = new JButton(POSConstants.SELECT);
        this.C.addActionListener(actionEvent -> this.b());
        this.B = new FixedLengthTextField(512);
        this.B.setText(this.A.getAutoDbBackupPath());
        this.D = new JLabel(Messages.getString("DatabaseConfigurationView.6"));
        this.y = new JLabel(Messages.getString("DatabaseConfigurationView.7"));
        this.x = new TimeComboBox().getDefaultTimeComboBox15();
        String string2 = this.A.getAutoDbBackupTime();
        this.x.setSelectedItem(DateUtil.getOnlyFormattedTime(string2));
        this.x.addActionListener(actionEvent -> this.a());
        this.E = new JLabel(String.format(Messages.getString("DatabaseConfigurationView.8"), string2));
        int n = this.getSize().width / 2;
        jPanel3.add((Component)this.z, "wrap");
        jPanel3.add(this.D);
        jPanel3.add((Component)this.B, "growx, w " + n + "!");
        jPanel3.add((Component)this.C, "wrap");
        jPanel3.add(this.y);
        jPanel3.add(this.x);
        jPanel3.add((Component)this.E, "newline, span 2");
        jPanel.add((Component)jPanel3, "span, grow");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void a() {
        String string = DateUtil.getOnlyFormattedTime((Date)this.x.getSelectedItem());
        this.E.setText(String.format(Messages.getString("DatabaseConfigurationView.9"), string));
    }

    private void b() {
        String string = String.format("backup_%s.orodb", DatabaseBackupAction.BACKUP_FILE_NAME);
        JFileChooser jFileChooser = DataExportAction.getFileChooser(string, String.format(Messages.getString("DatabaseConfigurationView.10"), ".orodb"), ".orodb");
        int n = jFileChooser.showSaveDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string2 = FilenameUtils.getExtension((String)file.getName());
        if (StringUtils.isBlank((String)string2) || !".orodb".endsWith(string2)) {
            file = new File(file.getAbsolutePath() + ".orodb");
        }
        this.B.setText(file.getAbsolutePath());
    }

    private void c() {
        boolean bl = this.z.isSelected();
        this.D.setEnabled(bl);
        this.y.setEnabled(bl);
        this.x.setEnabled(bl);
        this.C.setEnabled(bl);
        this.B.setEnabled(bl);
        this.E.setVisible(bl);
    }

    private void d() {
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        this.l.addActionListener(this);
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Database database = (Database)((Object)DatabaseConfigurationView.this.m.getSelectedItem());
                if (database == Database.DERBY_SINGLE) {
                    DatabaseConfigurationView.this.a(false);
                    return;
                }
                DatabaseConfigurationView.this.a(true);
                String string = AppConfig.getDatabasePort();
                if (StringUtils.isEmpty((String)string)) {
                    string = database.getDefaultPort();
                }
                DatabaseConfigurationView.this.f.setText(string);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            Database database = (Database)((Object)this.m.getSelectedItem());
            String string2 = database.getProviderName();
            String string3 = this.e.getText();
            String string4 = this.f.getText();
            String string5 = this.g.getText();
            String string6 = this.h.getText();
            String string7 = new String(this.i.getPassword());
            String string8 = database.getConnectString(string3, string4, string5);
            String string9 = database.getHibernateDialect();
            String string10 = database.getHibernateConnectionDriverClass();
            if (d.equalsIgnoreCase(string)) {
                try {
                    DatabaseUtil.checkConnection(string8, string9, string10, string6, string7);
                }
                catch (DatabaseConnectionException databaseConnectionException) {
                    POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.32"));
                    return;
                }
                POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.31"));
                return;
            }
            if (a.equals(string)) {
                DatabaseSetupWizard databaseSetupWizard = new DatabaseSetupWizard();
                databaseSetupWizard.setTitle(String.format(Messages.getString("OroposDbSetupWizardTitle"), VersionInfo.getAppName()));
                databaseSetupWizard.setDefaultCloseOperation(0);
                databaseSetupWizard.setCloseSetupWizerdAndPosShutdown(false);
                databaseSetupWizard.open();
                return;
            }
            if (b.equalsIgnoreCase(string)) {
                int n;
                boolean bl = this.e();
                if (bl && (n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationView.0"))) != 0) {
                    return;
                }
                this.a(database, string2, string3, string4, string5, string6, string7, string8, string9);
                if (!bl) return;
                Main.restart();
                return;
            }
            if (!c.equalsIgnoreCase(string)) return;
        }
        catch (Exception exception) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void a(Database database, String string, String string2, String string3, String string4, String string5) {
        Application.getInstance().setSystemInitialized(false);
        int n = JOptionPane.showConfirmDialog(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.33"), Messages.getString("DatabaseConfigurationDialog.34"), 0);
        if (n != 0) {
            return;
        }
        n = JOptionPane.showConfirmDialog(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationView.3"), Messages.getString("CONFIRM"), 0);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        DatabaseConfigurationDialog.DbInfo dbInfo = new DatabaseConfigurationDialog.DbInfo();
        dbInfo.providerName = database.getProviderName();
        dbInfo.databaseURL = string;
        dbInfo.databasePort = string2;
        dbInfo.databaseName = string3;
        dbInfo.user = string4;
        dbInfo.pass = string5;
        dbInfo.connectionString = database.getConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.createDbConnectionString = database.getCreateDbConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.hibernateDialect = database.getHibernateDialect();
        dbInfo.driverClass = database.getHibernateConnectionDriverClass();
        DatabaseConfigurationDialog.saveConfig(dbInfo);
        DatabaseConfigurationDialog.doCreateDb(dbInfo, bl);
    }

    private void a(Database database, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        AppConfig.setDatabaseProviderName(string);
        AppConfig.setConnectString(string7);
        AppConfig.setDatabaseHost(string2);
        AppConfig.setDatabasePort(string3);
        AppConfig.setDatabaseName(string4);
        AppConfig.setDatabaseUser(string5);
        AppConfig.setDatabasePassword(string6);
    }

    private void a(boolean bl) {
        this.n.setVisible(bl);
        this.e.setVisible(bl);
        this.o.setVisible(bl);
        this.f.setVisible(bl);
        this.p.setVisible(bl);
        this.g.setVisible(bl);
        this.q.setVisible(bl);
        this.h.setVisible(bl);
        this.r.setVisible(bl);
        this.i.setVisible(bl);
    }

    @Override
    public boolean save() throws Exception {
        boolean bl = this.z.isSelected();
        this.A.putEnableAutoDbBackup(bl);
        Date date = (Date)this.x.getSelectedItem();
        this.A.putAutoDbBackupTime(date);
        String string = this.B.getText();
        if (StringUtils.isBlank((String)string)) {
            throw new PosException(Messages.getString("DatabaseConfigurationView.11"));
        }
        File file = new File(string);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            throw new PosException(Messages.getString("DatabaseConfigurationView.12"));
        }
        this.A.putAutoDbBackupPath(string);
        if (bl) {
            if (file.isDirectory() || !("." + FilenameUtils.getExtension((String)file.getName())).equals(".orodb")) {
                throw new PosException(Messages.getString("DatabaseConfigurationView.13"));
            }
            OroCronJobManager.getInstance().startAutoDbBackup();
        }
        TerminalDAO.getInstance().saveOrUpdate(this.A);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        this.initUI();
        this.d();
        Database database = (Database)((Object)this.m.getSelectedItem());
        this.s = database.getProviderName();
        this.t = AppConfig.getDatabaseHost();
        this.e.setText(this.t);
        this.u = AppConfig.getDatabasePort();
        if (StringUtils.isEmpty((String)this.u)) {
            this.u = database.getDefaultPort();
        }
        this.f.setText(this.u);
        this.v = AppConfig.getDatabaseName();
        this.g.setText(this.v);
        this.w = AppConfig.getDatabaseUser();
        this.h.setText(this.w);
        this.i.setText(AppConfig.getDatabasePassword());
        if (database == Database.DERBY_SINGLE) {
            this.a(false);
        } else {
            this.a(true);
        }
        boolean bl = this.A.isEnableAutoDbBackup();
        this.z.setSelected(bl);
        this.y.setEnabled(bl);
        this.x.setEnabled(bl);
        this.C.setEnabled(bl);
        this.B.setEnabled(bl);
        Font font = this.E.getFont();
        this.E.setFont(new Font(font.getName(), 1, font.getSize()));
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return Messages.getString("DatabaseConfigurationView.5");
    }

    private boolean e() {
        Database database = (Database)((Object)this.m.getSelectedItem());
        String string = database.getProviderName();
        String string2 = this.e.getText();
        String string3 = this.f.getText();
        String string4 = this.g.getText();
        String string5 = this.h.getText();
        if (StringUtils.isNotBlank((String)this.s) && StringUtils.isNotBlank((String)string) && !this.s.equals(string)) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.t) && StringUtils.isNotBlank((String)string2) && !this.t.equals(string2)) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.u) && StringUtils.isNotBlank((String)string3) && !this.u.equals(string3)) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.v) && StringUtils.isNotBlank((String)string4) && !this.v.equals(string4)) {
            return true;
        }
        return StringUtils.isNotBlank((String)this.w) && StringUtils.isNotBlank((String)string5) && !this.w.equals(string5);
    }
}

