/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.PeripheralConfigurationView;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DrawerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DrawerConnectionView
extends JPanel
implements ItemListener {
    private JPanel a;
    private JPanel b;
    private JRadioButton c;
    private JRadioButton d;
    private FixedLengthTextField e = new FixedLengthTextField(10);
    private FixedLengthTextField f = new FixedLengthTextField(15);
    private JLabel g;
    private JComboBox h;
    private JLabel i;
    private JComboBox j;
    private List<PrinterModel> k;
    private FixedLengthTextField l = new FixedLengthTextField(15);
    private JPanel m;
    private boolean n;
    private TitledBorder o;

    public DrawerConnectionView() {
        this(false, Messages.getString("PeripheralConfigurationView.4"));
    }

    public DrawerConnectionView(boolean bl, String string) {
        this.n = bl;
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "", ""));
        this.o = BorderFactory.createTitledBorder(string);
        this.setBorder(this.o);
        this.m = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", ""));
        JLabel jLabel = new JLabel(Messages.getString("PeripheralConfigurationView.2"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.d = new JRadioButton(KickDrawerType.Printer.getDisplayString());
        this.c = new JRadioButton(KickDrawerType.Drawer_Trigger.getDisplayString());
        this.d.addItemListener(this);
        this.c.addItemListener(this);
        buttonGroup.add(this.d);
        buttonGroup.add(this.c);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "0[]8[]", ""));
        jPanel.add(jLabel);
        jPanel.add(this.d);
        jPanel.add(this.c);
        this.m.add((Component)jPanel, "span 5, wrap");
        this.a = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.a.add(new JLabel(Messages.getString("TerminalConfigurationView.25")));
        this.a.add((Component)this.e, "");
        this.a.add((Component)new JLabel(Messages.getString("TerminalConfigurationView.27")), "newline");
        this.a.add((Component)this.f, "");
        JButton jButton = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton.addActionListener(actionEvent -> this.b());
        this.a.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("TerminalConfigurationView.32"));
        jButton2.addActionListener(actionEvent -> {
            if (bl) {
                this.e.setText("COM2");
            } else {
                this.e.setText("COM1");
            }
            this.f.setText(TerminalConfig.getDefaultDrawerControlCodes());
        });
        this.a.add(jButton2);
        this.m.add(this.a);
        this.b = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.g = new JLabel(Messages.getString("AddPrinterDialog.9"));
        this.h = new JComboBox();
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        arrayList.add(null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i]);
        }
        this.h.setModel(new ComboBoxModel(arrayList));
        this.h.setRenderer(new PrintServiceComboRenderer());
        this.b.add((Component)this.g, "alignx trailing");
        this.b.add((Component)this.h, "growx,split 2");
        this.i = new JLabel(Messages.getString("PeripheralConfigurationView.1"));
        this.j = new JComboBox();
        this.j.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            PrinterModel printerModel = (PrinterModel)jComboBox.getSelectedItem();
            this.l.setText(printerModel.drawerCode);
        });
        this.b.add((Component)this.i, "newline,alignx trailing");
        this.b.add((Component)this.j, "growx,split 2");
        this.b.add(new JLabel(Messages.getString("TerminalConfigurationView.27")));
        this.b.add((Component)this.l, "");
        JButton jButton3 = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton3.addActionListener(actionEvent -> {
            PrintService printService = (PrintService)this.h.getSelectedItem();
            String string = this.l.getText();
            if (printService == null) {
                POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.6"));
                return;
            }
            if (StringUtils.isBlank((String)string)) {
                POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.7"));
                return;
            }
            try {
                DrawerUtil.kickDrawerUsingDevicePrinter(printService.getName(), string);
            }
            catch (Exception exception) {
                PosLog.error(PeripheralConfigurationView.class, exception);
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE);
            }
        });
        this.b.add(jButton3);
        this.m.add(this.b);
        this.add(this.m);
    }

    public void initialize() throws Exception {
        this.a();
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        if (this.n) {
            Object object3;
            Object object22;
            this.j.setModel(new ComboBoxModel(this.k));
            this.e.setText(TerminalConfig.getSecondDrawerPortName());
            String string = TerminalConfig.getSecondDrawerControlCodes();
            if (StringUtils.isNotEmpty((String)string)) {
                string = string.replaceAll("_", ",");
            }
            this.f.setText(string);
            String string2 = terminal.getProperty("cashdrawer.deviceName.second");
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.h.getModel();
            List list = comboBoxModel.getDataList();
            for (Object object22 : list) {
                if (object22 == null || !object22.getName().equals(string2)) continue;
                this.h.setSelectedItem(object22);
                break;
            }
            String string3 = terminal.getProperty("cashdrawer.deviceModel.second");
            object22 = (ComboBoxModel)this.j.getModel();
            List list2 = ((ComboBoxModel)object22).getDataList();
            for (Object object3 : list2) {
                if (!((PrinterModel)object3).model.equals(string3)) continue;
                this.j.setSelectedItem(object3);
                break;
            }
            String string4 = terminal.getProperty("cashdrawer.controlCode.second", "27,112,0,50,250");
            this.l.setText(string4);
            object3 = terminal.getProperty("cashdrawer.kickType.second");
            if (StringUtils.isNotBlank((String)object3)) {
                if (((String)object3).equals(KickDrawerType.Drawer_Trigger.name())) {
                    this.c.setSelected(true);
                } else if (((String)object3).equals(KickDrawerType.Printer.name())) {
                    this.d.setSelected(true);
                }
            } else {
                this.d.setSelected(true);
            }
        } else {
            Object object5;
            Object object42;
            this.j.setModel(new ComboBoxModel(this.k));
            this.e.setText(TerminalConfig.getDrawerPortName());
            String string = TerminalConfig.getDrawerControlCodes();
            if (StringUtils.isNotEmpty((String)string)) {
                string = string.replaceAll("_", ",");
            }
            this.f.setText(string);
            String string5 = terminal.getProperty("cashdrawer.deviceName");
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.h.getModel();
            List list = comboBoxModel.getDataList();
            for (Object object42 : list) {
                if (object42 == null || !object42.getName().equals(string5)) continue;
                this.h.setSelectedItem(object42);
                break;
            }
            String string6 = terminal.getProperty("cashdrawer.deviceModel");
            object42 = (ComboBoxModel)this.j.getModel();
            List list3 = ((ComboBoxModel)object42).getDataList();
            for (Object object5 : list3) {
                if (!((PrinterModel)object5).model.equals(string6)) continue;
                this.j.setSelectedItem(object5);
                break;
            }
            String string7 = terminal.getProperty("cashdrawer.controlCode", "27,112,0,50,250");
            this.l.setText(string7);
            object5 = terminal.getProperty("cashdrawer.kickType");
            if (StringUtils.isNotBlank((String)object5)) {
                if (((String)object5).equals(KickDrawerType.Drawer_Trigger.name())) {
                    this.c.setSelected(true);
                } else if (((String)object5).equals(KickDrawerType.Printer.name())) {
                    this.d.setSelected(true);
                }
            } else {
                this.d.setSelected(true);
            }
        }
    }

    public boolean save(Terminal terminal) throws Exception {
        String string = null;
        if (this.n) {
            if (this.d.isSelected()) {
                string = KickDrawerType.Printer.name();
                PrintService printService = (PrintService)this.h.getSelectedItem();
                PrinterModel printerModel = (PrinterModel)this.j.getSelectedItem();
                String string2 = this.l.getText();
                if (StringUtils.isBlank((String)string2)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.3"));
                    return false;
                }
                if (printService != null) {
                    terminal.addProperty("cashdrawer.deviceName.second", printService.getName());
                }
                if (printerModel != null) {
                    terminal.addProperty("cashdrawer.deviceModel.second", printerModel.model);
                }
                terminal.addProperty("cashdrawer.controlCode.second", string2);
            } else if (this.c.isSelected()) {
                string = KickDrawerType.Drawer_Trigger.name();
                String string3 = this.e.getText();
                String string4 = this.f.getText();
                if (StringUtils.isBlank((String)string3)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.4"));
                    return false;
                }
                if (StringUtils.isBlank((String)string4)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.5"));
                    return false;
                }
                TerminalConfig.setSecondDrawerPortName(string3);
                if (StringUtils.isNotEmpty((String)string4)) {
                    string4 = string4.replaceAll(",", "_");
                }
                TerminalConfig.setSecondDrawerControlCodes(string4);
            }
            terminal.addProperty("cashdrawer.kickType.second", string);
        } else {
            if (this.d.isSelected()) {
                string = KickDrawerType.Printer.name();
                PrintService printService = (PrintService)this.h.getSelectedItem();
                PrinterModel printerModel = (PrinterModel)this.j.getSelectedItem();
                String string5 = this.l.getText();
                if (StringUtils.isBlank((String)string5)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.7"));
                    return false;
                }
                if (printService != null) {
                    terminal.addProperty("cashdrawer.deviceName", printService.getName());
                }
                if (printerModel != null) {
                    terminal.addProperty("cashdrawer.deviceModel", printerModel.model);
                }
                terminal.addProperty("cashdrawer.controlCode", string5);
            } else if (this.c.isSelected()) {
                string = KickDrawerType.Drawer_Trigger.name();
                String string6 = this.e.getText();
                String string7 = this.f.getText();
                if (StringUtils.isBlank((String)string6)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.8"));
                    return false;
                }
                if (StringUtils.isBlank((String)string7)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.9"));
                    return false;
                }
                TerminalConfig.setDrawerPortName(string6);
                if (StringUtils.isNotEmpty((String)string7)) {
                    string7 = string7.replaceAll(",", "_");
                }
                TerminalConfig.setDrawerControlCodes(string7);
            }
            terminal.addProperty("cashdrawer.kickType", string);
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.c) {
            if (this.c.isSelected()) {
                this.a.setVisible(true);
                this.b.setVisible(false);
            }
        } else if (itemEvent.getSource() == this.d && this.d.isSelected()) {
            this.b.setVisible(true);
            this.a.setVisible(false);
        }
    }

    private void a() {
        this.k = new ArrayList<PrinterModel>();
        PrinterModel printerModel = new PrinterModel();
        printerModel.model = "";
        printerModel.drawerCode = "";
        this.k.add(printerModel);
        printerModel = new PrinterModel();
        printerModel.model = "Generic";
        printerModel.drawerCode = "27,112,0,50,250";
        this.k.add(printerModel);
        String string = "/util/drawer-codes.txt";
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            if (inputStream == null) {
                POSMessageDialog.showError("Unable to find drawer codes file " + string, new Exception("Unable to find drawer codes file " + string));
                return;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split("=");
                    PrinterModel printerModel2 = new PrinterModel();
                    printerModel2.model = stringArray[0];
                    printerModel2.drawerCode = stringArray[1];
                    this.k.add(printerModel2);
                }
            }
            catch (IOException iOException) {
                POSMessageDialog.showError("Error reading file " + string, iOException);
            }
        }
        catch (IOException iOException) {
            POSMessageDialog.showError("Unable to find drawer codes file " + string, iOException);
        }
    }

    private void b() {
        String string = this.f.getText();
        if (StringUtils.isEmpty((String)string)) {
            string = TerminalConfig.getDefaultDrawerControlCodes();
        }
        String[] stringArray = string.split(",");
        char[] cArray = new char[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                cArray[i] = (char)Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                cArray[i] = 48;
            }
        }
        DrawerUtil.kickDrawerUsingSerialPort(this.e.getText(), cArray);
    }

    public void setCaption(String string) {
        this.o.setTitle(string);
    }

    public static enum KickDrawerType {
        Printer("Printer"),
        Drawer_Trigger("Drawer trigger");

        private String a;

        private KickDrawerType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }

        public String getDisplayString() {
            return this.a;
        }
    }

    private class PrinterModel {
        public String model;
        public String drawerCode;

        private PrinterModel() {
        }

        public String toString() {
            return this.model;
        }
    }
}

