/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class EmailConfigurationView
extends ConfigurationView {
    private FixedLengthTextField a = new FixedLengthTextField(25);
    private IntegerTextField b = new IntegerTextField(8);
    private FixedLengthTextField c = new FixedLengthTextField(25);
    private JPasswordField d = new JPasswordField(25);
    private static String e;
    private Terminal f;

    public EmailConfigurationView(Terminal terminal) {
        this.f = terminal;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("TerminalConfigurationView.26"));
        JLabel jLabel2 = new JLabel(Messages.getString("EmailConfigurationView.0"));
        JLabel jLabel3 = new JLabel(Messages.getString("TerminalConfigurationView.28"));
        JLabel jLabel4 = new JLabel(Messages.getString("PASSWORD"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[][grow]", ""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalConfigurationView.44")));
        jPanel.add(jLabel);
        jPanel.add(this.a);
        jPanel.add(jLabel2);
        jPanel.add(this.b);
        jPanel.add(jLabel3);
        jPanel.add(this.c);
        jPanel.add(jLabel4);
        jPanel.add(this.d);
        JButton jButton = new JButton(Messages.getString("EmailConfigurationView.4"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)jButton, "skip 1");
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        jScrollPane.setBorder(null);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalDAO terminalDAO = new TerminalDAO();
            terminalDAO.saveOrUpdate(this.f);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            if (this.f == null) {
                return;
            }
            String string = this.f.getSmtpHost();
            Integer n = this.f.getSmtpPort();
            this.a.setText(StringUtils.isEmpty((String)string) ? Messages.getString("EmailConfigurationView.10") : string);
            this.b.setText(String.valueOf(n == 0 ? 465 : n));
            this.c.setText(this.f.getSmtpSender());
            e = this.f.getSmtpPassword();
            if (e != null) {
                this.d.setText(AESencrp.decrypt(e));
            }
            this.setInitialized(true);
        }
        catch (Exception exception) {
            PosLog.error(EmailConfigurationView.class, exception);
        }
    }

    public boolean updateModel() {
        try {
            Terminal terminal = this.f;
            terminal.setSmtpHost(this.a.getText());
            terminal.setSmtpPort(this.b.getInteger());
            terminal.setSmtpSender(this.c.getText());
            terminal.setSmtpPassword(AESencrp.encrypt(new String(this.d.getPassword())));
            return true;
        }
        catch (Exception exception) {
            PosLog.error(EmailConfigurationView.class, exception);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_EMAIL;
    }
}

