/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.KitchenDisplayConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class KitchenDislayConfigurationDialog
extends POSDialog
implements RefreshableView {
    private Store a;
    private Outlet b;
    private JButton c;
    private JPanel d;
    private KitchenDisplayConfigurationView e;

    public KitchenDislayConfigurationDialog() throws Exception {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.initComponents();
    }

    public void initComponents() throws Exception {
        this.setTitle(VersionInfo.getAppName());
        this.a = DataProvider.get().getStore();
        this.b = DataProvider.get().getOutlet();
        StoreDAO.getInstance().refresh(this.a);
        OutletDAO.getInstance().refresh(this.b);
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("KitchenDislayConfigurationDialog.0"));
        this.add((Component)titlePanel, "North");
        this.d = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.e = new KitchenDisplayConfigurationView(this.a);
        this.e.initialize();
        this.d.add((Component)this.e, "span, grow");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,fill"));
        this.c = new JButton(POSConstants.CANCEL);
        this.c.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)this.c, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton jButton = new JButton(POSConstants.OK);
        jButton.addActionListener(actionEvent -> this.a());
        jPanel.add((Component)jButton, "dock east, gapright 5, gaptop 5, gapbottom 10");
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(actionEvent -> this.a(Boolean.FALSE));
        jPanel.add((Component)jButton2, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)jPanel, "South");
        this.setDefaultCloseOperation(2);
        this.add((Component)this.d, "Center");
    }

    private void a() {
        this.a(Boolean.TRUE);
    }

    private void a(boolean bl) {
        try {
            this.e.save();
            TerminalDAO.getInstance().performBatchSave(this.a, this.b);
            Application.getInstance().refreshStore();
            OroMqttClient.getInstance().notifyDataUpdated(Store.class);
            this.setCanceled(false);
            if (bl) {
                this.dispose();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void refresh() {
        StoreDAO.getInstance().refresh(this.a);
        OutletDAO.getInstance().refresh(this.b);
    }

    public void setCanceledButtonVisible(boolean bl) {
        this.c.setVisible(bl);
    }

    public String getOutletFullAddress() {
        return this.b.buildOutletFullAddress();
    }
}

