/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.QrCodeDataModel;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.GlobalConfigDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.qrcode.QRCodeUtil;
import com.floreantpos.util.StoreUtil;
import com.google.gson.Gson;
import com.orocube.oropos.rest.server.util.EmbeddedTomcat;
import com.orocube.oropos.rest.server.util.EmbeddedTomcatFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class OroposMobileQRView
extends JPanel {
    private JLabel a;

    public OroposMobileQRView() {
        this.setLayout((LayoutManager)new MigLayout("ins 5 5 5 5,fill", "[]", ""));
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("OroposMobileQRView.0"), 2, 2));
        this.a();
    }

    private void a() {
        this.a = new JLabel();
        this.a.setHorizontalAlignment(0);
        JButton jButton = new JButton(POSConstants.REFRESH);
        this.add((Component)this.a, "wrap,center");
        this.add((Component)jButton, "wrap,center");
        jButton.addActionListener(actionEvent -> this.updateView());
    }

    public void updateView() {
        this.updateView(DataProvider.get().getStore());
    }

    public void updateView(Store store) {
        EmbeddedTomcat embeddedTomcat = EmbeddedTomcatFactory.getEmbeddedTomcat();
        this.updateView(store, embeddedTomcat.isRunning());
    }

    public void updateView(Store store, boolean bl) {
        try {
            if (bl) {
                String string = OroposMobileQRView.generateServerAddress(store);
                String string2 = UUID.randomUUID().toString();
                GlobalConfigDAO.getInstance().saveOrUpdate("data_service.otp", string2);
                QrCodeDataModel qrCodeDataModel = new QrCodeDataModel(string, string2);
                String string3 = new Gson().toJson((Object)qrCodeDataModel);
                BufferedImage bufferedImage = QRCodeUtil.getQrCodeImage(string3, 50);
                this.setImageQrCodeIcon(new ImageIcon(bufferedImage.getScaledInstance(200, 200, 1)));
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
        catch (Exception exception) {
            this.setVisible(false);
        }
    }

    public static String generateServerAddress(Store store) throws Exception {
        String string = GlobalConfigDAO.getInstance().getValueByKey("data_service.port");
        String string2 = "";
        String string3 = StoreUtil.getEmbdedServerHostAddress(store);
        if (StringUtils.isBlank((String)string3)) {
            string2 = Messages.getString("IP_address_could_not_be_determind");
            if (DataProvider.get().getCurrentTerminal().isMasterTerminal().booleanValue()) {
                try {
                    string3 = EmbeddedTomcatFactory.getEmbeddedTomcat().getHostAddress();
                }
                catch (Exception exception) {
                    string2 = Messages.getString("IP_address_could_not_be_determind");
                }
            }
        } else {
            string2 = "http://" + string3 + ":" + string + "/";
        }
        return string2;
    }

    public void setImageQrCodeIcon(ImageIcon imageIcon) {
        this.a.setIcon(imageIcon);
    }
}

