/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.MultiPrinterPane;
import com.floreantpos.config.ui.PrinterGroupView;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.swing.PosUIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PrintConfigurationView
extends ConfigurationView {
    public static final String AUTO_PRINT_RECEIPT = "auto_print_receipt";
    private JComboBox<PaperSize> a;
    private JComboBox<KitchenStickerPaperSize> b;
    private PosPrinters c;
    private Terminal d;
    private JCheckBox e;
    private JCheckBox f;
    private JCheckBox g;
    private PrinterGroupView h;

    public PrintConfigurationView() {
        this(Application.getInstance().getTerminal());
    }

    public PrintConfigurationView(Terminal terminal) {
        this.d = terminal;
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_PRINT;
    }

    @Override
    public void initialize() throws Exception {
        Object object;
        if (this.isInitialized()) {
            return;
        }
        this.c = PosPrinters.load(this.d);
        this.a();
        String string = this.d.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)string)) {
            object = PaperSize.valueOf(string);
            this.a.setSelectedItem(object);
        }
        if (StringUtils.isNotEmpty((String)(object = this.d.getProperty("kitchen.sticker.paper_size")))) {
            KitchenStickerPaperSize kitchenStickerPaperSize = KitchenStickerPaperSize.fromName((String)object);
            this.b.setSelectedItem((Object)kitchenStickerPaperSize);
        }
        this.e.setSelected(this.d.isAutoPrintReceipt());
        this.f.setEnabled(this.d.isAutoPrintReceipt());
        this.g.setEnabled(this.d.isAutoPrintReceipt());
        this.f.setSelected(this.d.isAutoPrintCustomerReceipt());
        this.g.setSelected(this.d.isAutoPrintStoreReceipt());
        this.setInitialized(true);
    }

    @Override
    public boolean save() throws Exception {
        TerminalDAO.getInstance().refresh(this.d);
        PaperSize paperSize = (PaperSize)((Object)this.a.getSelectedItem());
        this.d.addProperty("report.paper_size", paperSize.name());
        KitchenStickerPaperSize kitchenStickerPaperSize = (KitchenStickerPaperSize)((Object)this.b.getSelectedItem());
        this.d.addProperty("kitchen.sticker.paper_size", kitchenStickerPaperSize.name());
        this.d.setAutoPrintReceipt(this.e.isSelected());
        this.d.setAutoPrintCustomerReceipt(this.f.isSelected());
        this.d.setAutoPrintStoreReceipt(this.g.isSelected());
        TerminalDAO.getInstance().performBatchSave(this.h.getEditedGroups().toArray());
        TerminalDAO.getInstance().update(this.d);
        return true;
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", ""));
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PrintConfigurationView.8"));
        MultiPrinterPane multiPrinterPane = new MultiPrinterPane(Messages.getString("PrintConfigurationView.1"), this.c.getKitchenPrinters(), this.d);
        jPanel.add((Component)multiPrinterPane, String.format("cell 0 1 2 1, h %s!, grow", PosUIManager.getSize((int)250)));
        this.h = new PrinterGroupView(Messages.getString("PrintConfigurationView.0"));
        this.h.setPreferredSize(new Dimension(0, 400));
        jPanel.add((Component)this.h, String.format("cell 0 2 2 1,grow,h %s!,wrap", PosUIManager.getSize((int)250)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(Messages.getString("PrintConfigurationView.10"));
        jPanel.add((Component)jLabel2, "cell 0 3, growx");
        this.a = new JComboBox<PaperSize>(PaperSize.values());
        jPanel.add(this.a, String.format("cell 1 3, w %s! ,wrap", PosUIManager.getSize((int)250)));
        JLabel jLabel3 = new JLabel(Messages.getString("PrintConfigurationView.100"));
        jPanel.add((Component)jLabel3, "cell 0 4, growx");
        this.b = new JComboBox<KitchenStickerPaperSize>(KitchenStickerPaperSize.values());
        jPanel.add(this.b, String.format("cell 1 4, w %s! ,wrap", PosUIManager.getSize((int)250)));
        this.e = new JCheckBox(Messages.getString("PrintConfigurationView.16"));
        jPanel.add((Component)this.e, "cell 0 5,growx");
        this.f = new JCheckBox(Messages.getString("PrintConfigurationView.2"));
        jPanel.add((Component)this.f, "gapleft 20, cell 0 6,growx");
        this.g = new JCheckBox(Messages.getString("PrintConfigurationView.3"));
        jPanel.add((Component)this.g, "gapleft 20,cell 0 7,growx");
        this.e.addActionListener(actionEvent -> this.b());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.add(jScrollPane);
    }

    private void b() {
        this.f.setEnabled(this.e.isSelected());
        this.g.setEnabled(this.e.isSelected());
        if (!this.e.isSelected()) {
            this.f.setSelected(false);
            this.g.setSelected(false);
        }
    }
}

