/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.PrintException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TipSuggestion;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseCourse;
import com.floreantpos.model.base.BaseModifiableTicketItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemCookingInstruction;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.qrcode.QRReceiptPlugin;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsSuggestionDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import com.floreantpos.versioning.VersionInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.util.OS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptConfigurationView
extends JPanel
implements RefreshableView {
    private boolean a = false;
    private JTextPane b;
    private JTextPane c;
    private JTextPane d;
    private JTextPane e;
    private JTextPane f;
    private JList<TipSuggestion> g;
    private JList<ReceiptParam> h;
    private OrderType i;
    private ButtonGroup j;
    private boolean k;
    private OrderInfoView l = null;
    private KitchenReceiptView m = null;
    private JCheckBox n = new JCheckBox(Messages.getString("ReceiptConfigurationView.0"));
    private JComboBox o = new JComboBox();
    private JComboBox p = new JComboBox();
    private JComboBox q = new JComboBox();
    private JComboBox r = new JComboBox();
    private JComboBox s = new JComboBox();
    private JComboBox t = new JComboBox();
    private String[] u;
    private JComboBox v = new JComboBox();
    private JCheckBox w = new JCheckBox(Messages.getString("ReceiptConfigurationView.1"));
    private JCheckBox x = new JCheckBox(Messages.getString("ZeroCostModifier"));
    private JCheckBox y = new JCheckBox(Messages.getString("ReceiptConfigurationView.2"));
    private JCheckBox z = new JCheckBox(Messages.getString("ReceiptConfigurationView.3"));
    private JCheckBox A = new JCheckBox(Messages.getString("ReceiptConfigurationView.111"));
    private JCheckBox B = new JCheckBox(Messages.getString("ReceiptConfigurationView.4"));
    private JCheckBox C = new JCheckBox(Messages.getString("ReceiptConfigurationView.5"));
    private JCheckBox D = new JCheckBox(Messages.getString("ReceiptConfigurationView.6"));
    private JCheckBox E = new JCheckBox(Messages.getString("ReceiptConfigurationView.7"));
    private JCheckBox F = new JCheckBox(Messages.getString("ReceiptConfigurationView.11"));
    private JComboBox<Integer> G;
    private JComboBox<String> H;
    private JButton I;
    private JLabel J = new JLabel(Messages.getString("FontSize"));
    private JCheckBox K = new JCheckBox(Messages.getString("ReceiptConfigurationView.11"));
    private JComboBox<Integer> L;
    private JComboBox<String> M;
    private JButton N;
    private JLabel O = new JLabel(Messages.getString("FontSize"));
    private POSToggleButton P;
    private POSToggleButton Q;
    private POSToggleButton R;
    private JComboBox<ReciptPaperSize> S;
    private JButton T;
    private JButton U;
    private JButton V;
    private JScrollPane W;
    private JPanel X;
    private JPanel Y = null;
    private JComboBox Z;
    private JPanel aa;
    private FontPropertiesPanel ab;
    private FontPropertiesPanel ac;
    private FontPropertiesPanel ad;
    private FontPropertiesPanel ae;
    private FontPropertiesPanel af;
    private FontPropertiesPanel ag;
    private String ah;

    public ReceiptConfigurationView() {
        this(false);
    }

    public ReceiptConfigurationView(boolean bl) {
        this.k = bl;
        this.d();
    }

    public void initialize() throws Exception {
        if (this.a) {
            this.refresh();
            return;
        }
        this.a();
        this.a = true;
    }

    private void a() {
        DataProvider.get().refreshStore();
        DataProvider.get().refreshCurrentTerminal();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        ReceiptParam[] receiptParamArray = ReceiptParam.values();
        List<ReceiptParam> list = Arrays.asList(receiptParamArray);
        list.sort(Comparator.comparing(Enum::name));
        this.h.setModel(new ListModel<ReceiptParam>(list));
        String string = terminal.getProperty("main.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String string2 = terminal.getProperty("kitchen.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String string3 = terminal.getProperty("main.receipt.print_preview_system", "Standard");
        String string4 = terminal.getProperty("kitchen.receipt.print_preview_system", "Standard");
        Store store = DataProvider.get().getStore();
        if (this.k) {
            this.s();
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string2);
            this.S.setSelectedItem((Object)reciptPaperSize);
            this.Z.setSelectedItem(string4);
            this.g();
        } else {
            this.o();
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string);
            this.S.setSelectedItem((Object)reciptPaperSize);
            this.Z.setSelectedItem(string3);
            this.e();
        }
        this.p();
        this.r();
        this.E();
        SwingUtilities.invokeLater(() -> this.S.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            Store store2 = (Store)SerializationUtils.clone((Serializable)store);
            if (!this.k) {
                boolean bl = this.i != null;
                this.a(bl, store2);
                this.b(false, store2);
            }
        }));
    }

    private String a(Object object) {
        String string = "#000000";
        Color color = Color.black;
        if (object != null) {
            color = ((SimpleColor)((Object)object)).a;
        }
        try {
            string = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean save(boolean bl) throws Exception {
        Object object = this.H.getSelectedItem();
        if (this.F.isSelected() && object == null) {
            throw new PosException(Messages.getString("ReceiptConfigurationView.12"));
        }
        Store store = DataProvider.get().getStore();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        TerminalDAO.getInstance().refresh(terminal);
        StoreDAO.getInstance().refresh(store);
        if (object == null && store.hasProperty("ticket_view_font.name")) {
            store.removeProperty("ticket_view_font.name");
        }
        this.a(bl, store);
        TerminalDAO.getInstance().update(terminal);
        StoreDAO.getInstance().saveOrUpdate(store);
        DataProvider.get().refreshStore();
        OutletDAO.getInstance().refresh(DataProvider.get().getOutlet());
        DataProvider.get().refreshCurrentTerminal();
        this.b();
        this.c();
        OroMqttClient.getInstance().notifyDataUpdated(Store.class);
        return true;
    }

    private void b() {
        Font font = DataProvider.get().getTicketViewFont();
        String string = this.a(font);
        AppConfig.putMainReceiptFontPath(string);
    }

    private void c() {
        Font font = DataProvider.get().getKitchenReciptFont();
        String string = this.a(font);
        AppConfig.putKitchenReceiptFontPath(string);
    }

    private String a(Font font) {
        if (font == null) {
            return null;
        }
        String string = "fonts/arial/arial.ttf";
        try {
            Object object;
            try {
                object = Class.forName("sun.font.FontUtilities").getDeclaredMethod("getFont2D", Font.class).invoke(null, font);
                PosLog.debug(this.getClass(), font.getName() + " font is found by FontUtilities.");
            }
            catch (Throwable throwable) {
                object = Class.forName("sun.font.FontManager").getDeclaredMethod("getFont2D", Font.class).invoke(null, font);
                PosLog.debug(this.getClass(), font.getName() + " font is found by FontManager.");
            }
            Field field = Class.forName("sun.font.PhysicalFont").getDeclaredField("platName");
            field.setAccessible(true);
            string = (String)field.get(object);
            PosLog.debug(this.getClass(), "Font path: " + string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return string;
    }

    private void a(boolean bl, Store store) {
        String string;
        Object object;
        Object object2;
        boolean bl2;
        this.b.getDocument().putProperty("__EndOfLine__", "<br>");
        this.e.getDocument().putProperty("__EndOfLine__", "<br>");
        this.f.getDocument().putProperty("__EndOfLine__", "<br>");
        this.c.getDocument().putProperty("__EndOfLine__", "<br>");
        this.d.getDocument().putProperty("__EndOfLine__", "<br>");
        String string2 = this.b.getText();
        String string3 = this.e.getText();
        String string4 = this.f.getText();
        String string5 = this.c.getText();
        String string6 = this.d.getText();
        if (string2.replaceAll("<br>", "").isEmpty()) {
            string2 = "";
        }
        if (string3.replaceAll("<br>", "").isEmpty()) {
            string3 = "";
        }
        if (string4.replaceAll("<br>", "").isEmpty()) {
            string4 = "";
        }
        if (string5.replaceAll("<br>", "").isEmpty()) {
            string5 = "";
        }
        if (string6.replaceAll("<br>", "").isEmpty()) {
            string6 = "";
        }
        String string7 = "";
        boolean bl3 = bl2 = this.i != null && bl;
        if (bl2 && this.i.getId() != "generic_order") {
            string7 = this.i.getId() + ".";
        }
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.g.getModel().getSize(); ++i) {
            object2 = this.g.getModel().getElementAt(i);
            object = new JSONObject();
            object.put("percentage", (Object)NumberUtil.trimDecilamIfNotNeeded(((TipSuggestion)object2).getPercentage()));
            object.put("sortOrder", ((TipSuggestion)object2).getSortOrder());
            jSONArray.put(object);
        }
        Map<String, String> map = store.getProperties();
        object2 = (ReciptPaperSize)((Object)this.S.getSelectedItem());
        object = DataProvider.get().getCurrentTerminal();
        if (!this.k) {
            POSUtil.storeLongProperty(map, string7 + "ticket.header", string2, 255);
            POSUtil.storeLongProperty(map, string7 + "ticket.order.info", string3, 255);
            POSUtil.storeLongProperty(map, string7 + "ticket.order.extrainfo1", string4, 255);
            POSUtil.storeLongProperty(map, string7 + "ticket.footer", string5, 255);
            POSUtil.storeLongProperty(map, string7 + "ticket.bottom", string6, 255);
            POSUtil.storeLongProperty(map, string7 + "tips_suggestion", jSONArray.toString(), 255);
            store.addProperty(string7 + "ticket.modifier.color", this.a(this.o.getSelectedItem()));
            store.addProperty(string7 + "ticket.seat.color", this.a(this.p.getSelectedItem()));
            store.addProperty(string7 + "ticket.instruction.color", this.a(this.v.getSelectedItem()));
            store.addProperty(string7 + "receipt.show_tips_suggestion", String.valueOf(this.n.isSelected()));
            store.addProperty(string7 + "receipt.show_tips_block", String.valueOf(this.y.isSelected()));
            store.addProperty(string7 + "receipt.show_tax_breakdown", String.valueOf(this.z.isSelected()));
            store.addProperty(string7 + "kitchen_receipt.print_cooking_instruction", String.valueOf(this.B.isSelected()));
            store.addProperty("showModifierPrice", String.valueOf(this.w.isSelected()));
            store.addProperty("suppress.zerocost.modifiers", String.valueOf(this.x.isSelected()));
            store.setShowQRCodeOnHeader(this.D.isSelected());
            store.setShowQRCodeOnFooter(this.E.isSelected());
            store.putEnableTicketViewFontNameAndSize(this.F.isSelected());
            store.putTicketViewFontSize((Integer)this.G.getSelectedItem());
            string = (String)this.H.getSelectedItem();
            if (StringUtils.isNotBlank((String)string)) {
                store.putTicketViewFontName(string);
            }
            this.ab.updateModel("ticket.header");
            this.ac.updateModel("ticket.order.info");
            this.ad.updateModel("ticket.order.extrainfo1");
            this.ae.updateModel("ticket.footer");
            this.af.updateModel("ticket.bottom");
            this.ag.updateModel("ticket.details");
            object.addProperty("main.recipt.paper_size", ((Enum)object2).name());
            object.addProperty("main.receipt.print_preview_system", String.valueOf(this.Z.getSelectedItem()));
            this.t();
        } else {
            POSUtil.storeLongProperty(map, string7 + "kitchen.header", string2, 255);
            POSUtil.storeLongProperty(map, string7 + "kitchen.order.info", string3, 255);
            POSUtil.storeLongProperty(map, string7 + "kitchen.order.extrainfo1", string4, 255);
            POSUtil.storeLongProperty(map, string7 + "kitchen.footer", string5, 255);
            POSUtil.storeLongProperty(map, string7 + "kitchen.bottom", string6, 255);
            store.addProperty(string7 + "kitchen_ticket.modifier.color", this.a(this.o.getSelectedItem()));
            store.addProperty(string7 + "kitchen_ticket.seat.color", this.a(this.p.getSelectedItem()));
            store.addProperty(string7 + "kitchen_ticket.instruction.color", this.a(this.v.getSelectedItem()));
            store.addProperty("kitchen_receipt.print_translated_name", String.valueOf(this.A.isSelected()));
            store.setShowGuestNote(this.C.isSelected());
            store.putEnableKitchenItemFontNameAndSize(this.K.isSelected());
            store.putKitchenItemFontName((String)this.M.getSelectedItem());
            store.putKitchenItemFontSize((Integer)this.L.getSelectedItem());
            this.ab.updateModel("kitchen.header");
            this.ac.updateModel("kitchen.order.info");
            this.ad.updateModel("kitchen.order.extrainfo1");
            this.ae.updateModel("kitchen.footer");
            this.af.updateModel("kitchen.bottom");
            this.ag.updateModel("kitchen.details");
            object.addProperty("kitchen.recipt.paper_size", ((Enum)object2).name());
            object.addProperty("kitchen.receipt.print_preview_system", String.valueOf(this.Z.getSelectedItem()));
            this.u();
        }
        string = ReceiptParam.STORE_LOGO.getParamName();
        if (string2.contains(string) || string4.contains(string) || string3.contains(string) || string5.contains(string) || string6.contains(string)) {
            POSUtil.storeLongProperty(map, this.k ? string7 + "kitchen.header.logo.show" : string7 + "ticket.header.logo.show", "true", 255);
        } else {
            POSUtil.storeLongProperty(map, this.k ? string7 + "kitchen.header.logo.show" : string7 + "ticket.header.logo.show", "false", 255);
        }
    }

    private void d() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        int n = PosUIManager.getSize((int)600);
        Dimension dimension = PosUIManager.getSize((int)600, (int)150);
        int n2 = PosUIManager.getDefaultFontSize();
        jPanel.setLayout((LayoutManager)new MigLayout("hidemode 3,ins 0 5 10 5 ,wrap 1,filly", "[" + n + "]", "[][grow,][grow,][grow,][grow,][grow,]"));
        this.h = new JList();
        this.h.setFocusable(false);
        this.h.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ReceiptConfigurationView.this.A();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.h);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Params"));
        jScrollPane.setPreferredSize(PosUIManager.getSize((int)180, (int)200));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.33")));
        this.S = new JComboBox<ReciptPaperSize>(ReciptPaperSize.values());
        jPanel4.add(this.S, "grow");
        jPanel3.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel5.setBorder(BorderFactory.createTitledBorder("Print preview"));
        this.Z = new JComboBox();
        this.Z.addItem("Standard");
        this.Z.addItem("EscPOS");
        this.Z.addItemListener(itemEvent -> {
            boolean bl;
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            boolean bl2 = DataProvider.get().getCurrentTerminal().isEnableRtl();
            boolean bl3 = DataProvider.get().getCurrentTerminal().isShowBothNameAndTranslatedName();
            boolean bl4 = bl = this.Z.getSelectedItem() != null && this.Z.getSelectedItem().toString().equals("EscPOS");
            if (bl && (bl2 || bl3)) {
                POSMessageDialog.showMessage(Messages.getString("ReceiptConfigurationView.8"));
            }
            this.r();
            Store store = DataProvider.get().getStore();
            Store store2 = (Store)SerializationUtils.clone((Serializable)store);
            if (this.k) {
                this.a(true, store2);
                this.c(false, store2);
            } else {
                this.a(this.i != null, store2);
                this.b(false, store2);
            }
        });
        jPanel5.add((Component)this.Z, "grow");
        jPanel3.add((Component)jPanel5, "North");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "West");
        this.ab = new FontPropertiesPanel();
        this.ac = new FontPropertiesPanel();
        this.ad = new FontPropertiesPanel();
        this.ae = new FontPropertiesPanel();
        this.af = new FontPropertiesPanel();
        this.ag = new FontPropertiesPanel();
        this.b = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n2);
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.b.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.26"), this.ab, this.b, dimension), "grow");
        this.e = new JTextPane();
        this.e.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.28"), this.ac, this.e, dimension), "grow");
        this.f = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.f.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.30"), this.ad, this.f, dimension), "grow");
        this.ag.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.14")));
        jPanel.add((Component)this.ag, "grow");
        this.d = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.d.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.37"), this.ae, this.d, dimension), "grow");
        this.c = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.c.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.32"), this.af, this.c, dimension), "grow");
        jPanel.add((Component)this.i(), "grow");
        jPanel.add((Component)this.l(), "grow,wrap,gap bottom 50");
        jPanel.add((Component)this.j(), "grow, gap left 50");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(null);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(25);
        this.add(jScrollPane2);
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        jPanel6.add((Component)new JSeparator(), "span,growx");
        JButton jButton = new JButton(POSConstants.RESTORE_DEFAULTS);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.35"), POSConstants.CONFIRM) == 1) {
                    return;
                }
                ReceiptConfigurationView.this.m();
            }
        });
        jPanel6.add((Component)jButton, "split 2,center, gapbottom 0");
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ReceiptConfigurationView.this.save(true);
                    if (ReceiptConfigurationView.this.k) {
                        ReceiptConfigurationView.this.c(false, null);
                    } else {
                        ReceiptConfigurationView.this.b(false, null);
                    }
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                }
                catch (JRFontNotFoundException jRFontNotFoundException) {
                    POSMessageDialog.showError(Messages.getString("ReceiptConfigurationView.16"));
                }
                catch (StaleStateException staleStateException) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), ReceiptConfigurationView.this);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage(), posException);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel6.add(jButton2);
        if (Application.getInstance().getLicense().isDemoLicense()) {
            JPanel jPanel7 = POSUtil.doCreateDemoMessagePanel(String.format(Messages.getString("StoreConfigurationView.13"), VersionInfo.getAppName()));
            jPanel6.add(jPanel7);
        }
        this.add((Component)jPanel6, "South");
        this.F.addActionListener(actionEvent -> this.e());
        this.I.addActionListener(actionEvent -> this.f());
        this.K.addActionListener(actionEvent -> this.g());
        this.N.addActionListener(actionEvent -> this.h());
        this.b(false);
    }

    private void e() {
        this.H.setEnabled(this.F.isSelected());
        this.G.setEnabled(this.F.isSelected());
        this.I.setEnabled(this.F.isSelected());
    }

    private void f() {
        FontUIResource fontUIResource = (FontUIResource)UIManager.get("Table.font");
        this.H.setSelectedItem(fontUIResource.getFontName());
        this.G.setSelectedItem(fontUIResource.getSize());
    }

    private void g() {
        this.M.setEnabled(this.K.isSelected());
        this.L.setEnabled(this.K.isSelected());
        this.N.setEnabled(this.K.isSelected());
    }

    private void h() {
        FontUIResource fontUIResource = (FontUIResource)UIManager.get("Table.font");
        this.M.setSelectedItem(fontUIResource.getFontName());
        this.L.setSelectedItem(fontUIResource.getSize());
    }

    private Component a(String string, JPanel jPanel, JTextPane jTextPane, Dimension dimension) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(jScrollPane);
        return jPanel2;
    }

    private JPanel i() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.n.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ReceiptConfigurationView.this.a(true);
                } else {
                    ReceiptConfigurationView.this.a(false);
                }
            }
        });
        this.D.setVisible(false);
        this.E.setVisible(false);
        jPanel.add((Component)this.D, "wrap");
        jPanel.add((Component)this.E, "wrap");
        jPanel.add((Component)this.w, "wrap");
        jPanel.add((Component)this.x, "wrap");
        jPanel.add((Component)this.y, "wrap");
        jPanel.add((Component)this.z, "wrap");
        jPanel.add((Component)this.C, "wrap");
        jPanel.add((Component)this.A, "wrap");
        jPanel.add((Component)this.B, "wrap");
        jPanel.add((Component)this.n, "wrap");
        jPanel.add((Component)this.F, "split 6");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.H = new JComboBox();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        jPanel.add(this.H);
        this.H.setModel(new ListComboBoxModel(arrayList));
        this.G = new JComboBox();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 8; i <= 24; ++i) {
            arrayList2.add(i);
        }
        this.G.setModel(new ListComboBoxModel(arrayList2));
        jPanel.add(this.J);
        jPanel.add(this.G, "");
        this.I = new JButton(Messages.getString("FontsConfigurationView.1"));
        jPanel.add((Component)this.I, "wrap");
        jPanel.add((Component)this.K, "split 6");
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.M = new JComboBox();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList3.add(stringArray2[i]);
        }
        jPanel.add(this.M);
        this.M.setModel(new ListComboBoxModel(arrayList3));
        this.L = new JComboBox();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (int i = 8; i <= 24; ++i) {
            arrayList4.add(i);
        }
        this.L.setModel(new ListComboBoxModel(arrayList4));
        jPanel.add(this.O);
        jPanel.add(this.L, "");
        this.N = new JButton(Messages.getString("FontsConfigurationView.1"));
        jPanel.add((Component)this.N, "wrap");
        return jPanel;
    }

    private JPanel j() {
        this.X = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.X.setBorder(BorderFactory.createTitledBorder(Messages.getString("TipsSuggestion")));
        this.g = new JList();
        this.W = new JScrollPane(this.g);
        this.W.setPreferredSize(PosUIManager.getSize((int)130, (int)120));
        this.T = new JButton(POSConstants.ADD_BUTTON_TEXT);
        this.T.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.B();
            }
        });
        this.U = new JButton(POSConstants.EDIT);
        this.U.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.C();
            }
        });
        this.V = new JButton(POSConstants.DELETE);
        this.V.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.D();
            }
        });
        this.X.add(this.W);
        this.X.add(this.T);
        this.X.add(this.U);
        this.X.add(this.V);
        this.a(false);
        return this.X;
    }

    private void a(boolean bl) {
        this.W.setVisible(bl);
        this.T.setVisible(bl);
        this.U.setVisible(bl);
        this.V.setVisible(bl);
        this.X.setVisible(bl);
    }

    private JPanel k() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.u = graphicsEnvironment.getAvailableFontFamilyNames();
        this.q.setModel(new DefaultComboBoxModel<String>(this.u));
        this.s.setModel(new DefaultComboBoxModel<String>(this.u));
        Integer[] integerArray = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.r.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.t.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.72")));
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel2.add(this.q);
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel2.add(this.r);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.71")));
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel3.add(this.s);
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel3.add(this.t);
        jPanel.add((Component)jPanel2, "grow, wrap");
        jPanel.add((Component)jPanel3, "grow");
        return jPanel;
    }

    private JPanel l() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.9")));
        this.o.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.v.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.p.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        jPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.10")), "split 6");
        jPanel.add((Component)this.o, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.13")));
        jPanel.add((Component)this.p, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.15")));
        jPanel.add((Component)this.v, "");
        return jPanel;
    }

    private void m() {
        try {
            Store store = DataProvider.get().getStore();
            if (this.k) {
                ReceiptUtil.populateDefaultKitchenReceiptProperties(store);
            } else {
                ReceiptUtil.populateDefaultTicketReceiptProperties(store);
            }
            this.n();
            this.a = false;
            this.initialize();
            this.save(false);
            if (this.k) {
                this.c(false, store);
            } else {
                this.b(false, store);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception.getMessage());
        }
    }

    private void n() {
        if (this.i == null) {
            return;
        }
        String string = this.i.getId();
        try {
            Store store = DataProvider.get().getStore();
            StoreDAO.getInstance().refresh(store);
            Map<String, String> map = store.getProperties();
            if (!this.k) {
                POSUtil.removeLongProperty(map, string + "." + "ticket.header");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.info");
                POSUtil.removeLongProperty(map, string + "." + "ticket.footer");
                POSUtil.removeLongProperty(map, string + "." + "ticket.bottom");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo2");
                store.removeProperty(string + "." + "ticket.modifier.color");
                store.removeProperty(string + "." + "ticket.seat.color");
                store.removeProperty(string + "." + "ticket.instruction.color");
                store.removeProperty(string + "." + "receipt.show_tips_suggestion");
                store.removeProperty(string + "." + "receipt.show_tips_block");
                store.removeProperty(string + "." + "receipt.show_tax_breakdown");
                store.removeProperty(string + "." + "showModifierPrice");
                store.removeProperty(string + "." + "suppress.zerocost.modifiers");
                POSUtil.removeLongProperty(map, string + "." + "tips_suggestion");
                POSUtil.removeLongProperty(map, string + "." + "ticket.header.logo.show");
            } else {
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.info");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.footer");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo2");
                store.removeProperty(string + "." + "kitchen_ticket.modifier.color");
                store.removeProperty(string + "." + "kitchen_ticket.seat.color");
                store.removeProperty(string + "." + "kitchen_ticket.instruction.color");
                store.removeProperty(string + "." + "kitchen_receipt.print_translated_name");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.bottom");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header.logo.show");
            }
            StoreDAO.getInstance().saveOrUpdate(store);
            Application.getInstance().refreshStore();
            if (!this.k) {
                this.t();
            } else {
                this.u();
            }
        }
        catch (Exception exception) {
            PosLog.error(ReceiptConfigurationView.class, exception.getMessage(), exception);
        }
    }

    private void o() {
        if (this.l != null && this.Y != null) {
            return;
        }
        Store store = DataProvider.get().getStore();
        List<OrderType> list = DataProvider.get().getOrderTypes();
        String string = "w " + PosUIManager.getSize((int)90);
        if (list == null || list.isEmpty()) {
            this.w();
            return;
        }
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        try {
            this.l = new OrderInfoView(arrayList);
            this.l.setPreferredSize(PosUIManager.getSize((int)550, (int)0));
            this.l.setBorder(new EmptyBorder(8, 0, 5, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.l, "East");
        this.l.add(this.x(), "South");
        this.Y = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.a(actionEvent);
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.i = null;
        this.P = new POSToggleButton(POSConstants.ALL);
        this.P.addActionListener(actionListener);
        OrderType orderType = new OrderType("generic_order");
        this.P.putClientProperty("orderType", orderType);
        buttonGroup.add(this.P);
        this.Y.add((Component)this.P, string);
        if (this.i == null) {
            this.i = orderType;
            this.P.setSelected(true);
        }
        for (OrderType orderType2 : list) {
            String string2 = ReceiptUtil.getReceiptSectionByOrderType(store, "ticket.header", orderType2.getId());
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType2.getName() + (string2 != null ? "*" : "") + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            this.Y.add((Component)pOSToggleButton, string);
            pOSToggleButton.putClientProperty("orderType", orderType2);
            pOSToggleButton.addActionListener(actionListener);
            if (this.i != null) continue;
            arrayList.add(this.createNewTicket(orderType2, null));
        }
        this.Y.add((Component)new JSeparator(), "gaptop 20");
        this.j = new ButtonGroup();
        this.Q = new POSToggleButton("<html><center>Guest Check</center></html>");
        this.Q.putClientProperty("guestCheck", "cash");
        this.Q.addActionListener(actionListener);
        this.j.add(this.Q);
        this.Y.add((Component)this.Q, string);
        this.R = new POSToggleButton("<html><center>Guest Check (Credit Card)</center><html>");
        this.R.putClientProperty("guestCheck", "creditCard");
        this.R.addActionListener(actionListener);
        this.j.add(this.R);
        this.Y.add((Component)this.R, string);
        JScrollPane jScrollPane = new JScrollPane(this.Y, 20, 31);
        this.l.add((Component)jScrollPane, "East");
        this.F.setSelected(store.isEnableTicketViewFontNameAndSize());
        this.H.setSelectedItem(store.getTicketViewFontName());
        this.G.setSelectedItem(store.getTicketViewFontSize());
        this.H.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.y();
            }
        });
        this.G.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.y();
            }
        });
        this.b(false, store);
    }

    private String a(String string, String string2) {
        Store store;
        String string3;
        if (StringUtils.isNotEmpty((String)string)) {
            string = string + ".";
        }
        if (StringUtils.isEmpty((String)(string3 = (store = DataProvider.get().getStore()).getProperty(string + string2)))) {
            string3 = store.getProperty(string2);
        }
        return string3;
    }

    private void p() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (this.i != null && this.i.getId() != "generic_order") {
            string6 = this.i.getId();
        }
        Store store = DataProvider.get().getStore();
        if (!this.k) {
            string = ReceiptUtil.getReceiptSection(store, "ticket.header", string6);
            string2 = ReceiptUtil.getReceiptSection(store, "ticket.order.info", string6);
            string3 = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", string6);
            string4 = ReceiptUtil.getReceiptSection(store, "ticket.footer", string6);
            string5 = ReceiptUtil.getReceiptSection(store, "ticket.bottom", string6);
            this.ab.updateView("ticket.header");
            this.ac.updateView("ticket.order.info");
            this.ad.updateView("ticket.order.extrainfo1");
            this.ae.updateView("ticket.footer");
            this.af.updateView("ticket.bottom");
            this.ag.updateView("ticket.details");
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.instruction.color")));
            this.w.setSelected(POSUtil.getBoolean(store.getProperty("showModifierPrice")));
            this.x.setSelected(POSUtil.getBoolean(store.getProperty("suppress.zerocost.modifiers")));
            this.D.setSelected(store.isShowQRCodeOnHeader());
            this.E.setSelected(store.isShowQRCodeOnFooter());
            this.n.setSelected(ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_suggestion", string6));
            this.y.setSelected(ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_block", string6));
            this.z.setSelected(ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tax_breakdown", string6));
            this.B.setSelected(ReceiptUtil.getReceiptBooleanProp(store, "kitchen_receipt.print_cooking_instruction", string6));
        } else {
            string = ReceiptUtil.getReceiptSection(store, "kitchen.header", string6);
            string2 = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", string6);
            string3 = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", string6);
            string4 = ReceiptUtil.getReceiptSection(store, "kitchen.footer", string6);
            string5 = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", string6);
            this.ab.updateView("kitchen.header");
            this.ac.updateView("kitchen.order.info");
            this.ad.updateView("kitchen.order.extrainfo1");
            this.ae.updateView("kitchen.footer");
            this.af.updateView("kitchen.bottom");
            this.ag.updateView("kitchen.details");
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.instruction.color")));
            boolean bl = store.getProperty("kitchen_receipt.print_translated_name") == null ? false : Boolean.valueOf(store.getProperty("kitchen_receipt.print_translated_name"));
            this.A.setSelected(bl);
            this.C.setSelected(store.isShowGuestNote());
        }
        this.q();
        this.w.setVisible(!this.k);
        this.x.setVisible(!this.k);
        this.z.setVisible(!this.k);
        this.B.setVisible(!this.k);
        this.n.setVisible(!this.k);
        this.F.setVisible(!this.k);
        this.H.setVisible(!this.k);
        this.G.setVisible(!this.k);
        this.I.setVisible(!this.k);
        this.J.setVisible(!this.k);
        this.y.setVisible(!this.k);
        this.C.setVisible(this.k);
        this.A.setVisible(this.k);
        this.K.setVisible(this.k);
        this.M.setVisible(this.k);
        this.L.setVisible(this.k);
        this.N.setVisible(this.k);
        this.O.setVisible(this.k);
        string = string.replaceAll("<br>", "\n");
        string2 = string2.replaceAll("<br>", "\n");
        string3 = string3.replaceAll("<br>", "\n");
        string4 = string4.replaceAll("<br>", "\n");
        string5 = string5.replaceAll("<br>", "\n");
        this.b.setText(string);
        this.e.setText(string2);
        this.f.setText(string3);
        this.c.setText(string4);
        this.d.setText(string5);
        this.E();
    }

    private void q() {
        this.D.setVisible(false);
        this.E.setVisible(false);
        QRReceiptPlugin qRReceiptPlugin = (QRReceiptPlugin)ExtensionManager.getPlugin(QRReceiptPlugin.class);
        if (qRReceiptPlugin != null && qRReceiptPlugin.hasValidLicense()) {
            this.D.setVisible(!this.k);
            this.E.setVisible(!this.k);
        }
    }

    private void r() {
        try {
            boolean bl = this.Z.getSelectedItem() != null && this.Z.getSelectedItem().toString().equals("EscPOS");
            this.b(bl);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void b(boolean bl) {
        this.ab.setVisible(bl);
        this.ac.setVisible(bl);
        this.ad.setVisible(bl);
        this.ae.setVisible(bl);
        this.af.setVisible(bl);
        this.ag.setVisible(bl);
        this.F.setVisible(!bl && !this.k);
        this.H.setVisible(!bl && !this.k);
        this.J.setVisible(!bl && !this.k);
        this.G.setVisible(!bl && !this.k);
        this.I.setVisible(!bl && !this.k);
        this.K.setVisible(!bl && this.k);
        this.M.setVisible(!bl && this.k);
        this.O.setVisible(!bl && this.k);
        this.L.setVisible(!bl && this.k);
        this.N.setVisible(!bl && this.k);
    }

    private void s() {
        try {
            if (this.m != null) {
                return;
            }
            this.m = new KitchenReceiptView();
            this.m.setBorder(new EmptyBorder(8, 0, 5, 0));
            this.m.setPreferredSize(PosUIManager.getSize((int)550, (int)0));
            this.add((Component)this.m, "East");
            this.m.add(this.x(), "South");
            Store store = DataProvider.get().getStore();
            this.K.setSelected(store.isEnableKitchenItemFontNameAndSize());
            this.M.setSelectedItem(store.getKitchenItemFontName());
            this.L.setSelectedItem(store.getKitchenItemFontSize());
            this.M.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.z();
                }
            });
            this.L.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.z();
                }
            });
            this.v();
            this.c(false, store);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void t() {
        Component[] componentArray = this.Y.getComponents();
        Store store = DataProvider.get().getStore();
        for (Component component : componentArray) {
            POSToggleButton pOSToggleButton;
            OrderType orderType;
            if (!(component instanceof POSToggleButton) || (orderType = (OrderType)(pOSToggleButton = (POSToggleButton)component).getClientProperty("orderType")) == null || !StringUtils.isNotEmpty((String)orderType.getName())) continue;
            String string = ReceiptUtil.getReceiptSectionByOrderType(store, "ticket.header", orderType.getId());
            pOSToggleButton.setText("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
        }
    }

    private void u() {
        Component[] componentArray = this.aa.getComponents();
        Store store = DataProvider.get().getStore();
        for (Component component : componentArray) {
            POSToggleButton pOSToggleButton;
            OrderType orderType;
            if (!(component instanceof POSToggleButton) || (orderType = (OrderType)(pOSToggleButton = (POSToggleButton)component).getClientProperty("orderType")) == null) continue;
            String string = ReceiptUtil.getReceiptSectionByOrderType(store, "kitchen.header", orderType.getId());
            pOSToggleButton.setText("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
        }
    }

    private void v() {
        Store store = DataProvider.get().getStore();
        List<OrderType> list = DataProvider.get().getOrderTypes();
        if (list == null || list.isEmpty()) {
            this.w();
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.i = null;
        this.aa = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
        for (OrderType orderType : list) {
            String string = ReceiptUtil.getReceiptSectionByOrderType(store, "kitchen.header", orderType.getId());
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            String string2 = "w " + PosUIManager.getSize((int)90);
            this.aa.add((Component)pOSToggleButton, string2);
            pOSToggleButton.putClientProperty("orderType", orderType);
            pOSToggleButton.addActionListener(actionEvent -> {
                POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
                if (orderType != null) {
                    this.i = orderType;
                }
                this.p();
                this.c(false, store);
            });
            if (this.i != null) continue;
            this.i = orderType;
            pOSToggleButton.setSelected(true);
        }
        JScrollPane jScrollPane = new JScrollPane(this.aa, 20, 31);
        this.m.add((Component)jScrollPane, "East");
        SwingUtilities.invokeLater(() -> this.S.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            Store store2 = (Store)SerializationUtils.clone((Serializable)store);
            if (this.k) {
                this.a(true, store2);
                this.c(false, store2);
            }
        }));
    }

    private void w() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.66"));
        this.removeAll();
    }

    private Component x() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 0 5"));
        JButton jButton = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Store store = DataProvider.get().getStore();
                Store store2 = (Store)SerializationUtils.clone((Serializable)store);
                if (ReceiptConfigurationView.this.k) {
                    ReceiptConfigurationView.this.a(true, store2);
                    ReceiptConfigurationView.this.c(false, store2);
                } else {
                    ReceiptConfigurationView.this.a(ReceiptConfigurationView.this.i != null, store2);
                    ReceiptConfigurationView.this.b(false, store2);
                }
            }
        });
        JButton jButton2 = new JButton(Messages.getString("ReceiptConfigurationView.65"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.F();
            }
        });
        jPanel.add((Component)jButton, "gapleft 100!,split 2");
        jPanel.add(jButton2);
        return jPanel;
    }

    private void y() {
        Store store = (Store)SerializationUtils.clone((Serializable)DataProvider.get().getStore());
        this.b(false, store);
    }

    private void b(boolean bl, Store store) {
        try {
            if (bl) {
                this.save(true);
            }
            if (this.R.isSelected() || this.Q.isSelected()) {
                String string = null;
                if (this.Q.isSelected()) {
                    string = (String)this.Q.getClientProperty("guestCheck");
                } else if (this.R.isSelected()) {
                    string = (String)this.R.getClientProperty("guestCheck");
                }
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                Ticket ticket = this.createNewTicket(this.i, string);
                arrayList.add(ticket);
                this.l.setTickets(arrayList);
                try {
                    this.l.getReportPanel().removeAll();
                    Font font = null;
                    if (string == null) {
                        String string2 = (String)this.H.getSelectedItem();
                        if (this.F.isSelected()) {
                            font = new Font(string2, 0, (Integer)this.G.getSelectedItem());
                        }
                        this.l.getReportPanel().removeAll();
                        this.l.createReport(font);
                        if (font != null) {
                            this.ah = string2;
                        }
                    } else {
                        String string3 = (String)this.H.getSelectedItem();
                        if (this.F.isSelected()) {
                            font = new Font(string3, 0, (Integer)this.G.getSelectedItem());
                        }
                        this.l.getReportPanel().removeAll();
                        this.l.createReport(ticket.getTransactions().iterator().next(), font);
                        if (font != null) {
                            this.ah = string3;
                        }
                    }
                    this.l.revalidate();
                    this.l.repaint();
                }
                catch (JRFontNotFoundException jRFontNotFoundException) {
                    this.H.hidePopup();
                    POSMessageDialog.showError(Messages.getString("ReceiptConfigurationView.16"));
                    this.H.setSelectedItem(store.getTicketViewFontName());
                    this.y();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(this, exception.getMessage(), exception);
                }
            } else {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                Ticket ticket = this.createNewTicket(this.i, null);
                arrayList.add(ticket);
                this.l.setTickets(arrayList);
                Font font = null;
                try {
                    String string = (String)this.H.getSelectedItem();
                    if (this.F.isSelected() && string != null) {
                        font = new Font(string, 0, (Integer)this.G.getSelectedItem());
                    }
                    this.l.getReportPanel().removeAll();
                    this.l.createReport(store, font, true);
                    if (font != null) {
                        this.ah = string;
                    }
                }
                catch (JRFontNotFoundException jRFontNotFoundException) {
                    this.H.hidePopup();
                    POSMessageDialog.showError(Messages.getString("ReceiptConfigurationView.16"));
                    if (OS.isLinux()) {
                        this.H.setSelectedItem(null);
                    } else {
                        this.H.setSelectedItem(store.getTicketViewFontName());
                    }
                    this.y();
                }
                catch (Exception exception) {
                    PosLog.error(ReceiptConfigurationView.class, exception.getMessage());
                }
            }
            this.l.revalidate();
            this.l.repaint();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void z() {
        Store store = (Store)SerializationUtils.clone((Serializable)DataProvider.get().getStore());
        this.c(false, store);
    }

    private void c(boolean bl, Store store) {
        try {
            if (bl) {
                this.save(true);
            }
            Ticket ticket = this.createNewTicket(this.i, null);
            try {
                this.m.getReportPanel().removeAll();
                this.m.createReport(ticket, store);
                this.m.revalidate();
                this.m.repaint();
            }
            catch (Exception exception) {}
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public Ticket createNewTicket(OrderType orderType, String string) {
        Object object;
        Cloneable cloneable;
        SalesArea salesArea;
        int n = 4;
        Date date = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Double d = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId(Messages.getString("ReceiptConfigurationView.97"));
        customer.setSignatureImageId(Messages.getString("ReceiptConfigurationView.98"));
        customer.setLoyaltyPoint(100);
        customer.putCustomerNo("123");
        if (orderType.isDelivery().booleanValue()) {
            date = new Date();
            string2 = "Customer address.....";
            string3 = Messages.getString("ReceiptConfigurationView.70");
            string4 = "Phone extension..";
            string5 = "Manager instructions..";
            bl = false;
            d = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(orderType);
        ticket.setNumberOfGuests(n);
        ticket.setNote("guest note");
        ticket.addExtraProperty("ticket.sub_order_type", POSConstants.FOR_HERE_TO_GO_BUTTON_TEXT);
        if (bl) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(date);
            ticket.setDeliveryAddress(string2);
            ticket.setExtraDeliveryInfo(string3);
            ticket.addProperty("PHONE_EXTENSION", string4);
            ticket.addProperty("MANAGER_INSTRUCTION", string5);
            ticket.setDeliveryCharge(d);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User user = Application.getCurrentUser();
        ticket.setOwner(user);
        ticket.setAssignedDriver(user);
        ticket.setShortId("123");
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (this.i.isShowTableSelection().booleanValue()) {
            cloneable = new ArrayList();
            cloneable.add(1);
            cloneable.add(2);
            ticket.setTableNumbers((List<Integer>)((Object)cloneable));
        }
        cloneable = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(((Calendar)cloneable).getTime());
        ticket.setCreationHour(((Calendar)cloneable).get(11));
        ticket.addProperty("printCount", String.valueOf(1));
        ticket.addProperty("previewTicket", String.valueOf(Boolean.TRUE));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.addProperty("split_ticket_id", ticket.getId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax = new TicketItemTax();
        ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax.setName(Messages.getString("ReceiptConfigurationView.99"));
        ticketItemTax.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName(Messages.getString("ReceiptConfigurationView.100"));
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            Comparable comparable;
            Comparable comparable2;
            object = new PreviewTicketItem();
            ((BaseTicketItem)object).setId(NumericGlobalIdGenerator.generateGlobalId());
            ((BaseTicketItem)object).setMenuItemId("0");
            ((BaseTicketItem)object).setName("Item " + (i + 1));
            ((BaseTicketItem)object).setQuantity((double)i + 1.0);
            ((BaseTicketItem)object).setUnitPrice(2.5);
            ((BaseTicketItem)object).setShouldPrintToKitchen(true);
            ((TicketItem)object).setTaxes(Arrays.asList(ticketItemTax, ticketItemTax2));
            if (orderType.isEnableCourse().booleanValue()) {
                comparable2 = new Course(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseCourse)comparable2).setShortName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseId(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
            }
            ticket.addToticketItems((TicketItem)object);
            ((BaseTicketItem)object).setTicket(ticket);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    comparable = new TicketItemModifier();
                    ((BaseTicketItemModifier)comparable).setId(NumericGlobalIdGenerator.generateGlobalId());
                    ((BaseTicketItemModifier)comparable).setItemId("0");
                    ((BaseTicketItemModifier)comparable).setGroupId("0");
                    ((BaseTicketItemModifier)comparable).setItemQuantity(2.0);
                    ((BaseTicketItemModifier)comparable).setName("Modifier " + (j + 1));
                    ((BaseTicketItemModifier)comparable).setUnitPrice(1.5);
                    ((BaseTicketItemModifier)comparable).setShouldPrintToKitchen(true);
                    ((BaseTicketItemModifier)comparable).setTicketItem((TicketItem)object);
                    ((BaseModifiableTicketItem)object).addToticketItemModifiers((TicketItemModifier)comparable);
                }
            } else if (i == 2) {
                comparable2 = new TicketItemCookingInstruction();
                ((BaseTicketItemCookingInstruction)comparable2).setDescription("Fry (Cooking Ins.)");
                ((TicketItem)object).addCookingInstruction((TicketItemCookingInstruction)comparable2);
            }
            if (i == 2) {
                TicketItem ticketItem = new TicketItem();
                comparable = new TicketItemSeat();
                ticketItem.setName("Seat** 1");
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setTreatAsSeat(true);
                ticketItem.setSeatNumber(1);
                ticketItem.setPrintedToKitchen(false);
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setSeat((TicketItemSeat)comparable);
                ticketItem.setTicket(ticket);
                ((BaseTicketItemSeat)comparable).setSeatNumber(1);
                ticket.addToticketItems(ticketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem ticketItem = new TicketItem();
            comparable = new TicketItemSeat();
            ticketItem.setName("Seat** Shared");
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setTreatAsSeat(true);
            ticketItem.setSeatNumber(null);
            ticketItem.setPrintedToKitchen(false);
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setSeat((TicketItemSeat)comparable);
            ticketItem.setTicket(ticket);
            ((BaseTicketItemSeat)comparable).setSeatNumber(1);
            ticket.addToticketItems(ticketItem);
        }
        ticket.calculatePrice();
        PosTransaction posTransaction = null;
        object = null;
        if (string != null && string.equals("creditCard")) {
            object = PaymentType.CREDIT_CARD;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway("Payment gateway name..");
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName("Card holder name");
            posTransaction.setCardNumber("4111111111111111");
            posTransaction.setCardExpMonth("12");
            posTransaction.setCardExpYear("2020");
            posTransaction.setCardType(CardTypeEnum.VISA.name());
            posTransaction.setCardAuthCode("00000");
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(user);
        } else {
            object = PaymentType.CASH;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
        }
        posTransaction.setLoyaltyEarnedForPurchase(5);
        posTransaction.setLoyaltyChargedAmount(3);
        posTransaction.setTenderAmount(ticket.getDueAmount());
        posTransaction.setAmount(ticket.getDueAmount());
        posTransaction.setTicket(ticket);
        ticket.addTotransactions(posTransaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
        ticket.calculatePrice();
        Date date2 = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        posTransaction.setTerminal(terminal);
        posTransaction.setUser(user);
        posTransaction.setServer(user);
        posTransaction.setTransactionTime(date2);
        return ticket;
    }

    private void A() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent jTextComponent = null;
        if (!(component instanceof JTextComponent)) {
            return;
        }
        jTextComponent = (JTextComponent)component;
        ReceiptParam receiptParam = this.h.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String string = "<" + receiptParam.getParamName() + ">$" + receiptParam.getParamName() + "</" + receiptParam.getParamName() + ">";
        jTextComponent.replaceSelection(string);
    }

    @Override
    public void refresh() {
        DataProvider.get().refreshStore();
        OutletDAO.getInstance().refresh(DataProvider.get().getOutlet());
        DataProvider.get().refreshCurrentTerminal();
        this.a();
    }

    private void a(ActionEvent actionEvent) {
        try {
            String string;
            POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
            OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
            if (orderType != null) {
                this.i = orderType;
            }
            if (StringUtils.isEmpty((String)(string = (String)pOSToggleButton.getClientProperty("guestCheck")))) {
                string = null;
                this.j.clearSelection();
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            Ticket ticket = this.createNewTicket(this.i, string);
            arrayList.add(ticket);
            this.p();
            this.l.setTickets(arrayList);
            this.l.getReportPanel().removeAll();
            Font font = null;
            if (string == null) {
                String string2 = (String)this.H.getSelectedItem();
                if (this.F.isSelected()) {
                    font = new Font(string2, 0, (Integer)this.G.getSelectedItem());
                }
                this.l.getReportPanel().removeAll();
                this.l.createReport(font);
                if (font != null) {
                    this.ah = string2;
                }
            } else {
                String string3 = (String)this.H.getSelectedItem();
                if (this.F.isSelected()) {
                    font = new Font(string3, 0, (Integer)this.G.getSelectedItem());
                }
                this.l.getReportPanel().removeAll();
                this.l.createReport(ticket.getTransactions().iterator().next(), font);
                if (font != null) {
                    this.ah = string3;
                }
            }
            this.l.revalidate();
            this.l.repaint();
        }
        catch (JRFontNotFoundException jRFontNotFoundException) {
            this.H.hidePopup();
            POSMessageDialog.showError(Messages.getString("ReceiptConfigurationView.16"));
            if (StringUtils.isBlank((String)this.ah)) {
                return;
            }
            this.H.setSelectedItem(this.ah);
            this.y();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void B() {
        try {
            TipsSuggestionDialog tipsSuggestionDialog = new TipsSuggestionDialog(Messages.getString("AddTips"), this.a((TipSuggestion)null));
            tipsSuggestionDialog.setSize(PosUIManager.getSize((int)400, (int)250));
            tipsSuggestionDialog.open();
            if (tipsSuggestionDialog.isCanceled()) {
                return;
            }
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.add(tipsSuggestionDialog.getTipSuggestion());
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private List<Double> a(TipSuggestion tipSuggestion) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.g.getModel().getSize(); ++i) {
            TipSuggestion tipSuggestion2 = this.g.getModel().getElementAt(i);
            if (tipSuggestion != null && tipSuggestion.getPercentage() == tipSuggestion2.getPercentage()) continue;
            arrayList.add(tipSuggestion2.getPercentage());
        }
        return arrayList;
    }

    private void C() {
        try {
            TipSuggestion tipSuggestion3 = this.g.getSelectedValue();
            if (tipSuggestion3 == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            TipsSuggestionDialog tipsSuggestionDialog = new TipsSuggestionDialog(Messages.getString("EditTips"), this.a(tipSuggestion3));
            tipsSuggestionDialog.setTipsPercentage(tipSuggestion3.getPercentage());
            tipsSuggestionDialog.setTipsSortOrder(tipSuggestion3.getSortOrder());
            tipsSuggestionDialog.setSize(PosUIManager.getSize((int)400, (int)250));
            tipsSuggestionDialog.open();
            if (tipsSuggestionDialog.isCanceled()) {
                return;
            }
            int n = this.g.getSelectedIndex();
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.remove(n);
            arrayList.add(n, tipsSuggestionDialog.getTipSuggestion());
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void D() {
        try {
            int n = this.g.getSelectedIndex();
            if (n == -1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.remove(n);
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(List<TipSuggestion> list) {
        ListModel<TipSuggestion> listModel = new ListModel<TipSuggestion>(list);
        this.g.setModel(listModel);
        this.g.revalidate();
        this.g.repaint();
    }

    private void E() throws JSONException, JsonSyntaxException {
        if (this.i != null) {
            Store store = DataProvider.get().getStore();
            String string = ReceiptUtil.getReceiptSection(store, "tips_suggestion", this.i.getId());
            if (string == null) {
                string = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
            }
            JSONArray jSONArray = new JSONArray(string);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                if (object == null) continue;
                arrayList.add((TipSuggestion)gson.fromJson(object.toString(), TipSuggestion.class));
            }
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
    }

    private void F() {
        try {
            if (this.k && ReceiptPrintService.hasNoKitchenReceiptPrinters() || !this.k && ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            Store store = DataProvider.get().getStore();
            Store store2 = (Store)SerializationUtils.clone((Serializable)store);
            if (this.k) {
                this.a(true, store2);
                this.m.print(store2);
            } else {
                this.a(false, store2);
                ReceiptPrintService.printTestTicket(this.l.getTickets().get(0), store2);
            }
        }
        catch (PrintException printException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), printException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    static class PreviewTicketItem
    extends ModifiableTicketItem {
        private static final long b = 1L;

        @Override
        public List<Printer> getPrinters(OrderType orderType) {
            PrinterGroup printerGroup = this.getPrinterGroup();
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            arrayList.add(VirtualPrinter.getKdsPrinter());
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            arrayList.addAll(posPrinters.getStickerPrinters());
            if (printerGroup == null) {
                arrayList.addAll(posPrinters.getKitchenPrinters());
                return arrayList;
            }
            List<String> list = printerGroup.getPrinterNames();
            List<Printer> list2 = posPrinters.getKitchenPrinters();
            for (Printer printer : list2) {
                if (!list.contains(printer.getVirtualPrinter().getName())) continue;
                arrayList.add(printer);
            }
            return arrayList;
        }
    }

    static enum SimpleColor {
        black(Color.black),
        red(Color.red);

        final Color a;

        private SimpleColor(Color color) {
            this.a = color;
        }

        public static SimpleColor getColor(String string) {
            Color color = SimpleColor.getAwtColor(string);
            if (color != null) {
                for (SimpleColor simpleColor : SimpleColor.values()) {
                    if (simpleColor.a.getRGB() != color.getRGB()) continue;
                    return simpleColor;
                }
            }
            return black;
        }

        public static Color getAwtColor(String string) {
            try {
                return Color.decode(string);
            }
            catch (Exception exception) {
                return Color.black;
            }
        }

        static String[] a() {
            List<SimpleColor> list = Arrays.asList(SimpleColor.values());
            String string = list.toString().replaceAll(" ", "");
            return string.substring(1, string.length() - 1).split(",");
        }
    }

    public class KitchenReceiptView
    extends JPanel {
        private JPanel b;
        private Ticket c;

        public KitchenReceiptView() {
            this.createUI();
        }

        public void createUI() {
            this.b = new VerticalTouchScrollPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            JScrollPane jScrollPane = new JScrollPane(this.b);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane);
        }

        public void createReport(Ticket ticket, Store store) throws Exception {
            this.c = ticket;
            Font font = null;
            try {
                String string = (String)ReceiptConfigurationView.this.M.getSelectedItem();
                if (ReceiptConfigurationView.this.K.isSelected()) {
                    font = new Font(string, 0, (Integer)ReceiptConfigurationView.this.L.getSelectedItem());
                }
                ReceiptPrintService.getKitchenReceiptPrintPreviewService().rendererKitchenReceipt(ticket, store, this.b, font);
                if (font != null) {
                    ReceiptConfigurationView.this.ah = string;
                }
            }
            catch (JRFontNotFoundException jRFontNotFoundException) {
                ReceiptConfigurationView.this.M.hidePopup();
                POSMessageDialog.showError(Messages.getString("ReceiptConfigurationView.16"));
                ReceiptConfigurationView.this.M.setSelectedItem(store.getKitchenItemFontName());
                ReceiptConfigurationView.this.z();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }

        public void print(Store store) throws Exception {
            ReceiptPrintService.printToKitchen(this.c, store, false, false);
        }

        public JPanel getReportPanel() {
            return this.b;
        }
    }

    private class FontPropertiesPanel
    extends JPanel {
        private static final String b = "48";
        private static final String c = "01";
        public static final String FONT_TYPE_A = "Font A";
        public static final String FONT_TYPE_B = "Font B";
        private JCheckBox d;
        private JComboBox<Object> e;
        private JComboBox<String> f;
        private FixedLengthTextField g;

        public FontPropertiesPanel() {
            this.setLayout((LayoutManager)new MigLayout("center,ins 0 0 3 0"));
            this.d = new JCheckBox(Messages.getString("FontBold"));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            for (int i = 10; i <= 39; ++i) {
                arrayList.add(String.format("%02d", i));
            }
            this.e = new JComboBox<Object>(arrayList.toArray());
            this.f = new JComboBox<String>(new String[]{"", FONT_TYPE_A, FONT_TYPE_B});
            this.g = new FixedLengthTextField();
            this.g.setLength(2);
            this.add(this.d);
            this.add((Component)new JLabel(Messages.getString("FontSize")), "gapleft 10!");
            this.add(this.e, String.format("w %s!", PosUIManager.getSize((int)50)));
            this.add(new JLabel(Messages.getString("Type")));
            this.add(this.f);
            this.add((Component)this.g, String.format("w %s!", PosUIManager.getSize((int)50)));
            this.f.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                this.a();
            });
        }

        public void updateView(String string) {
            try {
                Store store = DataProvider.get().getStore();
                this.d.setSelected(store.getBooleanProperty(string + ".font-weight", false));
                String string2 = store.getProperty(string + ".font-size", "");
                if (StringUtils.isEmpty((String)string2)) {
                    this.e.setSelectedIndex(0);
                } else {
                    this.e.setSelectedItem(string2);
                }
                String string3 = store.getProperty(string + ".font-type", "");
                if (StringUtils.isEmpty((String)string3)) {
                    this.f.setSelectedIndex(0);
                } else {
                    this.f.setSelectedItem(this.a(string3));
                }
                this.g.setText(string3);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        public void updateModel(String string) {
            try {
                Store store = DataProvider.get().getStore();
                store.addProperty(string + ".font-weight", String.valueOf(this.d.isSelected()));
                store.addProperty(string + ".font-size", this.e.getSelectedItem() == null ? "" : this.e.getSelectedItem().toString());
                store.addProperty(string + ".font-type", this.g.getText());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void a() {
            try {
                if (this.f.getSelectedItem() == null || StringUtils.isBlank((String)this.f.getSelectedItem().toString())) {
                    this.g.setText("");
                    return;
                }
                this.g.setText(this.b());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private String b() {
            Object object = this.f.getSelectedItem();
            if (object == null) {
                return "";
            }
            switch (object.toString()) {
                case "Font B": {
                    return c;
                }
                case "Font A": {
                    return b;
                }
            }
            return "";
        }

        private String a(String string) {
            if (string == null) {
                return "";
            }
            if (b.equalsIgnoreCase(string)) {
                return FONT_TYPE_A;
            }
            if (c.equalsIgnoreCase(string)) {
                return FONT_TYPE_B;
            }
            return "";
        }
    }
}

