/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ChargeConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.QuickTenderInputView;
import com.floreantpos.config.ui.StoreBrandingConfigurationView;
import com.floreantpos.config.ui.StoreConfigurationView;
import com.floreantpos.config.ui.StoreMiscellaneousConfigurationView;
import com.floreantpos.config.ui.StoreOpeningHourConfigurationView;
import com.floreantpos.config.ui.StoreSessionConfigurationView;
import com.floreantpos.config.ui.TicketImportConfigurationView;
import com.floreantpos.config.ui.TipsConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.TicketImportPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSTabbedPane;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class StoreConfigurationDialog
extends POSDialog
implements RefreshableView,
ChangeListener {
    private POSTabbedPane a = new POSTabbedPane();
    private List<ConfigurationView> b = new ArrayList<ConfigurationView>();
    private Store c;
    private Outlet d;
    private JButton e;
    private JPanel f;

    public StoreConfigurationDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.initComponents(false, false);
    }

    public StoreConfigurationDialog(boolean bl) {
        this(bl, false);
    }

    public StoreConfigurationDialog(boolean bl, boolean bl2) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.initComponents(bl, bl2);
    }

    public void initComponents(boolean bl, boolean bl2) {
        this.c = DataProvider.get().getStore();
        this.d = DataProvider.get().getOutlet();
        StoreDAO.getInstance().refresh(this.c);
        OutletDAO.getInstance().refresh(this.d);
        this.setLayout(new BorderLayout());
        this.f = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.a.addChangeListener(this);
        if (!bl2) {
            this.setTitle(POSConstants.STORE_CONFIGURATION_WINDOW_TITLE);
            this.f.add((Component)this.a, "span, grow");
        }
        this.a(bl, bl2);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,fill"));
        this.e = new JButton(POSConstants.CANCEL);
        this.e.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)this.e, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton jButton = new JButton(POSConstants.OK);
        jButton.addActionListener(actionEvent -> this.a());
        jPanel.add((Component)jButton, "dock east, gapright 5, gaptop 5, gapbottom 10");
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(actionEvent -> this.a(Boolean.FALSE));
        jPanel.add((Component)jButton2, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)jPanel, "South");
        this.setDefaultCloseOperation(2);
        this.add((Component)this.f, "Center");
    }

    private void a(boolean bl, boolean bl2) {
        if (bl2) {
            StoreConfigurationView storeConfigurationView = new StoreConfigurationView(this.c, this.d);
            this.setTitle(Messages.getString("StoreConfigurationDialog.0"));
            try {
                storeConfigurationView.initialize();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE);
            }
            this.b.add(storeConfigurationView);
            this.f.add((Component)storeConfigurationView, "span, grow");
            TitlePanel titlePanel = new TitlePanel();
            titlePanel.setTitle(Messages.getString("StoreConfigurationDialog.2"));
            this.add((Component)titlePanel, "North");
        } else if (bl) {
            this.addView(new StoreOpeningHourConfigurationView(this.c));
        } else {
            this.addView(new StoreConfigurationView(this.c, this.d));
            this.addView(new StoreOpeningHourConfigurationView(this.c));
            this.addView(new ChargeConfigurationView(this.c, this.d));
            this.addView(new StoreBrandingConfigurationView(this.c));
            this.addView(new TipsConfigurationView(this.c));
            this.addView(new StoreMiscellaneousConfigurationView(this.c));
            this.addView(new StoreSessionConfigurationView(this.c));
            TicketImportPlugin ticketImportPlugin = (TicketImportPlugin)ExtensionManager.getPlugin(TicketImportPlugin.class);
            if (ticketImportPlugin != null) {
                this.addView(new TicketImportConfigurationView());
            }
            this.addView(new QuickTenderInputView(this.c));
        }
    }

    public void addView(ConfigurationView configurationView) {
        this.a.addTab(configurationView.getName(), configurationView);
        this.b.add(configurationView);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ConfigurationView configurationView = (ConfigurationView)this.a.getSelectedComponent();
        try {
            if (configurationView != null && !configurationView.isInitialized()) {
                configurationView.initialize();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
        this.a.setInitialized(true);
    }

    private void a() {
        this.a(Boolean.TRUE);
    }

    private void a(boolean bl) {
        try {
            for (ConfigurationView configurationView : this.b) {
                if (!configurationView.isInitialized() || configurationView.save()) continue;
                return;
            }
            TerminalDAO.getInstance().performBatchSave(this.c, this.d);
            Application.getInstance().refreshStore();
            OroMqttClient.getInstance().notifyDataUpdated(Store.class);
            this.setCanceled(false);
            if (bl) {
                this.dispose();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void refresh() {
        this.a.setInitialized(false);
        StoreDAO.getInstance().refresh(this.c);
        OutletDAO.getInstance().refresh(this.d);
        for (ConfigurationView configurationView : this.b) {
            if (!configurationView.isInitialized()) continue;
            try {
                configurationView.initialize();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.a.setSelectedIndex(0);
        this.a.setInitialized(true);
    }

    public void setCanceledButtonVisible(boolean bl) {
        this.e.setVisible(bl);
    }

    public String getOutletFullAddress() {
        return this.d.buildOutletFullAddress();
    }
}

