/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.util.EnumDateFormat;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class StoreConfigurationView
extends ConfigurationView {
    private Store a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private POSTextField g;
    private FixedLengthTextField h;
    private POSTextField i;
    private JComboBox<EnumDateFormat> j;
    private JComboBox<Currency> k;
    private JComboBox l;
    private AutoCompletionComboBox m;
    private AutoCompletionComboBox n;
    private AutoCompletionComboBox o;
    private AddressUtil p;
    private JLabel q;
    private JLabel r;
    private JLabel s;
    private JLabel t;
    private JLabel u;
    private Outlet v;
    private List<Currency> w;
    private boolean x;

    public StoreConfigurationView(Store store, Outlet outlet) {
        this.a = store;
        this.v = outlet;
        this.p = new AddressUtil();
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][][grow]", ""));
        this.q = new JLabel(Messages.getString("RestaurantConfigurationView.3") + ":");
        jPanel.add((Component)this.q, "cell 0 1");
        this.b = new FixedLengthTextField();
        this.b.setLength(120);
        jPanel.add((Component)this.b, "cell 1 1 3 1,growx");
        this.r = new JLabel(Messages.getString("StoreConfigurationView.0") + Messages.getString("StoreConfigurationView.1"));
        jPanel.add((Component)this.r, "cell 0 2");
        this.c = new FixedLengthTextField();
        this.c.setLength(60);
        jPanel.add((Component)this.c, "cell 1 2 3 1,growx");
        JLabel jLabel = new JLabel(Messages.getString("RestaurantConfigurationView.7") + ":");
        jPanel.add((Component)jLabel, "cell 0 3");
        this.d = new FixedLengthTextField();
        this.d.setLength(60);
        jPanel.add((Component)this.d, "cell 1 3 3 1,growx");
        JLabel jLabel2 = new JLabel(Messages.getString("StoreConfigurationView.3") + ":");
        jPanel.add((Component)jLabel2, "cell 0 4");
        this.e = new FixedLengthTextField();
        this.e.setLength(60);
        jPanel.add((Component)this.e, "cell 1 4 3 1,growx");
        JLabel jLabel3 = new JLabel(Messages.getString("StoreConfigurationView.4") + ":");
        jPanel.add((Component)jLabel3, "cell 0 5");
        this.f = new FixedLengthTextField();
        this.f.setLength(60);
        jPanel.add((Component)this.f, "cell 1 5 3 1,growx");
        JLabel jLabel4 = new JLabel(Messages.getString("StoreConfigurationView.5") + ":");
        jPanel.add((Component)jLabel4, "cell 0 6");
        this.m = new AutoCompletionComboBox();
        this.m.setStrict(false);
        this.m.setModel(new DefaultComboBoxModel<Object>(this.p.getCountryNames().toArray()));
        jPanel.add((Component)this.m, "cell 1 6 3 1,growx");
        JLabel jLabel5 = new JLabel(Messages.getString("StoreConfigurationView.6") + ":");
        jPanel.add((Component)jLabel5, "cell 0 7");
        this.n = new AutoCompletionComboBox();
        this.n.setStrict(false);
        jPanel.add((Component)this.n, "cell 1 7 3 1,growx");
        JLabel jLabel6 = new JLabel(Messages.getString("StoreConfigurationView.7") + ":");
        jPanel.add((Component)jLabel6, "cell 0 8");
        this.o = new AutoCompletionComboBox();
        this.o.setStrict(false);
        jPanel.add((Component)this.o, "cell 1 8 3 1,growx");
        JLabel jLabel7 = new JLabel(Messages.getString("RestaurantConfigurationView.19"));
        jPanel.add((Component)jLabel7, "cell 0 9");
        this.h = new FixedLengthTextField(10);
        jPanel.add((Component)this.h, "cell 1 9,growx");
        JLabel jLabel8 = new JLabel(Messages.getString("RestaurantConfigurationView.22"));
        jPanel.add((Component)jLabel8, "cell 0 10");
        this.g = new POSTextField();
        jPanel.add((Component)this.g, "cell 1 10,growx");
        this.s = new JLabel(Messages.getString("StoreConfigurationView.2"));
        jPanel.add((Component)this.s, "cell 0 11");
        this.i = new POSTextField();
        jPanel.add((Component)this.i, "cell 1 11,growx");
        this.t = new JLabel(Messages.getString("DATE_FORMAT"));
        jPanel.add((Component)this.t, "cell 0 12");
        this.j = new JComboBox();
        jPanel.add(this.j, "cell 1 12,growx");
        this.u = new JLabel(Messages.getString("StoreConfigurationView.15"));
        jPanel.add((Component)this.u, "cell 0 13");
        this.k = new JComboBox();
        jPanel.add(this.k, "cell 1 13,growx");
        JLabel jLabel9 = new JLabel(Messages.getString("StoreConfigurationView.17"));
        jPanel.add((Component)jLabel9, "cell 0 14");
        this.l = new JComboBox();
        List<String> list = Arrays.asList(TimeZone.getAvailableIDs());
        this.l.setModel(new ComboBoxModel(list));
        jPanel.add((Component)this.l, "cell 1 14, growx");
        this.e();
        this.f();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add((Component)jScrollPane, "Center");
        boolean bl = Application.getInstance().getLicense().isDemoLicense();
        if (bl) {
            JPanel jPanel2 = POSUtil.doCreateDemoMessagePanel(String.format(Messages.getString("StoreConfigurationView.13"), VersionInfo.getAppName()));
            this.add((Component)jPanel2, "South");
            this.b();
        } else {
            this.m.addActionListener(actionEvent -> this.c());
            this.n.addActionListener(actionEvent -> this.d());
        }
    }

    private void b() {
        this.b.setEnabled(false);
        this.c.setEnabled(false);
        this.d.setEnabled(false);
        this.e.setEnabled(false);
        this.f.setEnabled(false);
        this.m.setEnabled(false);
        this.n.setEnabled(false);
        this.o.setEnabled(false);
        this.h.setEnabled(false);
        this.g.setEnabled(false);
        this.i.setEnabled(false);
        this.j.setEnabled(false);
    }

    private void c() {
        try {
            this.n.setEnabled(true);
            this.o.setEnabled(false);
            String string = (String)this.m.getSelectedItem();
            List<String> list = this.p.getStateNames(string);
            this.n.removeAllItems();
            this.o.removeAllItems();
            this.n.addItem(null);
            for (String string2 : list) {
                this.n.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void d() {
        try {
            this.o.setEnabled(true);
            String string = (String)this.m.getSelectedItem();
            String string2 = (String)this.n.getSelectedItem();
            List<String> list = this.p.getCityNames(string, string2);
            this.o.removeAllItems();
            this.o.addItem(null);
            for (String string3 : list) {
                this.o.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void e() {
        LinkedList<EnumDateFormat> linkedList = new LinkedList<EnumDateFormat>();
        linkedList.addAll(Arrays.asList(EnumDateFormat.values()));
        this.j.setModel(new ComboBoxModel(linkedList));
    }

    private void f() {
        this.w = CurrencyDAO.getInstance().findAll();
        this.k.setModel(new ComboBoxModel(this.w));
    }

    @Override
    public boolean save() throws Exception {
        Currency currency;
        if (!this.isInitialized()) {
            return true;
        }
        if (!this.validationComplete()) {
            return false;
        }
        String string = this.b.getText();
        String string2 = this.g.getText();
        String string3 = this.d.getText();
        String string4 = this.e.getText();
        String string5 = this.f.getText();
        String string6 = this.m.getSelectedItem() == null ? "" : this.m.getSelectedItem().toString();
        String string7 = this.n.getSelectedItem() == null ? "" : this.n.getSelectedItem().toString();
        String string8 = this.o.getSelectedItem() == null ? "" : this.o.getSelectedItem().toString();
        this.a.setName(string);
        String string9 = this.c.getText();
        if (StringUtils.isNotBlank((String)string9)) {
            this.a.setOutletName(string9);
            this.v.setName(string9);
        }
        this.v.setAddressLine1(string3);
        this.v.setAddressLine2(string4);
        this.v.setAddressLine3(string5);
        this.v.setCountry(string6);
        this.v.setState(string7);
        this.v.setCity(string8);
        this.v.setZipCode(this.h.getText());
        this.v.setTelephone(string2);
        this.v.setAdminEmail(this.i.getText());
        EnumDateFormat enumDateFormat = (EnumDateFormat)((Object)this.j.getSelectedItem());
        if (enumDateFormat != null) {
            this.a.setDateFormat(enumDateFormat.getFormat());
            this.v.setDateFormat(enumDateFormat.getFormat());
        }
        if ((currency = (Currency)this.k.getSelectedItem()) != null && !this.x) {
            this.v.setCurrency(currency);
            currency.setMain(true);
            CurrencyDAO.getInstance().saveOrUpdate(currency);
        }
        String string10 = (String)this.l.getSelectedItem();
        TimeZone timeZone = TimeZone.getTimeZone(string10);
        this.a.addProperty("time_zone", timeZone.getID());
        return true;
    }

    @Override
    public boolean validationComplete() {
        if (!this.isInitialized()) {
            return true;
        }
        String string = this.b.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.8"));
            this.b.requestFocus();
            this.b.selectAll();
            return false;
        }
        String string2 = this.c.getText();
        if (StringUtils.isBlank((String)string2) && StringUtils.isNotBlank((String)this.v.getName())) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.16"));
            this.d.requestFocus();
            this.d.selectAll();
            return false;
        }
        String string3 = this.d.getText();
        if (StringUtils.isBlank((String)string3)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.9"));
            this.d.requestFocus();
            this.d.selectAll();
            return false;
        }
        String string4 = this.g.getText();
        if (StringUtils.isNotBlank((String)string4) && !POSUtil.validatePhoneNo(string4)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.10"));
            this.g.requestFocus();
            this.g.selectAll();
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.i.getText()) && !this.a(this.i.getText())) {
            return false;
        }
        String string5 = (String)this.l.getSelectedItem();
        if (StringUtils.isBlank((String)string5)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.18"));
            return false;
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        String string;
        this.b.setText(this.a.getName());
        if (this.v != null) {
            this.c.setText(this.v.getName());
            this.d.setText(this.v.getAddressLine1());
            this.e.setText(this.v.getAddressLine2());
            this.f.setText(this.v.getAddressLine3());
            this.m.setSelectedItem((Object)this.v.getCountry());
            this.n.setSelectedItem((Object)this.v.getState());
            this.o.setSelectedItem((Object)this.v.getCity());
        }
        this.h.setText(this.v.getZipCode());
        this.g.setText(this.v.getTelephone());
        this.i.setText(this.v.getAdminEmail());
        this.j.setSelectedItem((Object)EnumDateFormat.get(this.a.getDateFormat()));
        if (this.w != null && this.w.size() > 0) {
            this.k.setSelectedItem(this.v.getCurrency());
        }
        if (StringUtils.isNotBlank((String)(string = this.a.getProperty("time_zone")))) {
            this.l.setSelectedItem(string);
        } else {
            this.l.setSelectedItem(TimeZone.getDefault().getID());
        }
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }

    public Store getStore() {
        return this.a;
    }

    public void hideNonAddressFields() {
        this.q.setVisible(false);
        this.b.setVisible(false);
        this.r.setVisible(false);
        this.c.setVisible(false);
        this.s.setVisible(false);
        this.i.setVisible(false);
        this.u.setVisible(false);
        this.k.setVisible(false);
        this.x = true;
    }

    private boolean a(String string) {
        if (!EmailValidator.getInstance().isValid(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return true;
    }
}

