/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.TerminalForm;
import com.floreantpos.config.ui.CardConfigurationView;
import com.floreantpos.config.ui.CashDrawerConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DatabaseConfigurationView;
import com.floreantpos.config.ui.FontsConfigurationView;
import com.floreantpos.config.ui.GiftCardConfigurationView;
import com.floreantpos.config.ui.PaymentOptionConfigurationView;
import com.floreantpos.config.ui.PeripheralConfigurationView;
import com.floreantpos.config.ui.PrintConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class TerminalConfigurationDialog
extends POSDialog
implements ActionListener,
ChangeListener {
    private static final String a = POSConstants.OK;
    private static final String b = POSConstants.CANCEL;
    private JTabbedPane c = new JTabbedPane();
    private Terminal d;

    public TerminalConfigurationDialog() {
        this(DataProvider.get().getCurrentTerminal());
    }

    public TerminalConfigurationDialog(Terminal terminal) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        boolean bl;
        this.d = terminal;
        boolean bl2 = bl = this.d.getId() == DataProvider.get().getCurrentTerminal().getId();
        if (bl) {
            this.setTitle(POSConstants.CONFIGURE_WINDOW_TITLE);
        } else {
            this.setTitle("Configure Terminal " + terminal.getId());
        }
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.c.addChangeListener(this);
        jPanel.add((Component)this.c, "span, grow");
        this.addView(new TerminalForm(this.d));
        this.addView(new PrintConfigurationView(this.d));
        if (DataProvider.get().getCurrentTerminal().equals(this.d)) {
            this.addView(new CardConfigurationView());
            this.addView(new DatabaseConfigurationView());
            this.addView(new PeripheralConfigurationView());
            this.addView(new GiftCardConfigurationView());
            DataProvider.get().refreshCurrentTerminal();
            this.addView(new PaymentOptionConfigurationView(DataProvider.get().getCurrentTerminal()));
            this.addView(new CashDrawerConfigurationView());
            this.addView(new FontsConfigurationView());
        }
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton jButton = new JButton(b);
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton jButton2 = new JButton(a);
        jButton2.addActionListener(this);
        jPanel2.add((Component)jButton2, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
        for (FloreantPlugin floreantPlugin : ExtensionManager.getPlugins()) {
            floreantPlugin.initConfigurationView(this);
        }
        this.add((Component)jPanel, "Center");
    }

    public void addView(ConfigurationView configurationView) {
        this.c.addTab(configurationView.getName(), configurationView);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ConfigurationView configurationView = (ConfigurationView)this.c.getSelectedComponent();
        if (!configurationView.isInitialized()) {
            try {
                configurationView.initialize();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (a.equalsIgnoreCase(actionEvent.getActionCommand())) {
            try {
                int n = this.c.getTabCount();
                ConfigurationView configurationView = (ConfigurationView)this.c.getSelectedComponent();
                int n2 = this.c.getSelectedIndex();
                if (!configurationView.save()) {
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    ConfigurationView configurationView2;
                    Component component = this.c.getComponentAt(i);
                    if (!(component instanceof ConfigurationView) || i == n2 || !(configurationView2 = (ConfigurationView)component).isInitialized() || configurationView2.save()) continue;
                    this.c.setSelectedComponent(configurationView2);
                    return;
                }
                OroMqttClient.getInstance().notifyDataUpdated(Terminal.class);
                this.setCanceled(false);
                this.dispose();
            }
            catch (StaleStateException staleStateException) {
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, staleStateException);
            }
            catch (PosException posException) {
                POSMessageDialog.showError(this, posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        } else if (b.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.setCanceled(true);
            this.dispose();
        }
    }
}

