/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customPayment;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.customPayment.InputPromptModel;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleObjectStateException;

public class CustomPaymentForm
extends BeanEditor<CustomPayment> {
    private JLabel a;
    private FixedLengthTextField b;
    private JCheckBox c;
    private JCheckBox d;
    private JList<InputPromptModel> e;
    private List<InputPromptModel> f;
    private DefaultListModel<InputPromptModel> g;
    private JButton h;
    private TransparentPanel i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;

    public CustomPaymentForm() {
        this.a();
    }

    public CustomPaymentForm(CustomPayment customPayment) {
        this.a();
        this.setBean(customPayment);
    }

    private void a() {
        this.a = new JLabel(Messages.getString("NAME"));
        this.b = new FixedLengthTextField(60);
        this.c = new JCheckBox(Messages.getString("CustomPaymentForm.3"));
        this.c.setSelected(true);
        this.d = new JCheckBox(Messages.getString("CustomPaymentForm.7"));
        this.d.setSelected(true);
        this.e = new JList();
        this.g = new DefaultListModel();
        this.e.setModel(this.g);
        this.e.setSelectionMode(0);
        this.e.setFixedCellHeight(PosUIManager.getSize((int)30));
        this.e.setFocusable(false);
        this.e.setSelectionBackground(new Color(38, 117, 191));
        this.e.setSelectionForeground(Color.WHITE);
        this.h = new JButton(POSConstants.ADD_BUTTON_TEXT);
        this.h.addActionListener(actionEvent -> {
            String string = GlobalInputDialog.showInputDialog("Input field name");
            if (StringUtils.isNotBlank((String)string)) {
                InputPromptModel inputPromptModel = new InputPromptModel(string);
                this.g.addElement(inputPromptModel);
            }
        });
        this.m = new JButton(POSConstants.EDIT);
        this.m.addActionListener(actionEvent -> {
            InputPromptModel inputPromptModel = this.e.getSelectedValue();
            if (inputPromptModel == null) {
                return;
            }
            String string = GlobalInputDialog.showInputDialog("Input field name", inputPromptModel.getFieldName());
            if (StringUtils.isNotBlank((String)string)) {
                inputPromptModel.setFieldName(string);
            }
        });
        this.l = new JButton(POSConstants.DELETE);
        this.l.addActionListener(actionEvent -> {
            int n = this.e.getSelectedIndex();
            if (n < 0) {
                return;
            }
            this.g.remove(n);
        });
        this.j = new JButton();
        this.j.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.j.addActionListener(actionEvent -> this.d());
        this.k = new JButton();
        this.k.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.k.addActionListener(actionEvent -> this.c());
        this.i = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        this.i.setBorder(new TitledBorder("Input Prompt"));
        this.i.add((Component)new JScrollPane(this.e), "north");
        this.i.add((Component)this.h, "left, split 3");
        this.i.add(this.m);
        this.i.add(this.l);
        this.i.add((Component)this.j, "split 2, right, gapy " + PosUIManager.getSize((int)5) + "! " + PosUIManager.getSize((int)3) + "!");
        this.i.add((Component)this.k, "gapy " + PosUIManager.getSize((int)5) + "! " + PosUIManager.getSize((int)3) + "!");
        this.setLayout((LayoutManager)new MigLayout("fillx, hidemode 3", "[][]", ""));
        this.add((Component)this.a, "");
        this.add((Component)this.b, "growx, wrap");
        this.add((Component)this.i, "skip 1, growx, wrap");
        this.add((Component)this.c, "skip 1, wrap");
        this.add((Component)this.d, "skip 1, wrap");
        this.b.setEnabled(false);
        this.c.setEnabled(false);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
        this.i.setEnabled(bl);
        this.e.setEnabled(bl);
        this.h.setEnabled(bl);
        this.m.setEnabled(bl);
        this.l.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new CustomPayment());
        this.c.setSelected(true);
        this.d.setSelected(true);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            CustomPayment customPayment = (CustomPayment)this.getBean();
            CustomPaymentDAO.getInstance().saveOrUpdate(customPayment);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("CustomPaymentForm.10"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        this.b.setText(customPayment.getName());
        this.c.setSelected(customPayment.isEnable());
        this.d.setSelected(customPayment.isConfirmPaymentImmediately());
        this.f = customPayment.getInputPromptList();
        if (this.f.isEmpty() && customPayment.isRequiredRefNumber().booleanValue()) {
            this.f.add(new InputPromptModel(customPayment.getRefNumberFieldName()));
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.e.getModel();
        defaultListModel.removeAllElements();
        for (InputPromptModel inputPromptModel : this.f) {
            defaultListModel.addElement(inputPromptModel);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        if (StringUtils.isBlank((String)this.b.getText())) {
            POSMessageDialog.showMessage(null, Messages.getString("CustomPaymentForm.12"));
            return false;
        }
        String string = this.b.getText().trim();
        if (CustomPaymentDAO.getInstance().nameExists(string, customPayment.getId())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_ALREADY_EXISTS);
            return false;
        }
        customPayment.setName(string);
        customPayment.setEnable(this.c.isSelected());
        this.f.clear();
        for (int i = 0; i < this.g.getSize(); ++i) {
            InputPromptModel inputPromptModel = this.g.get(i);
            inputPromptModel.setSortOrder(i);
            this.f.add(inputPromptModel);
        }
        customPayment.putInputFieldNameJson(new Gson().toJson(this.f));
        customPayment.setEnable(this.c.isSelected());
        customPayment.setConfirmPaymentImmediately(this.d.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            CustomPayment customPayment = (CustomPayment)this.getBean();
            if (customPayment == null) {
                return false;
            }
            String string = Messages.getString("CustomPaymentForm.2");
            String string2 = Messages.getString("CustomPaymentForm.4");
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string);
            if (n != 0) {
                return false;
            }
            this.g.removeAllElements();
            CustomPaymentDAO.getInstance().delete(customPayment);
            this.b();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    private void b() {
        this.b.setText("");
        this.c.setSelected(false);
        this.d.setSelected(false);
    }

    @Override
    public void cancel() {
        this.updateView();
    }

    @Override
    public String getDisplayText() {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        if (customPayment.getId() == null) {
            return Messages.getString("CustomPaymentForm.5");
        }
        return Messages.getString("CustomPaymentForm.6");
    }

    private void c() {
        int n = this.e.getSelectedIndex();
        if (n == -1) {
            return;
        }
        int n2 = this.g.getSize() - 1 == n ? n : n + 1;
        this.a(n, n2);
        this.e.setSelectedIndex(n2);
    }

    private void d() {
        int n = this.e.getSelectedIndex();
        if (n == -1) {
            return;
        }
        int n2 = n == 0 ? 0 : n - 1;
        this.a(n, n2);
        this.e.setSelectedIndex(n2);
    }

    private void a(int n, int n2) {
        if (n == n2) {
            return;
        }
        InputPromptModel inputPromptModel = this.g.remove(n);
        this.g.add(n2, inputPromptModel);
    }
}

