/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.jdbc.Work;

public class UpdateDBTo239 {
    private SessionFactory a;

    public UpdateDBTo239(SessionFactory sessionFactory) {
        this.a = sessionFactory;
    }

    public void update() throws Exception {
        this.a.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try {
                    UpdateDBTo239.this.a(connection);
                    UpdateDBTo239.this.a();
                }
                catch (Exception exception) {
                    throw new PosException(exception.getMessage(), exception);
                }
            }
        });
    }

    private void a(Connection connection) throws SQLException, IOException {
        try {
            connection.setAutoCommit(false);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = DatabaseUtil.getActualTableName(databaseMetaData, "TICKET_ITEM_MODIFIER_RELATION");
            String string2 = DatabaseUtil.getActualTableName(databaseMetaData, "TICKET_ITEM_MODIFIER");
            String string3 = DatabaseUtil.getActualColumnName(databaseMetaData, string2, "ID");
            String string4 = DatabaseUtil.getActualColumnName(databaseMetaData, string, "MODIFIER_ID");
            String string5 = DatabaseUtil.getActualColumnName(databaseMetaData, string2, "ITEM_QUANTITY");
            try (Statement statement = connection.createStatement();){
                String string6 = "delete from %s where %s != 0 and %s not in (select %s from %s)";
                string6 = String.format(string6, string2, string5, string3, string4, string);
            }
            PosLog.debug(this.getClass(), "Updating modifier table successful.\n");
            connection.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a() throws IOException {
        DataProvider.get().initialize();
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.setProjection(Projections.rowCount());
            int n = POSUtil.getInteger(criteria.uniqueResult());
            GlassPane glassPane = (GlassPane)Application.getPosWindow().getGlassPane();
            glassPane.showMessage("Converting data to new format, this may take a while");
            glassPane.setProgressMaximum(n);
            int n2 = 1000;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; i += n2) {
                criteria = session.createCriteria(Ticket.class);
                criteria.addOrder(Order.asc((String)Ticket.PROP_ID));
                criteria.setFirstResult(i);
                criteria.setMaxResults(n2);
                List list = criteria.list();
                Transaction transaction = session.beginTransaction();
                for (Ticket ticket : list) {
                    Comparable comparable;
                    double d = ticket.getDueAmount();
                    boolean bl = ticket.getServiceCharge() > 0.0;
                    List<TicketItem> list2 = ticket.getTicketItems();
                    for (TicketItem object2 : list2) {
                        object2.setServiceChargeApplicable(true);
                        object2.setDataVersion(1);
                        if (object2.getCreateDate() == null || object2.getCreateDate().compareTo(ticket.getCreateDate()) < 0) {
                            object2.setCreateDate(ticket.getCreateDate());
                        }
                        if (!ticket.isClosed().booleanValue() || object2.isVoided().booleanValue()) continue;
                        object2.setPaid(true);
                    }
                    Set<PosTransaction> set = ticket.getTransactions();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        comparable = (PosTransaction)iterator.next();
                        ((BasePosTransaction)comparable).setServiceChargeAmount(0.0);
                        ((BasePosTransaction)comparable).setTaxAmount(0.0);
                        ((BasePosTransaction)comparable).setDataVersion(1);
                        ((BasePosTransaction)comparable).setFeeAmount(POSUtil.getDoubleAmount(((PosTransaction)comparable).getExtraProperty("transactionFee")));
                        if (((BasePosTransaction)comparable).getTransactionTime() != null && ((BasePosTransaction)comparable).getTransactionTime().compareTo(ticket.getCreateDate()) >= 0) continue;
                        ((BasePosTransaction)comparable).setTransactionTime(ticket.getCreateDate());
                    }
                    if (bl) {
                        ticket.setServiceChargeApplicable(true);
                        Double d2 = ticket.getSubtotalAmount();
                        comparable = ticket.getDiscountAmount();
                        Double d3 = ticket.getServiceCharge();
                        double d4 = d3 * 100.0 / (d2 - (Double)comparable);
                        ticket.setOutletServiceChargeRate(d4);
                    } else {
                        ticket.setServiceChargeApplicable(false);
                    }
                    ticket.calculatePrice();
                    double d4 = ticket.getDueAmount();
                    if (ticket.isClosed().booleanValue() && d == 0.0 && d != d4) {
                        ticket.setOldDataTolerance(d4 - d);
                        ticket.calculatePrice();
                    }
                    ticket.setDataVersion(1);
                    TicketDAO.getInstance().update(ticket, session);
                    glassPane.setProgress(n3++);
                }
                transaction.commit();
                PosLog.debug(this.getClass(), String.format("converted %s tickets", n4 += list.size()));
            }
        }
    }

    private void a(PrintWriter printWriter) {
        try {
            List list;
            VoidItem voidItem2;
            List<VoidItem> list2 = VoidItemDAO.getInstance().findAll();
            if (list2 == null || list2.isEmpty()) {
                return;
            }
            HashMap hashMap = new HashMap();
            for (VoidItem voidItem2 : list2) {
                list = (List)hashMap.get(voidItem2.getTicketId());
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(voidItem2.getTicketId(), list);
                }
                list.add(voidItem2);
            }
            Transaction transaction = null;
            voidItem2 = TicketItemDAO.getInstance().createNewSession();
            list = null;
            try {
                transaction = voidItem2.beginTransaction();
                for (String string : hashMap.keySet()) {
                    List list3;
                    Ticket ticket = TicketDAO.getInstance().get(string, (Session)voidItem2);
                    if (ticket == null || (list3 = (List)hashMap.get(string)) == null || list3.size() <= 0) continue;
                    List<TicketItem> list4 = ticket.getTicketItems();
                    block13: for (TicketItem ticketItem : list4) {
                        for (VoidItem voidItem3 : list3) {
                            if (!ticketItem.isVoided().booleanValue() || ticketItem.getMenuItemId() == null || !ticketItem.getMenuItemId().equals(voidItem3.getMenuItemId()) || voidItem3.getTicketId() == null || !voidItem3.getTicketId().equals(ticket.getId())) continue;
                            ticketItem.setItemReturned(ticketItem.isReturned());
                            ticketItem.setVoidReason(voidItem3.getVoidReason());
                            ticketItem.setItemWasted(voidItem3.isItemWasted());
                            ticketItem.addProperty("voidedByUser", voidItem3.getVoidByUserId());
                            TicketItemDAO.getInstance().update(ticketItem, (Session)voidItem2);
                            continue block13;
                        }
                    }
                }
                transaction.commit();
            }
            catch (Throwable throwable) {
                list = throwable;
                throw throwable;
            }
            finally {
                if (voidItem2 != null) {
                    if (list != null) {
                        try {
                            voidItem2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)list)).addSuppressed(throwable);
                        }
                    } else {
                        voidItem2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            printWriter.write("Could not update voided ticket items");
        }
    }
}

