/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.CloudSyncPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.server.BaseDataServiceDao;
import com.sun.jersey.api.client.ClientHandlerException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CloudAutoSyncJob
extends CronJob {
    public static final String CLOUD_AUTO_SYNC_ID = "cloud_auto_sync";
    public static final String CLOUD_AUTO_SYNC_NAME = "Cloud auto sync";

    public CloudAutoSyncJob() {
        this.setId(CLOUD_AUTO_SYNC_ID);
        this.setJobId(CLOUD_AUTO_SYNC_ID);
        this.setJobName(CLOUD_AUTO_SYNC_NAME);
        this.setFrequency("EVERY");
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
        synchronized (baseDataServiceDao) {
            PosWindow posWindow = Application.getPosWindow();
            posWindow.setProgressType(PosWindow.ProgressType.SYNC);
            try {
                CloudSyncPlugin cloudSyncPlugin = (CloudSyncPlugin)ExtensionManager.getPlugin(CloudSyncPlugin.class);
                if (cloudSyncPlugin == null || !cloudSyncPlugin.hasValidLicense()) {
                    return;
                }
                Boolean bl = DataProvider.get().getCurrentTerminal().isMasterTerminal();
                if (!bl.booleanValue()) {
                    return;
                }
                if (!PosWebService.get().checkIsConnectedToHost()) {
                    return;
                }
                posWindow.updateVisibilityOfProgressObserver(true);
                PosLog.debug(this.getClass(), "Starting cloud sync.....");
                SyncService.sync(posWindow);
                PosLog.debug(this.getClass(), "Finished cloud sync.....");
            }
            catch (ClientHandlerException clientHandlerException) {
                PosLog.debug(this.getClass(), "Cloud sync connection failed.");
                posWindow.progressComplete(false);
            }
            catch (Exception exception) {
                PosLog.debug(this.getClass(), "Connection lost");
                posWindow.progressComplete(false);
            }
        }
    }
}

