/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.bo.actions.DatabaseBackupAction;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.export_import.service.DataBackupService;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DbAutoBackupJob
extends CronJob {
    public static final String DB_AUTO_BACKUP = "db_auto_backup";
    public static final String DB_AUTO_BACKUP_NAME = "Db auto backup";
    private static boolean b = false;

    public DbAutoBackupJob() {
        this.setId(DB_AUTO_BACKUP);
        this.setJobId(DB_AUTO_BACKUP);
        this.setJobName(DB_AUTO_BACKUP_NAME);
        this.setFrequency("DAILY");
    }

    public DbAutoBackupJob(String string) {
        this();
        this.setExecutionTime(string);
    }

    @Override
    public synchronized void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PosWindow posWindow = Application.getPosWindow();
        posWindow.setProgressType(PosWindow.ProgressType.BACKUP);
        try {
            Object object;
            if (b) {
                return;
            }
            b = true;
            posWindow.updateVisibilityOfProgressObserver(true);
            PosLog.debug(this.getClass(), "Starting database backup.....");
            String string = DataProvider.get().getCurrentTerminal().getAutoDbBackupPath();
            File file = new File(string);
            if (file.exists()) {
                object = new File(file.getParent(), "old_" + file.getName());
                Files.copy((File)file, (File)object);
            }
            if (StringUtils.isBlank((CharSequence)(object = FilenameUtils.getExtension((String)file.getName()))) || !".orodb".endsWith((String)object)) {
                String string2 = String.format("backup_%s.orodb", DatabaseBackupAction.BACKUP_FILE_NAME);
                file = new File(file.getAbsolutePath(), string2);
            }
            new DataBackupService(posWindow, file).startBackup();
            PosLog.debug(this.getClass(), "Finished database backup.....");
            b = false;
        }
        catch (Exception exception) {
            b = false;
            PosLog.error(this.getClass(), exception);
            posWindow.progressComplete(false);
        }
    }
}

