/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.NumberUtil;
import com.orocube.common.util.TicketStatus;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeliveryOrderKitchenSendingJob
extends CronJob {
    private static boolean b = false;

    public DeliveryOrderKitchenSendingJob() {
        this.setId("delivery-kitchen-sender");
        this.setJobName("Auto kitchen sending job");
        this.setFrequency("Every");
        this.setExecutionTime("-1:1");
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            Store store = DataProvider.get().getStore();
            if (store == null) {
                return;
            }
            if (!store.isAutoSendOrdersToKitchen()) {
                return;
            }
            PosLog.debug(this.getClass(), "executing kitchen sending job");
            if (b) {
                PosLog.debug(this.getClass(), "another kitchen sending job is running, returning...");
                return;
            }
            b = true;
            String string = store.getProperty("deliveryConfig.preperationTime");
            int n = NumberUtil.parseOrGetZero(string).intValue();
            List<Ticket> list = TicketDAO.getInstance().findTicketsToSendToKitchen(n);
            for (Ticket ticket : list) {
                OrderType orderType;
                if (ticket.getTicketStatus() == TicketStatus.Pending || (orderType = ticket.getOrderType()) == null || !orderType.isShouldPrintToKitchen().booleanValue()) continue;
                TicketDAO.getInstance().loadFullTicket(ticket);
                ReceiptPrintService.printToKitchen(ticket);
            }
            b = false;
            PosLog.debug(this.getClass(), "kitchen sending job done");
        }
        catch (Exception exception) {
            b = false;
            PosLog.error(this.getClass(), exception.getMessage());
        }
    }
}

