/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseComboGroup;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ComboGroup
extends BaseComboGroup
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROP_ITEM_MODIFIED_PRICE = "itemModifiedPrices";
    public static final String JSON_PROP_MENU_ITEM_PRICE = "price";
    public static final String JSON_PROP_MENU_ITEM_ID = "menuItemId";
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private List<String> itemsId;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ComboGroup() {
    }

    public ComboGroup(String string) {
        super(string);
    }

    public List<String> getItemsId() {
        return this.itemsId;
    }

    public void setItemsId(List<String> list) {
        this.itemsId = list;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public void addItemPrice(String string, String string2) {
        JsonObject jsonObject;
        JsonArray jsonArray;
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        if ((jsonArray = this.propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE)) == null) {
            jsonArray = new JsonArray();
        }
        if ((jsonObject = this.getItemJsonObject(string, jsonArray)) == null) {
            jsonObject = new JsonObject();
            jsonObject.addProperty(JSON_PROP_MENU_ITEM_ID, string);
            jsonObject.addProperty(JSON_PROP_MENU_ITEM_PRICE, string2);
            jsonArray.add((JsonElement)jsonObject);
        } else {
            jsonObject.remove(JSON_PROP_MENU_ITEM_PRICE);
            jsonObject.addProperty(JSON_PROP_MENU_ITEM_PRICE, string2);
        }
        this.propertiesContainer.add(JSON_PROP_ITEM_MODIFIED_PRICE, (JsonElement)jsonArray);
    }

    public String getItemPriceDisplay(String string) {
        String string2 = "0%";
        if (this.propertiesContainer == null) {
            return string2;
        }
        JsonArray jsonArray = this.propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE);
        if (jsonArray == null || jsonArray.isJsonNull()) {
            return string2;
        }
        for (JsonElement jsonElement : jsonArray) {
            JsonElement jsonElement2;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (jsonElement2 = jsonObject.get(JSON_PROP_MENU_ITEM_ID)) == null || !jsonElement2.getAsString().equals(string)) continue;
            JsonElement jsonElement3 = jsonObject.get(JSON_PROP_MENU_ITEM_PRICE);
            if (jsonElement3 == null) {
                return string2;
            }
            if (!jsonElement3.getAsString().contains("%")) {
                return NumberUtil.formatNumber(NumberUtil.parseOrGetZero(jsonElement3.getAsString()).doubleValue(), true);
            }
            return jsonElement3.getAsString();
        }
        return string2;
    }

    private JsonObject getItemJsonObject(String string, JsonArray jsonArray) {
        if (!jsonArray.isJsonNull()) {
            for (JsonElement jsonElement : jsonArray) {
                JsonElement jsonElement2;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject == null || (jsonElement2 = jsonObject.get(JSON_PROP_MENU_ITEM_ID)) == null || !jsonElement2.getAsString().equals(string)) continue;
                return jsonObject;
            }
        }
        return null;
    }

    public void putSortOrder(int n) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        this.addProperty("sort_order", String.valueOf(n));
    }

    public int getSortOrder() {
        return this.getIntProperty("sort_order", 0);
    }

    public void putChildItemSortOrder(String string, int n) {
        JsonObject jsonObject;
        JsonArray jsonArray;
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        if ((jsonArray = this.propertiesContainer.getAsJsonArray("combo_group_items_sort_order")) == null) {
            jsonArray = new JsonArray();
        }
        if ((jsonObject = this.getItemJsonObject(string, jsonArray)) == null) {
            jsonObject = new JsonObject();
            jsonObject.addProperty(JSON_PROP_MENU_ITEM_ID, string);
            jsonObject.addProperty("sort_order", (Number)n);
            jsonArray.add((JsonElement)jsonObject);
        } else {
            jsonObject.remove("sort_order");
            jsonObject.addProperty("sort_order", (Number)n);
        }
        this.propertiesContainer.add("combo_group_items_sort_order", (JsonElement)jsonArray);
    }

    public int getChildItemSortOrder(String string) {
        int n = 0;
        if (this.propertiesContainer == null) {
            return n;
        }
        JsonArray jsonArray = this.propertiesContainer.getAsJsonArray("combo_group_items_sort_order");
        if (jsonArray == null || jsonArray.isJsonNull()) {
            return n;
        }
        for (JsonElement jsonElement : jsonArray) {
            JsonElement jsonElement2;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (jsonElement2 = jsonObject.get(JSON_PROP_MENU_ITEM_ID)) == null || !jsonElement2.getAsString().equals(string)) continue;
            JsonElement jsonElement3 = jsonObject.get("sort_order");
            if (jsonElement3 == null) {
                return n;
            }
            return POSUtil.parseInteger(jsonElement3.getAsString());
        }
        return n;
    }
}

