/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"deliveryAddresses", "deliveryInstructions"})
@XmlRootElement
public class Customer
extends BaseCustomer
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String APPETIZER_PREF = "appetizerPref";
    public static final String BILLINGSTATEMENT_PREF = "billingStatementPref";
    public static final String COCKTAIL_PREF = "cocktailPref";
    public static final String DESSERT_PREF = "dessertPref";
    public static final String ENTREE_PREF = "entreePref";
    public static final String GOLFBALL_PREF = "golfBallPref";
    public static final String MEAL_PREF = "mealPref";
    public static final String PAYMENT_PREF = "paymentPref";
    public static final String PILLOW_PREF = "pillowPref";
    public static final String ROLLAWAYCRIB_PREF = "rollawayCribPref";
    public static final String SEATING_PREF = "seatingPref";
    public static final String SMOKING_PREF = "smokingPref";
    public static final String WINE_PREF = "winePref";
    public static final String ROOM_ACCESS_PREF = "roomAccessPref";
    public static final String ROOM_LOC_PREF = "roomLocPref";
    public static final String ROOM_NUMBER_PREF = "roomNumberPref";
    public static final String REMAINING_CURRENT_QUARTER = "club62__Remaining_Current_Quarter_F_B_Spends__c";
    public static final String STATUS = "club62__Status__c";
    public static final String STREET_1 = "street_1";
    public static final String STREET_2 = "street_2";
    public static final String STREET_3 = "street_3";
    private Boolean selected;
    private transient JsonObject propertiesContainer;
    private String membershipTypeDisplayString;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private String customerGroupName;
    private String customerNo;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public Customer() {
    }

    public Customer(String string) {
        super(string);
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = this.getEmail();
        }
        return string;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String string = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            string = string + " " + super.getLastName();
        }
        return string;
    }

    @Override
    public void setMobileNo(String string) {
        super.setMobileNo(string);
    }

    @Override
    public void setWorkPhoneNo(String string) {
        super.setWorkPhoneNo(string);
    }

    @Override
    public void setHomePhoneNo(String string) {
        super.setHomePhoneNo(string);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean bl) {
        this.selected = bl;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return (CustomerGroup)DataProvider.get().getObjectOf(CustomerGroup.class, (Serializable)((Object)this.getCustomerGroupId()));
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String string = null;
        if (customerGroup != null) {
            string = customerGroup.getId();
        }
        super.setCustomerGroupId(string);
    }

    public void setEncryptedSecretCode(String string) {
        try {
            this.setSecretCode(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            this.setSecretCode(string);
        }
    }

    public String getUnencryptedSecretCode() {
        String string = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public void setEncryptedPin(String string) {
        try {
            this.setPin(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            this.setPin(string);
        }
    }

    public String getUnencryptedPin() {
        String string = this.getPin();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        if (StringUtils.isNotEmpty((String)string)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.propertiesContainer.addProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    @XmlTransient
    @JsonIgnore
    public String getMembershipTypeDisplayString() {
        if (!this.isMember().booleanValue()) {
            return null;
        }
        if (StringUtils.isBlank((String)super.getMembershipType())) {
            return null;
        }
        if (this.membershipTypeDisplayString != null) {
            return this.membershipTypeDisplayString;
        }
        Attribute attribute = AttributeDAO.getInstance().get(super.getMembershipType());
        if (attribute == null) {
            return null;
        }
        return attribute.getName();
    }

    public void setMembershipTypeDisplayString(String string) {
        this.membershipTypeDisplayString = string;
    }

    @XmlTransient
    @JsonIgnore
    public String getCustomerGroupName() {
        return this.customerGroupName;
    }

    public void setCustomerGroupName(String string) {
        this.customerGroupName = string;
    }

    @XmlTransient
    @JsonIgnore
    public String getMembershipTypeName() {
        if (StringUtils.isBlank((String)super.getMembershipType())) {
            return "";
        }
        Attribute attribute = (Attribute)DataProvider.get().getObjectOf(Attribute.class, (Serializable)((Object)super.getMembershipType()));
        if (attribute == null) {
            return "";
        }
        return attribute.getName();
    }

    public void setMembershipTypeName(String string) {
    }

    @XmlTransient
    @JsonIgnore
    public String getCustomerGroupNames() {
        List<CustomerGroup> list = DataProvider.get().getCustomerGroups(this);
        if (list != null && !list.isEmpty()) {
            return POSUtil.createStringByField(list, CustomerGroup.class, "getName");
        }
        return "";
    }

    public void setCustomerGroupNames(String string) {
    }

    public void putCustomerNo(String string) {
        this.customerNo = string;
    }

    @XmlTransient
    @JsonIgnore
    public String getCustomerNo() {
        return this.customerNo;
    }

    public static enum MemberType {
        MEMBER(0, "Member"),
        GUEST(1, "Guest"),
        EMPLOYEE(2, "Employee"),
        STORE_OWNER(3, "StoreOwner");

        private int typeInt;
        private String name;

        private MemberType(int n2, String string2) {
            this.typeInt = n2;
            this.name = string2;
        }

        public int getTypeInt() {
            return this.typeInt;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static MemberType fromInt(int n) {
            MemberType[] memberTypeArray;
            for (MemberType memberType : memberTypeArray = MemberType.values()) {
                if (memberType.getTypeInt() != n) continue;
                return memberType;
            }
            return MEMBER;
        }

        public static MemberType fromName(String string) {
            MemberType[] memberTypeArray;
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            for (MemberType memberType : memberTypeArray = MemberType.values()) {
                if (!memberType.getName().equalsIgnoreCase(string)) continue;
                return memberType;
            }
            return null;
        }
    }
}

