/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseDiscount;
import com.floreantpos.model.ext.DiscountCondition;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"originalValue", "discountCondition"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Discount
extends BaseDiscount
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private static final String LOYALTY_DISCOUNT_ID = "loyalty_discount";
    public static final String LOYALTY_DISCOUNT_NAME = "Loyalty";
    public static final String LOYALTY_DISCOUNT_BARCODE = "loyalty";
    public static final int FREE_AMOUNT = 0;
    public static final int FIXED_PER_CATEGORY = 1;
    public static final int FIXED_PER_ITEM = 2;
    public static final int FIXED_PER_ORDER = 3;
    public static final int PERCENTAGE_PER_CATEGORY = 4;
    public static final int PERCENTAGE_PER_ITEM = 5;
    public static final int PERCENTAGE_PER_ORDER = 6;
    public static final int DISCOUNT_TYPE_AMOUNT = 0;
    public static final int DISCOUNT_TYPE_PERCENTAGE = 1;
    public static final int DISCOUNT_TYPE_REPRICE = 2;
    public static final int DISCOUNT_TYPE_LOYALTY = 3;
    public static final int DISCOUNT_TYPE_ALT_PRICE = 4;
    public static final int QUALIFICATION_TYPE_ITEM = 0;
    public static final int QUALIFICATION_TYPE_ORDER = 1;
    public static final String[] COUPON_TYPE_NAMES = new String[]{"AMOUNT", "PERCENTAGE", "REPRICE", "LOYALTY"};
    public static final String[] COUPON_QUALIFICATION_NAMES = new String[]{"ITEM", "ORDER"};
    @XmlTransient
    private List<String> menuItemIds;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private double originalValue;
    private transient JsonObject propertiesContainer;

    public Discount() {
    }

    public Discount(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public double calculateDiscount(ITicketItem iTicketItem) {
        Double d = iTicketItem.getUnitPrice();
        switch (this.getType()) {
            case 0: {
                return d;
            }
            case 1: {
                if (d != null) {
                    return this.getValue() * d / 100.0;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getAmountByType(double d) {
        switch (this.getType()) {
            case 0: {
                return d - this.getValue();
            }
            case 1: {
                return d - this.getValue() / 100.0;
            }
        }
        return 0.0;
    }

    @XmlTransient
    public List<String> getMenuItemIds() {
        return this.menuItemIds;
    }

    public void setMenuItemIds(List<String> list) {
        this.menuItemIds = list;
    }

    public static String getLoyaltyDiscountId() {
        return LOYALTY_DISCOUNT_ID;
    }

    public String getTypeName() {
        return COUPON_TYPE_NAMES[this.getType()];
    }

    public void setTypeName(String string) {
    }

    public String getQualificationName() {
        return COUPON_QUALIFICATION_NAMES[this.getQualificationType()];
    }

    public void setQualificationName(String string) {
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    @XmlTransient
    public double getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(double d) {
        this.originalValue = d;
    }

    @XmlTransient
    public boolean isExpired() {
        if (this.isNeverExpire().booleanValue()) {
            return Boolean.FALSE;
        }
        Date date = this.getExpiryDate();
        Date date2 = new Date();
        if (date != null && (date.compareTo(date2) < 0 || date.compareTo(date2) == 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setDiscountCondition(DiscountCondition discountCondition) {
        if (discountCondition != null) {
            this.addProperty("discount.condition", discountCondition.name());
        } else {
            this.removeProperty("discount.condition");
        }
    }

    @XmlTransient
    public DiscountCondition getDiscountCondition() {
        String string = this.getProperty("discount.condition");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return DiscountCondition.fromValue(string);
    }
}

