/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseInventoryTransaction;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"unitCostDisplay", "vendor", "toInventoryLocation", "fromInventoryLocation", "transactionDateAsString"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class InventoryTransaction
extends BaseInventoryTransaction
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_FROM_LOC = "fromInventoryLocation";
    public static final String PROPERTY_TO_LOC = "toInventoryLocation";
    public static final String REASON_NEW_STOCK = "NEW STOCK";
    public static final String REASON_RETURN = "RETURN";
    public static final String REASON_PURCHASE = "PURCHASE";
    public static final String REASON_DAMAGED = "DAMAGED";
    public static final String REASON_TICKET_SALES = "TICKET SALES";
    public static final String REASON_TRANSFER = "TRANSFER";
    public static final String REASON_UNIT_CONVERSION = "UNIT. CONV.";
    public static final String REASON_ADJUST = "ADJUST";
    public static final String REASON_ADJUST_IN = "ADJUST IN";
    public static final String REASON_ADJUST_OUT = "ADJUST OUT";
    public static final String REASON_PREPARE_IN = "PREPARE IN";
    public static final String REASON_PREPARE_OUT = "PREPARE OUT";
    public static final String REASON_PREPARE_SALE = "PREPARE SALE";
    public static final String REASON_VOID = "VOID";
    public static final String VENDOR_RETURN = "VENDOR RETURN";
    public static final String[] REASON_IN = new String[]{"NEW STOCK", "RETURN", "PURCHASE", "ADJUST IN", "PREPARE IN"};
    public static final String[] REASON_OUT = new String[]{"TICKET SALES", "DAMAGED", "ADJUST OUT", "PREPARE OUT", "VENDOR RETURN"};
    public static final String[] REASON_TRANS = new String[]{"TRANSFER"};
    public static InventoryTransactionType transactionType;
    private double openingQty;
    private double openingCost;
    private double openingTotalCost;
    private transient InventoryLocation inventoryToLocation;
    private transient InventoryLocation inventoryFromLocation;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public InventoryTransaction() {
    }

    public InventoryTransaction(String string) {
        super(string);
    }

    public InventoryTransactionType getTransactionType() {
        transactionType = InventoryTransactionType.fromInt(super.getType());
        return transactionType;
    }

    public void setTransactionType(InventoryTransactionType inventoryTransactionType) {
        super.setType(inventoryTransactionType.getType());
    }

    public String getTransactionDateAsString() {
        if (super.getTransactionDate() == null) {
            return "";
        }
        return DateUtil.formatFullDateAndTimeAsString(super.getTransactionDate());
    }

    public void setTransactionDateAsString(String string) {
    }

    public double getOpeningQty() {
        return this.openingQty;
    }

    public void setOpeningQty(double d) {
        this.openingQty = d;
    }

    public double getOpeningCost() {
        return this.openingCost;
    }

    public void setOpeningCost(double d) {
        this.openingCost = d;
    }

    public double getOpeningTotalCost() {
        return this.openingTotalCost;
    }

    public void setOpeningTotalCost(double d) {
        this.openingTotalCost = d;
    }

    public void setUnitCostDisplay(String string) {
    }

    @XmlTransient
    public String getUnitCostDisplay() {
        return NumberUtil.format3DigitNumber(this.getUnitCost());
    }

    public void setUnitPriceDisplay(String string) {
    }

    public String getUnitPriceDisplay() {
        return NumberUtil.format3DigitNumber(this.getUnitPrice());
    }

    public String getSku() {
        return this.getMenuItem().getSku();
    }

    public void setSku(String string) {
    }

    public String getItemName() {
        return this.getMenuItem().getName();
    }

    public void setItemName(String string) {
    }

    public void setToInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryToLocation = inventoryLocation;
        this.setToLocationId(inventoryLocation == null ? null : inventoryLocation.getId());
    }

    @XmlTransient
    public InventoryLocation getToInventoryLocation() {
        if (this.inventoryToLocation != null) {
            return this.inventoryToLocation;
        }
        return DataProvider.get().getInventoryLocationById(this.getToLocationId());
    }

    public void setFromInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryFromLocation = inventoryLocation;
        this.setFromLocationId(inventoryLocation == null ? null : inventoryLocation.getId());
    }

    @XmlTransient
    public InventoryLocation getFromInventoryLocation() {
        if (this.inventoryFromLocation != null) {
            return this.inventoryFromLocation;
        }
        return DataProvider.get().getInventoryLocationById(this.getFromLocationId());
    }

    public void setUser(User user) {
        this.setUserId(user == null ? null : user.getId());
    }

    public void setVendor(InventoryVendor inventoryVendor) {
        this.setVendorId(inventoryVendor == null ? null : inventoryVendor.getId());
    }

    @XmlTransient
    public InventoryVendor getVendor() {
        if (this.getVendorId() == null) {
            return null;
        }
        return InventoryVendorDAO.getInstance().get(this.getVendorId());
    }

    public void setUnitDisplay(String string) {
    }

    public String getUnitDisplay() {
        IUnit iUnit = DataProvider.get().getUnitById(this.getUnitId(), this.getUnitType());
        if (iUnit != null) {
            return iUnit.getName();
        }
        return "";
    }

    public void calculateTotal() {
        this.calculateTotal(DataProvider.get().getUnitById(this.getUnitId(), this.getUnitType()));
    }

    public void calculateTotal(IUnit iUnit) {
        Double d = super.getUnitCost();
        if (iUnit == null) {
            this.setTotal(this.getQuantity() * d);
            return;
        }
        MenuItem menuItem = this.getMenuItem();
        if (StringUtils.isEmpty((String)menuItem.getUnitId())) {
            this.setTotal(this.getQuantity() * d);
            return;
        }
        double d2 = InventoryUnitConvertionUtil.calculateCost(d, menuItem.getUnit(), iUnit, menuItem);
        this.setUnitCost(d2);
        this.setTotal(this.getQuantity() * d2);
    }

    @Override
    public void addProperty(String string, String string2) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public String getProperty(String string) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    @Override
    public void removeProperty(String string) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(string);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
    }

    public void setDisplayUnit(IUnit iUnit, Double d, MenuItem menuItem) {
        block7: {
            try {
                List<InventoryUnit> list;
                InventoryUnit inventoryUnit;
                String string;
                if (iUnit != null) {
                    this.addProperty("display_unit", iUnit.getUniqueCode());
                    this.addProperty("display_unit_quantity", String.valueOf(d));
                    this.addProperty("display_unit_conversion_rate", String.valueOf(iUnit.getConversionRate()));
                    this.addProperty("display_unit_stock_countable", String.valueOf(iUnit.isStockCountable()));
                    if (iUnit instanceof InventoryUnit && (string = (inventoryUnit = (InventoryUnit)iUnit).getConversionRule()) != null) {
                        this.addProperty("display_unit_conversion_rule", string.getName());
                    }
                }
                if (menuItem == null) {
                    return;
                }
                inventoryUnit = menuItem.getUnit();
                if (inventoryUnit == null) break block7;
                string = inventoryUnit.getUniqueCode();
                this.addProperty("menu_item_unit", string);
                this.addProperty("menu_item_unit_cost", String.valueOf(menuItem.getItemCost()));
                if (inventoryUnit.isBaseUnit().booleanValue()) {
                    this.addProperty("base_unit", inventoryUnit.getUniqueCode());
                    this.addProperty("base_unit_quantity", String.valueOf(InventoryUnitConvertionUtil.getUnitQuantity(iUnit, inventoryUnit, menuItem) * d));
                    break block7;
                }
                InventoryUnitGroup inventoryUnitGroup = inventoryUnit.getUnitGroup();
                if (inventoryUnitGroup == null || (list = inventoryUnitGroup.getUnits()) == null || list.size() <= 0) break block7;
                for (InventoryUnit inventoryUnit2 : list) {
                    if (!inventoryUnit2.isBaseUnit().booleanValue()) continue;
                    this.addProperty("base_unit", inventoryUnit2.getUniqueCode());
                    this.addProperty("base_unit_quantity", String.valueOf(InventoryUnitConvertionUtil.getUnitQuantity(iUnit, inventoryUnit2, menuItem) * d));
                    break;
                }
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }
}

