/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseKitchenTicket;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"parentTicket", "orderType"})
@XmlRootElement
public class KitchenTicket
extends BaseKitchenTicket
implements PropertyContainer {
    private static final long serialVersionUID = 1L;
    private String customerName;
    private Printer printer;
    private Ticket parentTicket;
    private Boolean filterItem;
    private Integer sortOrder;
    private transient JsonObject propertiesContainer;

    public KitchenTicket() {
    }

    public KitchenTicket(String string) {
        super(string);
    }

    @JsonIgnore
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @JsonIgnore
    public List<KitchenTicketItem> getModifiersForTicketItem(String string) {
        ArrayList<KitchenTicketItem> arrayList = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> list = this.getTicketItems();
        if (list != null) {
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isModifierItem().booleanValue() || !string.equals(kitchenTicketItem.getTicketItemId())) continue;
                arrayList.add(kitchenTicketItem);
            }
        }
        return arrayList;
    }

    @JsonIgnore
    public List<KitchenTicketItem> getCookingInstructionForTicketItem(String string) {
        ArrayList<KitchenTicketItem> arrayList = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> list = this.getTicketItems();
        if (list != null) {
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isCookingInstruction().booleanValue() || !string.equals(kitchenTicketItem.getTicketItemId())) continue;
                arrayList.add(kitchenTicketItem);
            }
        }
        return arrayList;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    @JsonIgnore
    public Printer getPrinter() {
        return this.printer;
    }

    @JsonIgnore
    public List<Printer> getPrinters() {
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        PrinterGroup printerGroup = this.getPrinterGroup();
        if (printerGroup == null) {
            arrayList.addAll(posPrinters.getKitchenPrinters());
            return arrayList;
        }
        List<String> list = printerGroup.getPrinterNames();
        List<Printer> list2 = posPrinters.getKitchenPrinters();
        for (Printer printer : list2) {
            if (!list.contains(printer.getVirtualPrinter().getName())) continue;
            arrayList.add(printer);
        }
        return arrayList;
    }

    @Override
    public List<KitchenTicketItem> getTicketItems() {
        List<KitchenTicketItem> list = super.getTicketItems();
        if (list == null) {
            list = new ArrayList<KitchenTicketItem>();
            super.setTicketItems(list);
        }
        return list;
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean bl) {
        return KitchenTicket.fromTicket(ticket, bl, null);
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean bl, List<TicketItem> list) {
        List<TicketItem> list2;
        Object object;
        boolean bl2;
        HashMap<Printer, KitchenTicket> hashMap = new HashMap<Printer, KitchenTicket>();
        ArrayList<KitchenTicket> arrayList = new ArrayList<KitchenTicket>(4);
        Ticket ticket2 = (Ticket)SerializationUtils.clone((Serializable)ticket);
        boolean bl3 = bl2 = list == null;
        if (list == null) {
            list = ticket2.getTicketItems();
        }
        if (list == null) {
            return arrayList;
        }
        OrderType orderType = ticket.getOrderType();
        boolean bl4 = KitchenTicket.filterByCourse(list, orderType);
        boolean bl5 = false;
        if (bl4) {
            bl5 = KitchenTicket.sortBySeat(list, orderType);
            if (bl5) {
                Collections.sort(list, new Comparator<TicketItem>(){

                    @Override
                    public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                        return ticketItem.getSeatNumber().compareTo(ticketItem2.getSeatNumber());
                    }
                });
            }
            Collections.sort(list, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    return ticketItem.getSortOrder().compareTo(ticketItem2.getSortOrder());
                }
            });
        }
        for (TicketItem object22 : list) {
            Object object2;
            Object object3;
            if (bl && !object22.isKitchenPrintable()) continue;
            object = object22.getPrinters(orderType);
            list2 = ticket.getTicketItems();
            if (list2 != null && !list2.isEmpty()) {
                object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = (TicketItem)object3.next();
                    if (object2 == null || ((BaseTicketItem)object2).getId() == null || object22.getId() == null || !object22.getId().equals(((BaseTicketItem)object2).getId())) continue;
                    object22.setProperties(((BaseTicketItem)object2).getProperties());
                }
            }
            if (bl4 && StringUtils.isEmpty((String)(object3 = object22.getCourseId()))) {
                object3 = "";
            }
            boolean object4 = Boolean.parseBoolean(DataProvider.get().getStore().getProperty("kitchen_receipt.print_translated_name"));
            object2 = object.iterator();
            while (object2.hasNext()) {
                Printer printer = (Printer)object2.next();
                VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
                KitchenTicket kitchenTicket = (KitchenTicket)hashMap.get(printer);
                if (kitchenTicket == null) {
                    kitchenTicket = new KitchenTicket();
                    kitchenTicket.setPrinterGroup(object22.getPrinterGroup());
                    kitchenTicket.setTicketId(ticket.getId());
                    kitchenTicket.setTokenNo(ticket.getTokenNo());
                    kitchenTicket.setCreateDate(StoreDAO.getServerTimestamp());
                    kitchenTicket.setOrderType(orderType);
                    kitchenTicket.setSubOrderType(ticket.getSubOrderType());
                    kitchenTicket.setNote(ticket.getNote());
                    if (ticket.getTableNumbers() != null) {
                        kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                    }
                    kitchenTicket.setServerName(ticket.getOwner() != null ? ticket.getOwner().getFirstName() : "");
                    kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                    if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                        kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                    }
                    kitchenTicket.setPrinter(printer);
                    if (virtualPrinter != null) {
                        kitchenTicket.setPrinterName(virtualPrinter.getName());
                    }
                    hashMap.put(printer, kitchenTicket);
                }
                if (bl5 && object22.isTreatAsSeat().booleanValue()) continue;
                KitchenTicket.addKitchenItem(object22, kitchenTicket, object4, bl5);
                if (object22.isComboItem().booleanValue()) {
                    List<TicketItem> list3 = object22.getComboItems();
                    if (list3 != null) {
                        for (TicketItem ticketItem : list3) {
                            KitchenTicket.includeModifiers(ticketItem, kitchenTicket, object4);
                        }
                    }
                } else {
                    KitchenTicket.includeModifiers(object22, kitchenTicket, object4);
                }
                KitchenTicket.includeCookintInstructions(object22, kitchenTicket);
                object22.setPrintedToKitchen(true);
            }
        }
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (KitchenTicket)iterator.next();
            KitchenTicket.filterInvalidSeats((KitchenTicket)object);
            if (((KitchenTicket)object).getTicketItems() == null || ((KitchenTicket)object).getTicketItems().isEmpty()) continue;
            ((KitchenTicket)object).setParentTicket(ticket);
            ((KitchenTicket)object).setFilterItem(bl);
            arrayList.add((KitchenTicket)object);
            list2 = ticket.getProperty("KITCHEN_TICKET_NUMBER");
            list2 = list2 == null ? "1" : String.valueOf(Integer.valueOf((String)((Object)list2)) + 1);
            ticket.addProperty("KITCHEN_TICKET_NUMBER", (String)((Object)list2));
            ((BaseKitchenTicket)object).setSequenceNumber(Integer.valueOf((String)((Object)list2)));
        }
        if (!bl2) {
            ticket.markPrintedToKitchen(list);
        } else {
            ticket.markPrintedToKitchen();
        }
        return arrayList;
    }

    private static boolean filterByCourse(List<TicketItem> list, OrderType orderType) {
        if (orderType != null && !orderType.isEnableCourse().booleanValue()) {
            return false;
        }
        for (TicketItem ticketItem : list) {
            if (!StringUtils.isNotEmpty((String)ticketItem.getCourseId())) continue;
            return true;
        }
        return false;
    }

    private static boolean sortBySeat(List<TicketItem> list, OrderType orderType) {
        if (!orderType.isAllowSeatBasedOrder().booleanValue()) {
            return false;
        }
        for (TicketItem ticketItem : list) {
            if (ticketItem.getSeat() == null && ticketItem.getSeatNumber() <= 0) continue;
            return true;
        }
        return false;
    }

    private static void filterInvalidSeats(KitchenTicket kitchenTicket) {
        List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
        if (list == null) {
            return;
        }
        ListIterator<KitchenTicketItem> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            KitchenTicketItem kitchenTicketItem = listIterator.next();
            if (!kitchenTicketItem.isSeat().booleanValue()) continue;
            if (!listIterator.hasNext()) {
                listIterator.remove();
                continue;
            }
            int n = listIterator.nextIndex();
            KitchenTicketItem kitchenTicketItem2 = list.get(n);
            if (!kitchenTicketItem2.isSeat().booleanValue()) continue;
            listIterator.remove();
        }
    }

    private static void addKitchenItem(TicketItem ticketItem, KitchenTicket kitchenTicket, boolean bl, boolean bl2) {
        Object object;
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
        kitchenTicketItem.setTicketItemId(ticketItem.getId());
        kitchenTicketItem.setMenuItemCode(ticketItem.getItemCode());
        kitchenTicketItem.setVoided(ticketItem.isVoided());
        kitchenTicketItem.setVoidedItemId(ticketItem.getVoidedItemId());
        String string = "";
        if (ticketItem.getSeatNumber() > 0) {
            ShopSeat shopSeat;
            object = ticketItem.getSeat();
            if (object != null && (shopSeat = ((TicketItemSeat)object).getShopSeat()) != null) {
                string = "[" + shopSeat.getSeatNumberWithTableName() + "]  ";
            }
            if (StringUtils.isBlank((String)string)) {
                string = "[S." + ticketItem.getSeatNumber() + "]  ";
            }
        }
        object = ticketItem.getProperty("translatedName");
        if (bl && object != null) {
            kitchenTicketItem.setMenuItemName(string + ticketItem.getNameDisplay((String)object, true, false, false, true));
        } else {
            kitchenTicketItem.setMenuItemName(string + ticketItem.getNameDisplay(ticketItem.getName(), true, false, false, true));
        }
        kitchenTicketItem.setPrintKitchenSticker(ticketItem.isPrintKitchenSticker());
        if (ticketItem.getMenuItem() == null) {
            kitchenTicketItem.setMenuItemGroupName("MISC.");
            kitchenTicketItem.setSortOrder(10001);
        } else {
            kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
            if (StringUtils.isNotEmpty((String)ticketItem.getCourseId())) {
                kitchenTicketItem.setSortOrder(ticketItem.getSortOrder());
            } else {
                kitchenTicketItem.setSortOrder(ticketItem.getTableRowNum());
            }
        }
        kitchenTicketItem.setCourseId(ticketItem.getCourseId());
        kitchenTicketItem.setCourseName(ticketItem.getCourseName());
        kitchenTicketItem.setUnitId(ticketItem.getUnitId());
        kitchenTicketItem.setUnitType(ticketItem.getUnitType());
        kitchenTicketItem.setQuantity(ticketItem.getQuantity());
        kitchenTicketItem.setKitchenStatusValue(KitchenStatus.WAITING);
        kitchenTicketItem.setKitchenTicket(kitchenTicket);
        kitchenTicketItem.setSeat(ticketItem.isTreatAsSeat());
        kitchenTicketItem.setSeatNumber(ticketItem.getSeatNumber());
        kitchenTicketItem.putSeatName(string);
        kitchenTicket.addToticketItems(kitchenTicketItem);
    }

    private static void includeCookintInstructions(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        List<TicketItemCookingInstruction> list = ticketItem.getCookingInstructions();
        if (list != null) {
            for (TicketItemCookingInstruction ticketItemCookingInstruction : list) {
                KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                kitchenTicketItem.setCookingInstruction(true);
                kitchenTicketItem.setVoided(ticketItem.isVoided());
                kitchenTicketItem.setTicketItemId(ticketItem.getId());
                kitchenTicketItem.setMenuItemName(ticketItemCookingInstruction.getNameDisplay());
                if (ticketItem.getMenuItem() == null) {
                    kitchenTicketItem.setMenuItemGroupName("MISC.");
                    kitchenTicketItem.setSortOrder(10001);
                } else {
                    kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
                }
                if (StringUtils.isNotEmpty((String)ticketItem.getCourseId())) {
                    kitchenTicketItem.setSortOrder(ticketItem.getSortOrder());
                }
                kitchenTicketItem.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(kitchenTicketItem);
            }
        }
    }

    private static void includeModifiers(TicketItem ticketItem, KitchenTicket kitchenTicket, boolean bl) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (!ticketItemModifier.isShouldPrintToKitchen().booleanValue()) continue;
                KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                kitchenTicketItem.setTicketItemId(ticketItem.getId());
                kitchenTicketItem.setTicketItemModifierId(ticketItemModifier.getId());
                kitchenTicketItem.setModifierItem(true);
                kitchenTicketItem.setVoided(ticketItem.isVoided());
                String string = ticketItemModifier.getProperty("translatedName");
                if (bl && string != null) {
                    kitchenTicketItem.setMenuItemName(string);
                } else {
                    kitchenTicketItem.setMenuItemName(ticketItemModifier.getNameDisplay(true));
                }
                if (ticketItem.getMenuItem() == null) {
                    kitchenTicketItem.setMenuItemGroupName("MISC.");
                    kitchenTicketItem.setSortOrder(10001);
                } else {
                    kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
                }
                if (StringUtils.isNotEmpty((String)ticketItem.getCourseId())) {
                    kitchenTicketItem.setSortOrder(ticketItem.getSortOrder());
                }
                kitchenTicketItem.setQuantity(ticketItemModifier.getItemQuantity());
                kitchenTicketItem.setKitchenStatusValue(KitchenStatus.WAITING);
                kitchenTicketItem.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(kitchenTicketItem);
                ticketItemModifier.setPrintedToKitchen(true);
            }
        }
    }

    private static void addSeparator(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
        kitchenTicketItem.setMenuItemName("----------------------------------");
        kitchenTicketItem.setKitchenStatusValue(KitchenStatus.WAITING);
        kitchenTicketItem.setKitchenTicket(kitchenTicket);
        if (StringUtils.isNotEmpty((String)ticketItem.getCourseId())) {
            kitchenTicketItem.setSortOrder(ticketItem.getSortOrder());
        } else {
            kitchenTicketItem.setSortOrder(ticketItem.getTableRowNum());
        }
        kitchenTicket.addToticketItems(kitchenTicketItem);
    }

    @JsonIgnore
    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String string) {
        this.customerName = string;
    }

    @XmlTransient
    @JsonIgnore
    public Ticket getParentTicket() {
        if (this.parentTicket == null) {
            this.parentTicket = TicketDAO.getInstance().get(this.getTicketId());
        }
        return this.parentTicket;
    }

    public void setParentTicket(Ticket ticket) {
        this.parentTicket = ticket;
    }

    public Boolean isFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(Boolean bl) {
        this.filterItem = bl;
    }

    public void setOrderType(OrderType orderType) {
        if (orderType != null) {
            super.setOrderTypeId(orderType.getId());
        } else {
            super.setOrderTypeId(null);
        }
    }

    @XmlTransient
    @JsonIgnore
    public OrderType getOrderType() {
        if (StringUtils.isEmpty((String)this.getOrderTypeId())) {
            return null;
        }
        return DataProvider.get().getOrderType(this.getOrderTypeId());
    }

    public void setSortOrder(Integer n) {
        this.sortOrder = n;
    }

    @JsonIgnore
    public Integer getSortOrder() {
        return this.sortOrder == null ? 0 : this.sortOrder;
    }

    public void setSubOrderType(SubOrderType subOrderType) {
        if (subOrderType != null) {
            this.addProperty("ticket.sub_order_type", subOrderType.getName());
        }
    }

    @JsonIgnore
    public SubOrderType getSubOrderType() {
        return SubOrderType.fromName((String)this.getProperty("ticket.sub_order_type"));
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
    }

    @Override
    public void addProperty(String string, String string2) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    @JsonIgnore
    public JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    public String getNote() {
        return this.getProperty("guest_note");
    }

    public void setNote(String string) {
        this.addProperty("guest_note", string);
    }
}

