/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Department;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuCategory;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "menuGroups", "discounts", "orderTypes", "departments", "terminalTypes", "menuShifts"})
@XmlRootElement(name="menu-category")
public class MenuCategory
extends BaseMenuCategory
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CATEGORY_ID = "default_category";
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Color buttonColor;
    private Color textColor;
    private List<String> departmentIds;
    private List<String> orderTypeIds;
    private List<String> menuShiftIds;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public MenuCategory() {
    }

    public MenuCategory(String string) {
        super(string);
    }

    public MenuCategory(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColorCode() {
        Integer n = super.getButtonColorCode();
        if (n == null || n == 0 || n == -1316371) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null || this.getButtonColorCode() == 0) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null || this.getTextColorCode() == 0) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    @Override
    @XmlTransient
    public Set<Department> getDepartments() {
        return super.getDepartments();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menu_category_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    public List<String> getDepartmentIds() {
        return this.departmentIds;
    }

    public void setDepartmentIds(List<String> list) {
        this.departmentIds = list;
    }

    public List<String> getOrderTypeIds() {
        return this.orderTypeIds;
    }

    public void setOrderTypeIds(List<String> list) {
        this.orderTypeIds = list;
    }

    public List<String> getMenuShiftIds() {
        return this.menuShiftIds;
    }

    public void setMenuShiftIds(List<String> list) {
        this.menuShiftIds = list;
    }

    public void setTicketDiscountApplicable(boolean bl) {
        this.addProperty("tDiscApplicable", String.valueOf(bl));
    }

    public boolean isTicketDiscountApplicable() {
        return POSUtil.getBoolean(this.getProperty("tDiscApplicable"), true);
    }
}

