/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Color;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"properties", "departments", "tableServingBGColor", "tableServingForeColor", "tableBookForeColor", "tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatForeColor", "tableSeatBGColor", "taxGroup", "currency", "autoOpenStore", "autoCloseStore", "autoCloseStoreTime", "autoOpenCloseStoreBy"})
@XmlRootElement
public class Outlet
extends BaseOutlet
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private transient Address address;

    public Outlet() {
    }

    public Outlet(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String string = null;
        if (taxGroup != null) {
            string = taxGroup.getId();
        }
        super.setTaxGroupId(string);
    }

    @XmlTransient
    public Currency getCurrency() {
        return DataProvider.get().getCurrency(this.getCurrencyId());
    }

    public void setCurrency(Currency currency) {
        String string = null;
        if (currency != null) {
            string = currency.getId();
        }
        super.setCurrencyId(string);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public void setTablePrimaryFontSize(int n) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(n));
    }

    public void setTableSecondaryFontSize(int n) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(n));
    }

    public void setTableBtnWidth(int n) {
        this.addProperty("floorplan.btnWidth", String.valueOf(n));
    }

    public void setTableBtnHeight(int n) {
        this.addProperty("floorplan.btnHeight", String.valueOf(n));
    }

    public void setTableSeatForeColor(Color color) {
        this.addProperty("floorplan.seatForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableSeatBGColor(Color color) {
        this.addProperty("floorplan.seatBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableServingForeColor(Color color) {
        this.addProperty("floorplan.servingForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableServingBGColor(Color color) {
        this.addProperty("floorplan.servingBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableBookForeColor(Color color) {
        this.addProperty("floorplan.bookForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableBookBGColor(Color color) {
        this.addProperty("floorplan.bookBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setTableFreeBGColor(Color color) {
        this.addProperty("floorplan.freeBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    public void setShowTableNameOnTable(boolean bl) {
        this.addProperty("floorplan.showTableName", String.valueOf(bl));
    }

    public void setShowTableNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTableNumber", String.valueOf(bl));
    }

    public void setShowServerNameOnTable(boolean bl) {
        this.addProperty("floorplan.showServerName", String.valueOf(bl));
    }

    public void setShowTokenNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTokenName", String.valueOf(bl));
    }

    public void setDateFormat(String string) {
        this.addProperty("default_date_format", string);
    }

    public String getDateFormat() {
        return this.getProperty("default_date_format", "dd-MMM-yy");
    }

    @Override
    public String getExtraProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getExtraProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void setLengthUnit(String string) {
        this.addProperty("deliveryConfig.unitName", string);
    }

    public String getLengthUnit() {
        return this.getProperty("deliveryConfig.unitName", "MILE");
    }

    @XmlTransient
    public boolean isLengthUnitInMile() {
        String string = this.getProperty("deliveryConfig.unitName");
        return !"KM".equals(string);
    }

    public String buildOutletFullAddress() {
        String string = "";
        if (StringUtils.isNotBlank((String)this.getAddressLine1())) {
            string = string + this.getAddressLine1();
        }
        if (StringUtils.isNotBlank((String)this.getAddressLine2())) {
            if (!POSUtil.endsWithComma(string)) {
                string = string + ", ";
            }
            string = string + this.getAddressLine2();
        }
        if (StringUtils.isNotBlank((String)this.getAddressLine3())) {
            if (!POSUtil.endsWithComma(string)) {
                string = string + ", ";
            }
            string = string + this.getAddressLine3();
        }
        if (StringUtils.isNotBlank((String)this.getCity())) {
            if (!POSUtil.endsWithComma(string)) {
                string = string + ", ";
            }
            string = string + this.getCity();
        }
        if (StringUtils.isNotBlank((String)this.getState())) {
            if (!POSUtil.endsWithComma(string)) {
                string = string + ", ";
            }
            string = string + this.getState();
        }
        if (StringUtils.isNotBlank((String)this.getCountry())) {
            if (!POSUtil.endsWithComma(string)) {
                string = string + ", ";
            }
            string = string + this.getCountry();
        }
        PosLog.info(this.getClass(), string);
        return string;
    }
}

