/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.payment.MemberPaymentPlugin;
import com.floreantpos.payment.PaymentPlugin;

public enum PaymentType {
    CASH("CASH"),
    CUSTOM_PAYMENT("CUSTOM PAYMENT"),
    CREDIT_CARD("CREDIT CARD"),
    DEBIT_CARD("DEBIT CARD"),
    GIFT_CERTIFICATE("GIFT CERTIFICATE"),
    MEMBER_ACCOUNT("CUSTOMER ACCOUNT"),
    PROMOTION("PROMOTION"),
    CARD("CARD"),
    MANUAL_ENTRY("MANUAL ENTRY"),
    CARRY_OUT("CARRY OUT"),
    CARRY_OVER("CARRY OVER");

    private String displayString;
    private String imageFile;

    private PaymentType(String string2) {
        this.displayString = string2;
    }

    private PaymentType(String string2, String string3) {
        this.displayString = string2;
        this.imageFile = string3;
    }

    public String toString() {
        return this.displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String string) {
        this.displayString = string;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String string) {
        this.imageFile = string;
    }

    public boolean isSupported() {
        switch (this) {
            case CASH: {
                return true;
            }
        }
        return CardConfig.isSwipeCardSupported() || CardConfig.isManualEntrySupported() || CardConfig.isExtTerminalSupported();
    }

    public static PaymentType fromDisplayString(String string) {
        PaymentType[] paymentTypeArray;
        for (PaymentType paymentType : paymentTypeArray = PaymentType.values()) {
            if (!paymentType.getDisplayString().equals(string)) continue;
            return paymentType;
        }
        return null;
    }

    public PosTransaction createTransaction() {
        PosTransaction posTransaction = null;
        switch (this) {
            case CREDIT_CARD: {
                posTransaction = new CreditCardTransaction();
                break;
            }
            case DEBIT_CARD: {
                posTransaction = new DebitCardTransaction();
                break;
            }
            case GIFT_CERTIFICATE: {
                posTransaction = new GiftCertificateTransaction();
                break;
            }
            case CUSTOM_PAYMENT: {
                posTransaction = new CustomPaymentTransaction();
                break;
            }
            case MEMBER_ACCOUNT: {
                posTransaction = new CustomerAccountTransaction();
                break;
            }
            default: {
                posTransaction = new CashTransaction();
            }
        }
        posTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        posTransaction.setPaymentType(this);
        posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        return posTransaction;
    }

    public PosTransaction createTransaction(Ticket ticket, double d) {
        PosTransaction posTransaction = null;
        switch (this) {
            case CREDIT_CARD: {
                posTransaction = new CreditCardTransaction();
                posTransaction.setAuthorizable(true);
                break;
            }
            case DEBIT_CARD: {
                posTransaction = new DebitCardTransaction();
                posTransaction.setAuthorizable(true);
                break;
            }
            case GIFT_CERTIFICATE: {
                posTransaction = new GiftCertificateTransaction();
                break;
            }
            case CUSTOM_PAYMENT: {
                posTransaction = new CustomPaymentTransaction();
                break;
            }
            case MEMBER_ACCOUNT: {
                posTransaction = new CustomerAccountTransaction();
                break;
            }
            default: {
                posTransaction = new CashTransaction();
            }
        }
        posTransaction.setTicket(ticket);
        posTransaction.setTenderAmount(d);
        if (ticket != null && d >= ticket.getDueAmount()) {
            posTransaction.setAmount(ticket.getDueAmount());
        } else {
            posTransaction.setAmount(d);
        }
        posTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        posTransaction.setPaymentType(this);
        posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        return posTransaction;
    }

    public PaymentPlugin getPaymentPlugin() {
        switch (this) {
            case GIFT_CERTIFICATE: {
                return (PaymentPlugin)ExtensionManager.getPlugin(GiftCardPaymentPlugin.class);
            }
            case MEMBER_ACCOUNT: {
                return new MemberPaymentPlugin();
            }
        }
        return null;
    }
}

