/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.base.BasePurchaseOrderItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem", "purchaseOrder"})
public class PurchaseOrderItem
extends BasePurchaseOrderItem
implements PropertyContainer {
    private static final long serialVersionUID = 1L;
    private Double quantityToReceive;
    private MenuItem menuItem;
    private transient JsonObject propertiesContainer;

    public PurchaseOrderItem() {
    }

    public PurchaseOrderItem(String string) {
        super(string);
    }

    public PurchaseOrderItem(String string, PurchaseOrder purchaseOrder) {
        super(string, purchaseOrder);
    }

    public void calculatePrice() {
        this.setSubtotalAmount(this.getUnitPrice() * this.getItemQuantity());
        this.setTotalAmount(this.getSubtotalAmount() + this.getTaxAmount() - this.getDiscountAmount());
    }

    public String getQuantityDisplay() {
        return NumberUtil.format6DigitNumber(super.getItemQuantity());
    }

    public String getPriceDisplay() {
        return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getUnitPrice());
    }

    public String getTotalDisplay() {
        return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getTotalAmount());
    }

    public Double getQuantityToReceive() {
        return this.quantityToReceive == null ? Double.valueOf(0.0) : this.quantityToReceive;
    }

    public void setQuantityToReceive(Double d) {
        this.quantityToReceive = d;
    }

    @Override
    public void addProperty(String string, String string2) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public String getProperty(String string) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    @Override
    public void removeProperty(String string) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(string);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public void setDisplayUnit(IUnit iUnit) {
        try {
            if (iUnit != null) {
                this.addProperty("unit_Name", iUnit.getName());
                this.addProperty("unit_Code", iUnit.getUniqueCode());
                this.addProperty("unit_Id", iUnit.getId());
                this.addProperty("unit_stock_countable", String.valueOf(iUnit.isStockCountable()));
                this.addProperty("unit_conversion_rate", String.valueOf(iUnit.getConversionRate()));
                if (iUnit instanceof InventoryUnit) {
                    this.addProperty("unit_conversion_rule", String.valueOf(((InventoryUnit)iUnit).getConversionRule().getName()));
                }
                this.setUnitType(iUnit.getUnitType());
            } else if (this.menuItem != null) {
                Optional<InventoryUnit> optional = Optional.ofNullable(this.menuItem.getUnit());
                optional.ifPresent(inventoryUnit -> {
                    this.addProperty("unit_Name", inventoryUnit.getName());
                    this.addProperty("unit_Code", inventoryUnit.getUniqueCode());
                    this.addProperty("unit_Id", inventoryUnit.getId());
                    this.addProperty("unit_stock_countable", String.valueOf(inventoryUnit.isStockCountable()));
                    this.addProperty("unit_conversion_rate", String.valueOf(inventoryUnit.getConversionRate()));
                    this.addProperty("unit_conversion_rule", String.valueOf(inventoryUnit.getConversionRule().getName()));
                    this.setUnitType(inventoryUnit.getUnitType());
                });
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public String getUnitNameDisplay() {
        IUnit iUnit = DataProvider.get().getUnitById(this.getUnitId(), this.getUnitType());
        if (iUnit == null) {
            return "";
        }
        return iUnit.getName();
    }
}

