/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.pricecalc.TicketItemCalcFactory;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"inventoryAdjusted", "menuItem", "voidItem", "comboItemsModifierExtraPrice", "unitPriceWithoutModifierAfterDiscount"})
@XmlSeeAlso(value={ModifiableTicketItem.class, ComboTicketItem.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ModifiableTicketItem.class), @JsonSubTypes.Type(value=ComboTicketItem.class)})
public class TicketItem
extends BaseTicketItem
implements ITicketItem,
PropertyContainer {
    public static final String JSON_PROP_DISCOUNT_ON_SC = "discountOnSc";
    public static final String JSON_PROP_VOID_ID = "voidId";
    public static final String JSON_PROP_VOIDED_BY_USER = "voidedByUser";
    public static final String JSON_PROP_MODIIFIER_VOID_IDS = "modifierVoidIds";
    public static final String JSON_PROP_VOID_REASON = "voidReason";
    public static final String JSON_PROP_VOID_QUANTITY = "voidQuantity";
    public static final String JSON_PROP_WASTED = "wasted";
    public static final String JSON_PROP_PRINTED_TO_KITCHEN = "originalItemPrintedToKitchen";
    public static final String JSON_PROP_RETURNED = "returned";
    public static final String JSON_PROP_RETURNED_ITEM_VOIDED = "returnedVoided";
    public static final String PROPERTY_COOKING_INSTRUCTION = "COOKING_INSTRUCTION";
    private static final String JSON_PROP_GIFT_CARD_PAID_AMOUNT = "gift_card_paid_amount";
    private static final String JSON_PROP_SC_WITHOUT_MODOFIERS = "scWithoutModifiers";
    public static final String PROPERTY_TAX = "TAX";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient com.google.gson.JsonObject propertiesContainer;
    private String classType;
    private transient MenuItem menuItem;
    private int tableRowNum;
    private Double quantityToShip;
    public static final int HALF = 0;
    public static final int FULL = 1;
    public static final int SHARED_FULL = 2;
    public static final int SHARED_CUSTOM = 3;
    private Boolean includeVoidQuantity;
    private VoidItem voidItem;
    private List<TicketItemCookingInstruction> cookingInstructions;
    private List<TicketItemTax> taxes;
    private List<TicketItemDiscount> discounts;
    private TicketItem parentTicketItem;
    private Integer sortOrder;

    public TicketItem() {
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(String string) {
        super(string);
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(Ticket ticket, String string, double d, double d2, TicketItemTax ticketItemTax) {
        this.setName(string);
        this.setUnitPrice(d);
        this.setQuantity(d2);
        this.addTotaxes(ticketItemTax);
        this.setTicket(ticket);
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem createNew() {
        if (this instanceof ModifiableTicketItem) {
            return new ModifiableTicketItem();
        }
        return new TicketItem();
    }

    public Boolean isHasModifiers() {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        return list != null && list.size() > 0;
    }

    public TicketItemModifier getSizeModifier() {
        return null;
    }

    public void setSizeModifier(TicketItemModifier ticketItemModifier) {
    }

    public List<TicketItemModifier> getTicketItemModifiers() {
        return null;
    }

    public void setTicketItemModifiers(List<TicketItemModifier> list) {
    }

    public void addToticketItemModifiers(TicketItemModifier ticketItemModifier) {
    }

    public TicketItem clone() {
        return (TicketItem)SerializationUtils.clone((Serializable)this);
    }

    public TicketItem cloneAsNew() {
        return this.cloneAsNew(false);
    }

    public TicketItem cloneAsNew(boolean bl) {
        Object object;
        Object object2;
        TicketItem ticketItem = (TicketItem)SerializationUtils.clone((Serializable)this);
        boolean bl2 = bl && ticketItem.isPrintedToKitchen() != false;
        ticketItem.setId(null);
        ticketItem.setCreateDate(StoreDAO.getServerTimestamp());
        ticketItem.setVersion(0L);
        ticketItem.setPaid(Boolean.FALSE);
        ticketItem.setPrintedToKitchen(bl2);
        ticketItem.setInventoryAdjustQty(0.0);
        ticketItem.setCloudSynced(false);
        ticketItem.setHasSyncError(false);
        ticketItem.setKitchenStatusValue(KitchenStatus.WAITING);
        ticketItem.setSeat(null);
        if (ticketItem.getSizeModifier() != null) {
            ticketItem.getSizeModifier().setId(null);
            ticketItem.getSizeModifier().setPrintedToKitchen(bl2);
        }
        this.cloneModifiers(this, ticketItem, bl2);
        List<TicketItemCookingInstruction> list = ticketItem.getCookingInstructions();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                ((TicketItemCookingInstruction)object).setPrintedToKitchen(bl2);
                ((TicketItemCookingInstruction)object).setKitchenStatusValue(KitchenStatus.WAITING);
            }
        }
        ticketItem.setComboItems(null);
        if (this.isComboItem().booleanValue() && (object2 = this.getComboItems()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItem ticketItem2 = (TicketItem)object.next();
                TicketItem ticketItem3 = (TicketItem)SerializationUtils.clone((Serializable)ticketItem2);
                ticketItem3.setId(null);
                ticketItem3.setCreateDate(StoreDAO.getServerTimestamp());
                ticketItem3.setParentTicketItem(ticketItem);
                ticketItem3.setComboItems(null);
                if (ticketItem3.getSizeModifier() != null) {
                    ticketItem3.getSizeModifier().setId(null);
                    ticketItem3.getSizeModifier().setPrintedToKitchen(bl2);
                }
                this.cloneModifiers(ticketItem2, ticketItem3, bl2);
                ticketItem.addTocomboItems(ticketItem3);
            }
        }
        if (ticketItem.isService().booleanValue()) {
            ticketItem.addProperty("processed", String.valueOf(Boolean.FALSE));
        }
        return ticketItem;
    }

    private void cloneModifiers(TicketItem ticketItem, TicketItem ticketItem2, boolean bl) {
        ticketItem2.setTicketItemModifiers(null);
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null && list.size() > 0) {
            for (TicketItemModifier ticketItemModifier : list) {
                Object object;
                if (!ticketItemModifier.isInfoOnly().booleanValue()) {
                    ModifierGroup modifierGroup;
                    List<MenuModifier> list2;
                    object = ticketItemModifier.getItemId();
                    MenuModifier menuModifier = MenuModifierDAO.getInstance().get((String)object);
                    String string = ticketItemModifier.getGroupId();
                    MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(string);
                    if (menuItemModifierSpec != null && menuItemModifierSpec.isUseModifierGroupSettings() && (list2 = (modifierGroup = menuItemModifierSpec.getModifierGroup()).getModifiers()) != null && !list2.contains(menuModifier) || menuModifier != null && menuModifier.isDeleted().booleanValue()) continue;
                }
                object = (TicketItemModifier)SerializationUtils.clone((Serializable)ticketItemModifier);
                ((BaseTicketItemModifier)object).setId(null);
                ((BaseTicketItemModifier)object).setTicketItem(ticketItem2);
                ((BaseTicketItemModifier)object).setPrintedToKitchen(bl);
                ((TicketItemModifier)object).setKitchenStatusValue(KitchenStatus.WAITING);
                ((BaseTicketItemModifier)object).setTaxesProperty(null);
                ticketItem2.addToticketItemModifiers((TicketItemModifier)object);
            }
        }
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        this.buildTaxes();
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    ticketItemTax.setName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_RATE));
                    ticketItemTax.setTaxAmount(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_TAX_AMOUNT));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        this.taxes = this.getTaxes();
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setDiscounts(List<TicketItemDiscount> list) {
        this.discounts = list;
    }

    public List<TicketItemDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
            String string = super.getDiscountsProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JSONArray jSONArray = new JSONArray(string);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                    ticketItemDiscount.setTicketItem(this);
                    ticketItemDiscount.setDiscountId(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                    ticketItemDiscount.setName(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_NAME));
                    ticketItemDiscount.setType(OrgJsonUtil.getInt(jSONObject, TicketItemDiscount.PROP_TYPE));
                    ticketItemDiscount.setAutoApply(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_AUTO_APPLY));
                    ticketItemDiscount.setApplyIfDivisible(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_APPLY_IF_DIVISIBLE));
                    ticketItemDiscount.setCouponQuantity(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                    ticketItemDiscount.setMinimumAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                    ticketItemDiscount.setValue(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_VALUE));
                    ticketItemDiscount.setAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_AMOUNT));
                    ticketItemDiscount.setAmountWithoutModifiers(OrgJsonUtil.getDouble(jSONObject, "amountWithoutModifier"));
                    ticketItemDiscount.setDataVersion(OrgJsonUtil.getInt(jSONObject, "dataVersion"));
                    ticketItemDiscount.setDiscountPercentage(OrgJsonUtil.getDouble(jSONObject, "discountPercentage"));
                    this.discounts.add(ticketItemDiscount);
                }
            }
        }
        return this.discounts;
    }

    public void addTodiscounts(TicketItemDiscount ticketItemDiscount) {
        this.discounts = this.getDiscounts();
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
        }
        this.discounts.add(ticketItemDiscount);
        ActionHistoryDAO.addTicketItemDiscountAddedActionHistory(this.getTicket(), ticketItemDiscount);
    }

    public void buildDiscounts() {
        if (this.discounts == null || this.discounts.isEmpty()) {
            this.setDiscountsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemDiscount ticketItemDiscount : this.discounts) {
            jSONArray.put((Object)ticketItemDiscount.toJson());
        }
        this.setDiscountsProperty(jSONArray.toString());
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return this.isPrintedToKitchen() == false;
    }

    @Override
    public String toString() {
        return POSConstants.NAME.toLowerCase() + ": " + this.getName() + " " + POSConstants.ID.toLowerCase() + ": " + this.getId();
    }

    public void setCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = list;
        this.buildCoookingInstructions();
    }

    public void addCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>(2);
        }
        for (TicketItemCookingInstruction ticketItemCookingInstruction : list) {
            this.addCookingInstruction(ticketItemCookingInstruction);
        }
    }

    public void addCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            return;
        }
        this.cookingInstructions.add(ticketItemCookingInstruction);
        this.buildCoookingInstructions();
    }

    public void buildCoookingInstructions() {
        if (this.cookingInstructions == null || this.cookingInstructions.isEmpty()) {
            this.setCookingInstructionsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemCookingInstruction ticketItemCookingInstruction : this.cookingInstructions) {
            jSONArray.put((Object)ticketItemCookingInstruction.toJson());
        }
        this.setCookingInstructionsProperty(jSONArray.toString());
    }

    public void removeCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        List<TicketItemCookingInstruction> list = this.getCookingInstructions();
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<TicketItemCookingInstruction> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemCookingInstruction ticketItemCookingInstruction2 = iterator.next();
            if (ticketItemCookingInstruction2.getTableRowNum() != ticketItemCookingInstruction.getTableRowNum()) continue;
            iterator.remove();
            this.buildCoookingInstructions();
            return;
        }
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier) {
        return this.addTicketItemModifier(menuModifier, n, orderType, multiplier, 1.0);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier, double d) {
        return TicketItemCalcFactory.getCalc(this).addTicketItemModifier(this, menuModifier, n, orderType, multiplier, d);
    }

    public void updateModifiersUnitPriceByGroup(MenuItemModifierSpec menuItemModifierSpec) {
        TicketItemCalcFactory.getCalc(this).updateModifiersUnitPriceByGroup(this, menuItemModifierSpec);
    }

    public boolean contains(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        int n = 0;
        if (list != null) {
            for (TicketItemModifier ticketItemModifier2 : list) {
                if (ticketItemModifier2.isInfoOnly().booleanValue() || !ticketItemModifier.getName().trim().equals(ticketItemModifier2.getName().trim())) continue;
                ++n;
            }
        }
        return n > 1;
    }

    public TicketItemModifier removeTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (!ticketItemModifier2.getItemId().equals(ticketItemModifier.getItemId()) || ticketItemModifier2.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iterator.remove();
            return ticketItemModifier2;
        }
        return ticketItemModifier;
    }

    public TicketItemModifier removeTicketItemModifier(int n) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        TicketItemModifier ticketItemModifier = list.get(n);
        list.remove(n);
        return ticketItemModifier;
    }

    public void calculatePrice() {
        TicketItemCalcFactory.getCalc(this).calculatePrice(this);
    }

    public boolean isMergable(TicketItem ticketItem, boolean bl) {
        if (this.isTreatAsSeat().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) {
            return false;
        }
        if (this.isFractionalUnit().booleanValue() || ticketItem.isFractionalUnit().booleanValue()) {
            return false;
        }
        if (this.getQuantity() > 0.0 && ticketItem.getQuantity() < 0.0 || this.getQuantity() < 0.0 && ticketItem.getQuantity() > 0.0) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMenuItemId()) || StringUtils.isEmpty((String)ticketItem.getMenuItemId())) {
            return false;
        }
        if (this.hasCookingInstructions() || ticketItem.hasCookingInstructions()) {
            return false;
        }
        if (this.isReturned() || ticketItem.isReturned()) {
            return false;
        }
        if (!this.getMenuItemId().equals(ticketItem.getMenuItemId())) {
            return false;
        }
        if (!this.getUnitPrice().equals(ticketItem.getUnitPrice())) {
            return false;
        }
        if (this.isComboItem().booleanValue() || ticketItem.isComboItem().booleanValue()) {
            return false;
        }
        if (!this.getSeatNumber().equals(ticketItem.getSeatNumber())) {
            return false;
        }
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            return true;
        }
        return this.isMergableModifiers(this.getTicketItemModifiers(), ticketItem.getTicketItemModifiers(), bl);
    }

    public boolean isMergableModifiers(List<TicketItemModifier> list, List<TicketItemModifier> list2, boolean bl) {
        if (list2 == null || list == null) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Comparator<TicketItemModifier> comparator = new Comparator<TicketItemModifier>(){

            @Override
            public int compare(TicketItemModifier ticketItemModifier, TicketItemModifier ticketItemModifier2) {
                return ticketItemModifier.getItemId().compareTo(ticketItemModifier2.getItemId());
            }
        };
        Collections.sort(list, comparator);
        Collections.sort(list2, comparator);
        Iterator<TicketItemModifier> iterator = list.iterator();
        Iterator<TicketItemModifier> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier;
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (comparator.compare(ticketItemModifier2, ticketItemModifier = iterator2.next()) != 0) {
                return false;
            }
            if (!bl) continue;
            ticketItemModifier2.merge(ticketItemModifier);
        }
        return true;
    }

    public void merge(TicketItem ticketItem) {
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
            return;
        }
        if (this.isMergable(ticketItem, false)) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
        }
    }

    public boolean hasCookingInstructions() {
        return this.getCookingInstructions() != null && this.getCookingInstructions().size() > 0;
    }

    public double getAmountByType(TicketItemDiscount ticketItemDiscount) {
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return ticketItemDiscount.getValue() * this.getUnitPrice() / 100.0;
            }
        }
        return 0.0;
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    @Override
    public String getNameDisplay() {
        return this.getNameDisplay(this.getName(), false, false, true);
    }

    public String getNameDisplay(boolean bl, boolean bl2, boolean bl3) {
        return this.getNameDisplay(this.getName(), bl, bl2, bl3);
    }

    public String getNameDisplay(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.getNameDisplay(string, bl, bl2, bl3, false);
    }

    public String getNameDisplay(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List<Comparable> list;
        boolean bl5 = DataProvider.get().getCurrentTerminal().isShowTranslatedName();
        boolean bl6 = DataProvider.get().getCurrentTerminal().isShowBothNameAndTranslatedName();
        Function<String, String> function = string -> string != null ? string : "";
        String string3 = function.apply(this.getProperty("translatedName"));
        if (bl5 && StringUtils.isNotBlank((String)string3)) {
            string2 = string3;
        }
        if (this.isTreatAsSeat().booleanValue()) {
            return string2;
        }
        String string4 = "";
        if (this.getQuantity() < 0.0) {
            if (this.isVoided().booleanValue() && !this.isItemReturned().booleanValue()) {
                string4 = string4 + "*Voided* ";
                string4 = string4 + this.getItemQuantityDisplay(true);
            } else {
                string4 = string4 + this.getItemQuantityDisplay();
            }
        } else {
            string4 = string4 + this.getItemQuantityDisplay();
        }
        if (this.isComboItem().booleanValue()) {
            list = this.getComboItems();
            if (list != null && !list.isEmpty()) {
                string4 = bl6 && StringUtils.isNotBlank((String)string3) ? string4 + string2 + "\n" + string3 : string4 + string2;
                string4 = string4 + "\n";
                Iterator<Comparable> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Comparable comparable = (TicketItem)iterator.next();
                    String string5 = ((BaseTicketItem)comparable).getName();
                    String string6 = function.apply(((TicketItem)comparable).getProperty("translatedName"));
                    if (bl6 && StringUtils.isNotBlank((String)string6)) {
                        string5 = string5 + "\n" + string6;
                    } else if (bl5 && StringUtils.isNotBlank((String)string6)) {
                        string5 = string6;
                    }
                    double d = ((BaseTicketItem)comparable).getQuantity() / this.getQuantity();
                    string4 = string4 + " #" + (d > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(d, true) + " | " : " ") + string5;
                    if (((TicketItem)comparable).getSizeModifier() != null) {
                        string4 = string4 + ((TicketItem)comparable).getSizeModifier().getNameDisplay();
                    }
                    if (!bl4) {
                        List<TicketItemModifier> list2 = ((TicketItem)comparable).getTicketItemModifiers();
                        if (iterator.hasNext() || list2 != null) {
                            string4 = string4 + "\n";
                        }
                        if (list2 == null || list2.isEmpty()) continue;
                        Iterator<TicketItemModifier> iterator2 = list2.iterator();
                        while (iterator2.hasNext()) {
                            TicketItemModifier ticketItemModifier = iterator2.next();
                            string4 = string4 + ticketItemModifier.getNameDisplay(bl);
                            if (iterator2.hasNext()) {
                                string4 = string4 + "\n";
                                continue;
                            }
                            if (!iterator.hasNext()) continue;
                            string4 = string4 + "\n";
                        }
                        continue;
                    }
                    if (!iterator.hasNext()) continue;
                    string4 = string4 + "\n";
                }
            }
        } else if (this.getSizeModifier() != null) {
            string4 = string4 + this.getSizeModifier().getNameDisplay().trim() + " " + (bl5 && StringUtils.isNotBlank((String)string3) ? string3 : string2);
            if (bl6 && StringUtils.isNotBlank((String)string3)) {
                string4 = string4 + "\n " + this.getSizeModifier().getTranslatedNameDisplay() + " " + string3;
            }
        } else {
            string4 = bl6 && StringUtils.isNotBlank((String)string3) ? string4 + string2 + "\n" + string3 : string4 + string2;
        }
        if (!bl4 && (list = this.getTicketItemModifiers()) != null) {
            for (Comparable comparable : list) {
                if (bl2 && ((BaseTicketItemModifier)comparable).getUnitPrice() == 0.0) continue;
                string4 = string4 + "\n";
                string4 = string4 + ((TicketItemModifier)comparable).getNameDisplay(bl);
            }
        }
        if (bl3 && (list = this.getCookingInstructions()) != null) {
            for (Comparable comparable : list) {
                string4 = string4 + "\n";
                string4 = string4 + ((TicketItemCookingInstruction)comparable).getNameDisplay();
            }
        }
        return string4;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return this.getItemQuantityDisplay(false);
    }

    public String getItemQuantityDisplay(boolean bl) {
        if (this.isTreatAsSeat().booleanValue()) {
            return "";
        }
        String string = this.getProperty("unit_display_name", "");
        String string2 = "";
        if (string != null && string.length() != 0) {
            string2 = string;
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = this.getUnitName();
        }
        Double d = bl ? Math.abs(this.getQuantity()) : this.getQuantity();
        if (!this.isFractionalUnit().booleanValue() && d == 1.0 && ("ea".equals(string2) || "Each".equals(string2))) {
            return "";
        }
        String string3 = NumberUtil.trimDecilamIfNotNeeded(d, true);
        if (string2.equals("") || "ea".equals(string2) || "pc".equals(string2)) {
            if (d == 1.0) {
                return "";
            }
            return string3 + "x | ";
        }
        return string3 + string2.trim() + " ";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmountWithoutModifiers());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmountWithoutModifiers());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubtotalAmountWithoutModifiers());
    }

    @Override
    public String getItemCode() {
        return String.valueOf(this.getMenuItemId());
    }

    public List<Printer> getPrinters(OrderType orderType) {
        PrinterGroup printerGroup = this.getPrinterGroup();
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        List<Printer> list = posPrinters.getKitchenPrinters();
        arrayList.addAll(posPrinters.getStickerPrinters());
        Printer printer = VirtualPrinter.getKdsPrinter();
        if (printerGroup == null && (list == null || list.isEmpty()) && posPrinters.isPrintToKds()) {
            arrayList.add(printer);
        }
        boolean bl = false;
        if (printerGroup == null && list != null && list.size() > 0) {
            for (Printer printer2 : list) {
                if (StringUtils.isBlank((String)printer2.getDeviceName())) {
                    if (bl) continue;
                    arrayList.add(printer);
                    bl = true;
                    continue;
                }
                arrayList.add(printer2);
            }
            return arrayList;
        }
        if (printerGroup != null) {
            List<String> list2 = printerGroup.getPrinterNames();
            for (Printer printer3 : list) {
                VirtualPrinter virtualPrinter = printer3.getVirtualPrinter();
                if (StringUtils.isBlank((String)printer3.getDeviceName()) || !list2.contains(virtualPrinter.getName())) continue;
                arrayList.add(printer3);
            }
        }
        if (arrayList.isEmpty() && posPrinters.isPrintToKds()) {
            arrayList.add(printer);
        }
        return arrayList;
    }

    @Override
    public boolean canAddDiscount() {
        return true;
    }

    @Override
    public boolean canVoid() {
        return true;
    }

    @Override
    public boolean canAddAdOn() {
        return true;
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        String string = null;
        if (menuItem != null) {
            string = menuItem.getId();
        }
        super.setMenuItemId(string);
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getKitchenStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setKitchenStatus(kitchenStatus.name());
    }

    public void setKitchenStatusValueWithChildren(KitchenStatus kitchenStatus) {
        Object object;
        Object object2;
        super.setKitchenStatus(kitchenStatus.name());
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TicketItemModifier)object2.next();
                ((TicketItemModifier)object).setKitchenStatusValue(kitchenStatus);
            }
        }
        if ((object2 = this.getCookingInstructions()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)object.next();
                ticketItemCookingInstruction.setKitchenStatusValue(kitchenStatus);
            }
            this.buildCoookingInstructions();
        }
    }

    public String getUnitName() {
        if (StringUtils.isBlank((String)super.getUnitId())) {
            return "";
        }
        IUnit iUnit = DataProvider.get().getUnitById(this.getUnitId(), this.getUnitType());
        return iUnit.getName();
    }

    public Double getQuantityToShip() {
        return this.quantityToShip == null ? 0.0 : this.quantityToShip;
    }

    public void setQuantityToShip(Double d) {
        this.quantityToShip = d;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        if (this.isVoided().booleanValue() && !this.isItemReturned().booleanValue()) {
            return "(" + NumberUtil.formatCurrencyAmount(Math.abs(this.getSubtotalAmount())) + ")";
        }
        return NumberUtil.formatCurrencyAmount(this.getSubtotalAmount());
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            boolean bl;
            String string = ticketItemModifier.getItemId();
            String string2 = menuModifier.getMenuItemModifierSpec() == null ? null : menuModifier.getMenuItemModifierSpec().getId();
            String string3 = ticketItemModifier.getGroupId();
            String string4 = ticketItemModifier.getMultiplierName();
            boolean bl2 = bl = string == null || string2 == null || string3 == null;
            if (bl) {
                return null;
            }
            if (multiplier != null && StringUtils.isNotBlank((String)string4) && !multiplier.getId().equals(string4)) {
                return null;
            }
            if (!string2.equals(string3) || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public List<TicketItemModifier> findTicketItemModifiersFor(MenuModifier menuModifier, Multiplier multiplier, boolean bl) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        if (list == null) {
            return arrayList;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || multiplier == null || !string.equals(menuModifier.getId())) continue;
            if (multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                arrayList.add(ticketItemModifier);
                continue;
            }
            if (!bl) continue;
            arrayList.add(ticketItemModifier);
        }
        return arrayList;
    }

    public double findTicketItemModifierByMenuModifier(MenuModifier menuModifier, String string, boolean bl) {
        if (menuModifier == null) {
            return 0.0;
        }
        double d = 0.0;
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        if (list != null) {
            for (Multiplier multiplier : list) {
                List<TicketItemModifier> list2 = this.findTicketItemModifiersFor(menuModifier, multiplier, bl);
                if (list2 != null && !list2.isEmpty()) {
                    for (TicketItemModifier ticketItemModifier : list2) {
                        if (!ticketItemModifier.getGroupId().equals(string)) continue;
                        d += ticketItemModifier.getItemQuantity().doubleValue();
                    }
                }
                if (!bl) continue;
                break;
            }
        }
        return d;
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string) {
        return this.findTicketItemModifierFor(menuModifier, string, null);
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string2 = ticketItemModifier.getItemId();
            if (multiplier != null && string2 != null && string2.equals(menuModifier.getId()) && string != null && string.equals(ticketItemModifier.getSectionName()) && multiplier != null && multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                return ticketItemModifier;
            }
            if (string2 == null || !string2.equals(menuModifier.getId()) || string == null || !string.equals(ticketItemModifier.getSectionName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public int countModifierFromGroup(MenuItemModifierSpec menuItemModifierSpec) {
        return TicketItemCalcFactory.getCalc(this).countModifierFromGroup(this, menuItemModifierSpec);
    }

    public boolean requiredModifiersAdded(MenuItemModifierSpec menuItemModifierSpec) {
        return TicketItemCalcFactory.getCalc(this).requiredModifiersAdded(this, menuItemModifierSpec);
    }

    public boolean deleteTicketItemModifier(TicketItemModifier ticketItemModifier) {
        return TicketItemCalcFactory.getCalc(this).deleteTicketItemModifier(this, ticketItemModifier);
    }

    public boolean deleteTicketItemModifierByName(TicketItemModifier ticketItemModifier) {
        return TicketItemCalcFactory.getCalc(this).deleteTicketItemModifierByName(this, ticketItemModifier);
    }

    public void setPizzaSectionMode(PIZZA_SECTION_MODE pIZZA_SECTION_MODE) {
        this.setPizzaSectionModeType(pIZZA_SECTION_MODE.getValue());
    }

    public PIZZA_SECTION_MODE getPizzaSectionMode() {
        return PIZZA_SECTION_MODE.from(this.getPizzaSectionModeType());
    }

    public void removeTicketItemDiscount(TicketItemDiscount ticketItemDiscount) {
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list == null) {
            return;
        }
        Iterator<TicketItemDiscount> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscount ticketItemDiscount2 = iterator.next();
            if (ticketItemDiscount2.getTableRowNum() != ticketItemDiscount.getTableRowNum()) continue;
            iterator.remove();
            return;
        }
    }

    public boolean isInventoryAdjusted() {
        if (this.isTreatAsSeat().booleanValue() || !this.isInventoryItem().booleanValue()) {
            return false;
        }
        return this.getQuantity().doubleValue() == this.getInventoryAdjustQty().doubleValue();
    }

    public Boolean isIncludeVoidQuantity() {
        return this.includeVoidQuantity == null ? false : this.includeVoidQuantity;
    }

    public void setIncludeVoidQuantity(Boolean bl) {
        this.includeVoidQuantity = bl;
    }

    public void setVoidItem(VoidItem voidItem) {
        this.voidItem = voidItem;
        if (voidItem == null) {
            this.removeProperty(JSON_PROP_VOID_REASON);
            this.removeProperty(JSON_PROP_VOID_QUANTITY);
        }
    }

    @XmlTransient
    public VoidItem getVoidItem() {
        if (this.voidItem != null) {
            return this.voidItem;
        }
        String string = this.getProperty(JSON_PROP_VOID_REASON);
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        double d = POSUtil.parseDouble(this.getProperty(JSON_PROP_VOID_QUANTITY));
        if (d == 0.0) {
            return null;
        }
        this.voidItem = this.createVoidItem(string, POSUtil.getBoolean(this.getProperty(JSON_PROP_WASTED)), d);
        return this.voidItem;
    }

    public void markVoided(String string, boolean bl, double d, boolean bl2) {
        TicketItemCalcFactory.getCalc(this).markVoided(this, string, bl, d, bl2);
    }

    public void setVoidProperties(String string, boolean bl, double d) {
        this.setVoidProperties(string, bl, d, this.isPrintedToKitchen());
    }

    public void setVoidProperties(String string, boolean bl, double d, boolean bl2) {
        User user = PosAction.getAuthorizedUser() == null ? Application.getCurrentUser() : PosAction.getAuthorizedUser();
        TicketItemCalcFactory.getCalc(this).setVoidProperties(this, string, bl, d, bl2, user);
    }

    public VoidItem createVoidItem(String string, boolean bl, double d) {
        User user = Application.getCurrentUser();
        return TicketItemCalcFactory.getCalc(this).createVoidItem(this, string, bl, d, user, user.getActiveCashDrawer());
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isRefundable() {
        return true;
    }

    public List<TicketItemCookingInstruction> getCookingInstructions() {
        if (this.cookingInstructions == null) {
            this.convertCookingInstructionPropertyToList();
        }
        return this.cookingInstructions;
    }

    public void convertCookingInstructionPropertyToList() {
        this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
        String string = super.getCookingInstructionsProperty();
        if (StringUtils.isNotEmpty((String)string)) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
            JsonArray jsonArray = jsonReader.readArray();
            jsonReader.close();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_DESCRIPTION));
                ticketItemCookingInstruction.setPrintedToKitchen(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_PRINTED_TO_KITCHEN));
                ticketItemCookingInstruction.setSaved(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_SAVED));
                ticketItemCookingInstruction.setKitchenStatus(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_KITCHEN_STATUS));
                ticketItemCookingInstruction.setParentItem(this);
                this.cookingInstructions.add(ticketItemCookingInstruction);
            }
        }
    }

    public PrinterGroup getPrinterGroup() {
        PrinterGroup printerGroup = DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
        if (printerGroup == null) {
            DataProvider.get().getDefaultPrinterGroup();
        }
        return printerGroup;
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String string = null;
        if (printerGroup != null) {
            string = printerGroup.getId();
        }
        super.setPrinterGroupId(string);
    }

    public TicketItem getParentTicketItem() {
        return this.parentTicketItem;
    }

    public void setParentTicketItem(TicketItem ticketItem) {
        this.parentTicketItem = ticketItem;
    }

    public List<TicketItem> getComboItems() {
        return null;
    }

    public void setComboItems(List<TicketItem> list) {
    }

    public void addTocomboItems(TicketItem ticketItem) {
    }

    public Integer getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder;
        }
        if (StringUtils.isEmpty((String)this.getCourseId())) {
            return 0;
        }
        Course course = DataProvider.get().getCourse(this.getCourseId());
        if (course != null) {
            return course.getSortOrder();
        }
        return 0;
    }

    public void setSortOrder(Integer n) {
        this.sortOrder = n;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }

    @Override
    public void addProperty(String string, String string2) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public String getProperty(String string) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    @Override
    public void removeProperty(String string) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(string);
        super.setProperties(this.propertiesContainer.toString());
    }

    public void setUnitSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitSelection() {
        String string = this.getProperty("menuitem.allow_unit_selection");
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public void setItemIsGiftCard(String string, double d) {
        this.setQuantity(1.0);
        this.setShouldPrintToKitchen(false);
        this.setInventoryItem(false);
        this.setTicketDiscountApplicable(false);
        this.setName(Messages.getString("GiftCardAddBalanceView.22"));
        this.setCategoryName(Messages.getString("GiftCard"));
        this.setGroupName(Messages.getString("GiftCard"));
        this.setUnitPrice(d);
        this.addProperty("isGiftCard", String.valueOf(true));
        this.addProperty("giftCardNo", string);
    }

    public boolean isGiftCard() {
        return Boolean.valueOf(this.getProperty("isGiftCard"));
    }

    public String getGiftCardNo() {
        return this.getProperty("giftCardNo");
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String string) {
        this.classType = string;
    }

    public void setReturned(Boolean bl) {
        this.addProperty(JSON_PROP_RETURNED, String.valueOf(bl));
        super.setItemReturned(bl);
    }

    public boolean isReturned() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED));
    }

    public boolean isReturnedItemVoided() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED_ITEM_VOIDED));
    }

    public double getComboItemsPrice() {
        double d = 0.0;
        List<TicketItem> list = this.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (ticketItem.getGroupId() != null) continue;
                d += ticketItem.getUnitPrice() * (ticketItem.getQuantity() / this.getQuantity());
            }
        }
        return d;
    }

    @XmlTransient
    public double getComboItemsModifierExtraPrice() {
        double d = 0.0;
        List<TicketItem> list = this.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                ticketItem.calculatePrice();
                d += (ticketItem.getSubtotalAmount() - ticketItem.getSubtotalAmountWithoutModifiers()) / this.getQuantity();
            }
        }
        return d;
    }

    public double getGiftCardPaidAmount() {
        return POSUtil.parseDouble(this.getProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT));
    }

    public void setGiftCardPaidAmount(double d) {
        this.addProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT, String.valueOf(d));
    }

    public void setSplitted(boolean bl) {
        this.addProperty("splitted", String.valueOf(bl));
    }

    public boolean isSplitted() {
        return Boolean.valueOf(this.getProperty("splitted"));
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new com.google.gson.JsonObject() : (com.google.gson.JsonObject)new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
        }
    }

    public void setServiceChargeWithoutModifiers(double d) {
        this.addProperty(JSON_PROP_SC_WITHOUT_MODOFIERS, String.valueOf(d));
    }

    public double getServiceChargeWithoutModifiers() {
        return this.getDoubleProperty(JSON_PROP_SC_WITHOUT_MODOFIERS);
    }

    @Override
    public com.google.gson.JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    public boolean hasDiscount() {
        List<TicketItemDiscount> list = this.getDiscounts();
        return list != null && list.size() > 0;
    }

    @Override
    public Boolean isShouldPrintToKitchen() {
        if (this.getKitchenStatusValue() == KitchenStatus.BUMP) {
            return false;
        }
        return super.isShouldPrintToKitchen();
    }

    public void setCustomerRequired(boolean bl) {
        this.addProperty("service.customerRequired", String.valueOf(bl));
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCustomerRequired() {
        return this.getBooleanProperty("service.customerRequired", false);
    }

    public void setPaymentType(ServicePaymentType servicePaymentType) {
        this.addProperty("service.paymentType", servicePaymentType == null ? null : servicePaymentType.name());
    }

    @XmlTransient
    @JsonIgnore
    public ServicePaymentType getPaymentType() {
        String string = this.getProperty("service.paymentType");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return ServicePaymentType.valueOf((String)string);
    }

    public void setServiceStartDate(Date date) {
        this.addProperty("service.startDate", date == null ? null : DateUtil.formatSyncTime(date));
    }

    @XmlTransient
    @JsonIgnore
    public Date getServiceStartDate() {
        String string = this.getProperty("service.startDate");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return DateUtil.parseSyncTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setServiceEndDate(Date date) {
        this.addProperty("service.endDate", date == null ? null : DateUtil.formatSyncTime(date));
    }

    @XmlTransient
    @JsonIgnore
    public Date getServiceEndDate() {
        String string = this.getProperty("service.endDate");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return DateUtil.parseSyncTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean isKitchenPrintable() {
        return this.isShouldPrintToKitchen() != false && this.isPrintedToKitchen() == false && this.isItemReturned() == false && this.isTreatAsSeat() == false;
    }

    public TicketItem getOriginalItemForReturnedItem(TicketItem ticketItem) {
        String string = this.getVoidedItemId();
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return null;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            if (!string.equals(ticketItem2.getId())) continue;
            return ticketItem2;
        }
        return null;
    }

    public void putUnitPriceWithoutModifierAfterDiscount(double d) {
        this.addProperty("uprice_wt_modifier_ad", String.valueOf(d));
    }

    @XmlTransient
    @JsonIgnore
    public Double getUnitPriceWithoutModifierAfterDiscount() {
        String string = this.getProperty("uprice_wt_modifier_ad");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return POSUtil.parseDouble(string);
    }

    public double getReturnableQuantity() {
        double d = this.getQuantity();
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return d;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            String string;
            if (ticketItem.isTreatAsSeat().booleanValue() || !StringUtils.isNotBlank((String)(string = ticketItem.getVoidedItemId())) || !string.equals(this.getId()) || !ticketItem.isItemReturned().booleanValue()) continue;
            d += ticketItem.getQuantity().doubleValue();
        }
        return Math.abs(d);
    }

    public Boolean isCanBeSold() {
        return this.getBooleanProperty("service.can_be_sold", true);
    }

    public void putCanBeSold(Boolean bl) {
        this.addProperty("service.can_be_sold", String.valueOf(bl));
    }

    public Boolean isCanBePurchased() {
        return this.getBooleanProperty("service.can_be_purchased", true);
    }

    public void putCanBePurchased(Boolean bl) {
        this.addProperty("service.can_be_purchased", String.valueOf(bl));
    }

    public Boolean isRecurring() {
        return this.getBooleanProperty("service.recurring", false);
    }

    public void putRecurring(Boolean bl) {
        this.addProperty("service.recurring", String.valueOf(bl));
    }

    public Boolean isCanBeRented() {
        return this.getBooleanProperty("service.can_be_rented", false);
    }

    public void putCanBeRented(Boolean bl) {
        this.addProperty("service.can_be_rented", String.valueOf(bl));
    }

    public Boolean isDigitalProduct() {
        return this.getBooleanProperty("service.digital_product", false);
    }

    public void putDigitalProduct(Boolean bl) {
        this.addProperty("service.digital_product", String.valueOf(bl));
    }

    public Boolean isCanBeDownloaded() {
        return this.getBooleanProperty("service.can_be_downloaded", false);
    }

    public void putCanBeDownloaded(Boolean bl) {
        this.addProperty("service.can_be_downloaded", String.valueOf(bl));
    }

    public Boolean isCanBeShipped() {
        return this.getBooleanProperty("service.can_be_shipped", false);
    }

    public void putCanBeShipped(Boolean bl) {
        this.addProperty("service.can_be_shipped", String.valueOf(bl));
    }

    public String getProductType() {
        return this.getProperty("service.product_type", "");
    }

    public void putProductType(String string) {
        this.addProperty("service.product_type", string);
    }

    public boolean isShowItemCountdown() {
        return DataProvider.get().getStore().isAllowShowItemCountdown() && this.isInventoryItem() != false;
    }

    public static enum PIZZA_SECTION_MODE {
        FULL(1),
        HALF(2),
        QUARTER(3);

        private final int value;

        private PIZZA_SECTION_MODE(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static PIZZA_SECTION_MODE from(int n) {
            if (n == 2) {
                return HALF;
            }
            if (n == 3) {
                return QUARTER;
            }
            return FULL;
        }

        public String toString() {
            return this.name();
        }
    }
}

