/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.BaseBalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BalanceUpdateTransactionDAO
extends BaseBalanceUpdateTransactionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveBalanceUpdateTrans(BalanceType balanceType, Ticket ticket, PosTransaction posTransaction, TransactionType transactionType, String string, Double d, Double d2, TransactionSubType transactionSubType, Session session) {
        this.saveBalanceUpdateTrans(balanceType, ticket == null ? null : ticket.getId(), posTransaction, transactionType, string, d, d2, transactionSubType, session);
    }

    public void saveBalanceUpdateTrans(BalanceType balanceType, String string, PosTransaction posTransaction, TransactionType transactionType, String string2, Double d, Double d2, TransactionSubType transactionSubType, Session session) {
        BalanceUpdateTransaction balanceUpdateTransaction = balanceType.createTransaction(posTransaction == null ? PaymentType.CASH : posTransaction.getPaymentType(), transactionType, d);
        balanceUpdateTransaction.setTransactionId(posTransaction == null ? null : posTransaction.getId());
        balanceUpdateTransaction.setTicketId(string);
        balanceUpdateTransaction.setAccountNumber(string2);
        if (transactionSubType != null) {
            balanceUpdateTransaction.setTransactionSubType(transactionSubType.name());
            balanceUpdateTransaction.setDescription(transactionSubType.name());
        }
        if (!NumberUtil.isZero(d2)) {
            d2 = NumberUtil.round(d2);
            balanceUpdateTransaction.setBalanceBefore(d2);
        }
        BalanceUpdateTransactionDAO.getInstance().save(balanceUpdateTransaction, session);
    }

    private void adjustBalanceUpdateTransaction(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
        this.save(balanceUpdateTransaction, session);
        BalanceType balanceType = balanceUpdateTransaction.getBalanceType();
        if (balanceType == BalanceType.GIFT_CARD) {
            GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, balanceUpdateTransaction.getAccountNumber());
            if (giftCard == null) {
                return;
            }
            giftCard.setBalance(giftCard.getBalance() + balanceUpdateTransaction.getAmount());
            GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            return;
        }
        Customer customer = CustomerDAO.getInstance().get(balanceUpdateTransaction.getAccountNumber(), session);
        if (customer == null) {
            return;
        }
        if (balanceType == BalanceType.CUSTOMER) {
            customer.setBalance(customer.getBalance() + balanceUpdateTransaction.getAmount());
        } else if (balanceType == BalanceType.LOYALTY) {
            customer.setLoyaltyPoint((int)((double)customer.getLoyaltyPoint().intValue() + balanceUpdateTransaction.getAmount()));
        }
        customer.setUpdateLastUpdateTime(false);
        customer.setUpdateSyncTime(false);
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
    }

    public void saveOrUpdateBalanceUpdateTransactions(List<BalanceUpdateTransaction> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
                BalanceUpdateTransaction balanceUpdateTransaction2 = this.get(balanceUpdateTransaction.getId());
                if (balanceUpdateTransaction2 != null) continue;
                balanceUpdateTransaction.setUpdateLastUpdateTime(bl);
                balanceUpdateTransaction.setUpdateSyncTime(bl2);
                this.adjustBalanceUpdateTransaction(balanceUpdateTransaction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BalanceUpdateTransaction> findBy(String string, BalanceType balanceType) {
        try (Session session = this.createNewSession();){
            Object object;
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER, (Object)string));
            }
            if (balanceType != null) {
                criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_BALANCE_TYPE_STRING, (Object)balanceType.name()));
            }
            if ((list = criteria.list()) != null && list.size() > 0) {
                object = 0.0;
                for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
                    object = (Double)object + balanceUpdateTransaction.getAmount();
                    balanceUpdateTransaction.setEndBalance((Double)object);
                }
            }
            object = list;
            return object;
        }
    }

    public void updateCustomerBalanceForManualEntry(Customer customer, double d, double d2, String string, BalanceType balanceType, Session session) {
        BalanceUpdateTransaction balanceUpdateTransaction = new BalanceUpdateTransaction();
        balanceUpdateTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        balanceUpdateTransaction.setAccountNumber(customer.getId());
        balanceUpdateTransaction.setAmount(d);
        balanceUpdateTransaction.setBalanceBefore(d2);
        balanceUpdateTransaction.setBalanceType(balanceType);
        balanceUpdateTransaction.setDescription(string);
        balanceUpdateTransaction.setTransactionType(TransactionType.CREDIT.name());
        balanceUpdateTransaction.setPaymentType(PaymentType.MANUAL_ENTRY);
        if (!balanceType.equals((Object)BalanceType.LOYALTY)) {
            balanceUpdateTransaction.setTransactionSubType(TransactionSubType.BALANCE_UPDATED.name());
        }
        this.saveOrUpdate(balanceUpdateTransaction, session);
    }
}

