/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Brand;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseBrandDAO;
import com.floreantpos.model.dao.GenericDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;

public class BrandDAO
extends BaseBrandDAO {
    @Override
    public List<Brand> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Brand.class);
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Brand.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public void delete(Object object, Session session) {
        Brand brand = (Brand)object;
        if (brand == null) {
            throw new PosException(Messages.getString("BrandDAO.1"));
        }
        this.checkForeignRelation(brand);
        brand.setDeleted(Boolean.TRUE);
        this.update(brand, session);
    }

    private void checkForeignRelation(Brand brand) throws PosException {
        try (Session session = this.createNewSession();){
            List<String> list = GenericDAO.getInstance().getForeignDataListNames(session, MenuItem.class, MenuItem.PROP_BRAND_ID, brand.getId());
            if (list != null && list.size() > 0) {
                throw new PosException(Messages.getString("BrandDAO.0"));
            }
        }
    }

    public Brand createNewBrand(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        string = string.trim();
        Brand brand = new Brand();
        brand.setName(string);
        this.saveOrUpdate(brand);
        return brand;
    }
}

