/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseCustomPaymentTransactionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginationSupport;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CustomPaymentTransactionDAO
extends BaseCustomPaymentTransactionDAO {
    public void loadCustomTransactions(PaginationSupport paginationSupport, String string) {
        this.loadCustomTransactions(paginationSupport, null, null, null, string);
    }

    public void loadCustomTransactions(PaginationSupport paginationSupport, String string, Date date, Date date2, String string2) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Customer.class);
            List list = null;
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
                list = criteria.list();
            }
            Criteria criteria2 = session.createCriteria(CustomPaymentTransaction.class);
            this.addDeletedFilter(criteria2);
            criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                criteria2.createAlias(CustomPaymentTransaction.PROP_TICKET, "ticket");
                disjunction.add(Restrictions.ilike((String)("ticket." + Ticket.PROP_ID), (String)string, (MatchMode)MatchMode.END));
                disjunction.add(Restrictions.ilike((String)CustomPaymentTransaction.PROP_ID, (String)string, (MatchMode)MatchMode.END));
                if (list != null && list.size() > 0) {
                    disjunction.add(Restrictions.in((String)CustomPaymentTransaction.PROP_CUSTOMER_ID, (Collection)list));
                }
                criteria2.add((Criterion)disjunction);
            }
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                criteria2.add(Restrictions.ilike((String)CustomPaymentTransaction.PROP_EXTRA_PROPERTIES, (String)("\"custom.payment.ref\":\"%" + string2.trim() + "%\""), (MatchMode)MatchMode.ANYWHERE));
            }
            if (date != null) {
                criteria2.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date)));
            }
            if (date2 != null) {
                criteria2.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.endOfDay(date2)));
            }
            criteria2.setProjection(Projections.rowCount());
            Number number = (Number)criteria2.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria2.setProjection(null);
            criteria2.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria2.setMaxResults(paginationSupport.getPageSize());
            criteria2.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            criteria2.addOrder(Order.desc((String)CustomPaymentTransaction.PROP_TRANSACTION_TIME));
            paginationSupport.setRows(criteria2.list());
        }
    }
}

