/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.GlobalConfig;
import com.floreantpos.model.TicketIdSequence;
import com.floreantpos.model.dao.BaseGlobalConfigDAO;
import java.text.DecimalFormat;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class GlobalConfigDAO
extends BaseGlobalConfigDAO {
    public static final String DB_ID = "database_id";
    public static final String TICKET_ID_GENERATOR_FORMAT = "tikcet.id.generator.format";
    public static final String TICKET_ID_SEQUENCE_FORMAT = "tikcet.id.sequence.format";

    public String getDatabaseId() {
        GlobalConfig globalConfig = this.findGlobalConfig(DB_ID);
        if (globalConfig == null) {
            globalConfig = this.saveOrUpdate(DB_ID, UUID.randomUUID().toString());
        }
        return globalConfig.getValue();
    }

    public String getValueByKey(String string) {
        GlobalConfig globalConfig = this.findGlobalConfig(string);
        if (globalConfig == null) {
            return null;
        }
        return globalConfig.getValue();
    }

    public GlobalConfig findGlobalConfig(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)GlobalConfig.PROP_KEY, (Object)string));
            criteria.setMaxResults(1);
            GlobalConfig globalConfig = (GlobalConfig)criteria.uniqueResult();
            return globalConfig;
        }
    }

    public String getTicketIdPrefix() {
        return this.getValueByKey(this.getDatabaseId() + "-ticket-prefix");
    }

    public TicketIdSequence getTicketIdGeneratorFormat() {
        String string = this.getValueByKey(TICKET_ID_GENERATOR_FORMAT);
        if (string == null) {
            return TicketIdSequence.Default;
        }
        return TicketIdSequence.INSTANCE.getTicketIdSequenceById(Integer.parseInt(string));
    }

    public DecimalFormat getTicketIdSequenceFormat() {
        String string = this.getValueByKey(TICKET_ID_SEQUENCE_FORMAT);
        if (string == null) {
            return new DecimalFormat("0");
        }
        return new DecimalFormat(string);
    }

    public void saveTicketIdSequenceFormat(String string) {
        this.saveOrUpdate(TICKET_ID_SEQUENCE_FORMAT, string);
    }

    public void saveTicketIdGeneratorFormat(TicketIdSequence ticketIdSequence) {
        this.saveOrUpdate(TICKET_ID_GENERATOR_FORMAT, String.valueOf(ticketIdSequence.getId()));
    }

    public void saveTicketIdPrefix(String string) {
        this.saveOrUpdate(this.getDatabaseId() + "-ticket-prefix", string);
    }

    public GlobalConfig saveOrUpdate(String string, String string2) {
        GlobalConfig globalConfig = this.findGlobalConfig(string);
        if (globalConfig == null) {
            globalConfig = new GlobalConfig();
            globalConfig.setKey(string);
        }
        globalConfig.setValue(string2);
        this.saveOrUpdate(globalConfig);
        return globalConfig;
    }

    public int getEmbdedServerPort() {
        String string = this.getValueByKey("data_service.port");
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 8080;
            }
        }
        return 8080;
    }
}

