/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.BaseGratuityDAO;
import com.floreantpos.model.dao.GratuityPaymentHistoryDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class GratuityDAO
extends BaseGratuityDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Deprecated
    public List<Gratuity> findByUser(User user) throws PosException {
        return this.findByUser(user, false);
    }

    @Deprecated
    public List<Gratuity> findByUser(User user, boolean bl) throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_PAID, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            throw new PosException("" + user.getFirstName() + " " + user.getLastName());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Gratuity> findByUserRoles(User user) throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            GratuityDAO.addUserWithAllRoleCriteria(criteria, user, Gratuity.PROP_OWNER_ID);
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add(Restrictions.isNotNull((String)Gratuity.PROP_TICKET_ID));
            criteria.add(Restrictions.isNotNull((String)Gratuity.PROP_OWNER_ID));
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            throw new PosException("" + user.getFirstName() + " " + user.getLastName());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Deprecated
    public void payGratuities(List<Gratuity> list, List<GratuityPaymentHistory> list2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Gratuity timedModel : list) {
                this.saveOrUpdate(timedModel, session);
            }
            for (GratuityPaymentHistory gratuityPaymentHistory : list2) {
                GratuityPaymentHistoryDAO.getInstance().saveOrUpdate(gratuityPaymentHistory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new PosException("");
        }
        finally {
            this.closeSession(session);
        }
    }

    public TipsCashoutReport createReport(Date date, Date date2, User user) {
        return this.createReport(date, date2, user, false);
    }

    public TipsCashoutReport createReport(Date date, Date date2, User user, boolean bl) {
        Session session = null;
        try {
            Object object2;
            List list;
            session = this.getSession();
            if (date != null) {
                date = DateUtil.startOfDay(date);
            }
            if (date2 != null) {
                date2 = DateUtil.endOfDay(date2);
            }
            TipsCashoutReport tipsCashoutReport = new TipsCashoutReport();
            StoreSession storeSession = StoreUtil.getCurrentStoreSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_GRATUITY));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)new Double(0.0)));
            ArrayList<String> arrayList = new ArrayList<String>();
            if (user != null) {
                arrayList.add(user.getId());
                list = user.getLinkedUser();
                for (Object object2 : list) {
                    if (((BaseUser)object2).getId().equals(user.getId())) continue;
                    arrayList.add(((BaseUser)object2).getId());
                }
                if (!arrayList.isEmpty()) {
                    criteria.add(Restrictions.in((String)("g." + Gratuity.PROP_OWNER_ID), arrayList));
                }
            }
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
                tipsCashoutReport.setFromDate(storeSession.getOpenTime());
                tipsCashoutReport.setToDate(new Date());
            } else if (date == null && date2 == null) {
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_PAID), (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_REFUNDED), (Object)Boolean.FALSE));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            list = criteria.list();
            tipsCashoutReport.setServer(user == null ? "ALL" : user.getId() + "/" + user.toString());
            tipsCashoutReport.setReportTime(new Date());
            if (!bl) {
                tipsCashoutReport.setFromDate(date);
                tipsCashoutReport.setToDate(date2);
            }
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                Set<PosTransaction> set;
                object2 = (Ticket)((Object)object3.next());
                Gratuity gratuity = ((BaseTicket)object2).getGratuity();
                TipsCashoutReportData tipsCashoutReportData = new TipsCashoutReportData();
                tipsCashoutReportData.setTicketId(String.valueOf(((BaseTicket)object2).getTokenNo()));
                tipsCashoutReportData.setTicketTotal(((Ticket)object2).getTotalAmountWithTips());
                if (gratuity != null) {
                    tipsCashoutReportData.setDeclareTipsAmount(gratuity.getDeclareTipsAmount());
                }
                if ((object2 = TicketDAO.getInstance().loadCouponsAndTransactions(((BaseTicket)object2).getId())) != null && (set = ((Ticket)object2).getTransactions()) != null && set.size() > 0) {
                    for (PosTransaction posTransaction : set) {
                        if (posTransaction.isVoided().booleanValue()) continue;
                        if (posTransaction instanceof CashTransaction) {
                            tipsCashoutReportData.setCashTips(tipsCashoutReportData.getCashTips() + posTransaction.getTipsAmount());
                            continue;
                        }
                        tipsCashoutReportData.setChargedTips(tipsCashoutReportData.getChargedTips() + posTransaction.getTipsAmount());
                    }
                }
                if (gratuity != null && !gratuity.isRefunded().booleanValue()) {
                    if (date == null && date2 == null && tipsCashoutReportData.getCashTips() + tipsCashoutReportData.getChargedTips() + tipsCashoutReportData.getDeclareTipsAmount() <= 0.0) {
                        object3.remove();
                        continue;
                    }
                    if (gratuity.getAmount() > 0.0) {
                        tipsCashoutReportData.setSaleType("");
                    }
                    tipsCashoutReportData.setPaid(gratuity.isPaid());
                    tipsCashoutReportData.setTipsPaidAmount(gratuity.getTipsPaidAmount());
                }
                tipsCashoutReport.addReportData(tipsCashoutReportData);
            }
            criteria = session.createCriteria(DeclaredTips.class);
            criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
            if (date == null && date2 == null) {
                criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)storeSession.getId()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date2));
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)DeclaredTips.PROP_OWNER_ID, arrayList));
            }
            if ((object3 = criteria.uniqueResult()) != null) {
                tipsCashoutReport.setDeclaredTipsAmount((Double)object3);
            }
            tipsCashoutReport.calculateOthers();
            object2 = tipsCashoutReport;
            return object2;
        }
        catch (Exception exception) {
            if (user != null) {
                throw new PosException("" + user.getFirstName() + " " + user.getLastName(), exception);
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findTotalGratuityAmount(Date date, Date date2, User user) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)Gratuity.PROP_AMOUNT), Gratuity.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                double d = number.doubleValue();
                return d;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0.0;
    }

    public List<Gratuity> findGratuititesForStaffBank(CashDrawer cashDrawer) throws PosException {
        try (Session session = this.createNewSession();){
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(PosTransaction.class);
            detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            detachedCriteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)cashDrawer.getId()));
            detachedCriteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_TICKET));
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add(Property.forName((String)Gratuity.PROP_TICKET_ID).in(detachedCriteria));
            List list = criteria.list();
            return list;
        }
    }

    public double findTotalPaidGratuititesForStaffBank(CashDrawer cashDrawer) throws PosException {
        try (Session session = this.createNewSession();){
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(PosTransaction.class);
            detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            detachedCriteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)cashDrawer.getId()));
            detachedCriteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_TICKET));
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Property.forName((String)Gratuity.PROP_TICKET_ID).in(detachedCriteria));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)Gratuity.PROP_AMOUNT));
            projectionList.add((Projection)Projections.sum((String)Gratuity.PROP_TIPS_PAID_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            double d = 0.0;
            if (list.size() > 0) {
                Object[] objectArray = (Object[])list.get(0);
                if (objectArray.length > 0) {
                    d = POSUtil.getDoubleAmount(objectArray[0]);
                }
                if (objectArray.length > 1) {
                    d -= POSUtil.getDoubleAmount(objectArray[1]);
                }
            }
            criteria = session.createCriteria(GratuityPaymentHistory.class);
            criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_CASH_DRAWER, (Object)cashDrawer));
            criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
            double d2 = d + POSUtil.getDoubleAmount(criteria.uniqueResult());
            return d2;
        }
    }

    public void saveOrUpdateGratuityList(List<Gratuity> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (Gratuity gratuity : list) {
                Gratuity gratuity2 = this.get(gratuity.getId(), session);
                if (gratuity2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(gratuity.getLastUpdateTime(), gratuity2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), "Gratuity " + gratuity.getId() + " already updated");
                        continue;
                    }
                    long l = gratuity2.getVersion();
                    PropertyUtils.copyProperties((Object)gratuity2, (Object)gratuity);
                    gratuity2.setVersion(l);
                    gratuity2.setUpdateLastUpdateTime(bl);
                    gratuity2.setUpdateSyncTime(bl2);
                    this.update(gratuity2, session);
                    continue;
                }
                gratuity.setUpdateLastUpdateTime(bl);
                gratuity.setUpdateSyncTime(bl2);
                this.save(gratuity, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void payTips(List<Gratuity> list, CashDrawer cashDrawer, User user, Double d) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.payTips(session, list, cashDrawer, user, d);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void payTips(Session session, List<Gratuity> list, CashDrawer cashDrawer, User user, Double d) {
        if (d > 0.0) {
            for (Gratuity gratuity : list) {
                double d2;
                if (d < 0.0) break;
                double d3 = PosTransactionDAO.getInstance().getTipsAmount(gratuity.getTicketId(), session);
                double d4 = gratuity.getTipsPaidAmount();
                double d5 = d2 = NumberUtil.roundToTwoDigit(d3 - d4);
                if (d - d5 < 0.0) {
                    d5 = d;
                }
                d5 = NumberUtil.round(d5);
                d = d - d5;
                GratuityPaymentHistory gratuityPaymentHistory = new GratuityPaymentHistory();
                gratuityPaymentHistory.setAmount(d5);
                gratuityPaymentHistory.setTenderedAmount(d5);
                gratuityPaymentHistory.setCashDrawer(cashDrawer);
                gratuityPaymentHistory.setTransactionTime(new Date());
                gratuityPaymentHistory.setGratuity(gratuity);
                gratuityPaymentHistory.setPaidBy(user);
                gratuityPaymentHistory.setStoreSessionId(DataProvider.get().getStoreSessionId());
                GratuityPaymentHistoryDAO.getInstance().saveOrUpdate(gratuityPaymentHistory, session);
                gratuity.setTipsPaidAmount(NumberUtil.round(d4 + d5));
                if (NumberUtil.isZero(gratuity.getAmount() - gratuity.getTipsPaidAmount())) {
                    gratuity.setPaid(true);
                }
                GratuityDAO.getInstance().saveOrUpdate(gratuity, session);
            }
        }
    }
}

